/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control;

import java.io.File;
import java.io.FileOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.jmesa.core.CoreContext;
import org.jmesa.util.ExportUtils;
import org.jmesa.view.AbstractViewExporter;
import org.jmesa.view.View;

public class OCCsvViewExporter
extends AbstractViewExporter {
    String fileName;

    public OCCsvViewExporter(View view, CoreContext coreContext, HttpServletResponse response) {
        super(view, coreContext, response, null);
        if (this.fileName == null) {
            this.fileName = ExportUtils.exportFileName((View)view, (String)this.getExtensionName());
        }
    }

    public OCCsvViewExporter(View view, CoreContext coreContext, HttpServletResponse response, String fileName) {
        super(view, coreContext, response, fileName);
        this.fileName = fileName + "." + this.getExtensionName();
    }

    public void export() throws Exception {
        String viewData = (String)this.getView().render();
        byte[] contents = viewData.getBytes();
        File f = new File(this.fileName);
        FileOutputStream fos = new FileOutputStream(f, true);
        fos.write(contents);
        fos.flush();
    }

    public String getContextType() {
        return "text/csv";
    }

    public String getExtensionName() {
        return "txt";
    }
}

