/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.hibernate.DatabaseChangeLogDao;
import org.akaza.openclinica.domain.technicaladmin.DatabaseChangeLogBean;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.jmesa.facade.TableFacade;
import org.jmesa.facade.TableFacadeFactory;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.DateCellEditor;
import org.jmesa.view.html.component.HtmlColumn;
import org.jmesa.view.html.component.HtmlRow;
import org.jmesa.view.html.component.HtmlTable;

public class AuditDatabaseServlet
extends SecureController {
    private static final long serialVersionUID = 1L;
    Locale locale;
    private DatabaseChangeLogDao databaseChangeLogDao;

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (!this.ub.isSysAdmin()) {
            throw new InsufficientPermissionException(Page.MENU, resexception.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String auditDatabaseHtml = this.renderAuditDatabaseTable((List)this.getDatabaseChangeLogDao().findAll());
        this.request.setAttribute("auditDatabaseHtml", (Object)auditDatabaseHtml);
        this.forwardPage(Page.AUDIT_DATABASE);
    }

    private String renderAuditDatabaseTable(List<DatabaseChangeLogBean> databaseChangeLogs) {
        TableFacade tableFacade = TableFacadeFactory.createTableFacade((String)"databaseChangeLogs", (HttpServletRequest)this.request);
        tableFacade.setColumnProperties(new String[]{"id", "author", "fileName", "dataExecuted", "md5Sum", "description", "comments", "tag", "liquibase"});
        tableFacade.setItems(databaseChangeLogs);
        HtmlTable table = (HtmlTable)tableFacade.getTable();
        table.setCaption("");
        HtmlRow row = table.getRow();
        HtmlColumn id = row.getColumn("id");
        id.setTitle("Id");
        HtmlColumn author = row.getColumn("author");
        author.setTitle("Author");
        HtmlColumn fileName = row.getColumn("fileName");
        fileName.setTitle("File Name");
        HtmlColumn dataExecuted = row.getColumn("dataExecuted");
        dataExecuted.setTitle("Date Executed");
        dataExecuted.getCellRenderer().setCellEditor((CellEditor)new DateCellEditor("yyyy-MM-dd hh:mm:ss"));
        HtmlColumn md5Sum = row.getColumn("md5Sum");
        md5Sum.setTitle("md5 sum");
        HtmlColumn description = row.getColumn("description");
        description.setTitle("Description");
        HtmlColumn comments = row.getColumn("comments");
        comments.setTitle("Comments");
        HtmlColumn tag = row.getColumn("tag");
        tag.setTitle("Tag");
        HtmlColumn liquibase = row.getColumn("liquibase");
        liquibase.setTitle("Liquibase");
        return tableFacade.render();
    }

    protected String getAdminServlet() {
        return "admin";
    }

    public DatabaseChangeLogDao getDatabaseChangeLogDao() {
        this.databaseChangeLogDao = this.databaseChangeLogDao != null ? this.databaseChangeLogDao : (DatabaseChangeLogDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("databaseChangeLogDao");
        return this.databaseChangeLogDao;
    }

    public void setDatabaseChangeLogDao(DatabaseChangeLogDao databaseChangeLogDao) {
        this.databaseChangeLogDao = databaseChangeLogDao;
    }
}

