/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.control.admin.AuditUserLoginTableFactory;
import org.akaza.openclinica.dao.hibernate.AuditUserLoginDao;
import org.akaza.openclinica.dao.hibernate.AuditUserLoginFilter;
import org.akaza.openclinica.dao.hibernate.AuditUserLoginSort;
import org.akaza.openclinica.domain.technicaladmin.LoginStatus;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.jmesa.core.filter.DateFilterMatcher;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Filter;
import org.jmesa.limit.FilterSet;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.DateCellEditor;
import org.jmesa.view.editor.FilterEditor;

public class AuditUserLoginTableFactory
extends AbstractTableFactory {
    private AuditUserLoginDao auditUserLoginDao;
    private ResourceBundle resword;

    protected String getTableName() {
        return "userLogins";
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        tableFacade.setColumnProperties(new String[]{"userName", "loginAttemptDate", "loginStatus", "details", "actions"});
        Row row = tableFacade.getTable().getRow();
        this.configureColumn(row.getColumn("userName"), "User Name", null, null);
        this.configureColumn(row.getColumn("loginAttemptDate"), "Attempt Date", (CellEditor)new DateCellEditor("yyyy-MM-dd HH:mm:ss"), null);
        this.configureColumn(row.getColumn("loginStatus"), "Status", null, (FilterEditor)new AvailableDroplistFilterEditor(this, null));
        this.configureColumn(row.getColumn("details"), "Details", null, null);
        String actionsHeader = this.resword.getString("actions") + "&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;";
        this.configureColumn(row.getColumn("actions"), actionsHeader, (CellEditor)new ActionsCellEditor(this, null), (FilterEditor)new DefaultActionsEditor(locale), true, false);
    }

    protected void configureExportColumns(TableFacade tableFacade, Locale locale) {
        tableFacade.setColumnProperties(new String[]{"userName", "loginAttemptDate", "loginStatus"});
        Row row = tableFacade.getTable().getRow();
        this.configureColumn(row.getColumn("userName"), "User Name", null, null);
        this.configureColumn(row.getColumn("loginAttemptDate"), "Login Attempt Date", (CellEditor)new DateCellEditor("yyyy-MM-dd HH:mm:ss"), null);
        this.configureColumn(row.getColumn("loginStatus"), "Login Status", null, (FilterEditor)new AvailableDroplistFilterEditor(this, null));
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        super.configureTableFacade(response, tableFacade);
        tableFacade.addFilterMatcher(new MatcherKey(Date.class, "loginAttemptDate"), (FilterMatcher)new DateFilterMatcher("yyyy-MM-dd HH:mm"));
        tableFacade.addFilterMatcher(new MatcherKey(LoginStatus.class, "loginStatus"), (FilterMatcher)new AvailableFilterMatcher(this, null));
    }

    public int getSize(Limit limit) {
        return this.getAuditUserLoginDao().getCountWithFilter(new AuditUserLoginFilter());
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        AuditUserLoginSort auditUserLoginSort;
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)this.getLocale());
        Limit limit = tableFacade.getLimit();
        AuditUserLoginFilter auditUserLoginFilter = this.getAuditUserLoginFilter(limit);
        if (!limit.isComplete()) {
            int totalRows = this.getAuditUserLoginDao().getCountWithFilter(auditUserLoginFilter);
            tableFacade.setTotalRows(totalRows);
        }
        if ((auditUserLoginSort = this.getAuditUserLoginSort(limit)).getSorts().size() == 0) {
            auditUserLoginSort.addSort("loginAttemptDate", "desc");
        }
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        ArrayList items = this.getAuditUserLoginDao().getWithFilterAndSort(auditUserLoginFilter, auditUserLoginSort, rowStart, rowEnd);
        tableFacade.setItems((Collection)items);
    }

    protected AuditUserLoginFilter getAuditUserLoginFilter(Limit limit) {
        AuditUserLoginFilter auditUserLoginFilter = new AuditUserLoginFilter();
        FilterSet filterSet = limit.getFilterSet();
        if (filterSet != null) {
            Collection filters = filterSet.getFilters();
            for (Filter filter : filters) {
                String property = filter.getProperty();
                String value = filter.getValue();
                auditUserLoginFilter.addFilter(property, (Object)value);
            }
        }
        return auditUserLoginFilter;
    }

    protected AuditUserLoginSort getAuditUserLoginSort(Limit limit) {
        AuditUserLoginSort auditUserLoginSort = new AuditUserLoginSort();
        SortSet sortSet = limit.getSortSet();
        if (sortSet != null) {
            Collection sorts = sortSet.getSorts();
            for (Sort sort : sorts) {
                String property = sort.getProperty();
                String order = sort.getOrder().toParam();
                auditUserLoginSort.addSort(property, order);
            }
        }
        return auditUserLoginSort;
    }

    public AuditUserLoginDao getAuditUserLoginDao() {
        return this.auditUserLoginDao;
    }

    public void setAuditUserLoginDao(AuditUserLoginDao auditUserLoginDao) {
        this.auditUserLoginDao = auditUserLoginDao;
    }
}

