/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class CreateCRFServlet
extends SecureController {
    Locale locale;

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("you_not_have_permission_create_CRF") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.CRF_LIST_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        String action = this.request.getParameter("action");
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        this.request.setAttribute("xformEnabled", (Object)CoreResources.getField((String)"xform.enabled"));
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        this.setToPanel(resword.getString("create_CRF"), respage.getString("br_create_new_CRF_entering"));
        this.setToPanel(resword.getString("create_CRF_version"), respage.getString("br_create_new_CRF_uploading"));
        this.setToPanel(resword.getString("revise_CRF_version"), respage.getString("br_if_you_owner_CRF_version"));
        this.setToPanel(resword.getString("CRF_spreadsheet_template"), respage.getString("br_download_blank_CRF_spreadsheet_from"));
        this.setToPanel(resword.getString("example_CRF_br_spreadsheets"), respage.getString("br_download_example_CRF_instructions_from"));
        if (StringUtil.isBlank((String)action)) {
            this.session.setAttribute("crf", (Object)new CRFBean());
            this.forwardPage(Page.CREATE_CRF);
        } else if ("confirm".equalsIgnoreCase(action)) {
            Validator v = new Validator(this.request);
            v.addValidation("name", 1);
            String name = fp.getString("name");
            String description = fp.getString("description");
            CRFBean crf = new CRFBean();
            crf.setName(name.trim());
            crf.setDescription(description.trim());
            this.session.setAttribute("crf", (Object)crf);
            this.errors = v.validate();
            if (fp.getString("name").trim().length() > 255) {
                Validator.addError((HashMap)this.errors, (String)"name", (String)resexception.getString("maximum_length_name_255"));
            }
            if (fp.getString("description").trim().length() > 2048) {
                Validator.addError((HashMap)this.errors, (String)"description", (String)resexception.getString("maximum_length_description_255"));
            }
            if (!this.errors.isEmpty()) {
                logger.info("has validation errors in the first section");
                this.request.setAttribute("formMessages", (Object)this.errors);
                this.forwardPage(Page.CREATE_CRF);
            } else {
                CRFBean crf1 = (CRFBean)cdao.findByName(name.trim());
                if (crf1.getId() > 0) {
                    Validator.addError((HashMap)this.errors, (String)"name", (String)resexception.getString("CRF_name_used_choose_unique_name"));
                    this.request.setAttribute("formMessages", (Object)this.errors);
                    this.forwardPage(Page.CREATE_CRF);
                } else {
                    crf = (CRFBean)this.session.getAttribute("crf");
                    logger.info("The crf to be saved:" + crf.getName());
                    crf.setOwner(this.ub);
                    crf.setCreatedDate(new Date());
                    crf.setStatus(Status.AVAILABLE);
                    crf.setStudyId(this.currentStudy.getId());
                    cdao.create((EntityBean)crf);
                    crf = (CRFBean)cdao.findByName(crf.getName());
                    CRFVersionBean version = new CRFVersionBean();
                    version.setCrfId(crf.getId());
                    this.session.setAttribute("version", (Object)version);
                    this.session.setAttribute("crfName", (Object)crf.getName());
                    this.session.removeAttribute("crf");
                    this.forwardPage(Page.CREATE_CRF_VERSION);
                }
            }
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

