/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.extract.ExtractPropertyBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.job.XsltStatefulJob;
import org.akaza.openclinica.service.extract.ExtractUtils;
import org.akaza.openclinica.service.extract.XsltTriggerService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.job.TriggerService;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;

public class CreateJobExportServlet
extends SecureController {
    public static final String PERIOD = "periodToRun";
    public static final String FORMAT_ID = "formatId";
    public static final String DATASET_ID = "dsId";
    public static final String DATE_START_JOB = "job";
    public static final String EMAIL = "contactEmail";
    public static final String JOB_NAME = "jobName";
    public static final String JOB_DESC = "jobDesc";
    public static final String USER_ID = "user_id";
    public static final String STUDY_NAME = "study_name";
    private static String SCHEDULER = "schedulerFactoryBean";
    private StdScheduler scheduler;

    protected void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private StdScheduler getScheduler() {
        this.scheduler = this.scheduler != null ? this.scheduler : (StdScheduler)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(SCHEDULER);
        return this.scheduler;
    }

    private void setUpServlet() {
        FormProcessor fp2 = new FormProcessor(this.request);
        DatasetDAO dsdao = new DatasetDAO(this.sm.getDataSource());
        Collection dsList = dsdao.findAllOrderByStudyIdAndName();
        this.request.setAttribute("datasets", (Object)dsList);
        this.request.setAttribute(JOB_NAME, (Object)fp2.getString(JOB_NAME));
        this.request.setAttribute(JOB_DESC, (Object)fp2.getString(JOB_DESC));
        this.request.setAttribute("extractProperties", (Object)CoreResources.getExtractProperties());
        this.request.setAttribute(EMAIL, (Object)fp2.getString(EMAIL));
        this.request.setAttribute(FORMAT_ID, (Object)fp2.getInt(FORMAT_ID));
        this.request.setAttribute(PERIOD, (Object)fp2.getString(PERIOD));
        this.request.setAttribute(DATASET_ID, (Object)fp2.getInt(DATASET_ID));
        Date jobDate = fp2.getDateTime(DATE_START_JOB);
        HashMap<String, Object> presetValues = new HashMap<String, Object>();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(jobDate);
        presetValues.put("jobHour", calendar.get(11));
        presetValues.put("jobMinute", calendar.get(12));
        presetValues.put("jobDate", this.local_df.format(jobDate));
        fp2.setPresetValues(presetValues);
        this.setPresetValues(fp2.getPresetValues());
        this.request.setAttribute(DATE_START_JOB, (Object)fp2.getDateTime("jobDate"));
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        TriggerService triggerService = new TriggerService();
        this.scheduler = this.getScheduler();
        String action = fp.getString("action");
        ExtractUtils extractUtils = new ExtractUtils();
        if (StringUtil.isBlank((String)action)) {
            this.setUpServlet();
            this.forwardPage(Page.CREATE_JOB_EXPORT);
        } else if ("confirmall".equalsIgnoreCase(action)) {
            XsltTriggerService xsltService = new XsltTriggerService();
            Set triggerKeySet = this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)xsltService.getTriggerGroupNameForExportJobs()));
            TriggerKey[] triggerKeys = (TriggerKey[])triggerKeySet.stream().toArray(TriggerKey[]::new);
            HashMap errors = this.validateForm(fp, this.request, triggerKeys, "");
            if (!errors.isEmpty()) {
                this.request.setAttribute("formMessages", (Object)errors);
                logger.info("has validation errors in the first section");
                logger.info("errors found: " + errors.toString());
                this.setUpServlet();
                this.forwardPage(Page.CREATE_JOB_EXPORT);
            } else {
                logger.info("found no validation errors, continuing");
                StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
                DatasetDAO datasetDao = new DatasetDAO(this.sm.getDataSource());
                UserAccountBean userBean = (UserAccountBean)this.request.getSession().getAttribute("userBean");
                CoreResources cr = new CoreResources();
                int datasetId = fp.getInt(DATASET_ID);
                String period = fp.getString(PERIOD);
                String email = fp.getString(EMAIL);
                String jobName = fp.getString(JOB_NAME);
                String jobDesc = fp.getString(JOB_DESC);
                Date startDateTime = fp.getDateTime(DATE_START_JOB);
                Integer exportFormatId = fp.getInt(FORMAT_ID);
                ExtractPropertyBean epBean = cr.findExtractPropertyBeanById(exportFormatId.intValue(), "" + datasetId);
                DatasetBean dsBean = (DatasetBean)datasetDao.findByPK(new Integer(datasetId).intValue());
                String[] files = epBean.getFileName();
                int fileSize = files.length;
                int cnt = 0;
                dsBean.setName(dsBean.getName().replaceAll(" ", "_"));
                String[] exportFiles = epBean.getExportFileName();
                String pattern = "yyyy" + File.separator + "MM" + File.separator + "dd" + File.separator + "HHmmssSSS" + File.separator;
                SimpleDateFormat sdfDir = new SimpleDateFormat(pattern);
                String[] temp = new String[exportFiles.length];
                String datasetFilePath = SQLInitServlet.getField((String)"filePath") + "datasets";
                for (int i = 0; i < exportFiles.length; ++i) {
                    temp[i] = extractUtils.resolveVars(exportFiles[i], dsBean, sdfDir, datasetFilePath);
                }
                epBean.setDoNotDelFiles(temp);
                epBean.setExportFileName(temp);
                String generalFileDir = SQLInitServlet.getField((String)"filePath");
                generalFileDir = generalFileDir + "datasets" + File.separator + dsBean.getId() + File.separator + sdfDir.format(new Date());
                String exportFileName = epBean.getExportFileName()[cnt];
                String xsltPath = SQLInitServlet.getField((String)"filePath") + "xslt" + File.separator + files[cnt];
                String endFilePath = epBean.getFileLocation();
                endFilePath = extractUtils.getEndFilePath(endFilePath, dsBean, sdfDir, datasetFilePath);
                if (epBean.getPostProcExportName() != null) {
                    String preProcExportPathName = extractUtils.resolveVars(epBean.getPostProcExportName(), dsBean, sdfDir, datasetFilePath);
                    epBean.setPostProcExportName(preProcExportPathName);
                }
                if (epBean.getPostProcLocation() != null) {
                    String prePocLoc = extractUtils.getEndFilePath(epBean.getPostProcLocation(), dsBean, sdfDir, datasetFilePath);
                    epBean.setPostProcLocation(prePocLoc);
                }
                extractUtils.setAllProps(epBean, dsBean, sdfDir, datasetFilePath);
                SimpleTrigger trigger = null;
                trigger = xsltService.generateXsltTrigger(xsltPath, generalFileDir, endFilePath + File.separator, exportFileName, dsBean.getId(), epBean, userBean, LocaleResolver.getLocale((HttpServletRequest)this.request).getLanguage(), cnt, SQLInitServlet.getField((String)"filePath") + "xslt", xsltService.getTriggerGroupNameForExportJobs());
                trigger = (SimpleTrigger)trigger.getTriggerBuilder().withIdentity(jobName, xsltService.getTriggerGroupNameForExportJobs()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(64000).withIntervalInSeconds(XsltTriggerService.getIntervalTimeInSeconds((String)period)).withMisfireHandlingInstructionNextWithExistingCount()).startAt(startDateTime).forJob(jobName, xsltService.getTriggerGroupNameForExportJobs()).withDescription(jobDesc).build();
                trigger.getJobDataMap().put(EMAIL, email);
                trigger.getJobDataMap().put(PERIOD, period);
                trigger.getJobDataMap().put("exportFormat", epBean.getFiledescription());
                trigger.getJobDataMap().put("exportFormatId", (Object)exportFormatId);
                trigger.getJobDataMap().put(JOB_NAME, jobName);
                trigger.getJobDataMap().put("job_type", "exportJob");
                JobDetailFactoryBean jobDetailBean = new JobDetailFactoryBean();
                jobDetailBean.setGroup(xsltService.getTriggerGroupNameForExportJobs());
                jobDetailBean.setName(jobName);
                jobDetailBean.setJobClass(XsltStatefulJob.class);
                jobDetailBean.setJobDataMap(trigger.getJobDataMap());
                jobDetailBean.setDurability(true);
                jobDetailBean.afterPropertiesSet();
                try {
                    Date dateStart = this.scheduler.scheduleJob(jobDetailBean.getObject(), (Trigger)trigger);
                    logger.info("== found job date: " + dateStart.toString());
                }
                catch (SchedulerException se) {
                    logger.error("Scheduler is not able to schedule the job correctly: ", (Throwable)se);
                    this.setUpServlet();
                    this.addPageMessage("Error creating Job.");
                    this.forwardPage(Page.VIEW_JOB_SERVLET);
                    return;
                }
                this.setUpServlet();
                this.addPageMessage("You have successfully created a new job: " + jobName + " which is now set to run at the time you specified.");
                this.forwardPage(Page.VIEW_JOB_SERVLET);
            }
        } else {
            this.forwardPage(Page.ADMIN_SYSTEM);
        }
    }

    public HashMap validateForm(FormProcessor fp, HttpServletRequest request, TriggerKey[] triggerKeys, String properName) {
        String jobDesc;
        Validator v = new Validator(request);
        v.addValidation(JOB_NAME, 1);
        v.addValidation(JOB_NAME, 46);
        v.addValidation(JOB_DESC, 1);
        v.addValidation(EMAIL, 6);
        v.addValidation(PERIOD, 1);
        v.addValidation("jobDate", 4);
        int formatId = fp.getInt(FORMAT_ID);
        Date jobDate = fp.getDateTime(DATE_START_JOB);
        HashMap errors = v.validate();
        if (formatId == 0) {
            Validator.addError((HashMap)errors, (String)FORMAT_ID, (String)"Please pick at least one.");
        }
        for (TriggerKey triggerKey : triggerKeys) {
            if (!triggerKey.getName().equals(fp.getString(JOB_NAME)) || triggerKey.getName().equals(properName)) continue;
            Validator.addError((HashMap)errors, (String)JOB_NAME, (String)"A job with that name already exists.  Please pick another name.");
        }
        if (jobDate.before(new Date())) {
            Validator.addError((HashMap)errors, (String)"jobDate", (String)"This date needs to be later than the present time.");
        }
        if (null != (jobDesc = fp.getString(JOB_DESC)) && !jobDesc.equals("") && jobDesc.length() > 250) {
            Validator.addError((HashMap)errors, (String)JOB_DESC, (String)"A job description cannot be more than 250 characters.");
        }
        return errors;
    }
}

