/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.TermType;
import org.akaza.openclinica.bean.core.UserType;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.dao.core.EntityDAO;
import org.akaza.openclinica.dao.hibernate.AuthoritiesDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.user.AuthoritiesBean;
import org.akaza.openclinica.domain.user.LdapUser;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.user.LdapUserService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;

public class CreateUserAccountServlet
extends SecureController {
    Locale locale;
    public static final String INPUT_USER_SOURCE = "userSource";
    public static final String INPUT_USERNAME = "userName";
    public static final String INPUT_FIRST_NAME = "firstName";
    public static final String INPUT_LAST_NAME = "lastName";
    public static final String INPUT_EMAIL = "email";
    public static final String INPUT_INSTITUTION = "institutionalAffiliation";
    public static final String INPUT_STUDY = "activeStudy";
    public static final String INPUT_ROLE = "role";
    public static final String INPUT_TYPE = "type";
    public static final String INPUT_DISPLAY_PWD = "displayPwd";
    public static final String INPUT_RUN_WEBSERVICES = "runWebServices";
    public static final String USER_ACCOUNT_NOTIFICATION = "notifyPassword";

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (!this.ub.isSysAdmin()) {
            throw new InsufficientPermissionException(Page.MENU, resexception.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        ArrayList all = (ArrayList)sdao.findAll();
        ArrayList<StudyBean> finalList = new ArrayList<StudyBean>();
        for (StudyBean sb : all) {
            if (sb.getParentStudyId() > 0) continue;
            finalList.add(sb);
            finalList.addAll(sdao.findAllByParent(sb.getId()));
        }
        this.addEntityList("studies", finalList, respage.getString("a_user_cannot_be_created_no_study_as_active"), Page.ADMIN_SYSTEM);
        LinkedHashMap<Integer, String> roleMap = new LinkedHashMap<Integer, String>();
        for (Role role : this.getRoles()) {
            if (role.getId() == 7) continue;
            roleMap.put(role.getId(), role.getDescription());
        }
        this.request.setAttribute("roles", roleMap);
        ArrayList types = UserType.toArrayList();
        types.remove(UserType.INVALID);
        if (!this.ub.isTechAdmin()) {
            types.remove(UserType.TECHADMIN);
        }
        this.addEntityList("types", (Collection)types, respage.getString("a_user_cannot_be_created_no_user_types_for"), Page.ADMIN_SYSTEM);
        Boolean changeRoles = this.request.getParameter("changeRoles") == null ? false : Boolean.parseBoolean(this.request.getParameter("changeRoles"));
        int activeStudy = fp.getInt(INPUT_STUDY);
        if (changeRoles.booleanValue()) {
            StudyBean study = (StudyBean)sdao.findByPK(activeStudy);
            roleMap = new LinkedHashMap();
            ResourceBundle resterm = ResourceBundleProvider.getTermsBundle();
            if (study.getParentStudyId() > 0) {
                for (Role role : this.getRoles()) {
                    switch (role.getId()) {
                        case 4: {
                            roleMap.put(role.getId(), resterm.getString("site_investigator").trim());
                            break;
                        }
                        case 5: {
                            roleMap.put(role.getId(), resterm.getString("site_Data_Entry_Person").trim());
                            break;
                        }
                        case 6: {
                            roleMap.put(role.getId(), resterm.getString("site_monitor").trim());
                            break;
                        }
                        case 7: {
                            roleMap.put(role.getId(), resterm.getString("site_Data_Entry_Person2").trim());
                            break;
                        }
                    }
                }
            } else {
                for (Role role : this.getRoles()) {
                    switch (role.getId()) {
                        case 2: {
                            roleMap.put(role.getId(), resterm.getString("Study_Coordinator").trim());
                            break;
                        }
                        case 3: {
                            roleMap.put(role.getId(), resterm.getString("Study_Director").trim());
                            break;
                        }
                        case 4: {
                            roleMap.put(role.getId(), resterm.getString("Investigator").trim());
                            break;
                        }
                        case 5: {
                            roleMap.put(role.getId(), resterm.getString("Data_Entry_Person").trim());
                            break;
                        }
                        case 6: {
                            roleMap.put(role.getId(), resterm.getString("Monitor").trim());
                            break;
                        }
                    }
                }
            }
            this.request.setAttribute("roles", roleMap);
        }
        this.request.setAttribute("ldapEnabled", (Object)this.isLdapEnabled());
        this.request.setAttribute(INPUT_STUDY, (Object)activeStudy);
        if (!fp.isSubmitted() || changeRoles.booleanValue()) {
            String[] textFields = new String[]{INPUT_USER_SOURCE, INPUT_USERNAME, INPUT_FIRST_NAME, INPUT_LAST_NAME, INPUT_EMAIL, INPUT_INSTITUTION, INPUT_DISPLAY_PWD};
            fp.setCurrentStringValuesAsPreset(textFields);
            String[] ddlbFields = new String[]{INPUT_STUDY, INPUT_ROLE, INPUT_TYPE, INPUT_RUN_WEBSERVICES};
            fp.setCurrentIntValuesAsPreset(ddlbFields);
            HashMap presetValues = fp.getPresetValues();
            String sendPwd = SQLInitServlet.getField((String)"user_account_notification");
            fp.addPresetValue(USER_ACCOUNT_NOTIFICATION, sendPwd);
            this.setPresetValues(presetValues);
            this.forwardPage(Page.CREATE_ACCOUNT);
        } else {
            UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
            Validator v = new Validator(this.request);
            v.addValidation(INPUT_USERNAME, 1);
            v.addValidation(INPUT_USERNAME, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
            v.addValidation(INPUT_USERNAME, 16);
            v.addValidation(INPUT_USERNAME, 9, (EntityDAO)udao);
            v.addValidation(INPUT_FIRST_NAME, 1);
            v.addValidation(INPUT_LAST_NAME, 1);
            v.addValidation(INPUT_FIRST_NAME, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 50);
            v.addValidation(INPUT_LAST_NAME, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 50);
            v.addValidation(INPUT_EMAIL, 1);
            v.addValidation(INPUT_EMAIL, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 120);
            v.addValidation(INPUT_EMAIL, 6);
            v.addValidation(INPUT_INSTITUTION, 1);
            v.addValidation(INPUT_INSTITUTION, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
            v.addValidation(INPUT_STUDY, 8, (EntityDAO)sdao);
            v.addValidation(INPUT_ROLE, 17, TermType.ROLE);
            HashMap errors = v.validate();
            if (errors.isEmpty()) {
                UserAccountBean createdUserAccountBean = new UserAccountBean();
                createdUserAccountBean.setName(fp.getString(INPUT_USERNAME));
                createdUserAccountBean.setFirstName(fp.getString(INPUT_FIRST_NAME));
                createdUserAccountBean.setLastName(fp.getString(INPUT_LAST_NAME));
                createdUserAccountBean.setEmail(fp.getString(INPUT_EMAIL));
                createdUserAccountBean.setInstitutionalAffiliation(fp.getString(INPUT_INSTITUTION));
                boolean isLdap = fp.getString(INPUT_USER_SOURCE).equals("ldap");
                String password = null;
                String passwordHash = "*";
                if (!isLdap) {
                    SecurityManager secm = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
                    password = secm.genPassword();
                    passwordHash = secm.encrytPassword(password, this.getUserDetails());
                }
                createdUserAccountBean.setPasswd(passwordHash);
                createdUserAccountBean.setPasswdTimestamp(null);
                createdUserAccountBean.setLastVisitDate(null);
                createdUserAccountBean.setStatus(Status.AVAILABLE);
                createdUserAccountBean.setPasswdChallengeQuestion("");
                createdUserAccountBean.setPasswdChallengeAnswer("");
                createdUserAccountBean.setPhone("");
                createdUserAccountBean.setOwner(this.ub);
                createdUserAccountBean.setRunWebservices(Boolean.valueOf(fp.getBoolean(INPUT_RUN_WEBSERVICES)));
                createdUserAccountBean.setAccessCode("null");
                createdUserAccountBean.setEnableApiKey(true);
                String apiKey = null;
                while (this.isApiKeyExist(apiKey = this.getRandom32ChApiKey()).booleanValue()) {
                }
                createdUserAccountBean.setApiKey(apiKey);
                int studyId = fp.getInt(INPUT_STUDY);
                Role r = Role.get((int)fp.getInt(INPUT_ROLE));
                createdUserAccountBean = this.addActiveStudyRole(createdUserAccountBean, studyId, r);
                UserType type = UserType.get((int)fp.getInt(INPUT_TYPE));
                logger.debug("*** found type: " + fp.getInt(INPUT_TYPE));
                logger.debug("*** setting type: " + type.getDescription());
                createdUserAccountBean.addUserType(type);
                createdUserAccountBean = (UserAccountBean)udao.create((EntityBean)createdUserAccountBean);
                AuthoritiesDao authoritiesDao = (AuthoritiesDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("authoritiesDao");
                authoritiesDao.saveOrUpdate((DomainObject)new AuthoritiesBean(createdUserAccountBean.getName()));
                String displayPwd = fp.getString(INPUT_DISPLAY_PWD);
                if (createdUserAccountBean.isActive()) {
                    this.addPageMessage(respage.getString("the_user_account") + "\"" + createdUserAccountBean.getName() + "\"" + respage.getString("was_created_succesfully"));
                    if (!isLdap) {
                        if ("no".equalsIgnoreCase(displayPwd)) {
                            try {
                                this.sendNewAccountEmail(createdUserAccountBean, password);
                            }
                            catch (Exception e) {
                                this.addPageMessage(respage.getString("there_was_an_error_sending_account_creating_mail"));
                            }
                        } else {
                            this.addPageMessage(respage.getString("user_password") + ":<br/>" + password + "<br/> " + respage.getString("please_write_down_the_password_and_provide"));
                        }
                    }
                } else {
                    this.addPageMessage(respage.getString("the_user_account") + "\"" + createdUserAccountBean.getName() + "\"" + respage.getString("could_not_created_due_database_error"));
                }
                if (createdUserAccountBean.isActive()) {
                    this.request.setAttribute("userId", (Object)new Integer(createdUserAccountBean.getId()).toString());
                    this.forwardPage(Page.VIEW_USER_ACCOUNT_SERVLET);
                } else {
                    this.forwardPage(Page.LIST_USER_ACCOUNTS_SERVLET);
                }
            } else {
                String[] textFields = new String[]{INPUT_USERNAME, INPUT_FIRST_NAME, INPUT_LAST_NAME, INPUT_EMAIL, INPUT_INSTITUTION, INPUT_DISPLAY_PWD, INPUT_USER_SOURCE};
                fp.setCurrentStringValuesAsPreset(textFields);
                String[] ddlbFields = new String[]{INPUT_STUDY, INPUT_ROLE, INPUT_TYPE, INPUT_RUN_WEBSERVICES};
                fp.setCurrentIntValuesAsPreset(ddlbFields);
                HashMap presetValues = fp.getPresetValues();
                this.setPresetValues(presetValues);
                this.setInputMessages(errors);
                this.addPageMessage(respage.getString("there_were_some_errors_submission") + respage.getString("see_below_for_details"));
                this.forwardPage(Page.CREATE_ACCOUNT);
            }
        }
    }

    protected boolean isLdapEnabled() {
        LdapUserService ldapUserService = (LdapUserService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(LdapUserService.class);
        return ldapUserService.isLdapServerConfigured();
    }

    protected void setPresetValues(HashMap presetValues) {
        LdapUser ldapUser;
        HashMap<String, String> map = presetValues;
        if (this.isLdapEnabled() && (ldapUser = (LdapUser)this.session.getAttribute("ldapUser")) != null) {
            this.session.removeAttribute("ldapUser");
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put(INPUT_USERNAME, ldapUser.getUsername());
            map.put(INPUT_FIRST_NAME, ldapUser.getFirstName());
            map.put(INPUT_LAST_NAME, ldapUser.getLastName());
            map.put(INPUT_EMAIL, ldapUser.getEmail());
            map.put(INPUT_INSTITUTION, ldapUser.getOrganization());
        }
        super.setPresetValues((HashMap)map);
    }

    private ArrayList getRoles() {
        ArrayList roles = Role.toArrayList();
        roles.remove(Role.ADMIN);
        return roles;
    }

    private UserAccountBean addActiveStudyRole(UserAccountBean createdUserAccountBean, int studyId, Role r) {
        createdUserAccountBean.setActiveStudyId(studyId);
        StudyUserRoleBean activeStudyRole = new StudyUserRoleBean();
        activeStudyRole.setStudyId(studyId);
        activeStudyRole.setRoleName(r.getName());
        activeStudyRole.setStatus(Status.AVAILABLE);
        activeStudyRole.setOwner(this.ub);
        createdUserAccountBean.addRole(activeStudyRole);
        return createdUserAccountBean;
    }

    private void sendNewAccountEmail(UserAccountBean createdUserAccountBean, String password) throws Exception {
        logger.debug("Sending account creation notification to " + createdUserAccountBean.getName());
        StringBuffer body = new StringBuffer();
        body.append(resword.getString("dear") + " " + createdUserAccountBean.getFirstName() + " " + createdUserAccountBean.getLastName() + ",<br><br> ");
        body.append(restext.getString("a_new_user_account_has_been_created_for_you") + "<br><br>");
        body.append(resword.getString("user_name") + ": " + createdUserAccountBean.getName() + "<br>");
        body.append(resword.getString("password") + ": " + password + "<br><br>");
        body.append(restext.getString("please_test_your_login_information_and_let") + "<br>");
        body.append(SQLInitServlet.getField((String)"sysURL"));
        this.sendEmail(createdUserAccountBean.getEmail().trim(), restext.getString("your_new_openclinica_account"), body.toString(), Boolean.valueOf(false));
    }

    protected String getAdminServlet() {
        return "admin";
    }

    public Boolean isApiKeyExist(String uuid) {
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean uBean = (UserAccountBean)udao.findByApiKey(uuid);
        if (uBean == null || !uBean.isActive()) {
            return false;
        }
        return true;
    }

    public String getRandom32ChApiKey() {
        String uuid = UUID.randomUUID().toString();
        logger.debug(uuid.replaceAll("-", ""));
        return uuid.replaceAll("-", "");
    }
}

