/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import org.akaza.openclinica.bean.admin.NewCRFBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class DeleteCRFVersionServlet
extends SecureController {
    public static final String VERSION_ID = "verId";
    public static final String VERSION_TO_DELETE = "version";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.CRF_LIST_SERVLET, "not admin", "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int versionId = fp.getInt(VERSION_ID, true);
        String action = this.request.getParameter("action");
        if (versionId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_version_to_delete"));
            this.forwardPage(Page.CRF_LIST_SERVLET);
        } else {
            CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
            StudyEventDefinitionDAO sedDao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            StudyEventDAO seDao = new StudyEventDAO(this.sm.getDataSource());
            ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
            CRFVersionBean version = (CRFVersionBean)cvdao.findByPK(versionId);
            ArrayList definitions = edcdao.findByDefaultVersion(version.getId());
            for (Object edcBean : definitions) {
                StudyEventDefinitionBean sedBean = (StudyEventDefinitionBean)sedDao.findByPK(((EventDefinitionCRFBean)edcBean).getStudyEventDefinitionId());
                ((EventDefinitionCRFBean)edcBean).setEventName(sedBean.getName());
            }
            ArrayList idBeans = iddao.findByCRFVersion(version);
            ArrayList eCRFs = ecdao.findAllByCRF(version.getCrfId());
            for (EventCRFBean eCRF : eCRFs) {
                StudySubjectBean ssBean = (StudySubjectBean)ssdao.findByPK(eCRF.getStudySubjectId());
                eCRF.setStudySubject(ssBean);
                StudyEventBean seBean = (StudyEventBean)seDao.findByPK(eCRF.getStudyEventId());
                StudyEventDefinitionBean sedBean = (StudyEventDefinitionBean)sedDao.findByPK(seBean.getStudyEventDefinitionId());
                seBean.setStudyEventDefinition(sedBean);
                eCRF.setStudyEvent(seBean);
            }
            ArrayList eventCRFs = ecdao.findAllByCRFVersion(versionId);
            boolean canDelete = true;
            if (!definitions.isEmpty()) {
                canDelete = false;
                this.request.setAttribute("definitions", (Object)definitions);
                this.addPageMessage(respage.getString("this_CRF_version") + " " + version.getName() + respage.getString("has_associated_study_events_definitions_cannot_delete"));
            } else if (!idBeans.isEmpty()) {
                canDelete = false;
                this.request.setAttribute("eventCRFs", (Object)eCRFs);
                this.request.setAttribute("itemDataForVersion", (Object)idBeans);
                this.addPageMessage(respage.getString("this_CRF_version") + " " + version.getName() + respage.getString("has_associated_item_data_cannot_delete"));
            } else if (!eventCRFs.isEmpty()) {
                canDelete = false;
                this.request.setAttribute("eventsForVersion", (Object)eventCRFs);
                this.addPageMessage(respage.getString("this_CRF_version") + " " + version.getName() + respage.getString("has_associated_study_events_cannot_delete"));
            }
            if ("confirm".equalsIgnoreCase(action)) {
                this.request.setAttribute(VERSION_TO_DELETE, (Object)version);
                this.forwardPage(Page.DELETE_CRF_VERSION);
            } else {
                if (canDelete) {
                    ArrayList items = cvdao.findNotSharedItemsByVersion(versionId);
                    NewCRFBean nib = new NewCRFBean(this.sm.getDataSource(), version.getCrfId());
                    nib.setDeleteQueries(cvdao.generateDeleteQueries(versionId, items));
                    nib.deleteFromDB();
                    this.addPageMessage(respage.getString("the_CRF_version_has_been_deleted_succesfully"));
                } else {
                    this.addPageMessage(respage.getString("the_CRF_version_cannot_be_deleted"));
                }
                this.forwardPage(Page.CRF_LIST_SERVLET);
            }
        }
    }
}

