/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import org.akaza.openclinica.bean.core.EntityAction;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class DeleteStudyUserRoleServlet
extends SecureController {
    public static final String PATH = "DeleteStudyUserRole";
    public static final String ARG_USERNAME = "userName";
    public static final String ARG_STUDYID = "studyId";
    public static final String ARG_ACTION = "action";

    public static String getLink(String userName, int studyId, EntityAction action) {
        return "DeleteStudyUserRole?userName=" + userName + "&" + ARG_STUDYID + "=" + studyId + "&" + ARG_ACTION + "=" + action.getId();
    }

    protected void mayProceed() throws InsufficientPermissionException {
        if (!this.ub.isSysAdmin()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
            throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        String message;
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int studyId = fp.getInt(ARG_STUDYID);
        String uName = fp.getString(ARG_USERNAME);
        UserAccountBean user = (UserAccountBean)udao.findByUserName(uName);
        int action = fp.getInt(ARG_ACTION);
        StudyUserRoleBean s = udao.findRoleByUserNameAndStudyId(uName, studyId);
        if (!s.isActive()) {
            message = respage.getString("the_specified_user_role_not_exits_for_study");
        } else if (!EntityAction.contains((int)action)) {
            message = respage.getString("the_specified_action_is_invalid");
        } else if (!EntityAction.get((int)action).equals((Term)EntityAction.DELETE) && !EntityAction.get((int)action).equals((Term)EntityAction.RESTORE)) {
            message = respage.getString("the_specified_action_is_not_allowed");
        } else if (EntityAction.get((int)action).equals((Term)EntityAction.RESTORE) && user.getStatus().equals((Term)Status.DELETED)) {
            message = respage.getString("the_role_cannot_be_restored_since_user_deleted");
        } else {
            EntityAction desiredAction = EntityAction.get((int)action);
            if (desiredAction.equals((Term)EntityAction.DELETE)) {
                s.setStatus(Status.DELETED);
                message = respage.getString("the_study_user_role_deleted");
            } else {
                s.setStatus(Status.AVAILABLE);
                message = respage.getString("the_study_user_role_restored");
            }
            s.setUpdater(this.ub);
            udao.updateStudyUserRole(s, uName);
        }
        this.addPageMessage(message);
        this.forwardPage(Page.LIST_USER_ACCOUNTS_SERVLET);
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

