/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.EntityAction;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;

public class DeleteUserServlet
extends SecureController {
    private static final long serialVersionUID = 298106781476442393L;
    Locale locale;
    public static final String PATH = "DeleteUser";
    public static final String ARG_USERID = "userId";
    public static final String ARG_ACTION = "action";

    public static String getLink(UserAccountBean u, EntityAction action) {
        return "DeleteUser?userId=" + u.getId() + "&&" + ARG_ACTION + "=" + action.getId();
    }

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (!this.ub.isSysAdmin()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
            throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        String message;
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int userId = fp.getInt(ARG_USERID);
        int action = fp.getInt(ARG_ACTION);
        UserAccountBean u = (UserAccountBean)udao.findByPK(userId);
        if (!u.isActive()) {
            message = respage.getString("the_specified_user_not_exits");
        } else if (!EntityAction.contains((int)action)) {
            message = respage.getString("the_specified_action_on_the_user_is_invalid");
        } else if (!EntityAction.get((int)action).equals((Term)EntityAction.DELETE) && !EntityAction.get((int)action).equals((Term)EntityAction.RESTORE)) {
            message = respage.getString("the_specified_action_is_not_allowed");
        } else {
            EntityAction desiredAction = EntityAction.get((int)action);
            u.setUpdater(this.ub);
            if (desiredAction.equals((Term)EntityAction.DELETE)) {
                udao.delete(u);
                message = udao.isQuerySuccessful() ? respage.getString("the_user_has_been_removed_successfully") : respage.getString("the_user_could_not_be_deleted_due_database_error");
            } else {
                SecurityManager sm = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
                String password = sm.genPassword();
                String passwordHash = sm.encrytPassword(password, this.getUserDetails());
                if (!u.isLdapUser()) {
                    u.setPasswd(passwordHash);
                    u.setPasswdTimestamp(null);
                }
                udao.restore(u);
                if (udao.isQuerySuccessful()) {
                    message = respage.getString("the_user_has_been_restored");
                    try {
                        if (!u.isLdapUser()) {
                            this.sendRestoreEmail(u, password);
                        }
                    }
                    catch (Exception e) {
                        message = message + respage.getString("however_was_error_sending_user_email_regarding");
                    }
                } else {
                    message = respage.getString("the_user_could_not_be_deleted_due_database_error");
                }
            }
        }
        this.addPageMessage(message);
        this.forwardPage(Page.LIST_USER_ACCOUNTS_SERVLET);
    }

    private void sendRestoreEmail(UserAccountBean u, String password) throws Exception {
        logger.info("Sending restore and password reset notification to " + u.getName());
        String body = resword.getString("dear") + " " + u.getFirstName() + " " + u.getLastName() + ",\n";
        body = body + restext.getString("your_account_has_been_restored_and_password_reset") + ":\n\n";
        body = body + resword.getString("user_name") + " " + u.getName() + "\n";
        body = body + resword.getString("password") + " " + password + "\n\n";
        body = body + restext.getString("please_test_your_login_information_and_let") + "\n";
        body = body + SQLInitServlet.getField((String)"sysURL");
        body = body + " . ";
        body = body + restext.getString("openclinica_system_administrator");
        logger.info("Sending email...begin");
        this.sendEmail(u.getEmail().trim(), restext.getString("your_new_openclinica_account_has_been_restored"), body, Boolean.valueOf(false));
        logger.info("Sending email...done");
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

