/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;

public class DownloadVersionSpreadSheetServlet
extends SecureController {
    public static String CRF_ID = "crfId";
    public static String CRF_VERSION_NAME = "crfVersionName";
    public static String CRF_VERSION_ID = "crfVersionId";
    public static String CRF_VERSION_TEMPLATE = "CRF_Template_lc_v1.0.xls";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MANAGE_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    private CoreResources getCoreResources() {
        return (CoreResources)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("coreResources");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest() throws Exception {
        String dir = SQLInitServlet.getField((String)"filePath") + "crf" + File.separator + "new" + File.separator;
        FormProcessor fp = new FormProcessor(this.request);
        String crfIdString = fp.getString(CRF_ID);
        int crfVersionId = fp.getInt(CRF_VERSION_ID);
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        CRFVersionBean version = (CRFVersionBean)cvdao.findByPK(crfVersionId);
        boolean isTemplate = fp.getBoolean("template");
        String excelFileName = crfIdString + version.getOid() + ".xls";
        File excelFile = null;
        String oldExcelFileName = crfIdString + version.getName() + ".xls";
        if (isTemplate) {
            excelFile = this.getCoreResources().getFile(CRF_VERSION_TEMPLATE, "crf" + File.separator + "original" + File.separator);
            excelFileName = CRF_VERSION_TEMPLATE;
        } else {
            excelFile = new File(dir + excelFileName);
            File oldExcelFile = new File(dir + oldExcelFileName);
            if (oldExcelFile.exists() && oldExcelFile.length() > 0L && (!excelFile.exists() || excelFile.length() <= 0L)) {
                excelFile = oldExcelFile;
                excelFileName = oldExcelFileName;
            }
        }
        logger.info("looking for : " + excelFile.getName());
        if (!excelFile.exists() || excelFile.length() <= 0L) {
            this.addPageMessage(respage.getString("the_excel_is_not_available_on_server_contact"));
            this.forwardPage(Page.CRF_LIST_SERVLET);
        } else {
            this.response.setHeader("Content-disposition", "attachment; filename=\"" + excelFileName + "\";");
            this.response.setContentType("application/vnd.ms-excel");
            this.response.setHeader("Pragma", "public");
            ServletOutputStream op = this.response.getOutputStream();
            FilterInputStream in = null;
            try {
                int length;
                this.response.setContentType("application/vnd.ms-excel");
                this.response.setHeader("Pragma", "public");
                this.response.setContentLength((int)excelFile.length());
                byte[] bbuf = new byte[(int)excelFile.length()];
                in = new DataInputStream(new FileInputStream(excelFile));
                while (in != null && (length = ((DataInputStream)in).read(bbuf)) != -1) {
                    op.write(bbuf, 0, length);
                }
                in.close();
                op.flush();
                op.close();
            }
            catch (Exception ee) {
                logger.error("Input Stream is not working properly: ", (Throwable)ee);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (op != null) {
                    op.close();
                }
            }
        }
    }
}

