/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.UserAccountRow;

public class ListUserAccountsServlet
extends SecureController {
    public static final String PATH = "ListUserAccounts";
    public static final String ARG_MESSAGE = "message";

    protected void mayProceed() throws InsufficientPermissionException {
        if (!this.ub.isSysAdmin()) {
            this.addPageMessage(respage.getString("you_may_not_perform_administrative_functions"));
            throw new InsufficientPermissionException(Page.ADMIN_SYSTEM_SERVLET, respage.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList allUsers = this.getAllUsers(udao);
        this.setStudyNamesInStudyUserRoles(allUsers);
        ArrayList allUserRows = UserAccountRow.generateRowsFromBeans((ArrayList)allUsers);
        String[] columns = new String[]{resword.getString("user_name"), resword.getString("first_name"), resword.getString("last_name"), resword.getString("status"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(4);
        table.setQuery(PATH, new HashMap());
        table.addLink(resword.getString("create_a_new_user"), "CreateUserAccount");
        table.setRows(allUserRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        String message = fp.getString(ARG_MESSAGE, true);
        this.request.setAttribute(ARG_MESSAGE, (Object)message);
        this.request.setAttribute("siteRoleMap", (Object)Role.siteRoleMap);
        this.request.setAttribute("studyRoleMap", (Object)Role.studyRoleMap);
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        if (allUsers.size() > 0) {
            this.setToPanel(resword.getString("users"), new Integer(allUsers.size()).toString());
        }
        this.forwardPage(Page.LIST_USER_ACCOUNTS);
    }

    private ArrayList getAllUsers(UserAccountDAO udao) {
        ArrayList result = (ArrayList)udao.findAll();
        return result;
    }

    private void setStudyNamesInStudyUserRoles(ArrayList users) {
        int i;
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        ArrayList allStudies = (ArrayList)sdao.findAll();
        HashMap<Integer, StudyBean> studiesById = new HashMap<Integer, StudyBean>();
        for (i = 0; i < allStudies.size(); ++i) {
            StudyBean sb = (StudyBean)allStudies.get(i);
            studiesById.put(new Integer(sb.getId()), sb);
        }
        for (i = 0; i < users.size(); ++i) {
            UserAccountBean u = (UserAccountBean)users.get(i);
            ArrayList roles = u.getRoles();
            for (int j = 0; j < roles.size(); ++j) {
                StudyUserRoleBean surb = (StudyUserRoleBean)roles.get(j);
                StudyBean sb = (StudyBean)studiesById.get(new Integer(surb.getStudyId()));
                if (sb != null) {
                    surb.setStudyName(sb.getName());
                    surb.setParentStudyId(sb.getParentStudyId());
                }
                roles.set(j, surb);
            }
            u.setRoles(roles);
            users.set(i, u);
        }
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

