/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Date;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RestoreCRFServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.CRF_LIST_SERVLET, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        int crfId = fp.getInt("id", true);
        String action = this.request.getParameter("action");
        if (crfId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_to_restore"));
            this.forwardPage(Page.CRF_LIST_SERVLET);
        } else {
            CRFBean crf = (CRFBean)cdao.findByPK(crfId);
            ArrayList versions = cvdao.findAllByCRFId(crfId);
            crf.setVersions(versions);
            EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
            ArrayList edcs = (ArrayList)edcdao.findAllByCRF(crfId);
            SectionDAO secdao = new SectionDAO(this.sm.getDataSource());
            EventCRFDAO evdao = new EventCRFDAO(this.sm.getDataSource());
            ArrayList eventCRFs = evdao.findAllByCRF(crfId);
            if ("confirm".equalsIgnoreCase(action)) {
                this.request.setAttribute("crfToRestore", (Object)crf);
                this.request.setAttribute("eventCRFs", (Object)eventCRFs);
                this.forwardPage(Page.RESTORE_CRF);
            } else {
                int i;
                logger.info("submit to restore the crf");
                crf.setStatus(Status.AVAILABLE);
                crf.setUpdater(this.ub);
                crf.setUpdatedDate(new Date());
                cdao.update((EntityBean)crf);
                for (i = 0; i < versions.size(); ++i) {
                    CRFVersionBean version = (CRFVersionBean)versions.get(i);
                    if (!version.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                    version.setStatus(Status.AVAILABLE);
                    version.setUpdater(this.ub);
                    version.setUpdatedDate(new Date());
                    cvdao.update((EntityBean)version);
                    ArrayList sections = secdao.findAllByCRFVersionId(version.getId());
                    for (int j = 0; j < sections.size(); ++j) {
                        SectionBean section = (SectionBean)sections.get(j);
                        if (!section.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                        section.setStatus(Status.AVAILABLE);
                        section.setUpdater(this.ub);
                        section.setUpdatedDate(new Date());
                        secdao.update((EntityBean)section);
                    }
                }
                for (i = 0; i < edcs.size(); ++i) {
                    EventDefinitionCRFBean edc = (EventDefinitionCRFBean)edcs.get(i);
                    if (!edc.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                    edc.setStatus(Status.AVAILABLE);
                    edc.setUpdater(this.ub);
                    edc.setUpdatedDate(new Date());
                    edcdao.update((EntityBean)edc);
                }
                ItemDataDAO idao = new ItemDataDAO(this.sm.getDataSource());
                for (int i2 = 0; i2 < eventCRFs.size(); ++i2) {
                    EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(i2);
                    if (!eventCRF.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                    eventCRF.setStatus(Status.AVAILABLE);
                    eventCRF.setUpdater(this.ub);
                    eventCRF.setUpdatedDate(new Date());
                    evdao.update((EntityBean)eventCRF);
                    ArrayList items = idao.findAllByEventCRFId(eventCRF.getId());
                    for (int j = 0; j < items.size(); ++j) {
                        ItemDataBean item = (ItemDataBean)items.get(j);
                        if (!item.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                        item.setStatus(Status.AVAILABLE);
                        item.setUpdater(this.ub);
                        item.setUpdatedDate(new Date());
                        idao.update((EntityBean)item);
                    }
                }
                this.addPageMessage(respage.getString("the_CRF") + crf.getName() + " " + respage.getString("has_been_restored_succesfully"));
                this.forwardPage(Page.CRF_LIST_SERVLET);
            }
        }
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

