/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Date;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RestoreCRFVersionServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.CRF_LIST_SERVLET, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        int versionId = fp.getInt("id", true);
        String action = fp.getString("action");
        if (versionId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_version_to_restore"));
            this.forwardPage(Page.CRF_LIST_SERVLET);
        } else {
            if (StringUtil.isBlank((String)action)) {
                this.addPageMessage(respage.getString("no_action_specified"));
                this.forwardPage(Page.CRF_LIST_SERVLET);
                return;
            }
            CRFVersionBean version = (CRFVersionBean)cvdao.findByPK(versionId);
            SectionDAO secdao = new SectionDAO(this.sm.getDataSource());
            EventCRFDAO evdao = new EventCRFDAO(this.sm.getDataSource());
            ArrayList eventCRFs = evdao.findAllByCRFVersion(versionId);
            if ("confirm".equalsIgnoreCase(action)) {
                this.request.setAttribute("versionToRestore", (Object)version);
                this.request.setAttribute("eventCRFs", (Object)eventCRFs);
                this.forwardPage(Page.RESTORE_CRF_VERSION);
            } else {
                logger.info("submit to restore the crf version");
                version.setStatus(Status.AVAILABLE);
                version.setUpdater(this.ub);
                version.setUpdatedDate(new Date());
                cvdao.update((EntityBean)version);
                ArrayList sections = secdao.findAllByCRFVersionId(version.getId());
                for (int j = 0; j < sections.size(); ++j) {
                    SectionBean section = (SectionBean)sections.get(j);
                    if (!section.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                    section.setStatus(Status.AVAILABLE);
                    section.setUpdater(this.ub);
                    section.setUpdatedDate(new Date());
                    secdao.update((EntityBean)section);
                }
                ItemDataDAO idao = new ItemDataDAO(this.sm.getDataSource());
                for (int i = 0; i < eventCRFs.size(); ++i) {
                    EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(i);
                    if (!eventCRF.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                    eventCRF.setStatus(Status.AVAILABLE);
                    eventCRF.setUpdater(this.ub);
                    eventCRF.setUpdatedDate(new Date());
                    evdao.update((EntityBean)eventCRF);
                    ArrayList items = idao.findAllByEventCRFId(eventCRF.getId());
                    for (int j = 0; j < items.size(); ++j) {
                        ItemDataBean item = (ItemDataBean)items.get(j);
                        if (!item.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                        item.setStatus(Status.AVAILABLE);
                        item.setUpdater(this.ub);
                        item.setUpdatedDate(new Date());
                        idao.update((EntityBean)item);
                    }
                }
                this.addPageMessage(respage.getString("the_CRF_version") + version.getName() + " " + respage.getString("has_been_restored_succesfully"));
                this.forwardPage(Page.CRF_LIST_SERVLET);
            }
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

