/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Date;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SubjectGroupMapBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RestoreStudyServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.STUDY_LIST_SERVLET, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int studyId = fp.getInt("id");
        StudyBean study = (StudyBean)sdao.findByPK(studyId);
        ArrayList sites = (ArrayList)sdao.findAllByParent(studyId);
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        ArrayList userRoles = udao.findAllByStudyId(studyId);
        StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
        ArrayList subjects = ssdao.findAllByStudy(study);
        StudyEventDefinitionDAO sefdao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        ArrayList definitions = sefdao.findAllByStudy(study);
        String action = this.request.getParameter("action");
        if (studyId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_study_to_restore"));
            this.forwardPage(Page.STUDY_LIST_SERVLET);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.request.setAttribute("studyToRestore", (Object)study);
            this.request.setAttribute("sitesToRestore", (Object)sites);
            this.request.setAttribute("userRolesToRestore", (Object)userRoles);
            this.request.setAttribute("subjectsToRestore", (Object)subjects);
            this.request.setAttribute("definitionsToRRestore", (Object)definitions);
            this.forwardPage(Page.RESTORE_STUDY);
        } else {
            int i;
            logger.info("submit to restore the study");
            StudyDAO studao = new StudyDAO(this.sm.getDataSource());
            study.setStatus(study.getOldStatus());
            study.setUpdater(this.ub);
            study.setUpdatedDate(new Date());
            studao.update((EntityBean)study);
            for (i = 0; i < sites.size(); ++i) {
                StudyBean site = (StudyBean)sites.get(i);
                if (site.getStatus() != Status.AUTO_DELETED) continue;
                site.setStatus(site.getOldStatus());
                site.setUpdater(this.ub);
                site.setUpdatedDate(new Date());
                sdao.update((EntityBean)site);
            }
            for (i = 0; i < userRoles.size(); ++i) {
                StudyUserRoleBean role = (StudyUserRoleBean)userRoles.get(i);
                if (!role.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                role.setStatus(Status.AVAILABLE);
                role.setUpdater(this.ub);
                role.setUpdatedDate(new Date());
                udao.updateStudyUserRole(role, role.getUserName());
            }
            if (study.getId() == this.currentStudy.getId()) {
                this.currentStudy.setStatus(Status.AVAILABLE);
                StudyUserRoleBean r = new UserAccountDAO(this.sm.getDataSource()).findRoleByUserNameAndStudyId(this.ub.getName(), this.currentStudy.getId());
                this.currentRole.setRole(r.getRole());
            } else if (this.currentStudy.getParentStudyId() == study.getId() && this.currentStudy.getStatus() == Status.AUTO_DELETED) {
                this.currentStudy.setStatus(Status.AVAILABLE);
                StudyUserRoleBean r = new UserAccountDAO(this.sm.getDataSource()).findRoleByUserNameAndStudyId(this.ub.getName(), this.currentStudy.getId());
                StudyUserRoleBean rInParent = new UserAccountDAO(this.sm.getDataSource()).findRoleByUserNameAndStudyId(this.ub.getName(), this.currentStudy.getParentStudyId());
                this.currentRole.setRole(Role.get((int)Role.max((Role)r.getRole(), (Role)rInParent.getRole()).getId()));
            }
            for (int i2 = 0; i2 < subjects.size(); ++i2) {
                StudySubjectBean subject = (StudySubjectBean)subjects.get(i2);
                if (!subject.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                subject.setStatus(Status.AVAILABLE);
                subject.setUpdater(this.ub);
                subject.setUpdatedDate(new Date());
                ssdao.update((EntityBean)subject);
            }
            StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
            StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
            SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
            ArrayList groups = sgcdao.findAllByStudy(study);
            for (int i3 = 0; i3 < groups.size(); ++i3) {
                StudyGroupClassBean group = (StudyGroupClassBean)groups.get(i3);
                if (!group.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                group.setStatus(Status.AVAILABLE);
                group.setUpdater(this.ub);
                group.setUpdatedDate(new Date());
                sgcdao.update((EntityBean)group);
                ArrayList subjectGroupMaps = sgmdao.findAllByStudyGroupClassId(group.getId());
                for (int j = 0; j < subjectGroupMaps.size(); ++j) {
                    SubjectGroupMapBean sgMap = (SubjectGroupMapBean)subjectGroupMaps.get(j);
                    if (!sgMap.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                    sgMap.setStatus(Status.AVAILABLE);
                    sgMap.setUpdater(this.ub);
                    sgMap.setUpdatedDate(new Date());
                    sgmdao.update((EntityBean)sgMap);
                }
            }
            EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
            StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
            for (int i4 = 0; i4 < definitions.size(); ++i4) {
                StudyEventDefinitionBean definition = (StudyEventDefinitionBean)definitions.get(i4);
                if (!definition.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                definition.setStatus(Status.AVAILABLE);
                definition.setUpdater(this.ub);
                definition.setUpdatedDate(new Date());
                sefdao.update((EntityBean)definition);
                ArrayList edcs = (ArrayList)edcdao.findAllByDefinition(definition.getId());
                for (int j = 0; j < edcs.size(); ++j) {
                    EventDefinitionCRFBean edc = (EventDefinitionCRFBean)edcs.get(j);
                    if (!edc.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                    edc.setStatus(Status.AVAILABLE);
                    edc.setUpdater(this.ub);
                    edc.setUpdatedDate(new Date());
                    edcdao.update((EntityBean)edc);
                }
                ArrayList events = (ArrayList)sedao.findAllByDefinition(definition.getId());
                EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
                for (int j = 0; j < events.size(); ++j) {
                    StudyEventBean event = (StudyEventBean)events.get(j);
                    if (!event.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                    event.setStatus(Status.AVAILABLE);
                    event.setUpdater(this.ub);
                    event.setUpdatedDate(new Date());
                    sedao.update((EntityBean)event);
                    ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
                    ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
                    for (int k = 0; k < eventCRFs.size(); ++k) {
                        EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(k);
                        if (!eventCRF.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                        eventCRF.setStatus(eventCRF.getOldStatus());
                        eventCRF.setUpdater(this.ub);
                        eventCRF.setUpdatedDate(new Date());
                        ecdao.update((EntityBean)eventCRF);
                        ArrayList itemDatas = iddao.findAllByEventCRFId(eventCRF.getId());
                        for (int a = 0; a < itemDatas.size(); ++a) {
                            ItemDataBean item = (ItemDataBean)itemDatas.get(a);
                            if (!item.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                            item.setStatus(item.getOldStatus());
                            item.setUpdater(this.ub);
                            item.setUpdatedDate(new Date());
                            iddao.update((EntityBean)item);
                        }
                    }
                }
            }
            DatasetDAO datadao = new DatasetDAO(this.sm.getDataSource());
            ArrayList dataset = datadao.findAllByStudyId(study.getId());
            for (int i5 = 0; i5 < dataset.size(); ++i5) {
                DatasetBean data = (DatasetBean)dataset.get(i5);
                if (!data.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                data.setStatus(Status.AVAILABLE);
                data.setUpdater(this.ub);
                data.setUpdatedDate(new Date());
                datadao.update((EntityBean)data);
            }
            this.addPageMessage(respage.getString("this_study_has_been_restored_succesfully"));
            this.forwardPage(Page.STUDY_LIST_SERVLET);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

