/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.admin.NewCRFBean;
import org.akaza.openclinica.bean.core.ItemDataType;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Utils;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.oid.MeasurementUnitOidGenerator;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.bean.submit.ResponseSetBean;
import org.akaza.openclinica.control.admin.SpreadSheetTable;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.hibernate.MeasurementUnitDao;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.exception.CRFReadingException;
import org.akaza.openclinica.logic.score.ScoreValidator;
import org.akaza.openclinica.web.SQLInitServlet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadSheetTableClassic
implements SpreadSheetTable {
    private POIFSFileSystem fs = null;
    private UserAccountBean ub = null;
    private String versionName = null;
    private int crfId = 0;
    private String crfName = "";
    private String versionIdString = "";
    private Locale locale;
    private final int studyId;
    private Set<String> existingUnits = new TreeSet();
    private Set<String> existingOIDs = new TreeSet();
    private MeasurementUnitDao measurementUnitDao = new MeasurementUnitDao();
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public SpreadSheetTableClassic(FileInputStream parseStream, UserAccountBean ub, String versionName, Locale locale, int studyId) throws IOException {
        this.fs = new POIFSFileSystem((InputStream)parseStream);
        this.ub = ub;
        this.versionName = versionName;
        this.locale = locale;
        this.studyId = studyId;
    }

    public void setCrfId(int id) {
        this.crfId = id;
    }

    public int getCrfId() {
        return this.crfId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewCRFBean toNewCRF(DataSource ds, ResourceBundle resPageMsg) throws IOException, CRFReadingException {
        String sheetName;
        HSSFSheet sheet;
        int j;
        String dbName = SQLInitServlet.getDBName();
        NewCRFBean ncrf = new NewCRFBean(ds, this.crfId);
        ncrf.setCrfId(this.crfId);
        StringBuffer buf = new StringBuffer();
        HSSFWorkbook wb = new HSSFWorkbook(this.fs);
        int numSheets = wb.getNumberOfSheets();
        ArrayList<String> queries = new ArrayList<String>();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> repeats = new ArrayList<String>();
        HashMap tableNames = new HashMap();
        HashMap<String, ItemBean> items = new HashMap<String, ItemBean>();
        String pVersion = "";
        String pVerDesc = "";
        int parentId = 0;
        int dataTypeId = 5;
        HashMap itemCheck = ncrf.getItemNames();
        HashMap GroupCheck = ncrf.getItemGroupNames();
        LinkedHashMap<String, String> openQueries = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> backupItemQueries = new LinkedHashMap<String, String>();
        ArrayList<String> secNames = new ArrayList<String>();
        HashMap<String, String> allItems = new HashMap<String, String>();
        ArrayList<String> itemGroupOids = new ArrayList<String>();
        ArrayList<String> itemOids = new ArrayList<String>();
        CRFDAO cdao = new CRFDAO(ds);
        CRFBean crf = (CRFBean)cdao.findByPK(this.crfId);
        ItemDataDAO iddao = new ItemDataDAO(ds);
        ItemDAO idao = new ItemDAO(ds);
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        ItemGroupDAO itemGroupDao = new ItemGroupDAO(ds);
        int validSheetNum = 0;
        for (j = 0; j < numSheets; ++j) {
            sheet = wb.getSheetAt(j);
            sheetName = wb.getSheetName(j);
            if (!sheetName.equalsIgnoreCase("CRF") && !sheetName.equalsIgnoreCase("Sections") && !sheetName.equalsIgnoreCase("Items")) continue;
            ++validSheetNum;
        }
        if (validSheetNum != 3) {
            errors.add(resPageMsg.getString("excel_not_have_valid_worksheet"));
        }
        for (j = 0; j < numSheets; ++j) {
            sheet = wb.getSheetAt(j);
            sheetName = wb.getSheetName(j);
            if (sheetName.equalsIgnoreCase("Instructions")) continue;
            int numRows = sheet.getPhysicalNumberOfRows();
            int lastNumRow = sheet.getLastRowNum();
            this.logger.info("PhysicalNumberOfRows" + sheet.getPhysicalNumberOfRows());
            String secName = "";
            String page = "";
            ArrayList<String> resNames = new ArrayList<String>();
            HashMap<String, String> htmlErrors = new HashMap<String, String>();
            int blankRowCount = 0;
            if (sheetName.equalsIgnoreCase("Items")) {
                String itemName;
                HSSFCell cell;
                int k;
                this.logger.info("read an item in sheet" + sheetName);
                HashMap<String, String> labelWithType = new HashMap<String, String>();
                ItemGroupBean defaultGroup = new ItemGroupBean();
                defaultGroup.setName("Ungrouped");
                defaultGroup.setCrfId(Integer.valueOf(this.crfId));
                defaultGroup.setStatus(Status.AVAILABLE);
                String defaultGroupOid = itemGroupDao.getValidOid(defaultGroup, this.crfName, defaultGroup.getName(), itemGroupOids);
                itemGroupOids.add(defaultGroupOid);
                String defaultSql = "";
                defaultSql = dbName.equals("oracle") ? "INSERT INTO ITEM_GROUP ( name, crf_id, status_id, date_created ,owner_id,oc_oid)VALUES ('" + defaultGroup.getName() + "', " + defaultGroup.getCrfId() + "," + defaultGroup.getStatus().getId() + ",sysdate," + this.ub.getId() + ",'" + defaultGroupOid + "')" : "INSERT INTO ITEM_GROUP ( name, crf_id, status_id, date_created ,owner_id,oc_oid)VALUES ('" + defaultGroup.getName() + "', " + defaultGroup.getCrfId() + "," + defaultGroup.getStatus().getId() + ",now()," + this.ub.getId() + ",'" + defaultGroupOid + "')";
                if (!GroupCheck.containsKey("Ungrouped")) {
                    queries.add(defaultSql);
                }
                HashMap<Integer, String> itemNames = new HashMap<Integer, String>();
                for (k = 1; k < numRows; ++k) {
                    cell = sheet.getRow(k).getCell((short)0);
                    itemName = this.getValue(cell);
                    itemName = itemName.replaceAll("<[^>]*>", "");
                    itemNames.put(k, itemName);
                }
                for (k = 1; k < numRows; ++k) {
                    double dr;
                    double dphi;
                    Object st;
                    String[] scoreValidator;
                    String subHeader;
                    String header;
                    String rightItemText;
                    String unit;
                    String leftItemText;
                    if (blankRowCount == 5) {
                        this.logger.info("hit end of the row ");
                        break;
                    }
                    if (sheet.getRow(k) == null) {
                        ++blankRowCount;
                        continue;
                    }
                    cell = sheet.getRow(k).getCell((short)0);
                    itemName = this.getValue(cell);
                    if (!Utils.isMatchingRegexp((String)(itemName = itemName.replaceAll("<[^>]*>", "")), (String)"\\w+")) {
                        errors.add(resPageMsg.getString("item_name_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ". " + resPageMsg.getString("you_can_only_use_letters_or_numbers"));
                        htmlErrors.put(j + "," + k + ",0", resPageMsg.getString("INVALID_FIELD"));
                    }
                    if (StringUtil.isBlank((String)itemName)) {
                        errors.add(resPageMsg.getString("item_name_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ". ");
                        htmlErrors.put(j + "," + k + ",0", resPageMsg.getString("required_field"));
                    }
                    if (itemName != null && itemName.length() > 255) {
                        errors.add(resPageMsg.getString("item_name_length_error"));
                    }
                    if (repeats.contains(itemName)) {
                        errors.add(resPageMsg.getString("duplicate") + " " + resPageMsg.getString("item_name_column") + " " + itemName + " " + resPageMsg.getString("was_detected_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",0", resPageMsg.getString("required_field"));
                    } else if (itemName.length() > 0) {
                        allItems.put(itemName, "Ungrouped");
                    }
                    repeats.add(itemName);
                    cell = sheet.getRow(k).getCell((short)1);
                    String descLabel = this.getValue(cell);
                    descLabel = descLabel.replaceAll("<[^>]*>", "");
                    if (StringUtil.isBlank((String)descLabel)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DESCRIPTION_LABEL_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + "," + resPageMsg.getString("items_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",1", resPageMsg.getString("required_field"));
                    }
                    if (descLabel != null && descLabel.length() > 4000) {
                        errors.add(resPageMsg.getString("item_desc_length_error"));
                    }
                    if ((leftItemText = this.getValue(cell = sheet.getRow(k).getCell((short)2))) != null && leftItemText.length() > 4000) {
                        errors.add(resPageMsg.getString("left_item_length_error"));
                    }
                    if ((unit = this.getValue(cell = sheet.getRow(k).getCell((short)3)).trim()) != null && unit.length() > 0) {
                        String muSql = "";
                        if (this.existingUnits.size() <= 0) {
                            this.existingUnits = this.measurementUnitDao.findAllNamesInUpperCase();
                            if (this.existingUnits == null) {
                                this.existingUnits = new TreeSet();
                            }
                        }
                        if (this.existingOIDs.size() <= 0) {
                            this.existingOIDs = this.measurementUnitDao.findAllOIDs();
                            if (this.existingOIDs == null) {
                                this.existingOIDs = new TreeSet();
                            }
                        }
                        if (this.existingUnits.contains(unit.toUpperCase())) {
                            this.logger.error("unit=" + unit + " existed.");
                        } else {
                            String oid = "";
                            try {
                                oid = new MeasurementUnitOidGenerator().generateOidNoValidation(new String[]{unit});
                            }
                            catch (Exception e) {
                                throw new RuntimeException("CANNOT GENERATE OID");
                            }
                            if (this.existingOIDs.contains(oid)) {
                                if (oid.length() > 40) {
                                    oid = oid.substring(0, 35);
                                }
                                oid = new MeasurementUnitOidGenerator().randomizeOid(oid);
                            }
                            this.existingOIDs.add(oid);
                            this.existingUnits.add(unit.toUpperCase());
                            muSql = this.getMUInsertSql(oid, unit, this.ub.getId(), dbName);
                            queries.add(muSql);
                        }
                    }
                    if ((rightItemText = this.getValue(cell = sheet.getRow(k).getCell((short)4))) != null && rightItemText.length() > 2000) {
                        errors.add(resPageMsg.getString("right_item_length_error"));
                    }
                    if ((cell = sheet.getRow(k).getCell((short)5)) != null) {
                        secName = this.getValue(cell);
                        secName = secName.replaceAll("<[^>]*>", "");
                    }
                    if (secName != null && secName.length() > 2000) {
                        errors.add(resPageMsg.getString("section_label_length_error"));
                    }
                    if (!secNames.contains(secName)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SECTION_LABEL_column") + " " + resPageMsg.getString("not_valid_section_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ". " + resPageMsg.getString("check_to_see_that_there_is_valid_LABEL"));
                        htmlErrors.put(j + "," + k + ",5", resPageMsg.getString("NOT_A_VALID_LABEL"));
                    }
                    if ((header = this.getValue(cell = sheet.getRow(k).getCell((short)6))) != null && header.length() > 2000) {
                        errors.add(resPageMsg.getString("item_header_length_error"));
                    }
                    if ((subHeader = this.getValue(cell = sheet.getRow(k).getCell((short)7))) != null && subHeader.length() > 240) {
                        errors.add(resPageMsg.getString("item_subheader_length_error"));
                    }
                    cell = sheet.getRow(k).getCell((short)8);
                    String parentItem = this.getValue(cell);
                    if (!StringUtil.isBlank((String)(parentItem = parentItem.replaceAll("<[^>]*>", ""))) && !itemNames.containsValue(parentItem)) {
                        errors.add("the Parent item specified on row " + k + " does not exist in the CRF template. Please update the value. ");
                    }
                    if (itemName != null && itemName.equalsIgnoreCase(parentItem)) {
                        parentItem = "";
                    }
                    cell = sheet.getRow(k).getCell((short)9);
                    int columnNum = 0;
                    String column = this.getValue(cell);
                    if (!StringUtil.isBlank((String)column)) {
                        try {
                            columnNum = Integer.parseInt(column);
                        }
                        catch (NumberFormatException ne) {
                            columnNum = 0;
                        }
                    }
                    if ((cell = sheet.getRow(k).getCell((short)10)) != null) {
                        page = this.getValue(cell);
                    }
                    cell = sheet.getRow(k).getCell((short)11);
                    String questionNum = this.getValue(cell);
                    cell = sheet.getRow(k).getCell((short)12);
                    String responseType = this.getValue(cell);
                    int responseTypeId = 1;
                    if (StringUtil.isBlank((String)responseType)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_TYPE_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",12", resPageMsg.getString("required_field"));
                    } else if (!ResponseType.findByName((String)responseType.toLowerCase())) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_TYPE_column") + " " + resPageMsg.getString("was_invalid_at_row") + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",12", resPageMsg.getString("INVALID_FIELD"));
                    } else {
                        responseTypeId = ResponseType.getByName((String)responseType.toLowerCase()).getId();
                    }
                    cell = sheet.getRow(k).getCell((short)13);
                    String responseLabel = this.getValue(cell);
                    if (StringUtil.isBlank((String)responseLabel) && responseTypeId != ResponseType.TEXT.getId() && responseTypeId != ResponseType.TEXTAREA.getId()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_LABEL_column") + " " + resPageMsg.getString("was_blank_at_row") + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",13", resPageMsg.getString("required_field"));
                    } else if ("file".equalsIgnoreCase(responseType) && !"file".equalsIgnoreCase(responseLabel)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_LABEL_column") + " " + resPageMsg.getString("should_be_file") + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",13", resPageMsg.getString("should_be_file"));
                    }
                    cell = sheet.getRow(k).getCell((short)14);
                    String resOptions = this.getValue(cell);
                    if (responseLabel.equalsIgnoreCase("text") || responseLabel.equalsIgnoreCase("textarea")) {
                        resOptions = "text";
                    }
                    if ("file".equalsIgnoreCase(responseType)) {
                        resOptions = "file";
                    }
                    int numberOfOptions = 0;
                    if (!resNames.contains(responseLabel) && StringUtil.isBlank((String)resOptions) && responseTypeId != ResponseType.TEXT.getId() && responseTypeId != ResponseType.TEXTAREA.getId()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_OPTIONS_TEXT_column") + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",14", resPageMsg.getString("required_field"));
                    }
                    if (!resNames.contains(responseLabel) && !StringUtil.isBlank((String)resOptions)) {
                        if (responseTypeId == 8 || responseTypeId == 9) {
                            numberOfOptions = 1;
                        } else {
                            String text1 = resOptions.replaceAll("\\\\,", "##");
                            String[] resArray = text1.split(",");
                            numberOfOptions = resArray.length;
                        }
                    }
                    cell = sheet.getRow(k).getCell((short)15);
                    String resValues = this.getValue(cell);
                    String value1 = resValues.replaceAll("\\\\,", "##");
                    String[] resValArray = value1.split(",");
                    if (responseLabel.equalsIgnoreCase("text") || responseLabel.equalsIgnoreCase("textarea")) {
                        resValues = "text";
                    }
                    if ("file".equalsIgnoreCase(responseType)) {
                        resValues = "file";
                    }
                    if (!resNames.contains(responseLabel) && StringUtil.isBlank((String)resValues) && responseTypeId != ResponseType.TEXT.getId() && responseTypeId != ResponseType.TEXTAREA.getId()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",15", resPageMsg.getString("required_field"));
                    }
                    if (responseTypeId == 8 || responseTypeId == 9) {
                        ArrayList variables;
                        StringBuffer err;
                        String[] s;
                        if (resValues.contains(":") && !"func".equalsIgnoreCase((s = resValues.split(":"))[0].trim())) {
                            errors.add(resPageMsg.getString("expression_not_start_with_func_at") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ". ");
                            htmlErrors.put(j + "," + k + ",15", resPageMsg.getString("INVALID_FIELD"));
                        }
                        String exp = resValues;
                        exp = exp.replace("\\\\,", "##");
                        exp = exp.replace("##", ",");
                        resValues = exp = exp.replace(",", "\\\\,");
                        if (exp.startsWith("func:")) {
                            exp = exp.substring(5).trim();
                        }
                        if (!(scoreValidator = new ScoreValidator(this.locale)).isValidExpression(exp = exp.replace("\\\\,", "##"), err = new StringBuffer(), variables = new ArrayList())) {
                            errors.add(resPageMsg.getString("expression_invalid_at") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ": " + err);
                            htmlErrors.put(j + "," + k + ",15", resPageMsg.getString("INVALID_FIELD"));
                        }
                        String group = "Ungrouped";
                        for (String v : variables) {
                            if (allItems.containsKey(v)) continue;
                            errors.add(resPageMsg.getString("item") + v + resPageMsg.getString("must_listed_before_item") + itemName + resPageMsg.getString("item_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ". ");
                            htmlErrors.put(j + "," + k + ",15", resPageMsg.getString("INVALID_FIELD"));
                        }
                    } else if (numberOfOptions > 0 && resValArray.length != numberOfOptions) {
                        errors.add(resPageMsg.getString("incomplete_option_value_pair") + " " + resPageMsg.getString("RESPONSE_OPTIONS_column") + " " + resPageMsg.getString("and") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("at_row") + k + " " + resPageMsg.getString("items_worksheet") + "; " + resPageMsg.getString("perhaps_missing_comma"));
                        htmlErrors.put(j + ", " + k + ", 14", resPageMsg.getString("number_option_not_match"));
                        htmlErrors.put(j + ", " + k + ", 15", resPageMsg.getString("number_value_not_match"));
                    }
                    cell = sheet.getRow(k).getCell((short)16);
                    String dataType = this.getValue(cell);
                    dataType = dataType.replaceAll("<[^>]*>", "");
                    String dataTypeIdString = "1";
                    if (StringUtil.isBlank((String)dataType)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet"));
                        htmlErrors.put(j + ", " + k + ", 16", resPageMsg.getString("required_field"));
                    } else if (!ItemDataType.findByName((String)dataType.toLowerCase())) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                        htmlErrors.put(j + ", " + k + ", 16", resPageMsg.getString("INVALID_FIELD"));
                    } else {
                        if ("file".equalsIgnoreCase(responseType) && !"FILE".equalsIgnoreCase(dataType)) {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("should_be_file") + " " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                            htmlErrors.put(j + ", " + k + ", 16", resPageMsg.getString("should_be_file"));
                        }
                        dataTypeIdString = "(SELECT ITEM_DATA_TYPE_ID From ITEM_DATA_TYPE Where CODE='" + dataType.toUpperCase() + "')";
                    }
                    if (responseTypeId == 3 || responseTypeId == 5 || responseTypeId == 6 || responseTypeId == 7) {
                        if (labelWithType.containsKey(responseLabel)) {
                            this.logger.debug("in label=" + responseLabel);
                            if (!dataType.equalsIgnoreCase(labelWithType.get(responseLabel).toString())) {
                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("does_not_match_the_item_data_type_with_the_same_response_label") + " " + k + ", " + resPageMsg.getString("items_worksheet"));
                                htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("INVALID_FIELD"));
                            }
                        } else {
                            labelWithType.put(responseLabel, dataType);
                            if (resValArray.length > 0) {
                                String s;
                                boolean wrongType = false;
                                if ("int".equalsIgnoreCase(dataType)) {
                                    scoreValidator = resValArray;
                                    int group = scoreValidator.length;
                                    for (int i = 0; i < group; ++i) {
                                        s = scoreValidator[i];
                                        Object object = st = s != null && s.length() > 0 ? s.trim() : "";
                                        if (((String)st).length() <= 0) continue;
                                        try {
                                            Integer I = Integer.parseInt(s.trim());
                                            if (I.toString().equals(s.trim())) continue;
                                            wrongType = true;
                                            continue;
                                        }
                                        catch (Exception e) {
                                            wrongType = true;
                                        }
                                    }
                                    if (wrongType) {
                                        wrongType = false;
                                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("should_be_integer") + " " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                                        htmlErrors.put(j + ", " + k + ", 15", resPageMsg.getString("should_be_integer"));
                                    }
                                } else if ("real".equalsIgnoreCase(dataType)) {
                                    scoreValidator = resValArray;
                                    int group = scoreValidator.length;
                                    for (int i = 0; i < group; ++i) {
                                        String st2;
                                        s = scoreValidator[i];
                                        String string = st2 = s != null && s.length() > 0 ? s.trim() : "";
                                        if (st2.length() <= 0) continue;
                                        try {
                                            Double e = Double.parseDouble(s.trim());
                                            continue;
                                        }
                                        catch (Exception e) {
                                            wrongType = true;
                                        }
                                    }
                                    if (wrongType) {
                                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("should_be_real") + " " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                                        htmlErrors.put(j + ", " + k + ", 15", resPageMsg.getString("should_be_real"));
                                    }
                                }
                            }
                        }
                    }
                    cell = sheet.getRow(k).getCell((short)17);
                    String regexp = this.getValue(cell);
                    String regexp1 = "";
                    if (!StringUtil.isBlank((String)regexp)) {
                        regexp1 = regexp.trim();
                        if (regexp1.startsWith("regexp:")) {
                            String finalRegexp = regexp1.substring(7).trim();
                            if (finalRegexp.contains("\\\\")) {
                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + " " + resPageMsg.getString("has_an_invalid_regular_expression_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ". " + resPageMsg.getString("regular_expression_contained") + " '\\\\', " + resPageMsg.getString("it_should_only_contain_one") + "'\\'. ");
                                htmlErrors.put(j + "," + k + ",17", resPageMsg.getString("INVALID_FIELD"));
                            } else if (finalRegexp.startsWith("/") && finalRegexp.endsWith("/")) {
                                finalRegexp = finalRegexp.substring(1, finalRegexp.length() - 1);
                                try {
                                    Pattern p = Pattern.compile(finalRegexp);
                                    char[] chars = regexp1.toCharArray();
                                    regexp1 = "";
                                    st = chars;
                                    int e = ((Object)st).length;
                                    for (int i = 0; i < e; ++i) {
                                        Object c = st[i];
                                        regexp1 = c == 92 && !dbName.equals("oracle") ? regexp1 + (char)c + "\\" : regexp1 + (char)c;
                                    }
                                }
                                catch (PatternSyntaxException pse) {
                                    errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + resPageMsg.getString("has_an_invalid_regular_expression_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ". " + resPageMsg.getString("Example:") + " regexp: /[0-9]*/ ");
                                    htmlErrors.put(j + "," + k + ",17", resPageMsg.getString("INVALID_FIELD"));
                                }
                            } else {
                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + " " + resPageMsg.getString("has_an_invalid_regular_expression_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ". " + resPageMsg.getString("Example") + " regexp: /[0-9]*/ ");
                                htmlErrors.put(j + "," + k + ",17", resPageMsg.getString("INVALID_FIELD"));
                            }
                        } else if (regexp1.startsWith("func:")) {
                            boolean isProperFunction = false;
                            try {
                                Validator.processCRFValidationFunction((String)regexp1);
                                isProperFunction = true;
                            }
                            catch (Exception e) {
                                errors.add(e.getMessage() + ", " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ". ");
                                htmlErrors.put(j + "," + k + ",17", resPageMsg.getString("INVALID_FIELD"));
                            }
                        } else {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ". ");
                            htmlErrors.put(j + "," + k + ",17", resPageMsg.getString("INVALID_FIELD"));
                        }
                    }
                    cell = sheet.getRow(k).getCell((short)18);
                    String regexpError = this.getValue(cell);
                    regexpError = regexpError.replaceAll("<[^>]*>", "");
                    if (!StringUtil.isBlank((String)regexp) && StringUtil.isBlank((String)regexpError)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_ERROR_MESSAGE_column") + resPageMsg.getString("was_blank_at_row") + k + ", " + resPageMsg.getString("items_worksheet") + ". " + resPageMsg.getString("cannot_be_blank_if_VALIDATION_not_blank"));
                        htmlErrors.put(j + "," + k + ",18", resPageMsg.getString("required_field"));
                    }
                    if (regexpError != null && regexpError.length() > 255) {
                        errors.add(resPageMsg.getString("regexp_errror_length_error"));
                    }
                    boolean phiBoolean = false;
                    cell = sheet.getRow(k).getCell((short)19);
                    String phi = "";
                    if (cell.getCellType() == 0 && ((dphi = cell.getNumericCellValue()) - (double)((int)dphi)) * 1000.0 == 0.0) {
                        phi = (int)dphi + "";
                    }
                    if (!"0".equals(phi) && !"1".equals(phi)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("PHI_column") + resPageMsg.getString("was_invalid_at_row") + k + ", " + resPageMsg.getString("items_worksheet") + ". " + resPageMsg.getString("PHI_column") + " " + resPageMsg.getString("can_only_be_either_0_or_1"));
                        htmlErrors.put(j + "," + k + ",19", resPageMsg.getString("INVALID_VALUE"));
                    } else {
                        phiBoolean = "1".equals(phi);
                    }
                    boolean isRequired = false;
                    cell = sheet.getRow(k).getCell((short)20);
                    String required = this.getValue(cell);
                    this.logger.info(this.getValue(cell));
                    if (StringUtil.isBlank((String)required)) {
                        required = "0";
                    } else if (cell.getCellType() == 0 && ((dr = cell.getNumericCellValue()) - (double)((int)dr)) * 1000.0 == 0.0) {
                        required = (int)dr + "";
                    }
                    if (!"0".equals(required) && !"1".equals(required)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("REQUIRED_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ". " + resPageMsg.getString("REQUIRED_column") + resPageMsg.getString("can_only_be_either_0_or_1"));
                        htmlErrors.put(j + "," + k + ",20", resPageMsg.getString("INVALID_VALUE"));
                    } else {
                        isRequired = "1".equals(required);
                    }
                    String itemOid = idao.getValidOid(new ItemBean(), this.crfName, itemName, itemOids);
                    itemOids.add(itemOid);
                    String vlSql = "";
                    vlSql = dbName.equals("oracle") ? "INSERT INTO ITEM (NAME,DESCRIPTION,UNITS,PHI_STATUS,ITEM_DATA_TYPE_ID, ITEM_REFERENCE_TYPE_ID,STATUS_ID,OWNER_ID,DATE_CREATED,OC_OID) VALUES ('" + this.stripQuotes(itemName) + "','" + this.stripQuotes(descLabel) + "','" + this.stripQuotes(unit) + "'," + (phiBoolean ? 1 : 0) + "," + dataTypeIdString + ",1,1," + this.ub.getId() + ", sysdate,'" + itemOid + "')" : "INSERT INTO ITEM (NAME,DESCRIPTION,UNITS,PHI_STATUS,ITEM_DATA_TYPE_ID, ITEM_REFERENCE_TYPE_ID,STATUS_ID,OWNER_ID,DATE_CREATED,OC_OID) VALUES ('" + this.stripQuotes(itemName) + "','" + this.stripQuotes(descLabel) + "','" + this.stripQuotes(unit) + "'," + phiBoolean + "," + dataTypeIdString + ",1,1," + this.ub.getId() + ", NOW(),'" + itemOid + "')";
                    backupItemQueries.put(itemName, vlSql);
                    ItemBean ib = new ItemBean();
                    ib.setName(itemName);
                    ib.setUnits(unit);
                    ib.setPhiStatus(phiBoolean);
                    ib.setDescription(descLabel);
                    ib.setDataType(ItemDataType.getByName((String)dataType.toLowerCase()));
                    ResponseSetBean rsb = new ResponseSetBean();
                    String resOptions1 = resOptions.replaceAll("\\\\,", "\\,");
                    String resValues1 = resValues.replaceAll("\\\\,", "\\,");
                    rsb.setOptions(this.stripQuotes(resOptions1), this.stripQuotes(resValues1));
                    ItemFormMetadataBean ifmb = new ItemFormMetadataBean();
                    ifmb.setResponseSet(rsb);
                    ib.setItemMeta(ifmb);
                    items.put(itemName, ib);
                    int ownerId = this.ub.getId();
                    if (!itemCheck.containsKey(itemName)) {
                        openQueries.put(itemName, vlSql);
                    } else {
                        ItemBean oldItem = (ItemBean)idao.findByNameAndCRFId(itemName, this.crfId);
                        if (oldItem.getOwnerId() == this.ub.getId()) {
                            String upSql;
                            if (!cvdao.hasItemData(oldItem.getId())) {
                                upSql = "";
                                upSql = dbName.equals("oracle") ? "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',UNITS='" + this.stripQuotes(unit) + "',PHI_STATUS=" + (phiBoolean ? 1 : 0) + ",ITEM_DATA_TYPE_ID=" + dataTypeIdString + " WHERE exists (SELECT versioning_map.item_id from versioning_map, crf_version where versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id= " + this.crfId + " AND item.item_id = versioning_map.item_id) AND item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId : "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',UNITS='" + this.stripQuotes(unit) + "',PHI_STATUS=" + phiBoolean + ",ITEM_DATA_TYPE_ID=" + dataTypeIdString + " FROM versioning_map, crf_version WHERE item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId + " AND item.item_id = versioning_map.item_id AND versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id = " + this.crfId;
                                openQueries.put(itemName, upSql);
                            } else {
                                upSql = "";
                                upSql = dbName.equals("oracle") ? "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',PHI_STATUS=" + (phiBoolean ? 1 : 0) + " WHERE exists (SELECT versioning_map.item_id from versioning_map, crf_version where versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id= " + this.crfId + " AND item.item_id = versioning_map.item_id) AND item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId : "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',PHI_STATUS=" + phiBoolean + " FROM versioning_map, crf_version WHERE item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId + " AND item.item_id = versioning_map.item_id AND versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id = " + this.crfId;
                                openQueries.put(itemName, upSql);
                            }
                        } else {
                            ownerId = oldItem.getOwner().getId();
                        }
                    }
                    String sql = "";
                    sql = dbName.equals("oracle") ? "INSERT INTO RESPONSE_SET (LABEL, OPTIONS_TEXT, OPTIONS_VALUES, RESPONSE_TYPE_ID, VERSION_ID) VALUES ('" + this.stripQuotes(responseLabel) + "', '" + this.stripQuotes(resOptions.replaceAll("\\\\,", "\\,")) + "','" + this.stripQuotes(resValues.replace("\\\\", "\\")) + "',(SELECT RESPONSE_TYPE_ID From RESPONSE_TYPE Where NAME='" + this.stripQuotes(responseType.toLowerCase()) + "')," + this.versionIdString + ")" : "INSERT INTO RESPONSE_SET (LABEL, OPTIONS_TEXT, OPTIONS_VALUES, RESPONSE_TYPE_ID, VERSION_ID) VALUES ('" + this.stripQuotes(responseLabel) + "', E'" + this.stripQuotes(resOptions) + "', E'" + this.stripQuotes(resValues) + "',(SELECT RESPONSE_TYPE_ID From RESPONSE_TYPE Where NAME='" + this.stripQuotes(responseType.toLowerCase()) + "')," + this.versionIdString + ")";
                    if (!resNames.contains(responseLabel)) {
                        queries.add(sql);
                        resNames.add(responseLabel);
                    }
                    String parentItemString = "0";
                    if (!StringUtil.isBlank((String)parentItem)) {
                        parentItemString = dbName.equals("oracle") ? "(SELECT MAX(ITEM_ID) FROM ITEM WHERE NAME='" + this.stripQuotes(parentItem) + "' AND owner_id = " + ownerId + " )" : "(SELECT ITEM_ID FROM ITEM WHERE NAME='" + this.stripQuotes(parentItem) + "' AND owner_id = " + ownerId + " ORDER BY OC_OID DESC LIMIT 1)";
                    }
                    String selectCorrectItemQueryPostgres = " (SELECT I.ITEM_ID FROM ITEM I LEFT OUTER JOIN ITEM_FORM_METADATA IFM ON I.ITEM_Id = IFM.ITEM_ID LEFT OUTER JOIN CRF_VERSION CV ON IFM.CRF_VERSION_ID = CV.CRF_VERSION_ID  WHERE  ( I.NAME='" + itemName + "' AND I.owner_id = " + ownerId + " AND CV.CRF_VERSION_ID is null ) OR  ( I.NAME='" + itemName + "' AND I.owner_id = " + ownerId + " AND CV.CRF_VERSION_ID is not null AND CV.CRF_ID =" + this.crfId + " )  ORDER BY I.OC_ID DESC LIMIT 1) ";
                    String selectCorrectItemQueryOracle = " (SELECT MAX(I.ITEM_ID) FROM ITEM I LEFT OUTER JOIN ITEM_FORM_METADATA IFM ON I.ITEM_Id = IFM.ITEM_ID LEFT OUTER JOIN CRF_VERSION CV ON IFM.CRF_VERSION_ID = CV.CRF_VERSION_ID  WHERE  ( I.NAME='" + itemName + "' AND I.owner_id = " + ownerId + " AND CV.CRF_VERSION_ID is null ) OR  ( I.NAME='" + itemName + "' AND I.owner_id = " + ownerId + " AND CV.CRF_VERSION_ID is not null AND CV.CRF_ID =" + this.crfId + " )) ";
                    String sql2 = "";
                    if (dbName.equals("oracle")) {
                        sql2 = "INSERT INTO ITEM_FORM_METADATA (CRF_VERSION_ID, RESPONSE_SET_ID,ITEM_ID,SUBHEADER,header,LEFT_ITEM_TEXT,RIGHT_ITEM_TEXT,PARENT_ID,SECTION_ID,ORDINAL,PARENT_LABEL,COLUMN_NUMBER,PAGE_NUMBER_LABEL,question_number_label,REGEXP,REGEXP_ERROR_MSG,REQUIRED) VALUES (" + this.versionIdString + ",(SELECT RESPONSE_SET_ID FROM RESPONSE_SET WHERE LABEL='" + this.stripQuotes(responseLabel) + "' AND VERSION_ID=" + this.versionIdString + ")," + selectCorrectItemQueryOracle + ",'" + this.stripQuotes(subHeader) + "','" + this.stripQuotes(header) + "','" + this.stripQuotes(leftItemText) + "','" + this.stripQuotes(rightItemText) + "'," + parentItemString + ", (SELECT SECTION_ID FROM SECTION WHERE LABEL='" + secName + "' AND CRF_VERSION_ID IN " + this.versionIdString + "), " + k + ",'" + parentItem + "'," + columnNum + ",'" + this.stripQuotes(page) + "','" + this.stripQuotes(questionNum) + "','" + this.stripQuotes(regexp1) + "','" + this.stripQuotes(regexpError) + "', " + (isRequired ? 1 : 0) + ")";
                        this.logger.warn(sql2);
                    } else {
                        sql2 = "INSERT INTO ITEM_FORM_METADATA (CRF_VERSION_ID, RESPONSE_SET_ID,ITEM_ID,SUBHEADER,HEADER,LEFT_ITEM_TEXT,RIGHT_ITEM_TEXT,PARENT_ID,SECTION_ID,ORDINAL,PARENT_LABEL,COLUMN_NUMBER,PAGE_NUMBER_LABEL,question_number_label,REGEXP,REGEXP_ERROR_MSG,REQUIRED) VALUES (" + this.versionIdString + ",(SELECT RESPONSE_SET_ID FROM RESPONSE_SET WHERE LABEL='" + this.stripQuotes(responseLabel) + "' AND VERSION_ID=" + this.versionIdString + ")," + selectCorrectItemQueryPostgres + ",'" + this.stripQuotes(subHeader) + "','" + this.stripQuotes(header) + "','" + this.stripQuotes(leftItemText) + "','" + this.stripQuotes(rightItemText) + "'," + parentItemString + ", (SELECT SECTION_ID FROM SECTION WHERE LABEL='" + secName + "' AND CRF_VERSION_ID IN " + this.versionIdString + "), " + k + ",'" + parentItem + "'," + columnNum + ",'" + this.stripQuotes(page) + "','" + this.stripQuotes(questionNum) + "','" + this.stripQuotes(regexp1) + "','" + this.stripQuotes(regexpError) + "', " + isRequired + ")";
                    }
                    queries.add(sql2);
                    String sql3 = "";
                    sql3 = dbName.equals("oracle") ? "INSERT INTO VERSIONING_MAP (CRF_VERSION_ID, ITEM_ID) VALUES ( " + this.versionIdString + "," + selectCorrectItemQueryOracle + ")" : "INSERT INTO VERSIONING_MAP (CRF_VERSION_ID, ITEM_ID) VALUES ( " + this.versionIdString + "," + selectCorrectItemQueryPostgres + ")";
                    queries.add(sql3);
                    String sqlGroupLabel = "";
                    sqlGroupLabel = dbName.equals("oracle") ? "INSERT INTO ITEM_GROUP_METADATA (item_group_id,header,subheader, layout, repeat_number, repeat_max, repeat_array,row_start_number, crf_version_id,item_id , ordinal, borders) VALUES ((SELECT MAX(ITEM_GROUP_ID) FROM ITEM_GROUP WHERE NAME='Ungrouped' AND crf_id = " + this.crfId + " ),'', '', '', " + 1 + ", " + 1 + ", '', 1," + this.versionIdString + ",(SELECT MAX(ITEM.ITEM_ID) FROM ITEM,ITEM_FORM_METADATA,CRF_VERSION WHERE ITEM.NAME='" + itemName + "' AND ITEM.ITEM_ID = ITEM_FORM_METADATA.ITEM_ID and ITEM_FORM_METADATA.CRF_VERSION_ID=CRF_VERSION.CRF_VERSION_ID AND CRF_VERSION.CRF_ID= " + this.crfId + " )," + k + ",0)" : "INSERT INTO ITEM_GROUP_METADATA (item_group_id,HEADER,subheader, layout, repeat_number, repeat_max, repeat_array,row_start_number, crf_version_id,item_id , ordinal, borders) VALUES ((SELECT ITEM_GROUP_ID FROM ITEM_GROUP WHERE NAME='Ungrouped' AND crf_id = " + this.crfId + " ORDER BY oc_oid DESC LIMIT 1),'', '', '', " + 1 + ", " + 1 + ", '', 1," + this.versionIdString + ",(SELECT ITEM.ITEM_ID FROM ITEM,ITEM_FORM_METADATA,CRF_VERSION WHERE ITEM.NAME='" + itemName + "' AND ITEM.ITEM_ID = ITEM_FORM_METADATA.ITEM_ID and ITEM_FORM_METADATA.CRF_VERSION_ID=CRF_VERSION.CRF_VERSION_ID AND CRF_VERSION.CRF_ID= " + this.crfId + " ORDER BY ITEM.OC_OID DESC LIMIT 1)," + k + ",0)";
                    queries.add(sqlGroupLabel);
                }
            } else if (sheetName.equalsIgnoreCase("Sections")) {
                this.logger.info("read sections");
                for (int k = 1; k < numRows; ++k) {
                    String pageNumber;
                    String instructions;
                    String subtitle;
                    if (blankRowCount == 5) {
                        this.logger.info("hit end of the row ");
                        break;
                    }
                    if (sheet.getRow(k) == null) {
                        ++blankRowCount;
                        continue;
                    }
                    HSSFCell cell = sheet.getRow(k).getCell((short)0);
                    String secLabel = this.getValue(cell);
                    if (StringUtil.isBlank((String)(secLabel = secLabel.replaceAll("<[^>]*>", "")))) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SECTION_LABEL_column") + " " + resPageMsg.getString("was_blank_at_row") + k + " , " + resPageMsg.getString("sections_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",0", resPageMsg.getString("required_field"));
                    }
                    if (secLabel != null && secLabel.length() > 2000) {
                        errors.add(resPageMsg.getString("section_label_length_error"));
                    }
                    if (secNames.contains(secLabel)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SECTION_LABEL_column") + resPageMsg.getString("was_a_duplicate_of") + secLabel + " " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("sections_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",0", resPageMsg.getString("DUPLICATE_FIELD"));
                    }
                    secNames.add(secLabel);
                    cell = sheet.getRow(k).getCell((short)1);
                    String title = this.getValue(cell);
                    title = title.replaceAll("<[^>]*>", "");
                    if (StringUtil.isBlank((String)title)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SECTION_TITLE_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("sections_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",1", resPageMsg.getString("required_field"));
                    }
                    if (title != null && title.length() > 2000) {
                        errors.add(resPageMsg.getString("section_title_length_error"));
                    }
                    if ((subtitle = this.getValue(cell = sheet.getRow(k).getCell((short)2))) != null && subtitle.length() > 2000) {
                        errors.add(resPageMsg.getString("section_subtitle_length_error"));
                    }
                    if ((instructions = this.getValue(cell = sheet.getRow(k).getCell((short)3))) != null && instructions.length() > 2000) {
                        errors.add(resPageMsg.getString("section_instruction_length_error"));
                    }
                    if ((pageNumber = this.getValue(cell = sheet.getRow(k).getCell((short)4))) != null && pageNumber.length() > 5) {
                        errors.add(resPageMsg.getString("section_page_number_length_error"));
                    }
                    cell = sheet.getRow(k).getCell((short)5);
                    String parentSection = this.getValue(cell);
                    if (!StringUtil.isBlank((String)(parentSection = parentSection.replaceAll("<[^>]*>", "")))) {
                        try {
                            parentId = Integer.parseInt(parentSection);
                        }
                        catch (NumberFormatException ne) {
                            parentId = 0;
                        }
                    }
                    String sql = "";
                    sql = dbName.equals("oracle") ? "INSERT INTO SECTION (CRF_VERSION_ID,STATUS_ID,LABEL, TITLE, INSTRUCTIONS, SUBTITLE, PAGE_NUMBER_LABEL,ORDINAL, PARENT_ID, OWNER_ID, DATE_CREATED) VALUES (" + this.versionIdString + ",1,'" + secLabel + "','" + this.stripQuotes(title) + "', '" + this.stripQuotes(instructions) + "', '" + this.stripQuotes(subtitle) + "','" + pageNumber + "'," + k + "," + parentId + "," + this.ub.getId() + ",sysdate)" : "INSERT INTO SECTION (CRF_VERSION_ID,STATUS_ID,LABEL, TITLE, INSTRUCTIONS, SUBTITLE, PAGE_NUMBER_LABEL,ORDINAL, PARENT_ID, OWNER_ID, DATE_CREATED) VALUES (" + this.versionIdString + ",1,'" + secLabel + "','" + this.stripQuotes(title) + "', '" + this.stripQuotes(instructions) + "', '" + this.stripQuotes(subtitle) + "','" + pageNumber + "'," + k + "," + parentId + "," + this.ub.getId() + ",NOW())";
                    queries.add(sql);
                }
            } else if (sheetName.equalsIgnoreCase("CRF")) {
                String oid;
                this.logger.info("read crf");
                if (sheet == null || sheet.getRow(1) == null || sheet.getRow(1).getCell((short)0) == null) {
                    throw new CRFReadingException("Blank row found in sheet CRF.");
                }
                HSSFCell cell = sheet.getRow(1).getCell((short)0);
                this.crfName = this.getValue(cell);
                this.crfName = this.crfName.replaceAll("<[^>]*>", "");
                if (StringUtil.isBlank((String)this.crfName)) {
                    throw new CRFReadingException("The CRF_NAME column was blank in the CRF worksheet.");
                }
                if (this.crfName.length() > 255) {
                    errors.add(resPageMsg.getString("crf_name_length_error"));
                }
                CRFBean existingCRFWithSameName = (CRFBean)cdao.findByName(this.crfName);
                if (this.getCrfId() == 0 && existingCRFWithSameName.getName() != null && existingCRFWithSameName.getName().equals(this.crfName)) {
                    errors.add(resPageMsg.getString("crf_name_already_used"));
                }
                cell = sheet.getRow(1).getCell((short)1);
                String version = this.getValue(cell);
                version = version.replaceAll("<[^>]*>", "");
                ncrf.setVersionName(version);
                if (version != null && version.length() > 255) {
                    errors.add(resPageMsg.getString("version_length_error"));
                }
                cell = sheet.getRow(1).getCell((short)2);
                String versionDesc = this.getValue(cell);
                if ((versionDesc = versionDesc.replaceAll("<[^>]*>", "")) != null && versionDesc.length() > 4000) {
                    errors.add(resPageMsg.getString("version_description_length_error"));
                }
                cell = sheet.getRow(1).getCell((short)3);
                String revisionNotes = this.getValue(cell);
                if ((revisionNotes = revisionNotes.replaceAll("<[^>]*>", "")) != null && revisionNotes.length() > 255) {
                    errors.add(resPageMsg.getString("revision_notes_length_error"));
                }
                if (StringUtil.isBlank((String)revisionNotes)) {
                    errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("REVISION_NOTES_column") + " " + resPageMsg.getString("was_blank_in_the_CRF_worksheet"));
                    htmlErrors.put(j + ",1,3", resPageMsg.getString("required_field"));
                }
                Connection con = null;
                String crfOid = null;
                if (this.crfId == 0) {
                    crfOid = cdao.getValidOid(new CRFBean(), this.crfName);
                    try {
                        int nextCRFId;
                        con = ds.getConnection();
                        ResultSet nextIdRs = dbName.equals("oracle") ? con.createStatement().executeQuery("select crf_id_seq.nextval from dual") : con.createStatement().executeQuery("select nextval('crf_crf_id_seq')");
                        nextIdRs.next();
                        this.crfId = nextCRFId = nextIdRs.getInt(1);
                        ncrf.setCrfId(this.crfId);
                        String createCRFSql = "";
                        createCRFSql = dbName.equals("oracle") ? "INSERT INTO CRF (CRF_ID, STATUS_ID, NAME, DESCRIPTION, OWNER_ID, DATE_CREATED, OC_OID, SOURCE_STUDY_ID) VALUES (" + this.crfId + ", 1,'" + this.stripQuotes(this.crfName) + "','" + this.stripQuotes(versionDesc) + "'," + this.ub.getId() + ",sysdate,'" + crfOid + "'," + this.studyId + ")" : "INSERT INTO CRF (CRF_ID, STATUS_ID, NAME, DESCRIPTION, OWNER_ID, DATE_CREATED, OC_OID, SOURCE_STUDY_ID) VALUES (" + this.crfId + ", 1,'" + this.stripQuotes(this.crfName) + "','" + this.stripQuotes(versionDesc) + "'," + this.ub.getId() + ",NOW(),'" + crfOid + "'," + this.studyId + ")";
                        queries.add(createCRFSql);
                    }
                    catch (SQLException e) {
                        this.logger.warn("Exception encountered with query select nextval('crf_crf_id_seq'), Message-" + e.getMessage());
                    }
                    finally {
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (SQLException e) {
                                this.logger.warn("Connectin can't be closed");
                            }
                        }
                    }
                }
                HashMap checkCRFVersions = ncrf.getCrfVersions();
                boolean overwrite = false;
                if (checkCRFVersions.containsKey(version)) {
                    this.logger.info("found a matching version name..." + version);
                    errors.add(resPageMsg.getString("version_not_unique_cause_confusion"));
                    htmlErrors.put(j + ",1,2", resPageMsg.getString("NOT_UNIQUE"));
                }
                if (crfOid != null) {
                    oid = cvdao.getValidOid(new CRFVersionBean(), crfOid, version);
                } else {
                    CRFBean crfBean = (CRFBean)cdao.findByName(this.crfName);
                    oid = cvdao.getValidOid(new CRFVersionBean(), crfBean.getOid(), version);
                }
                String sql = "";
                if (dbName.equals("oracle")) {
                    this.logger.warn("TEST 2");
                    sql = this.crfId == 0 ? "INSERT INTO CRF_VERSION (NAME, DESCRIPTION, CRF_ID, STATUS_ID,DATE_CREATED,OWNER_ID,REVISION_NOTES,OC_OID) VALUES ('" + this.stripQuotes(version) + "','" + this.stripQuotes(versionDesc) + "',(SELECT CRF_ID FROM CRF WHERE NAME='" + this.crfName + "'),1,sysdate," + this.ub.getId() + ",'" + this.stripQuotes(revisionNotes) + "','" + oid + "')" : "INSERT INTO CRF_VERSION (NAME,DESCRIPTION, CRF_ID, STATUS_ID,DATE_CREATED,OWNER_ID,REVISION_NOTES,OC_OID) VALUES ('" + version + "','" + this.stripQuotes(versionDesc) + "'," + this.crfId + ",1,sysdate," + this.ub.getId() + ",'" + this.stripQuotes(revisionNotes) + "','" + oid + "')";
                } else {
                    sql = this.crfId == 0 ? "INSERT INTO CRF_VERSION (NAME, DESCRIPTION, CRF_ID, STATUS_ID,DATE_CREATED,OWNER_ID,REVISION_NOTES,OC_OID) VALUES ('" + this.stripQuotes(version) + "','" + this.stripQuotes(versionDesc) + "',(SELECT CRF_ID FROM CRF WHERE NAME='" + this.crfName + "'),1,NOW()," + this.ub.getId() + ",'" + this.stripQuotes(revisionNotes) + "','" + oid + "')" : "INSERT INTO CRF_VERSION (NAME,DESCRIPTION, CRF_ID, STATUS_ID,DATE_CREATED,OWNER_ID,REVISION_NOTES,OC_OID) VALUES ('" + version + "','" + this.stripQuotes(versionDesc) + "'," + this.crfId + ",1,NOW()," + this.ub.getId() + ",'" + this.stripQuotes(revisionNotes) + "','" + oid + "')";
                }
                queries.add(sql);
                for (int i = 0; i < queries.size(); ++i) {
                    String s = (String)queries.get(i);
                    this.logger.info("====================" + s);
                }
                pVersion = version;
                pVerDesc = versionDesc;
            }
            this.versionIdString = "(SELECT CRF_VERSION_ID FROM CRF_VERSION WHERE NAME ='" + pVersion + "' AND CRF_ID=" + this.crfId + ")";
            buf.append(sheetName + "<br>");
            buf.append("<div class=\"box_T\"><div class=\"box_L\"><div class=\"box_R\"><div class=\"box_B\"><div class=\"box_TL\"><div class=\"box_TR\"><div class=\"box_BL\"><div class=\"box_BR\">");
            buf.append("<div class=\"textbox_center\">");
            buf.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"");
            buf.append("caption=\"" + wb.getSheetName(j) + "\">");
            for (int i = 0; i < numRows; ++i) {
                buf.append("<tr>");
                if (sheet.getRow(i) == null) continue;
                int numCells = sheet.getRow(i).getLastCellNum();
                block41: for (int y = 0; y < numCells; ++y) {
                    HSSFCell cell = sheet.getRow(i).getCell((short)y);
                    int cellType = 0;
                    String error = "&nbsp;";
                    String errorKey = j + "," + i + "," + y;
                    if (htmlErrors.containsKey(errorKey)) {
                        error = "<span class=\"alert\">" + htmlErrors.get(errorKey) + "</span>";
                    }
                    cellType = cell == null ? 3 : cell.getCellType();
                    switch (cellType) {
                        case 3: {
                            buf.append("<td class=\"table_cell\">" + error + "</td>");
                            continue block41;
                        }
                        case 0: {
                            buf.append("<td class=\"table_cell\">" + cell.getNumericCellValue() + " " + error + "</td>");
                            continue block41;
                        }
                        case 1: {
                            buf.append("<td class=\"table_cell\">" + cell.getStringCellValue() + " " + error + "</td>");
                            continue block41;
                        }
                        default: {
                            buf.append("<td class=\"table_cell\">" + error + "</td>");
                        }
                    }
                }
                buf.append("</tr>");
            }
            buf.append("</table>");
            buf.append("<br></div>");
            buf.append("</div></div></div></div></div></div></div></div>");
            buf.append("</div><br>");
        }
        ncrf.setQueries(queries);
        ncrf.setItemQueries(openQueries);
        ncrf.setBackupItemQueries(backupItemQueries);
        ncrf.setItems(items);
        if (!errors.isEmpty()) {
            ncrf.setErrors(errors);
        }
        ncrf.setHtmlTable(buf.toString());
        return ncrf;
    }

    public String stripQuotes(String subj) {
        if (subj == null) {
            return null;
        }
        String returnme = "";
        String[] subjarray = subj.split("'");
        if (subjarray.length == 1) {
            returnme = subjarray[0];
        } else {
            for (int i = 0; i < subjarray.length - 1; ++i) {
                returnme = returnme + subjarray[i];
                returnme = returnme + "''";
            }
            returnme = returnme + subjarray[subjarray.length - 1];
        }
        return returnme;
    }

    public String getValue(HSSFCell cell) {
        String val = null;
        int cellType = 0;
        cellType = cell == null ? 3 : cell.getCellType();
        switch (cellType) {
            case 3: {
                val = "";
                break;
            }
            case 0: {
                val = cell.getNumericCellValue() + "";
                this.logger.info("found a numeric cell: " + val);
                double dphi = cell.getNumericCellValue();
                if ((dphi - (double)((int)dphi)) * 1000.0 == 0.0) {
                    val = (int)dphi + "";
                }
                this.logger.info("found a numeric cell after transfer: " + val);
                break;
            }
            case 1: {
                val = cell.getStringCellValue();
                if (!val.matches("'")) break;
                val.replaceAll("'", "''");
                break;
            }
            default: {
                val = "";
            }
        }
        return val.trim();
    }

    public String toHTML(int sheetIndex) throws IOException {
        StringBuffer buf = new StringBuffer();
        HSSFWorkbook wb = new HSSFWorkbook(this.fs);
        int numSheets = wb.getNumberOfSheets();
        for (int j = 0; j < numSheets; ++j) {
            HSSFSheet sheet = wb.getSheetAt(j);
            String sheetName = wb.getSheetName(j);
            buf.append(sheetName + "<br>");
            buf.append("<table border=\"2\"");
            buf.append("caption=\"" + wb.getSheetName(sheetIndex) + "\">");
            int numCols = sheet.getPhysicalNumberOfRows();
            for (int i = 0; i < numCols; ++i) {
                buf.append("<tr>");
                if (sheet.getRow(i) == null) continue;
                int numCells = sheet.getRow(i).getLastCellNum();
                block7: for (int y = 0; y < numCells; ++y) {
                    HSSFCell cell = sheet.getRow(i).getCell((short)y);
                    int cellType = 0;
                    cellType = cell == null ? 3 : cell.getCellType();
                    switch (cellType) {
                        case 3: {
                            buf.append("<td> </td>");
                            continue block7;
                        }
                        case 0: {
                            buf.append("<td>" + cell.getNumericCellValue() + "</td>");
                            continue block7;
                        }
                        case 1: {
                            buf.append("<td>" + cell.getStringCellValue() + "</td>");
                            continue block7;
                        }
                        default: {
                            buf.append("<td></td>");
                        }
                    }
                }
                buf.append("</tr>");
            }
            buf.append("</table>");
        }
        return buf.toString();
    }

    private String getMUInsertSql(String oid, String measurementUnitName, int ownerId, String dbName) {
        return "insert into measurement_unit (oc_oid, name) values ('" + oid + "', '" + this.stripQuotes(measurementUnitName) + "')";
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public MeasurementUnitDao getMeasurementUnitDao() {
        return this.measurementUnitDao;
    }

    public void setMeasurementUnitDao(MeasurementUnitDao measurementUnitDao) {
        this.measurementUnitDao = measurementUnitDao;
    }
}

