/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.admin.NewCRFBean;
import org.akaza.openclinica.bean.core.ItemDataType;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.oid.MeasurementUnitOidGenerator;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.bean.submit.ItemGroupMetadataBean;
import org.akaza.openclinica.bean.submit.ResponseSetBean;
import org.akaza.openclinica.control.admin.SpreadSheetItemUtil;
import org.akaza.openclinica.control.admin.SpreadSheetTable;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.form.spreadsheet.OnChangeSheetValidationCell;
import org.akaza.openclinica.control.form.spreadsheet.OnChangeSheetValidationType;
import org.akaza.openclinica.control.form.spreadsheet.OnChangeSheetValidator;
import org.akaza.openclinica.control.form.spreadsheet.SheetCell;
import org.akaza.openclinica.control.form.spreadsheet.SheetValidationContainer;
import org.akaza.openclinica.control.form.spreadsheet.SheetValidationType;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.core.util.CrfTemplateColumnNameEnum;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.hibernate.MeasurementUnitDao;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.exception.CRFReadingException;
import org.akaza.openclinica.logic.score.ScoreValidator;
import org.akaza.openclinica.web.SQLInitServlet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadSheetTableRepeating
implements SpreadSheetTable {
    private POIFSFileSystem fs = null;
    private UserAccountBean ub = null;
    private String versionName = null;
    private int crfId = 0;
    private String crfName = "";
    private String versionIdString = "";
    private boolean isRepeating = false;
    private final HashMap itemGroups = new HashMap();
    private final HashMap itemsToGrouplabels = new HashMap();
    private Locale locale;
    private final int studyId;
    private Set<String> existingUnits = new TreeSet();
    private Set<String> existingOIDs = new TreeSet();
    private MeasurementUnitDao measurementUnitDao = new MeasurementUnitDao();
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public SpreadSheetTableRepeating(FileInputStream parseStream, UserAccountBean ub, String versionName, Locale locale, int studyId) throws IOException {
        this.fs = new POIFSFileSystem((InputStream)parseStream);
        this.ub = ub;
        this.versionName = versionName;
        this.locale = locale;
        this.studyId = studyId;
        HSSFWorkbook wb = new HSSFWorkbook(this.fs);
        int numSheets = wb.getNumberOfSheets();
        for (int j = 0; j < numSheets; ++j) {
            HSSFSheet sheet = wb.getSheetAt(j);
            String sheetName = wb.getSheetName(j);
            if (!sheetName.equalsIgnoreCase("groups")) continue;
            this.isRepeating = true;
        }
    }

    public void setCrfId(int id) {
        this.crfId = id;
    }

    public int getCrfId() {
        return this.crfId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public NewCRFBean toNewCRF(DataSource ds, ResourceBundle resPageMsg) throws IOException, CRFReadingException {
        dbName = SQLInitServlet.getDBName();
        ncrf = new NewCRFBean(ds, this.crfId);
        ncrf.setCrfId(this.crfId);
        buf = new StringBuffer();
        wb = new HSSFWorkbook(this.fs);
        numSheets = wb.getNumberOfSheets();
        queries = new ArrayList<String>();
        errors = new ArrayList();
        tableNames = new HashMap<K, V>();
        items = new HashMap<String, ItemBean>();
        item_from_row = null;
        pVersion = "";
        pVerDesc = "";
        parentId = 0;
        dataTypeId = 5;
        itemCheck = ncrf.getItemNames();
        GroupCheck = ncrf.getItemGroupNames();
        openQueries = new LinkedHashMap<String, String>();
        backupItemQueries = new LinkedHashMap<String, String>();
        secNames = new ArrayList<String>();
        itemGroupOids = new ArrayList<String>();
        itemOids = new ArrayList<String>();
        cdao = new CRFDAO(ds);
        crf = (CRFBean)cdao.findByPK(this.crfId);
        idao = new ItemDAO(ds);
        cvdao = new CRFVersionDAO(ds);
        itemGroupDao = new ItemGroupDAO(ds);
        sheetContainer = new SheetValidationContainer();
        allItems = (HashMap)sheetContainer.getAllItems();
        controlValues = new HashMap<String, String[]>();
        maxItemFormMetadataId = new ItemFormMetadataDAO(ds).findMaxId();
        instantValidator = new OnChangeSheetValidator(sheetContainer, resPageMsg);
        validSheetNum = 0;
        for (j = 0; j < numSheets; ++j) {
            sheet = wb.getSheetAt(j);
            sheetName = wb.getSheetName(j);
            if (!sheetName.equalsIgnoreCase("CRF") && !sheetName.equalsIgnoreCase("Sections") && !sheetName.equalsIgnoreCase("Items")) continue;
            ++validSheetNum;
        }
        if (validSheetNum != 3) {
            errors.add("The excel spreadsheet doesn't have required valid worksheets. Please check whether it contains sheets of CRF, Sections and Items.");
        }
        sheet = wb.getSheetAt(4);
        insCell = sheet.getRow(1).getCell((short)0);
        versionNo = insCell.toString();
        for (j = 0; j < numSheets; ++j) {
            block257: {
                block260: {
                    sheet = wb.getSheetAt(j);
                    sheetName = wb.getSheetName(j);
                    if (sheetName.equalsIgnoreCase("Instructions")) continue;
                    numRows = sheet.getPhysicalNumberOfRows();
                    lastNumRow = sheet.getLastRowNum();
                    secName = "";
                    page = "";
                    resPairs = new ArrayList<String>();
                    resNames = new ArrayList<String>();
                    htmlErrors = new HashMap();
                    blankRowCount = 0;
                    itemName = null;
                    default_value = null;
                    if (!sheetName.equalsIgnoreCase("Items")) break block260;
                    this.logger.debug("read an item in sheet" + sheetName);
                    labelWithOptions = new HashMap<String, String[]>();
                    labelWithValues = new HashMap<String, String[]>();
                    labelWithType = new HashMap<String, String>();
                    this.logger.debug("row20 is: " + this.getValue(sheet.getRow(0).getCell((short)20)));
                    hasWDColumn = "width_decimal".equalsIgnoreCase(this.getValue(sheet.getRow(0).getCell((short)20))) != false;
                    row_items = new ArrayList<SpreadSheetItemUtil>();
                    for (k = 1; k < numRows; ++k) {
                        block262: {
                            block263: {
                                block264: {
                                    block261: {
                                        if (sheet.getRow(k) == null) {
                                            if (++blankRowCount != 5) continue;
                                            break;
                                        }
                                        cellIndex = 0;
                                        cell = sheet.getRow(k).getCell((short)0);
                                        item_from_row = new SpreadSheetItemUtil();
                                        row_items.add(item_from_row);
                                        item_from_row.setItemName(this.getValue(cell));
                                        item_from_row.verifyItemName(row_items, errors, htmlErrors, j, resPageMsg);
                                        itemName = item_from_row.getItemName();
                                        cell = sheet.getRow(k).getCell((short)1);
                                        descLabel = this.getValue(cell);
                                        descLabel = descLabel.replaceAll("<[^>]*>", "");
                                        item_from_row.setDescriptionLabel(descLabel);
                                        if (StringUtil.isBlank((String)descLabel)) {
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DESCRIPTION_LABEL_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                                            htmlErrors.put(j + "," + k + ",1", resPageMsg.getString("required_field"));
                                        }
                                        if (descLabel != null && descLabel.length() > 4000) {
                                            errors.add(resPageMsg.getString("item_desc_length_error"));
                                        }
                                        if ((leftItemText = this.getValue(cell = sheet.getRow(k).getCell((short)2))) != null && leftItemText.length() > 4000) {
                                            errors.add(resPageMsg.getString("left_item_length_error"));
                                        }
                                        item_from_row.setLeftItemText(leftItemText);
                                        cell = sheet.getRow(k).getCell((short)3);
                                        unit = this.getValue(cell).trim();
                                        if (unit != null && unit.length() > 0) {
                                            muSql = "";
                                            if (unit.length() > 64) {
                                                errors.add(resPageMsg.getString("units_length_error"));
                                                htmlErrors.put(j + "," + k + "," + CrfTemplateColumnNameEnum.UNITS.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
                                            }
                                            if (this.existingUnits.size() <= 0) {
                                                this.existingUnits = this.measurementUnitDao.findAllNames();
                                                if (this.existingUnits == null) {
                                                    this.existingUnits = new TreeSet<E>();
                                                }
                                            }
                                            if (this.existingOIDs.size() <= 0) {
                                                this.existingOIDs = this.measurementUnitDao.findAllOIDs();
                                                if (this.existingOIDs == null) {
                                                    this.existingOIDs = new TreeSet<E>();
                                                }
                                            }
                                            if (this.existingUnits.contains(unit)) {
                                                this.logger.debug("unit=" + unit + " existed.");
                                            } else {
                                                oid = "";
                                                try {
                                                    oid = new MeasurementUnitOidGenerator().generateOid(new String[]{unit});
                                                }
                                                catch (Exception e) {
                                                    throw new RuntimeException("CANNOT GENERATE OID");
                                                }
                                                if (this.existingOIDs.contains(oid)) {
                                                    if (oid.length() > 40) {
                                                        oid = oid.substring(0, 35);
                                                    }
                                                    oid = new MeasurementUnitOidGenerator().randomizeOid(oid);
                                                }
                                                this.existingOIDs.add(oid);
                                                this.existingUnits.add(unit);
                                                muSql = this.getMUInsertSql(oid, unit, this.ub.getId(), dbName);
                                                queries.add(muSql);
                                            }
                                        }
                                        if ((rightItemText = this.getValue(cell = sheet.getRow(k).getCell((short)4))) != null && rightItemText.length() > 2000) {
                                            errors.add(resPageMsg.getString("right_item_length_error"));
                                        }
                                        cell = sheet.getRow(k).getCell((short)5);
                                        item_from_row.setSectionLabel(this.getValue(cell));
                                        item_from_row.verifySectionLabel(row_items, errors, secNames, htmlErrors, j, resPageMsg);
                                        secName = item_from_row.getSectionLabel();
                                        cell = sheet.getRow(k).getCell((short)6);
                                        item_from_row.setGroupLabel(this.getValue(cell));
                                        if (item_from_row.getItemName().length() > 0) {
                                            if (!StringUtil.isBlank((String)item_from_row.getGroupLabel())) {
                                                allItems.put(item_from_row.getItemName(), item_from_row.getGroupLabel());
                                            } else {
                                                allItems.put(item_from_row.getItemName(), "Ungrouped");
                                            }
                                        }
                                        groupLabel = item_from_row.getGroupLabel();
                                        sheetContainer.getItemSectionNameMap().put(itemName, secName);
                                        sheetContainer.collectRepGrpItemNameMap(itemName, item_from_row.getGroupLabel());
                                        cell = sheet.getRow(k).getCell((short)7);
                                        header = this.getValue(cell);
                                        if (header != null && header.length() > 2000) {
                                            errors.add(resPageMsg.getString("item_header_length_error"));
                                        }
                                        if ((subHeader = this.getValue(cell = sheet.getRow(k).getCell((short)8))) != null && subHeader.length() > 240) {
                                            errors.add(resPageMsg.getString("item_subheader_length_error"));
                                            htmlErrors.put(j + "," + k + "," + CrfTemplateColumnNameEnum.SUBHEADER.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
                                        }
                                        cell = sheet.getRow(k).getCell((short)9);
                                        parentItem = this.getValue(cell);
                                        item_from_row.setParentItem(parentItem);
                                        item_from_row.verifyParentID(row_items, errors, htmlErrors, j, resPageMsg, this.itemGroups);
                                        parentItem = item_from_row.getParentItem();
                                        cell = sheet.getRow(k).getCell((short)10);
                                        columnNum = 0;
                                        column = this.getValue(cell);
                                        if (!StringUtil.isBlank((String)column)) {
                                            try {
                                                columnNum = Integer.parseInt(column);
                                            }
                                            catch (NumberFormatException ne) {
                                                columnNum = 0;
                                            }
                                        }
                                        if ((cell = sheet.getRow(k).getCell((short)11)) != null) {
                                            page = this.getValue(cell);
                                        }
                                        cell = sheet.getRow(k).getCell((short)12);
                                        questionNum = this.getValue(cell);
                                        cell = sheet.getRow(k).getCell((short)13);
                                        responseType = this.getValue(cell);
                                        responseTypeId = 1;
                                        if (StringUtil.isBlank((String)responseType)) {
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_TYPE_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                            htmlErrors.put(j + "," + k + ",13", resPageMsg.getString("required_field"));
                                        } else {
                                            if (!ResponseType.findByName((String)responseType.toLowerCase())) {
                                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_TYPE_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                                htmlErrors.put(j + "," + k + ",13", resPageMsg.getString("INVALID_FIELD"));
                                            } else {
                                                responseTypeId = ResponseType.getByName((String)responseType.toLowerCase()).getId();
                                                item_from_row.setResponseTypeId(responseTypeId);
                                            }
                                            if (responseTypeId == 5) {
                                                cell = sheet.getRow(k).getCell((short)18);
                                                def = this.getValue(cell);
                                                if (!StringUtil.isBlank((String)def)) {
                                                    errors.add(resPageMsg.getString("radio_with_default") + item_from_row.getItemName() + resPageMsg.getString("change_radio"));
                                                    htmlErrors.put(j + "," + k + "," + CrfTemplateColumnNameEnum.DEFAULT_VALUE.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
                                                }
                                            } else if (responseTypeId == ResponseType.INSTANT_CALCULATION.getId()) {
                                                unit = "";
                                            }
                                        }
                                        cell = sheet.getRow(k).getCell((short)14);
                                        responseLabel = this.getValue(cell);
                                        if (StringUtil.isBlank((String)responseLabel) && responseTypeId != ResponseType.TEXT.getId() && responseTypeId != ResponseType.TEXTAREA.getId()) {
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_LABEL_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                            htmlErrors.put(j + "," + k + ",14", resPageMsg.getString("required_field"));
                                        } else if ("file".equalsIgnoreCase(responseType) && !"file".equalsIgnoreCase(responseLabel)) {
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_LABEL_column") + " " + resPageMsg.getString("should_be_file") + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                                            htmlErrors.put(j + "," + k + ",14", resPageMsg.getString("should_be_file"));
                                        }
                                        cell = sheet.getRow(k).getCell((short)15);
                                        resOptions = this.getValue(cell);
                                        if (responseTypeId == ResponseType.TEXT.getId()) {
                                            responseLabel = "text";
                                        } else if (responseTypeId == ResponseType.TEXTAREA.getId()) {
                                            responseLabel = "textarea";
                                        }
                                        if (responseLabel.equalsIgnoreCase("text") || responseLabel.equalsIgnoreCase("textarea")) {
                                            resOptions = "text";
                                        } else if ("file".equalsIgnoreCase(responseType)) {
                                            resOptions = "file";
                                        }
                                        numberOfOptions = 0;
                                        if (!resNames.contains(responseLabel) && StringUtil.isBlank((String)resOptions) && responseTypeId != ResponseType.TEXT.getId() && responseTypeId != ResponseType.TEXTAREA.getId()) {
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_OPTIONS_TEXT_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                            htmlErrors.put(j + "," + k + ",15", resPageMsg.getString("required_field"));
                                        }
                                        if (!resNames.contains(responseLabel) && !StringUtil.isBlank((String)resOptions)) {
                                            if (responseTypeId == 8 || responseTypeId == 9) {
                                                numberOfOptions = 1;
                                            } else {
                                                text1 = resOptions.replaceAll("\\\\,", "##");
                                                resArray = text1.split(",");
                                                numberOfOptions = resArray.length;
                                            }
                                        }
                                        mapResArray = (String[])labelWithOptions.get(responseLabel);
                                        text1 = resOptions.replaceAll("\\\\,", "##");
                                        resArray = text1.split(",");
                                        item_from_row.setResponseOptions(resArray);
                                        this.logger.debug(item_from_row.getItemName());
                                        if (labelWithOptions.containsKey(responseLabel)) {
                                            if (!StringUtil.isBlank((String)resOptions)) {
                                                for (i = 0; i < resArray.length; ++i) {
                                                    if (resArray[i].equals(mapResArray[i])) continue;
                                                    errors.add(resPageMsg.getString("resp_label_with_different_resp_options") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                                    htmlErrors.put(j + "," + k + ",15", resPageMsg.getString("resp_label_with_different_resp_options_html_error"));
                                                    break;
                                                }
                                            }
                                        } else {
                                            labelWithOptions.put(responseLabel, resArray);
                                        }
                                        cell = sheet.getRow(k).getCell((short)16);
                                        resValues = this.getValue(cell);
                                        if (responseLabel.equalsIgnoreCase("text") || responseLabel.equalsIgnoreCase("textarea")) {
                                            resValues = "text";
                                        } else if ("file".equalsIgnoreCase(responseType)) {
                                            resValues = "file";
                                        }
                                        if (!resNames.contains(responseLabel) && StringUtil.isBlank((String)resValues) && responseTypeId != ResponseType.TEXT.getId() && responseTypeId != ResponseType.TEXTAREA.getId() && responseTypeId != ResponseType.INSTANT_CALCULATION.getId()) {
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                            htmlErrors.put(j + ", " + k + ",16", resPageMsg.getString("required_field"));
                                        }
                                        if (responseTypeId == ResponseType.CALCULATION.getId() || responseTypeId == ResponseType.GROUP_CALCULATION.getId()) {
                                            if (resValues.contains(":") && !"func".equalsIgnoreCase((s = resValues.split(":"))[0].trim())) {
                                                errors.add(resPageMsg.getString("expression_not_start_with_func_at") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                                                htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("INVALID_FIELD"));
                                            }
                                            exp = resValues;
                                            exp = exp.replace("\\\\,", "##");
                                            exp = exp.replace("##", ",");
                                            resValues = exp = exp.replace(",", "\\\\,");
                                            if (exp.startsWith("func:")) {
                                                exp = exp.substring(5).trim();
                                            }
                                            if (!(scoreValidator = new ScoreValidator(this.locale)).isValidExpression(exp = exp.replace("\\\\,", "##"), err = new StringBuffer(), variables = new ArrayList<E>())) {
                                                errors.add(resPageMsg.getString("expression_invalid_at") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ": " + err);
                                                htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("INVALID_FIELD"));
                                            }
                                            if (!exp.startsWith("getexternalvalue") && !exp.startsWith("getExternalValue")) {
                                                group = groupLabel.length() > 0 ? groupLabel : "Ungrouped";
                                                for (String v : variables) {
                                                    if (!allItems.containsKey(v)) {
                                                        errors.add("Item '" + v + "' must be listed before the item '" + itemName + "' at row " + k + ", items worksheet. ");
                                                        htmlErrors.put(j + "," + k + ",16", "INVALID FIELD");
                                                        continue;
                                                    }
                                                    if (responseTypeId == 8 && !((String)allItems.get(v)).equalsIgnoreCase(group)) {
                                                        errors.add("Item '" + v + "' and item '" + itemName + "' must have a same GROUP_LABEL at row " + k + ", items worksheet. ");
                                                        htmlErrors.put(j + "," + k + ",16", "INVALID FIELD");
                                                        continue;
                                                    }
                                                    if (responseTypeId != 9 || (g = (String[])allItems.get(v)).equalsIgnoreCase("ungrouped") || !g.equalsIgnoreCase(group)) continue;
                                                    errors.add("Item '" + v + "' and item '" + itemName + "' should not have a same GROUP_LABEL at row " + k + ", items worksheet. ");
                                                    htmlErrors.put(j + "," + k + ",16", "INVALID FIELD");
                                                }
                                            }
                                        } else if ("instant-calculation".equalsIgnoreCase(responseType)) {
                                            onchangecell = new OnChangeSheetValidationCell(OnChangeSheetValidationType.ALL, new SheetCell.Builder().rowName(itemName).colTitle("RESPONSE_VALUES_column").colValue(resValues).forWhich("instant_calculation").sheetNum(j).rowNum(k).colNum(16).build());
                                            instantValidator.addValidationCells(onchangecell);
                                        } else if (numberOfOptions > 0 && (resValArray = (value1 = resValues.replaceAll("\\\\,", "##")).split(",")).length != numberOfOptions) {
                                            errors.add(resPageMsg.getString("incomplete_option_value_pair") + " " + resPageMsg.getString("RESPONSE_OPTIONS_column") + " " + resPageMsg.getString("and") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("at_row") + k + " " + resPageMsg.getString("items_worksheet") + "; " + resPageMsg.getString("perhaps_missing_comma"));
                                            htmlErrors.put(j + "," + k + ",15", resPageMsg.getString("number_option_not_match"));
                                            htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("number_value_not_match"));
                                        }
                                        mapValArray = (String[])labelWithValues.get(responseLabel);
                                        value1 = resValues.replaceAll("\\\\,", "##");
                                        resValArray = value1.split(",");
                                        if (labelWithValues.containsKey(responseLabel)) {
                                            if (!StringUtil.isBlank((String)resValues)) {
                                                if (null != resValArray && null != mapValArray && resValArray.length != mapValArray.length) {
                                                    errors.add(resPageMsg.getString("resp_label_with_different_resp_values") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                                                    htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("resp_label_with_different_resp_values_html_error"));
                                                } else {
                                                    for (i = 0; i < resValArray.length; ++i) {
                                                        if (resValArray[i].equals(mapValArray[i])) continue;
                                                        errors.add(resPageMsg.getString("resp_label_with_different_resp_values") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                                        htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("resp_label_with_different_resp_values_html_error"));
                                                        break;
                                                    }
                                                }
                                            }
                                            controlValues.put(secName + "---" + itemName, mapValArray);
                                        } else {
                                            labelWithValues.put(responseLabel, resValArray);
                                            controlValues.put(secName + "---" + itemName, resValArray);
                                        }
                                        cell = sheet.getRow(k).getCell((short)17);
                                        responseLayout = this.getValue(cell);
                                        responseLayout = responseLayout.replaceAll("<[^>]*>", "");
                                        cell = sheet.getRow(k).getCell((short)19);
                                        dataType = this.getValue(cell);
                                        dataType = dataType.replaceAll("<[^>]*>", "");
                                        item_from_row.setDataType(dataType);
                                        dataTypeIdString = "1";
                                        if (StringUtil.isBlank((String)dataType)) {
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                            htmlErrors.put(j + "," + k + ",19", resPageMsg.getString("required_field"));
                                        } else if (!ItemDataType.findByName((String)dataType.toLowerCase())) {
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                            htmlErrors.put(j + "," + k + ",19", resPageMsg.getString("INVALID_FIELD"));
                                        } else {
                                            if ("file".equalsIgnoreCase(responseType) && !"FILE".equalsIgnoreCase(dataType)) {
                                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("should_be_file") + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                                htmlErrors.put(j + "," + k + ",19", resPageMsg.getString("should_be_file"));
                                            } else if ("instant-calculation".equalsIgnoreCase(responseType)) {
                                                onchangecell = new OnChangeSheetValidationCell(OnChangeSheetValidationType.NONE, SheetValidationType.SHOULD_BE_ST, new SheetCell.Builder().rowName(itemName).colTitle("DATA_TYPE_column").colValue(dataType).forWhich("instant_calculation").sheetNum(j).rowNum(k).colNum(19).build());
                                                instantValidator.addValidationCells(onchangecell);
                                            }
                                            dataTypeIdString = "(SELECT ITEM_DATA_TYPE_ID From ITEM_DATA_TYPE Where CODE='" + dataType.toUpperCase() + "')";
                                        }
                                        if (responseTypeId == 3 || responseTypeId == 5 || responseTypeId == 6 || responseTypeId == 7) {
                                            if (labelWithType.containsKey(responseLabel)) {
                                                if (!dataType.equalsIgnoreCase(labelWithType.get(responseLabel).toString())) {
                                                    errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("does_not_match_the_item_data_type_with_the_same_response_label") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                                    htmlErrors.put(j + "," + k + ",19", resPageMsg.getString("INVALID_FIELD"));
                                                }
                                            } else {
                                                labelWithType.put(responseLabel, dataType);
                                                if (resValArray.length > 0) {
                                                    wrongType = false;
                                                    if ("int".equalsIgnoreCase(dataType)) {
                                                        g = resValArray;
                                                        var86_138 = g.length;
                                                        for (var87_141 = 0; var87_141 < var86_138; ++var87_141) {
                                                            s = g[var87_141];
                                                            v0 = st = s != null && s.length() > 0 ? s.trim() : "";
                                                            if (st.length() <= 0) continue;
                                                            try {
                                                                I = Integer.parseInt(st);
                                                                if (I.toString().equals(st)) continue;
                                                                wrongType = true;
                                                                continue;
                                                            }
                                                            catch (Exception e) {
                                                                wrongType = true;
                                                            }
                                                        }
                                                        if (wrongType) {
                                                            wrongType = false;
                                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("should_be_integer") + " " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                                            htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("should_be_integer"));
                                                        }
                                                    } else if ("real".equalsIgnoreCase(dataType)) {
                                                        g = resValArray;
                                                        var86_139 = g.length;
                                                        for (var87_142 = 0; var87_142 < var86_139; ++var87_142) {
                                                            s = g[var87_142];
                                                            v1 = st = s != null && s.length() > 0 ? s.trim() : "";
                                                            if (st.length() <= 0) continue;
                                                            try {
                                                                e = Double.parseDouble(st);
                                                                continue;
                                                            }
                                                            catch (Exception e) {
                                                                wrongType = true;
                                                            }
                                                        }
                                                        if (wrongType) {
                                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("should_be_real") + " " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                                                            htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("should_be_real"));
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        cell = sheet.getRow(k).getCell((short)18);
                                        item_from_row.setDefaultValue(this.getValue(cell));
                                        item_from_row.verifyDefaultValue(row_items, errors, htmlErrors, j, resPageMsg);
                                        default_value = item_from_row.getDefaultValue();
                                        cellIndex = 19;
                                        widthDecimal = "";
                                        this.logger.debug("hasWidthDecimalColumn=" + hasWDColumn);
                                        if (hasWDColumn) {
                                            cell = sheet.getRow(k).getCell((short)(++cellIndex));
                                            widthDecimal = this.getValue(cell);
                                            if (StringUtil.isBlank((String)widthDecimal)) {
                                                widthDecimal = "";
                                            } else if ("single-select".equalsIgnoreCase(responseType) || "multi-select".equalsIgnoreCase(responseType) || "radio".equalsIgnoreCase(responseType) || "checkbox".equalsIgnoreCase(responseType)) {
                                                errors.add(resPageMsg.getString("error_message_for_width_decimal_at") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ": " + resPageMsg.getString("width_decimal_unavailable_for_single_multi_checkbox_radio"));
                                                htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                                            } else {
                                                message = new StringBuffer();
                                                isCalc = responseTypeId == 8 || responseTypeId == 9;
                                                message = Validator.validateWidthDecimalSetting((String)widthDecimal, (String)dataType, (boolean)isCalc, (Locale)this.locale);
                                                if (message.length() > 0) {
                                                    errors.add(resPageMsg.getString("error_message_for_width_decimal_at") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ": " + message);
                                                    htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                                                }
                                            }
                                        }
                                        cell = sheet.getRow(k).getCell((short)(++cellIndex));
                                        regexp = this.getValue(cell);
                                        regexp1 = "";
                                        if (!StringUtil.isBlank((String)regexp)) {
                                            regexp1 = regexp.trim();
                                            if (regexp1.startsWith("regexp:")) {
                                                finalRegexp = regexp1.substring(7).trim();
                                                if (finalRegexp.contains("\\\\")) {
                                                    errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + " " + resPageMsg.getString("has_an_invalid_regular_expression_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("regular_expression_contained") + " '\\\\', " + resPageMsg.getString("it_should_only_contain_one") + "'\\'. ");
                                                    htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                                                } else if (finalRegexp.startsWith("/") && finalRegexp.endsWith("/")) {
                                                    finalRegexp = finalRegexp.substring(1, finalRegexp.length() - 1);
                                                    try {
                                                        p = Pattern.compile(finalRegexp);
                                                        chars = regexp1.toCharArray();
                                                        regexp1 = "";
                                                        for (char c : chars) {
                                                            regexp1 = c == '\\' && dbName.equals("oracle") == false ? regexp1 + c + "\\" : regexp1 + c;
                                                        }
                                                    }
                                                    catch (PatternSyntaxException pse) {
                                                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + resPageMsg.getString("has_an_invalid_regular_expression_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("Example") + " regexp: /[0-9]*/ ");
                                                        htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                                                    }
                                                } else {
                                                    errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + resPageMsg.getString("has_an_invalid_regular_expression_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + " " + resPageMsg.getString("Example") + " regexp: /[0-9]*/ ");
                                                    htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                                                }
                                            } else if (regexp1.startsWith("func:")) {
                                                isProperFunction = false;
                                                try {
                                                    Validator.processCRFValidationFunction((String)regexp1);
                                                    isProperFunction = true;
                                                }
                                                catch (Exception e) {
                                                    errors.add(e.getMessage() + ", " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                                    htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                                                }
                                            } else {
                                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                                htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                                            }
                                        }
                                        cell = sheet.getRow(k).getCell((short)(++cellIndex));
                                        regexpError = this.getValue(cell);
                                        regexpError = regexpError.replaceAll("<[^>]*>", "");
                                        if (!StringUtil.isBlank((String)regexp) && StringUtil.isBlank((String)regexpError)) {
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_ERROR_MESSAGE_column") + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + " " + resPageMsg.getString("cannot_be_blank_if_VALIDATION_not_blank"));
                                            htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("required_field"));
                                        }
                                        if (regexpError != null && regexpError.length() > 255) {
                                            errors.add(resPageMsg.getString("regexp_errror_length_error"));
                                        }
                                        phiBoolean = false;
                                        cell = sheet.getRow(k).getCell((short)(++cellIndex));
                                        phi = this.getValue(cell);
                                        if (StringUtil.isBlank((String)phi)) {
                                            phi = "0";
                                        } else if (cell.getCellType() == 0 && ((dphi = cell.getNumericCellValue()) - (double)((int)dphi)) * 1000.0 == 0.0) {
                                            phi = (int)dphi + "";
                                        }
                                        if (!"0".equals(phi) && !"1".equals(phi)) {
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("PHI_column") + resPageMsg.getString("was_invalid_at_row") + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("PHI_column") + " " + resPageMsg.getString("can_only_be_either_0_or_1"));
                                            htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                                        } else {
                                            phiBoolean = "1".equals(phi) != false;
                                        }
                                        isRequired = false;
                                        cell = sheet.getRow(k).getCell((short)(++cellIndex));
                                        required = this.getValue(cell);
                                        if (StringUtil.isBlank((String)required)) {
                                            required = "0";
                                        } else if (cell.getCellType() == 0 && ((dr = cell.getNumericCellValue()) - (double)((int)dr)) * 1000.0 == 0.0) {
                                            required = (int)dr + "";
                                        }
                                        if (!"0".equals(required) && !"1".equals(required)) {
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("REQUIRED_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("REQUIRED_column") + resPageMsg.getString("can_only_be_either_0_or_1"));
                                            htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                                        } else {
                                            isRequired = "1".equals(required) != false;
                                        }
                                        isShowItem = true;
                                        cell = sheet.getRow(k).getCell((short)(++cellIndex));
                                        showItem = this.getValue(cell);
                                        if (!StringUtil.isBlank((String)showItem)) {
                                            isShowItem = "0".equals(showItem) == false;
                                            isShowItem = "Hide".equalsIgnoreCase(showItem) == false;
                                        }
                                        cell = sheet.getRow(k).getCell((short)(++cellIndex));
                                        display = this.getValue(cell);
                                        controlItemName = "";
                                        optionValue = "";
                                        message = "";
                                        if (!StringUtil.isBlank((String)display)) {
                                            if (isShowItem) {
                                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("ITEM_DISPLAY_STATUS_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("should_be_hide_for_scd"));
                                                htmlErrors.put(j + "," + k + "," + (cellIndex - 1), resPageMsg.getString("INVALID_VALUE"));
                                            }
                                            pvKey = secName + "---";
                                            d = display.replaceAll("\\\\,", "##");
                                            par = d.split(",");
                                            if (par.length == 3) {
                                                p0 = par[0].trim();
                                                p1 = par[1].trim();
                                                p2 = par[2].trim();
                                                if (p0.length() > 0 && p1.length() > 0 && p2.length() > 0) {
                                                    if (SpreadSheetItemUtil.isItemWithSameParameterExistsIncludingMyself((String)p0, row_items)) {
                                                        controlItemName = p0;
                                                        optionValue = p1;
                                                        message = p2;
                                                        if (controlValues.containsKey(pvKey = pvKey + p0)) {
                                                            pvs = (String[])controlValues.get(pvKey);
                                                            existing = false;
                                                            for (String s : pvs) {
                                                                if (!s.trim().equals(p1)) continue;
                                                                existing = true;
                                                                break;
                                                            }
                                                            if (!existing) {
                                                                optionValue = "";
                                                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SIMPLE_CONDITIONAL_DISPLAY_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("control_response_value_invalid") + " " + p1.replace("##", "\\\\,"));
                                                                htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                                                            }
                                                        }
                                                    } else {
                                                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SIMPLE_CONDITIONAL_DISPLAY_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("control_item_name_invalid") + " " + p0);
                                                        htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                                                    }
                                                } else {
                                                    errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SIMPLE_CONDITIONAL_DISPLAY_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("correct_pattern"));
                                                    htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                                                }
                                            } else {
                                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SIMPLE_CONDITIONAL_DISPLAY_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("correct_pattern"));
                                                htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                                            }
                                        }
                                        itemOid = idao.getValidOid(new ItemBean(), this.crfName, itemName, itemOids);
                                        itemOids.add(itemOid);
                                        vlSql = "";
                                        vlSql = dbName.equals("oracle") != false ? "INSERT INTO ITEM (NAME,DESCRIPTION,UNITS,PHI_STATUS,ITEM_DATA_TYPE_ID, ITEM_REFERENCE_TYPE_ID,STATUS_ID,OWNER_ID,DATE_CREATED,OC_OID) VALUES ('" + this.stripQuotes(itemName) + "','" + this.stripQuotes(descLabel) + "','" + this.stripQuotes(unit) + "'," + (phiBoolean == true ? 1 : 0) + "," + dataTypeIdString + ",1,1," + this.ub.getId() + ", sysdate,'" + itemOid + "')" : "INSERT INTO ITEM (NAME,DESCRIPTION,UNITS,PHI_STATUS,ITEM_DATA_TYPE_ID, ITEM_REFERENCE_TYPE_ID,STATUS_ID,OWNER_ID,DATE_CREATED,OC_OID) VALUES ('" + this.stripQuotes(itemName) + "','" + this.stripQuotes(descLabel) + "','" + this.stripQuotes(unit) + "'," + phiBoolean + "," + dataTypeIdString + ",1,1," + this.ub.getId() + ", NOW(),'" + itemOid + "')";
                                        backupItemQueries.put(itemName, vlSql);
                                        ib = new ItemBean();
                                        ib.setName(itemName);
                                        ib.setUnits(unit);
                                        ib.setPhiStatus(phiBoolean);
                                        ib.setDescription(descLabel);
                                        ib.setDataType(ItemDataType.getByName((String)dataType.toLowerCase()));
                                        rsb = new ResponseSetBean();
                                        resOptions1 = resOptions.replaceAll("\\\\,", "\\,");
                                        resValues1 = resValues.replaceAll("\\\\,", "\\,");
                                        rsb.setOptions(this.stripQuotes(resOptions1), this.stripQuotes(resValues1));
                                        ifmb = new ItemFormMetadataBean();
                                        ifmb.setResponseSet(rsb);
                                        ifmb.setShowItem(isShowItem);
                                        ib.setItemMeta(ifmb);
                                        items.put(itemName, ib);
                                        ownerId = this.ub.getId();
                                        if (itemCheck.containsKey(itemName)) break block261;
                                        openQueries.put(itemName, vlSql);
                                        break block262;
                                    }
                                    oldItem = (ItemBean)idao.findByNameAndCRFId(itemName, this.crfId);
                                    if (oldItem.getOwnerId() != this.ub.getId()) break block263;
                                    if (cvdao.hasItemData(oldItem.getId())) break block264;
                                    upSql = "";
                                    upSql = dbName.equals("oracle") != false ? "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',UNITS='" + this.stripQuotes(unit) + "',PHI_STATUS=" + (phiBoolean != false ? 1 : 0) + ",ITEM_DATA_TYPE_ID=" + dataTypeIdString + " WHERE exists (SELECT versioning_map.item_id from versioning_map, crf_version where versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id= " + this.crfId + " AND item.item_id = versioning_map.item_id) AND item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId : "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',UNITS='" + this.stripQuotes(unit) + "',PHI_STATUS=" + phiBoolean + ",ITEM_DATA_TYPE_ID=" + dataTypeIdString + " FROM versioning_map, crf_version WHERE item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId + " AND item.item_id = versioning_map.item_id AND versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id = " + this.crfId;
                                    openQueries.put(itemName, upSql);
                                    break block262;
                                }
                                upSql = "";
                                v2 = oldItem.getDataType();
                                oldItem.getDataType();
                                if (v2 != ItemDataType.DATE) ** GOTO lbl-1000
                                v3 = ib.getDataType();
                                ib.getDataType();
                                if (v3 == ItemDataType.PDATE) {
                                    upSql = dbName.equals("oracle") ? "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',PHI_STATUS=" + (phiBoolean != false ? 1 : 0) + ",ITEM_DATA_TYPE_ID=" + dataTypeIdString + " WHERE exists (SELECT versioning_map.item_id from versioning_map, crf_version where versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id= " + this.crfId + " AND item.item_id = versioning_map.item_id) AND item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId : "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',PHI_STATUS=" + phiBoolean + ",ITEM_DATA_TYPE_ID=" + dataTypeIdString + " FROM versioning_map, crf_version WHERE item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId + " AND item.item_id = versioning_map.item_id AND versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id = " + this.crfId;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    upSql = dbName.equals("oracle") != false ? "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',PHI_STATUS=" + (phiBoolean != false ? 1 : 0) + " WHERE exists (SELECT versioning_map.item_id from versioning_map, crf_version where versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id= " + this.crfId + " AND item.item_id = versioning_map.item_id) AND item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId : "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',PHI_STATUS=" + phiBoolean + " FROM versioning_map, crf_version WHERE item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId + " AND item.item_id = versioning_map.item_id AND versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id = " + this.crfId;
                                }
                                openQueries.put(itemName, upSql);
                                break block262;
                            }
                            ownerId = oldItem.getOwner().getId();
                        }
                        sql = "";
                        sql = dbName.equals("oracle") != false ? "INSERT INTO RESPONSE_SET (LABEL, OPTIONS_TEXT, OPTIONS_VALUES, RESPONSE_TYPE_ID, VERSION_ID) VALUES ('" + this.stripQuotes(responseLabel) + "', '" + this.stripQuotes(resOptions.replaceAll("\\\\,", "\\,")) + "','" + this.stripQuotes(resValues.replace("\\\\", "\\")) + "',(SELECT RESPONSE_TYPE_ID From RESPONSE_TYPE Where NAME='" + this.stripQuotes(responseType.toLowerCase()) + "')," + this.versionIdString + ")" : "INSERT INTO RESPONSE_SET (LABEL, OPTIONS_TEXT, OPTIONS_VALUES, RESPONSE_TYPE_ID, VERSION_ID) VALUES ('" + this.stripQuotes(responseLabel) + "', E'" + this.stripQuotes(resOptions) + "', E'" + this.stripQuotes(resValues) + "',(SELECT RESPONSE_TYPE_ID From RESPONSE_TYPE Where NAME='" + this.stripQuotes(responseType.toLowerCase()) + "')," + this.versionIdString + ")";
                        if (!resPairs.contains(responseLabel.toString().toLowerCase() + "_" + responseType.toString().toLowerCase())) {
                            if (!resNames.contains(responseLabel)) {
                                queries.add(sql);
                                resNames.add(responseLabel);
                            } else {
                                errors.add("Error found at row \"" + (k + 1) + "\" in items worksheet. ResponseLabel \"" + responseLabel + "\" for ResponseType \"" + responseType + "\" has been used for another ResponseType.  ");
                                htmlErrors.put(j + "," + k + ",14", "INVALID FIELD");
                            }
                            resPairs.add(responseLabel.toString().toLowerCase() + "_" + responseType.toString().toLowerCase());
                        }
                        parentItemString = "0";
                        if (!StringUtil.isBlank((String)parentItem)) {
                            parentItemString = dbName.equals("oracle") != false ? "(SELECT MAX(ITEM_ID) FROM ITEM WHERE NAME='" + this.stripQuotes(parentItem) + "' AND owner_id = " + ownerId + " )" : "(SELECT ITEM_ID FROM ITEM WHERE NAME='" + this.stripQuotes(parentItem) + "' AND owner_id = " + ownerId + " ORDER BY OC_OID DESC LIMIT 1)";
                        }
                        selectCorrectItemQueryPostgres = " (SELECT I.ITEM_ID FROM ITEM I LEFT OUTER JOIN ITEM_FORM_METADATA IFM ON I.ITEM_Id = IFM.ITEM_ID LEFT OUTER JOIN CRF_VERSION CV ON IFM.CRF_VERSION_ID = CV.CRF_VERSION_ID  WHERE  ( I.NAME='" + itemName + "' AND I.owner_id = " + ownerId + " AND CV.CRF_VERSION_ID is null ) OR  ( I.NAME='" + itemName + "' AND I.owner_id = " + ownerId + " AND CV.CRF_VERSION_ID is not null AND CV.CRF_ID =" + this.crfId + " )  ORDER BY I.OC_OID DESC LIMIT 1) ";
                        selectCorrectItemQueryOracle = " (SELECT MAX(I.ITEM_ID) FROM ITEM I LEFT OUTER JOIN ITEM_FORM_METADATA IFM ON I.ITEM_Id = IFM.ITEM_ID LEFT OUTER JOIN CRF_VERSION CV ON IFM.CRF_VERSION_ID = CV.CRF_VERSION_ID  WHERE  ( I.NAME='" + itemName + "' AND I.owner_id = " + ownerId + " AND CV.CRF_VERSION_ID is null ) OR  ( I.NAME='" + itemName + "' AND I.owner_id = " + ownerId + " AND CV.CRF_VERSION_ID is not null AND CV.CRF_ID =" + this.crfId + " )) ";
                        sql2 = "";
                        if (dbName.equals("oracle")) {
                            sql2 = "INSERT INTO ITEM_FORM_METADATA (CRF_VERSION_ID, RESPONSE_SET_ID,ITEM_ID,SUBHEADER,HEADER,LEFT_ITEM_TEXT,RIGHT_ITEM_TEXT,PARENT_ID,SECTION_ID,ORDINAL,PARENT_LABEL,COLUMN_NUMBER,PAGE_NUMBER_LABEL,question_number_label,REGEXP,REGEXP_ERROR_MSG,REQUIRED,DEFAULT_VALUE,RESPONSE_LAYOUT,WIDTH_DECIMAL, show_item) VALUES (" + this.versionIdString + ",(SELECT RESPONSE_SET_ID FROM RESPONSE_SET WHERE LABEL='" + this.stripQuotes(responseLabel) + "' AND VERSION_ID=" + this.versionIdString + ")," + selectCorrectItemQueryOracle + ",'" + this.stripQuotes(subHeader) + "','" + this.stripQuotes(header) + "','" + this.stripQuotes(leftItemText) + "','" + this.stripQuotes(rightItemText) + "'," + parentItemString + ", (SELECT SECTION_ID FROM SECTION WHERE LABEL='" + secName + "' AND CRF_VERSION_ID IN " + this.versionIdString + "), " + k + ",'" + parentItem + "'," + columnNum + ",'" + this.stripQuotes(page) + "','" + this.stripQuotes(questionNum) + "','" + this.stripQuotes(regexp1) + "','" + this.stripQuotes(regexpError) + "', " + (isRequired != false ? 1 : 0) + ", '" + this.stripQuotes(default_value) + "','" + this.stripQuotes(responseLayout) + "','" + widthDecimal + "', " + (isShowItem != false ? 1 : 0) + ")";
                            this.logger.debug(sql2);
                        } else {
                            sql2 = "INSERT INTO ITEM_FORM_METADATA (CRF_VERSION_ID, RESPONSE_SET_ID,ITEM_ID,SUBHEADER,HEADER,LEFT_ITEM_TEXT,RIGHT_ITEM_TEXT,PARENT_ID,SECTION_ID,ORDINAL,PARENT_LABEL,COLUMN_NUMBER,PAGE_NUMBER_LABEL,question_number_label,REGEXP,REGEXP_ERROR_MSG,REQUIRED,DEFAULT_VALUE,RESPONSE_LAYOUT,WIDTH_DECIMAL, show_item) VALUES (" + this.versionIdString + ",(SELECT RESPONSE_SET_ID FROM RESPONSE_SET WHERE LABEL='" + this.stripQuotes(responseLabel) + "' AND VERSION_ID=" + this.versionIdString + ")," + selectCorrectItemQueryPostgres + ",'" + this.stripQuotes(subHeader) + "','" + this.stripQuotes(header) + "','" + this.stripQuotes(leftItemText) + "','" + this.stripQuotes(rightItemText) + "'," + parentItemString + ", (SELECT SECTION_ID FROM SECTION WHERE LABEL='" + secName + "' AND CRF_VERSION_ID IN " + this.versionIdString + "), " + k + ",'" + parentItem + "'," + columnNum + ",'" + this.stripQuotes(page) + "','" + this.stripQuotes(questionNum) + "','" + this.stripQuotes(regexp1) + "','" + this.stripQuotes(regexpError) + "', " + isRequired + ", '" + this.stripQuotes(default_value) + "','" + this.stripQuotes(responseLayout) + "','" + widthDecimal + "'," + isShowItem + ")";
                        }
                        queries.add(sql2);
                        sql3 = "";
                        sql3 = dbName.equals("oracle") != false ? "INSERT INTO VERSIONING_MAP (CRF_VERSION_ID, ITEM_ID) VALUES ( " + this.versionIdString + "," + selectCorrectItemQueryOracle + ")" : "INSERT INTO VERSIONING_MAP (CRF_VERSION_ID, ITEM_ID) VALUES ( " + this.versionIdString + "," + selectCorrectItemQueryPostgres + ")";
                        queries.add(sql3);
                        sql2_1 = "";
                        if (display.length() > 0) {
                            if (controlItemName.length() > 0 && optionValue.length() > 0 && message.length() > 0) {
                                sql2_1 = dbName.equals("oracle") != false ? "insert into scd_item_metadata (scd_item_form_metadata_id,control_item_form_metadata_id,control_item_name,option_value,message) values((select max(ifm.item_form_metadata_id) from item_form_metadata ifm where ifm.item_id=" + selectCorrectItemQueryOracle + "and ifm.show_item=0 ),(select cifm.item_form_metadata_id from item, item_form_metadata cifm where cifm.crf_version_id = " + this.versionIdString + " and item.item_id = (select it.item_id from item it, versioning_map vm where it.name = '" + controlItemName + "' and vm.crf_version_id = " + this.versionIdString + " and vm.item_id = it.item_id) and cifm.item_id = item.item_id), '" + controlItemName + "', '" + this.stripQuotes(optionValue) + "', '" + this.stripQuotes(message) + "')" : "insert into scd_item_metadata (scd_item_form_metadata_id,control_item_form_metadata_id,control_item_name,option_value,message) values((select max(ifm.item_form_metadata_id) from item_form_metadata ifm where ifm.item_id=" + selectCorrectItemQueryPostgres + "and ifm.show_item=false ),(select cifm.item_form_metadata_id from item, item_form_metadata cifm where cifm.crf_version_id = " + this.versionIdString + " and item.item_id = (select it.item_id from item it, versioning_map vm where it.name = '" + controlItemName + "' and vm.crf_version_id = " + this.versionIdString + " and vm.item_id = it.item_id) and cifm.item_id = item.item_id), '" + controlItemName + "', '" + this.stripQuotes(optionValue) + "', '" + this.stripQuotes(message) + "')";
                                queries.add(sql2_1);
                            } else {
                                this.logger.debug("No insert into scd_item_metadata for item name = " + itemName + "with Simple_Conditional_Display = \"" + display + "\".");
                            }
                        }
                        if (!StringUtil.isBlank((String)groupLabel)) {
                            igMeta = new ItemGroupMetadataBean();
                            itemGroup = new ItemGroupBean();
                            try {
                                this.logger.debug("found " + groupLabel);
                                itemGroup = (ItemGroupBean)this.itemGroups.get(groupLabel);
                                this.logger.debug("*** Found " + groupLabel + " and matched with " + itemGroup.getName());
                                igMeta = itemGroup.getMeta();
                                if (igMeta == null) {
                                    igMeta = new ItemGroupMetadataBean();
                                }
                                sqlGroupLabel = "";
                                sqlGroupLabel = dbName.equals("oracle") != false ? "INSERT INTO ITEM_GROUP_METADATA (item_group_id,HEADER,subheader, layout, repeat_number, repeat_max, repeat_array,row_start_number, crf_version_id,item_id , ordinal, show_group, repeating_group) VALUES ((SELECT MAX(ITEM_GROUP_ID) FROM ITEM_GROUP WHERE NAME='" + this.stripQuotes(itemGroup.getName()) + "' AND crf_id = " + this.crfId + " ),'" + this.stripQuotes(igMeta.getHeader()) + "', '" + this.stripQuotes(igMeta.getSubheader()) + "', '" + igMeta.getLayout() + "', " + igMeta.getRepeatNum() + ", " + igMeta.getRepeatMax() + ", '" + igMeta.getRepeatArray() + "', " + igMeta.getRowStartNumber() + "," + this.versionIdString + ",(SELECT MAX(ITEM.ITEM_ID) FROM ITEM,ITEM_FORM_METADATA,CRF_VERSION WHERE ITEM.NAME='" + this.stripQuotes(itemName) + "' AND ITEM.ITEM_ID = ITEM_FORM_METADATA.ITEM_ID and ITEM_FORM_METADATA.CRF_VERSION_ID=CRF_VERSION.CRF_VERSION_ID AND CRF_VERSION.CRF_ID= " + this.crfId + " )," + k + ", " + (igMeta.isShowGroup() != false ? 1 : 0) + ", " + (igMeta.isRepeatingGroup() != false ? 1 : 0) + ")" : "INSERT INTO ITEM_GROUP_METADATA (item_group_id,header,subheader, layout, repeat_number, repeat_max, repeat_array,row_start_number, crf_version_id,item_id , ordinal, show_group, repeating_group) VALUES ((SELECT ITEM_GROUP_ID FROM ITEM_GROUP WHERE NAME='" + itemGroup.getName() + "' AND crf_id = " + this.crfId + " LIMIT 1),E'" + igMeta.getHeader() + "', E'" + igMeta.getSubheader() + "', '" + igMeta.getLayout() + "', " + igMeta.getRepeatNum() + ", " + igMeta.getRepeatMax() + ", '" + igMeta.getRepeatArray() + "', " + igMeta.getRowStartNumber() + "," + this.versionIdString + ",(SELECT ITEM.ITEM_ID FROM ITEM,ITEM_FORM_METADATA,CRF_VERSION WHERE ITEM.NAME='" + itemName + "' AND ITEM.ITEM_ID = ITEM_FORM_METADATA.ITEM_ID and ITEM_FORM_METADATA.CRF_VERSION_ID=CRF_VERSION.CRF_VERSION_ID AND CRF_VERSION.CRF_ID= " + this.crfId + " ORDER BY ITEM.OC_OID DESC LIMIT 1)," + k + ", " + igMeta.isShowGroup() + ", " + igMeta.isRepeatingGroup() + ")";
                                queries.add(sqlGroupLabel);
                            }
                            catch (NullPointerException e) {
                                this.logger.error("Error  message", (Throwable)e);
                                errors.add(resPageMsg.getString("Error_found_at_row") + " \"" + (k + 1) + "\"" + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("GROUP_LABEL") + "\"" + groupLabel + "\" " + resPageMsg.getString("does_not_exist_in_group_spreadsheet"));
                                htmlErrors.put(j + "," + k + ",6", resPageMsg.getString("GROUP_DOES_NOT_EXIST"));
                            }
                            continue;
                        }
                        sqlGroupLabel = "";
                        sqlGroupLabel = dbName.equals("oracle") != false ? "INSERT INTO ITEM_GROUP_METADATA (item_group_id,HEADER,subheader, layout, repeat_number, repeat_max, repeat_array,row_start_number, crf_version_id,item_id , ordinal, repeating_group) VALUES ((SELECT MAX(ITEM_GROUP_ID) FROM ITEM_GROUP WHERE NAME='Ungrouped' AND crf_id = " + this.crfId + " ),'', '', '', " + 1 + ", " + 1 + ", '', 1," + this.versionIdString + "," + selectCorrectItemQueryOracle + "," + k + ", 0)" : "INSERT INTO ITEM_GROUP_METADATA (item_group_id,header,subheader, layout, repeat_number, repeat_max, repeat_array,row_start_number, crf_version_id,item_id , ordinal, repeating_group) VALUES ((SELECT ITEM_GROUP_ID FROM ITEM_GROUP WHERE NAME='Ungrouped' AND crf_id = " + this.crfId + "  LIMIT 1),'', '', '', " + 1 + ", " + 1 + ", '', 1," + this.versionIdString + "," + selectCorrectItemQueryPostgres + "," + k + ", false)";
                        queries.add(sqlGroupLabel);
                    }
                    SpreadSheetItemUtil.verifySectionGroupPlacementForItems(row_items, errors, htmlErrors, (int)j, (ResourceBundle)resPageMsg, (HashMap)this.itemGroups);
                    SpreadSheetItemUtil.verifyUniqueItemPlacementInGroups(row_items, errors, htmlErrors, (int)j, (ResourceBundle)resPageMsg, (String)this.crfName, (DataSource)ds);
                    instantValidator.validate();
                    errors = (ArrayList)instantValidator.getSheetErrors().addErrorsToSheet(errors);
                    htmlErrors = (HashMap)instantValidator.getSheetErrors().putHtmlErrorsToSheet(htmlErrors);
                    break block257;
                }
                if (sheetName.equalsIgnoreCase("Groups")) {
                    this.logger.debug("read groups, ***comment added 5.14.07");
                    groupNames = new ArrayList<String>();
                    defaultGroup = new ItemGroupBean();
                    defaultGroup.setName("Ungrouped");
                    defaultGroup.setCrfId(Integer.valueOf(this.crfId));
                    defaultGroup.setStatus(Status.AVAILABLE);
                    defaultGroupOid = itemGroupDao.getValidOid(defaultGroup, this.crfName, defaultGroup.getName(), itemGroupOids);
                    itemGroupOids.add(defaultGroupOid);
                    defaultSql = "";
                    defaultSql = dbName.equals("oracle") != false ? "INSERT INTO ITEM_GROUP ( name, crf_id, status_id, date_created ,owner_id,oc_oid) VALUES ('" + defaultGroup.getName() + "', " + defaultGroup.getCrfId() + "," + defaultGroup.getStatus().getId() + ",sysdate," + this.ub.getId() + ",'" + defaultGroupOid + "')" : "INSERT INTO ITEM_GROUP (  name, crf_id, status_id, date_created ,owner_id,oc_oid) VALUES ('" + defaultGroup.getName() + "', " + defaultGroup.getCrfId() + "," + defaultGroup.getStatus().getId() + ",now()," + this.ub.getId() + ",'" + defaultGroupOid + "')";
                    if (!GroupCheck.containsKey("Ungrouped")) {
                        queries.add(defaultSql);
                    }
                    for (gk = 1; gk < numRows; ++gk) {
                        if (sheet.getRow(gk) == null) {
                            if (++blankRowCount != 5) continue;
                            break;
                        }
                        cell = sheet.getRow(gk).getCell((short)0);
                        groupLabel = this.getValue(cell);
                        if (StringUtil.isBlank((String)(groupLabel = groupLabel.replaceAll("<[^>]*>", "")))) {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_LABEL_column") + resPageMsg.getString("was_blank_at_row") + " " + gk + ", " + resPageMsg.getString("Groups_worksheet") + ".");
                            htmlErrors.put(j + "," + gk + ",0", resPageMsg.getString("required_field"));
                        }
                        if (groupLabel != null && groupLabel.length() > 255) {
                            errors.add(resPageMsg.getString("group_label_length_error"));
                        }
                        if (groupNames.contains(groupLabel)) {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_LABEL_column") + resPageMsg.getString("was_a_duplicate_of") + " " + groupLabel + resPageMsg.getString("at_row") + gk + ", " + resPageMsg.getString("Groups_worksheet") + ".");
                            htmlErrors.put(j + "," + gk + ",0", resPageMsg.getString("DUPLICATE_FIELD"));
                        } else {
                            groupNames.add(groupLabel);
                        }
                        isRepeatingGroup = true;
                        newVersionCrf = false;
                        cellNo = 0;
                        if (!(versionNo.equalsIgnoreCase("Version: 2.2") || versionNo.equalsIgnoreCase("Version: 2.5") || versionNo.equalsIgnoreCase("Version: 3.0"))) {
                            cellNo = 1;
                            cell = sheet.getRow(gk).getCell((short)cellNo);
                            try {
                                isRepeatingGroup = this.getValue(cell).equalsIgnoreCase("grid");
                                newVersionCrf = true;
                            }
                            catch (Exception eee) {
                                errors.add(resPageMsg.getString("repeating_group_error"));
                            }
                        }
                        cell = sheet.getRow(gk).getCell((short)(++cellNo));
                        groupHeader = this.getValue(cell);
                        if ((groupHeader = StringUtil.escapeSingleQuote((String)groupHeader)) != null && groupHeader.length() > 255) {
                            errors.add(resPageMsg.getString("group_header_length_error"));
                        }
                        if (isRepeatingGroup) {
                            sheetContainer.getRepeatingGroupLabels().add(groupLabel);
                        }
                        cell = sheet.getRow(gk).getCell((short)(++cellNo));
                        groupRepeatNumber = this.getValue(cell);
                        if (newVersionCrf && !isRepeatingGroup && !StringUtil.isBlank((String)groupRepeatNumber)) {
                            errors.add(resPageMsg.getString("repeat_number_none_repeating"));
                        } else if (!isRepeatingGroup && StringUtil.isBlank((String)groupRepeatNumber)) {
                            groupRepeatNumber = "1";
                        } else if (StringUtil.isBlank((String)groupRepeatNumber)) {
                            groupRepeatNumber = "1";
                        } else if (cell.getCellType() == 0) {
                            dr = cell.getNumericCellValue();
                            if ((dr - (double)((int)dr)) * 1000.0 == 0.0) {
                                groupRepeatNumber = (int)dr + "";
                            }
                        } else {
                            this.logger.debug("found a non-numeric code in a numeric field: groupRepeatNumber");
                        }
                        cell = sheet.getRow(gk).getCell((short)(++cellNo));
                        groupRepeatMax = this.getValue(cell);
                        if (newVersionCrf && !isRepeatingGroup && !StringUtil.isBlank((String)groupRepeatMax)) {
                            errors.add(resPageMsg.getString("repeat_max_none_repeating"));
                        } else if (!isRepeatingGroup && StringUtil.isBlank((String)groupRepeatMax)) {
                            groupRepeatMax = "1";
                        } else if (StringUtil.isBlank((String)groupRepeatMax)) {
                            groupRepeatMax = "40";
                        } else if (cell.getCellType() == 0) {
                            dr = cell.getNumericCellValue();
                            if ((dr - (double)((int)dr)) * 1000.0 == 0.0) {
                                groupRepeatMax = (int)dr + "";
                                try {
                                    repeatMaxInt = Integer.parseInt(groupRepeatMax);
                                    if (repeatMaxInt < 1) {
                                        groupRepeatMax = "40";
                                    }
                                }
                                catch (NumberFormatException nfe) {
                                    groupRepeatMax = "40";
                                }
                            }
                        } else {
                            this.logger.debug("found a non-numeric code in a numeric field: groupRepeatMax");
                        }
                        cell = sheet.getRow(gk).getCell((short)(++cellNo));
                        showGroup = this.getValue(cell);
                        isShowGroup = true;
                        if (!StringUtil.isBlank((String)showGroup)) {
                            try {
                                isShowGroup = "0".equals(showGroup) == false;
                                isShowGroup = "Hide".equalsIgnoreCase(showGroup) == false;
                            }
                            catch (Exception eee) {
                                this.logger.debug("caught an exception with the boolean value for groups");
                            }
                        }
                        fgb = new ItemGroupBean();
                        fgb.setName(groupLabel);
                        fgb.setCrfId(Integer.valueOf(this.crfId));
                        fgb.setStatus(Status.AVAILABLE);
                        igMeta = new ItemGroupMetadataBean();
                        igMeta.setHeader(groupHeader);
                        igMeta.setRepeatingGroup(isRepeatingGroup);
                        igMeta.setBorders(Integer.valueOf(0));
                        igMeta.setShowGroup(isShowGroup);
                        try {
                            igMeta.setRepeatMax(new Integer(Integer.parseInt(groupRepeatMax)));
                            if (igMeta.getRepeatMax() < 1) {
                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_REPEAT_MAX_column") + " " + resPageMsg.getString("must_be_a_positive_integer") + ". " + groupRepeatMax + " " + resPageMsg.getString("at_row") + " " + gk + ", " + resPageMsg.getString("Groups_worksheet") + ". ");
                                htmlErrors.put(j + "," + gk + ",3", resPageMsg.getString("INVALID_FIELD"));
                            }
                        }
                        catch (NumberFormatException n2) {
                            this.logger.error("Error  message", (Throwable)n2);
                            if ("".equals(groupRepeatMax)) {
                                igMeta.setRepeatMax(Integer.valueOf(40));
                            }
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_REPEAT_MAX_column") + " " + resPageMsg.getString("must_be_a_positive_integer") + ". " + groupRepeatMax + " " + resPageMsg.getString("at_row") + " " + gk + ", " + resPageMsg.getString("Groups_worksheet") + ". ");
                            htmlErrors.put(j + "," + gk + ",3", resPageMsg.getString("INVALID_FIELD"));
                        }
                        try {
                            igMeta.setRepeatNum(new Integer(Integer.parseInt(groupRepeatNumber)));
                            if (igMeta.getRepeatNum() < 1) {
                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_REPEAT_NUM_column") + " " + resPageMsg.getString("must_be_a_positive_integer_or_blank") + ". " + groupRepeatNumber + " " + resPageMsg.getString("at_row") + " " + gk + ", " + resPageMsg.getString("Groups_worksheet") + ". ");
                                htmlErrors.put(j + "," + gk + ",2", resPageMsg.getString("INVALID_FIELD"));
                            }
                        }
                        catch (NumberFormatException n3) {
                            this.logger.error(n3.getMessage());
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_REPEAT_NUM_column") + " " + resPageMsg.getString("must_be_a_positive_integer_or_blank") + ". " + groupRepeatNumber + " " + resPageMsg.getString("at_row") + " " + gk + ", " + resPageMsg.getString("Groups_worksheet") + ". ");
                            htmlErrors.put(j + "," + gk + ",2", resPageMsg.getString("INVALID_FIELD"));
                        }
                        fgb.setMeta(igMeta);
                        groupOid = itemGroupDao.getValidOid(fgb, this.crfName, fgb.getName(), itemGroupOids);
                        itemGroupOids.add(groupOid);
                        gsql = "";
                        gsql = dbName.equals("oracle") != false ? "INSERT INTO ITEM_GROUP ( name, crf_id, status_id, date_created ,owner_id,oc_oid)VALUES ('" + fgb.getName() + "', " + fgb.getCrfId() + "," + fgb.getStatus().getId() + ",sysdate," + this.ub.getId() + ",'" + groupOid + "')" : "INSERT INTO ITEM_GROUP ( name, crf_id, status_id, date_created ,owner_id,oc_oid)VALUES ('" + fgb.getName() + "', " + fgb.getCrfId() + "," + fgb.getStatus().getId() + ",now()," + this.ub.getId() + ",'" + groupOid + "')";
                        this.itemGroups.put(fgb.getName(), fgb);
                        if (GroupCheck.containsKey(fgb.getName())) continue;
                        queries.add(gsql);
                    }
                } else if (sheetName.equalsIgnoreCase("Sections")) {
                    this.logger.debug("read sections");
                    for (k = 1; k < numRows && blankRowCount != 5; ++k) {
                        if (sheet.getRow(k) == null) {
                            ++blankRowCount;
                            continue;
                        }
                        cell = sheet.getRow(k).getCell((short)0);
                        secLabel = this.getValue(cell);
                        if (StringUtil.isBlank((String)(secLabel = secLabel.replaceAll("<[^>]*>", "")))) {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SECTION_LABEL_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + " , " + resPageMsg.getString("sections_worksheet") + ".");
                            htmlErrors.put(j + "," + k + ",0", resPageMsg.getString("required_field"));
                        }
                        if (secLabel != null && secLabel.length() > 2000) {
                            errors.add(resPageMsg.getString("section_label_length_error"));
                        }
                        if (secNames.contains(secLabel)) {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SECTION_LABEL_column") + resPageMsg.getString("was_a_duplicate_of") + secLabel + " " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("sections_worksheet") + ".");
                            htmlErrors.put(j + "," + k + ",0", resPageMsg.getString("DUPLICATE_FIELD"));
                        }
                        secNames.add(secLabel);
                        cell = sheet.getRow(k).getCell((short)1);
                        title = this.getValue(cell);
                        title = title.replaceAll("<[^>]*>", "");
                        if (StringUtil.isBlank((String)title)) {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SECTION_TITLE_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("sections_worksheet") + ".");
                            htmlErrors.put(j + "," + k + ",1", resPageMsg.getString("required_field"));
                        }
                        if (title != null && title.length() > 2000) {
                            errors.add(resPageMsg.getString("section_title_length_error"));
                        }
                        if ((subtitle = this.getValue(cell = sheet.getRow(k).getCell((short)2))) != null && subtitle.length() > 2000) {
                            errors.add(resPageMsg.getString("section_subtitle_length_error"));
                        }
                        if ((instructions = this.getValue(cell = sheet.getRow(k).getCell((short)3))) != null && instructions.length() > 2000) {
                            errors.add(resPageMsg.getString("section_instruction_length_error"));
                        }
                        if ((pageNumber = this.getValue(cell = sheet.getRow(k).getCell((short)4))) != null && pageNumber.length() > 5) {
                            errors.add(resPageMsg.getString("section_page_number_length_error"));
                        }
                        cell = sheet.getRow(k).getCell((short)5);
                        parentSection = this.getValue(cell);
                        if (!StringUtil.isBlank((String)(parentSection = parentSection.replaceAll("<[^>]*>", "")))) {
                            try {
                                parentId = Integer.parseInt(parentSection);
                            }
                            catch (NumberFormatException ne) {
                                parentId = 0;
                            }
                        }
                        cell = sheet.getRow(k).getCell((short)6);
                        strBorder = this.getValue(cell);
                        strBorder = strBorder.replaceAll("<[^>]*>", "");
                        intBorder = new Integer(0);
                        try {
                            intBorder = new Integer(strBorder);
                        }
                        catch (NumberFormatException groupHeader) {
                            // empty catch block
                        }
                        sql = "";
                        sql = dbName.equals("oracle") != false ? "INSERT INTO SECTION (CRF_VERSION_ID,STATUS_ID,LABEL, TITLE, INSTRUCTIONS, SUBTITLE, PAGE_NUMBER_LABEL,ORDINAL, PARENT_ID, OWNER_ID, DATE_CREATED, BORDERS) VALUES (" + this.versionIdString + ",1,'" + secLabel + "','" + this.stripQuotes(title) + "', '" + this.stripQuotes(instructions) + "', '" + this.stripQuotes(subtitle) + "','" + pageNumber + "'," + k + "," + parentId + "," + this.ub.getId() + ",sysdate," + intBorder + ")" : "INSERT INTO SECTION (CRF_VERSION_ID,STATUS_ID,LABEL, TITLE, INSTRUCTIONS, SUBTITLE, PAGE_NUMBER_LABEL,ORDINAL, PARENT_ID, OWNER_ID, DATE_CREATED,BORDERS) VALUES (" + this.versionIdString + ",1,'" + secLabel + "','" + this.stripQuotes(title) + "', '" + this.stripQuotes(instructions) + "', '" + this.stripQuotes(subtitle) + "','" + pageNumber + "'," + k + "," + parentId + "," + this.ub.getId() + ",NOW()," + intBorder + ")";
                        queries.add(sql);
                    }
                } else if (sheetName.equalsIgnoreCase("CRF")) {
                    this.logger.debug("read crf");
                    if (sheet == null || sheet.getRow(1) == null || sheet.getRow(1).getCell((short)0) == null) {
                        throw new CRFReadingException("Blank row found in sheet CRF.");
                    }
                    cell = sheet.getRow(1).getCell((short)0);
                    this.crfName = this.getValue(cell);
                    this.crfName = this.crfName.replaceAll("<[^>]*>", "");
                    if (StringUtil.isBlank((String)this.crfName)) {
                        throw new CRFReadingException("The CRF_NAME column was blank in the CRF worksheet.");
                    }
                    if (this.crfId > 0 && !(checkName = (CRFBean)cdao.findByPK(this.crfId)).getName().equals(this.crfName)) {
                        throw new CRFReadingException(resPageMsg.getString("the") + " " + resPageMsg.getString("CRF_NAME_column") + " '" + this.crfName + "' " + resPageMsg.getString("did_not_match_crf_name") + " '" + checkName.getName() + "'.");
                    }
                    if (this.crfName.length() > 255) {
                        errors.add(resPageMsg.getString("crf_name_length_error"));
                    }
                    existingCRFWithSameName = (CRFBean)cdao.findByName(this.crfName);
                    if (this.getCrfId() == 0 && existingCRFWithSameName.getName() != null && existingCRFWithSameName.getName().equals(this.crfName)) {
                        errors.add(resPageMsg.getString("crf_name_already_used"));
                    }
                    cell = sheet.getRow(1).getCell((short)1);
                    version = this.getValue(cell);
                    version = version.replaceAll("<[^>]*>", "");
                    ncrf.setVersionName(version);
                    if (version != null && version.length() > 255) {
                        errors.add(resPageMsg.getString("version_length_error"));
                    }
                    cell = sheet.getRow(1).getCell((short)2);
                    versionDesc = this.getValue(cell);
                    if ((versionDesc = versionDesc.replaceAll("<[^>]*>", "")) != null && versionDesc.length() > 4000) {
                        errors.add(resPageMsg.getString("version_description_length_error"));
                    }
                    cell = sheet.getRow(1).getCell((short)3);
                    revisionNotes = this.getValue(cell);
                    if ((revisionNotes = revisionNotes.replaceAll("<[^>]*>", "")) != null && revisionNotes.length() > 255) {
                        errors.add(resPageMsg.getString("revision_notes_length_error"));
                    }
                    if (StringUtil.isBlank((String)revisionNotes)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("REVISION_NOTES_column") + " " + resPageMsg.getString("was_blank_in_the_CRF_worksheet"));
                        htmlErrors.put(j + ",1,3", resPageMsg.getString("required_field"));
                    }
                    con = null;
                    crfOid = null;
                    if (this.crfId == 0) {
                        crfOid = cdao.getValidOid(new CRFBean(), this.crfName);
                        try {
                            con = ds.getConnection();
                            nextIdRs = dbName.equals("oracle") != false ? con.createStatement().executeQuery("select crf_id_seq.nextval from dual") : con.createStatement().executeQuery("select nextval('crf_crf_id_seq')");
                            nextIdRs.next();
                            this.crfId = nextCRFId = nextIdRs.getInt(1);
                            ncrf.setCrfId(this.crfId);
                            createCRFSql = dbName.equals("oracle") != false ? "INSERT INTO CRF (CRF_ID, STATUS_ID, NAME, DESCRIPTION, OWNER_ID, DATE_CREATED, OC_OID, SOURCE_STUDY_ID) VALUES (" + this.crfId + ", 1,'" + this.stripQuotes(this.crfName) + "','" + this.stripQuotes(versionDesc) + "'," + this.ub.getId() + ",sysdate,'" + crfOid + "'," + this.studyId + ")" : "INSERT INTO CRF (CRF_ID, STATUS_ID, NAME, DESCRIPTION, OWNER_ID, DATE_CREATED, OC_OID, SOURCE_STUDY_ID) VALUES (" + this.crfId + ", 1,'" + this.stripQuotes(this.crfName) + "','" + this.stripQuotes(versionDesc) + "'," + this.ub.getId() + ",NOW(),'" + crfOid + "'," + this.studyId + ")";
                            queries.add(createCRFSql);
                        }
                        catch (SQLException e) {
                            this.logger.warn("Exception encountered with query select nextval('crf_crf_id_seq'), Message-" + e.getMessage());
                        }
                        finally {
                            if (con != null) {
                                try {
                                    con.close();
                                }
                                catch (SQLException e) {
                                    this.logger.warn("Connection can't be closed");
                                }
                            }
                        }
                    }
                    checkCRFVersions = ncrf.getCrfVersions();
                    overwrite = false;
                    if (checkCRFVersions.containsKey(version)) {
                        this.logger.debug("found a matching version name..." + version);
                        errors.add(resPageMsg.getString("version_not_unique_cause_confusion"));
                        htmlErrors.put(j + ",1,2", resPageMsg.getString("NOT_UNIQUE"));
                    }
                    if (crfOid != null) {
                        oid = cvdao.getValidOid(new CRFVersionBean(), crfOid, version);
                    } else {
                        crfBean = (CRFBean)cdao.findByName(this.crfName);
                        oid = cvdao.getValidOid(new CRFVersionBean(), crfBean.getOid(), version);
                    }
                    sql = "";
                    sql = dbName.equals("oracle") ? (this.crfId == 0 ? "INSERT INTO CRF_VERSION (NAME, DESCRIPTION, CRF_ID, STATUS_ID,DATE_CREATED,OWNER_ID,REVISION_NOTES,OC_OID) VALUES ('" + this.stripQuotes(version) + "','" + this.stripQuotes(versionDesc) + "',(SELECT CRF_ID FROM CRF C WHERE C.NAME='" + this.crfName + "'),1,sysdate," + this.ub.getId() + ",'" + this.stripQuotes(revisionNotes) + "','" + oid + "')" : "INSERT INTO CRF_VERSION (NAME,DESCRIPTION, CRF_ID, STATUS_ID,DATE_CREATED,OWNER_ID,REVISION_NOTES,OC_OID) VALUES ('" + version + "','" + this.stripQuotes(versionDesc) + "'," + this.crfId + ",1,sysdate," + this.ub.getId() + ",'" + this.stripQuotes(revisionNotes) + "','" + oid + "')") : (this.crfId == 0 ? "INSERT INTO CRF_VERSION (NAME, DESCRIPTION, CRF_ID, STATUS_ID,DATE_CREATED,OWNER_ID,REVISION_NOTES,OC_OID) VALUES ('" + this.stripQuotes(version) + "','" + this.stripQuotes(versionDesc) + "',(SELECT CRF_ID FROM CRF WHERE NAME='" + this.crfName + "'),1,NOW()," + this.ub.getId() + ",'" + this.stripQuotes(revisionNotes) + "','" + oid + "')" : "INSERT INTO CRF_VERSION (NAME,DESCRIPTION, CRF_ID, STATUS_ID,DATE_CREATED,OWNER_ID,REVISION_NOTES,OC_OID) VALUES ('" + version + "','" + this.stripQuotes(versionDesc) + "'," + this.crfId + ",1,NOW()," + this.ub.getId() + ",'" + this.stripQuotes(revisionNotes) + "','" + oid + "')");
                    queries.add(sql);
                    pVersion = version;
                    pVerDesc = versionDesc;
                }
            }
            this.versionIdString = "(SELECT CRF_VERSION_ID FROM CRF_VERSION WHERE NAME ='" + pVersion + "' AND CRF_ID=" + this.crfId + ")";
            buf.append(sheetName + "<br>");
            buf.append("<div class=\"box_T\"><div class=\"box_L\"><div class=\"box_R\"><div class=\"box_B\"><div class=\"box_TL\"><div class=\"box_TR\"><div class=\"box_BL\"><div class=\"box_BR\">");
            buf.append("<div class=\"textbox_center\">");
            buf.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"");
            buf.append("caption=\"" + wb.getSheetName(j) + "\">");
            for (i = 0; i < numRows; ++i) {
                buf.append("<tr>");
                if (sheet.getRow(i) == null) continue;
                numCells = sheet.getRow(i).getLastCellNum();
                block57: for (y = 0; y < numCells; ++y) {
                    cell = sheet.getRow(i).getCell((short)y);
                    cellType = 0;
                    error = "&nbsp;";
                    errorKey = j + "," + i + "," + y;
                    if (htmlErrors.containsKey(errorKey)) {
                        error = "<span class=\"alert\">" + htmlErrors.get(errorKey) + "</span>";
                    }
                    cellType = cell == null ? 3 : cell.getCellType();
                    switch (cellType) {
                        case 3: {
                            buf.append("<td class=\"table_cell\">" + error + "</td>");
                            continue block57;
                        }
                        case 0: {
                            buf.append("<td class=\"table_cell\">" + cell.getNumericCellValue() + " " + error + "</td>");
                            continue block57;
                        }
                        case 1: {
                            buf.append("<td class=\"table_cell\">" + cell.getStringCellValue() + " " + error + "</td>");
                            continue block57;
                        }
                        default: {
                            buf.append("<td class=\"table_cell\">" + error + "</td>");
                        }
                    }
                }
                buf.append("</tr>");
            }
            buf.append("</table>");
            buf.append("<br></div>");
            buf.append("</div></div></div></div></div></div></div></div>");
            buf.append("</div><br>");
        }
        ncrf.setQueries(queries);
        ncrf.setItemQueries(openQueries);
        ncrf.setBackupItemQueries(backupItemQueries);
        ncrf.setItems(items);
        if (!errors.isEmpty()) {
            ncrf.setErrors(errors);
        }
        ncrf.setHtmlTable(buf.toString());
        return ncrf;
    }

    public String stripQuotes(String subj) {
        if (subj == null) {
            return null;
        }
        String returnme = "";
        String[] subjarray = subj.split("'");
        if (subjarray.length == 1) {
            returnme = subjarray[0];
        } else {
            for (int i = 0; i < subjarray.length - 1; ++i) {
                returnme = returnme + subjarray[i];
                returnme = returnme + "''";
            }
            returnme = returnme + subjarray[subjarray.length - 1];
        }
        return returnme;
    }

    public String getValue(HSSFCell cell) {
        String val = null;
        int cellType = 0;
        cellType = cell == null ? 3 : cell.getCellType();
        switch (cellType) {
            case 3: {
                val = "";
                break;
            }
            case 0: {
                val = cell.getNumericCellValue() + "";
                double dphi = cell.getNumericCellValue();
                if ((dphi - (double)((int)dphi)) * 1000.0 != 0.0) break;
                val = (int)dphi + "";
                break;
            }
            case 1: {
                val = cell.getStringCellValue();
                if (!val.matches("'")) break;
                val.replaceAll("'", "''");
                break;
            }
            case 4: {
                boolean val2 = cell.getBooleanCellValue();
                val = val2 ? "true" : "false";
            }
            default: {
                val = "";
            }
        }
        return val.trim();
    }

    public String toHTML(int sheetIndex) throws IOException {
        StringBuffer buf = new StringBuffer();
        HSSFWorkbook wb = new HSSFWorkbook(this.fs);
        int numSheets = wb.getNumberOfSheets();
        for (int j = 0; j < numSheets; ++j) {
            HSSFSheet sheet = wb.getSheetAt(j);
            String sheetName = wb.getSheetName(j);
            buf.append(sheetName + "<br>");
            buf.append("<table border=\"2\"");
            buf.append("caption=\"" + wb.getSheetName(sheetIndex) + "\">");
            int numCols = sheet.getPhysicalNumberOfRows();
            for (int i = 0; i < numCols; ++i) {
                buf.append("<tr>");
                if (sheet.getRow(i) == null) continue;
                int numCells = sheet.getRow(i).getLastCellNum();
                block7: for (int y = 0; y < numCells; ++y) {
                    HSSFCell cell = sheet.getRow(i).getCell((short)y);
                    int cellType = 0;
                    cellType = cell == null ? 3 : cell.getCellType();
                    switch (cellType) {
                        case 3: {
                            buf.append("<td> </td>");
                            continue block7;
                        }
                        case 0: {
                            buf.append("<td>" + cell.getNumericCellValue() + "</td>");
                            continue block7;
                        }
                        case 1: {
                            buf.append("<td>" + cell.getStringCellValue() + "</td>");
                            continue block7;
                        }
                        default: {
                            buf.append("<td></td>");
                        }
                    }
                }
                buf.append("</tr>");
            }
            buf.append("</table>");
        }
        return buf.toString();
    }

    private String getMUInsertSql(String oid, String measurementUnitName, int ownerId, String dbName) {
        String muSql = "";
        muSql = "insert into measurement_unit (oc_oid, name) values ('" + oid + "', '" + this.stripQuotes(measurementUnitName) + "')";
        return muSql;
    }

    public boolean isRepeating() {
        return this.isRepeating;
    }

    public void setRepeating(boolean isRepeating) {
        this.isRepeating = isRepeating;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public MeasurementUnitDao getMeasurementUnitDao() {
        return this.measurementUnitDao;
    }

    public void setMeasurementUnitDao(MeasurementUnitDao measurementUnitDao) {
        this.measurementUnitDao = measurementUnitDao;
    }
}

