/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.TriggerBean;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.AuditEventDAO;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.service.extract.XsltTriggerService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.AuditEventRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.quartz.JobDataMap;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class ViewSingleJobServlet
extends SecureController {
    private static String TRIGGER_GROUP = "DEFAULT";
    private static String TRIGGER_IMPORT_GROUP = "importTrigger";
    private static String SCHEDULER = "schedulerFactoryBean";
    private static String EXPORT_TRIGGER = "exportTrigger";
    private SchedulerFactoryBean schedulerFactoryBean;
    private StdScheduler scheduler;

    protected void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private StdScheduler getScheduler() {
        this.scheduler = this.scheduler != null ? this.scheduler : (StdScheduler)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(SCHEDULER);
        return this.scheduler;
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String triggerName = fp.getString("tname");
        String gName = fp.getString("gname");
        String groupName = "";
        groupName = gName.equals("") || gName.equals("0") ? XsltTriggerService.TRIGGER_GROUP_NAME : TRIGGER_IMPORT_GROUP;
        this.scheduler = this.getScheduler();
        Trigger trigger = this.scheduler.getTrigger(new TriggerKey(triggerName, groupName));
        if (trigger == null) {
            groupName = XsltTriggerService.TRIGGER_GROUP_NAME;
            trigger = this.scheduler.getTrigger(new TriggerKey(triggerName.trim(), groupName));
        }
        logger.debug("found trigger name: " + triggerName);
        logger.debug("found group name: " + groupName);
        TriggerBean triggerBean = new TriggerBean();
        JobDataMap dataMap = new JobDataMap();
        AuditEventDAO auditEventDAO = new AuditEventDAO(this.sm.getDataSource());
        try {
            triggerBean.setFullName(trigger.getKey().getName());
            triggerBean.setPreviousDate(trigger.getPreviousFireTime());
            triggerBean.setNextDate(trigger.getNextFireTime());
            if (this.scheduler.getTriggerState(new TriggerKey(triggerName, groupName)) == Trigger.TriggerState.PAUSED) {
                triggerBean.setActive(false);
                logger.debug("setting active to false for trigger: " + trigger.getKey().getName());
            } else {
                triggerBean.setActive(true);
                logger.debug("setting active to TRUE for trigger: " + trigger.getKey().getName());
            }
            if (trigger.getDescription() != null) {
                triggerBean.setDescription(trigger.getDescription());
            }
            if (trigger.getJobDataMap().size() > 0) {
                dataMap = trigger.getJobDataMap();
                String contactEmail = dataMap.getString("contactEmail");
                logger.debug("found email: " + contactEmail);
                if (gName.equals("") || gName.equals("0")) {
                    String exportFormat = dataMap.getString("exportFormat");
                    String periodToRun = dataMap.getString("periodToRun");
                    int dsId = dataMap.getInt("dsId");
                    triggerBean.setExportFormat(exportFormat);
                    triggerBean.setPeriodToRun(periodToRun);
                    DatasetDAO datasetDAO = new DatasetDAO(this.sm.getDataSource());
                    DatasetBean dataset = (DatasetBean)datasetDAO.findByPK(dsId);
                    triggerBean.setDataset(dataset);
                }
                int userId = dataMap.getInt("user_id");
                UserAccountDAO userAccountDAO = new UserAccountDAO(this.sm.getDataSource());
                triggerBean.setContactEmail(contactEmail);
                UserAccountBean userAccount = (UserAccountBean)userAccountDAO.findByPK(userId);
                triggerBean.setUserAccount(userAccount);
                ArrayList triggerLogs = auditEventDAO.findAllByAuditTable(trigger.getKey().getName());
                ArrayList allRows = AuditEventRow.generateRowsFromBeans((ArrayList)triggerLogs);
                EntityBeanTable table = fp.getEntityBeanTable();
                String[] columns = new String[]{resword.getString("date_and_time"), resword.getString("action_message"), resword.getString("entity_operation"), resword.getString("changes_and_additions"), resword.getString("actions")};
                table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
                table.setAscendingSort(false);
                table.hideColumnLink(1);
                table.hideColumnLink(3);
                table.hideColumnLink(4);
                table.setQuery("ViewSingleJob?tname=" + triggerName + "&gname=" + gName, new HashMap());
                table.setRows(allRows);
                table.computeDisplay();
                this.request.setAttribute("table", (Object)table);
            }
        }
        catch (NullPointerException e) {
            logger.error(" found NPE ", (Throwable)e);
        }
        this.request.setAttribute("triggerBean", (Object)triggerBean);
        this.request.setAttribute("groupName", (Object)groupName);
        this.forwardPage(Page.VIEW_SINGLE_JOB);
    }
}

