/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyConfigService;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewStudyServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int studyId = fp.getInt("id");
        if (studyId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_study_to_view"));
            this.forwardPage(Page.STUDY_LIST_SERVLET);
        } else {
            if (this.currentStudy.getId() != studyId && this.currentStudy.getParentStudyId() != studyId) {
                this.checkRoleByUserAndStudy(this.ub, studyId, 0);
            }
            String viewFullRecords = fp.getString("viewFull");
            StudyBean study = (StudyBean)sdao.findByPK(studyId);
            StudyConfigService scs = new StudyConfigService(this.sm.getDataSource());
            study = scs.setParametersForStudy(study);
            StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
            String randomizationStatusInOC = spvdao.findByHandleAndStudy(study.getId(), "randomization").getValue();
            String participantStatusInOC = spvdao.findByHandleAndStudy(study.getId(), "participantPortal").getValue();
            if (participantStatusInOC == "") {
                participantStatusInOC = "disabled";
            }
            study.getStudyParameterConfig().setRandomization("disabled");
            ParticipantPortalRegistrar participantPortalRegistrar = new ParticipantPortalRegistrar();
            String pStatus = participantPortalRegistrar.getCachedRegistrationStatus(study.getOid(), this.session);
            if (participantPortalRegistrar != null && pStatus.equalsIgnoreCase("ACTIVE") && participantStatusInOC.equalsIgnoreCase("enabled")) {
                study.getStudyParameterConfig().setParticipantPortal("enabled");
            } else {
                study.getStudyParameterConfig().setParticipantPortal("disabled");
            }
            this.request.setAttribute("studyToView", (Object)study);
            if ("yes".equalsIgnoreCase(viewFullRecords)) {
                UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
                StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
                ArrayList sites = new ArrayList();
                ArrayList userRoles = new ArrayList();
                ArrayList subjects = new ArrayList();
                if (this.currentStudy.getParentStudyId() > 0 && this.currentRole.getRole().getId() > 3) {
                    sites.add(this.currentStudy);
                    userRoles = udao.findAllUsersByStudy(this.currentStudy.getId());
                    subjects = ssdao.findAllByStudy(this.currentStudy);
                } else {
                    sites = (ArrayList)sdao.findAllByParent(studyId);
                    userRoles = udao.findAllUsersByStudy(studyId);
                    subjects = ssdao.findAllByStudy(study);
                }
                StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
                EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
                ArrayList definitions = seddao.findAllByStudy(study);
                for (int i = 0; i < definitions.size(); ++i) {
                    StudyEventDefinitionBean def = (StudyEventDefinitionBean)definitions.get(i);
                    ArrayList crfs = (ArrayList)edcdao.findAllActiveParentsByEventDefinitionId(def.getId());
                    def.setCrfNum(crfs.size());
                }
                String moduleManager = CoreResources.getField((String)"moduleManager");
                this.request.setAttribute("moduleManager", (Object)moduleManager);
                String portalURL = CoreResources.getField((String)"portalURL");
                this.request.setAttribute("portalURL", (Object)portalURL);
                this.request.setAttribute("config", (Object)study);
                this.request.setAttribute("sitesToView", (Object)sites);
                this.request.setAttribute("siteNum", (Object)(sites.size() + ""));
                this.request.setAttribute("userRolesToView", (Object)userRoles);
                this.request.setAttribute("userNum", (Object)(userRoles.size() + ""));
                this.request.setAttribute("definitionsToView", (Object)definitions);
                this.request.setAttribute("defNum", (Object)(definitions.size() + ""));
                this.forwardPage(Page.VIEW_FULL_STUDY);
            } else {
                this.forwardPage(Page.VIEW_STUDY);
            }
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

