/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewSubjectServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.SUBJECT_LIST_SERVLET, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int subjectId = fp.getInt("id");
        if (subjectId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_subject_to_view"));
            this.forwardPage(Page.SUBJECT_LIST_SERVLET);
        } else {
            SubjectBean subject = (SubjectBean)sdao.findByPK(subjectId);
            StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
            ArrayList studySubs = ssdao.findAllBySubjectId(subjectId);
            this.request.setAttribute("subject", (Object)subject);
            this.request.setAttribute("studySubs", (Object)studySubs);
            this.forwardPage(Page.VIEW_SUBJECT);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

