/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.ArchivedDatasetFileBean;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.extract.ArchivedDatasetFileDAO;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class AccessFileServlet
extends SecureController {
    Locale locale;
    private static String WEB_DIR = "/WEB-INF/datasets/";

    public static String getLink(int fId) {
        return "AccessFile?fileId=" + fId;
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int fileId = fp.getInt("fileId");
        ArchivedDatasetFileDAO asdfdao = new ArchivedDatasetFileDAO(this.sm.getDataSource());
        DatasetDAO dsDao = new DatasetDAO(this.sm.getDataSource());
        ArchivedDatasetFileBean asdfBean = (ArchivedDatasetFileBean)asdfdao.findByPK(fileId);
        StudyDAO studyDao = new StudyDAO(this.sm.getDataSource());
        DatasetBean dsBean = (DatasetBean)dsDao.findByPK(asdfBean.getDatasetId());
        int parentId = this.currentStudy.getParentStudyId();
        if (parentId == 0) {
            StudyBean studyBean = (StudyBean)studyDao.findByPK(dsBean.getStudyId());
            parentId = studyBean.getParentStudyId();
        }
        if (parentId != this.currentStudy.getId() && dsBean.getStudyId() != this.currentStudy.getId()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
            throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
        }
        Page finalTarget = Page.EXPORT_DATA_CUSTOM;
        logger.debug("found file reference: " + asdfBean.getFileReference() + " and file name: " + asdfBean.getName());
        if (asdfBean.getFileReference().endsWith(".zip")) {
            this.response.setHeader("Content-disposition", "attachment; filename=\"" + asdfBean.getName() + "\";");
            this.response.setContentType("application/zip");
        } else if (asdfBean.getFileReference().endsWith(".pdf")) {
            this.response.setHeader("Content-disposition", "attachment; filename=\"" + asdfBean.getName() + "\";");
            this.response.setContentType("application/pdf");
        } else if (asdfBean.getFileReference().endsWith(".csv")) {
            this.response.setHeader("Content-disposition", "attachment; filename=\"" + asdfBean.getName() + "\";");
            this.response.setContentType("text/csv");
        } else if (asdfBean.getFileReference().endsWith(".xml")) {
            this.response.setHeader("Content-disposition", "attachment; filename=\"" + asdfBean.getName() + "\";");
            this.response.setContentType("text/xml");
        } else if (asdfBean.getFileReference().endsWith(".html")) {
            this.response.setHeader("Content-disposition", "filename=\"" + asdfBean.getName() + "\";");
            this.response.setContentType("text/html; charset=utf-8");
        }
        finalTarget.setFileName("/WEB-INF/jsp/extract/generatedFileDataset.jsp");
        this.request.setAttribute("generate", (Object)asdfBean.getFileReference());
        this.response.setHeader("Pragma", "public");
        this.forwardPage(finalTarget);
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR) || this.currentRole.getRole().equals((Term)Role.MONITOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }
}

