/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.DatasetRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;

public class RemoveDatasetServlet
extends SecureController {
    Locale locale;

    public static String getLink(int dsId) {
        return "RemoveDataset?dsId=" + dsId;
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int dsId = fp.getInt("dsId");
        DatasetDAO dsDAO = new DatasetDAO(this.sm.getDataSource());
        DatasetBean dataset = (DatasetBean)dsDAO.findByPK(dsId);
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = (StudyBean)sdao.findByPK(dataset.getStudyId());
        this.checkRoleByUserAndStudy(this.ub, study.getParentStudyId(), study.getId());
        if (study.getId() != this.currentStudy.getId() && study.getParentStudyId() != this.currentStudy.getId()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
            this.forwardPage(Page.MENU_SERVLET);
            return;
        }
        if (!this.ub.isSysAdmin() && dataset.getOwnerId() != this.ub.getId()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
            this.forwardPage(Page.MENU_SERVLET);
            return;
        }
        String action = this.request.getParameter("action");
        if (resword.getString("remove_this_dataset").equalsIgnoreCase(action)) {
            dataset.setStatus(Status.DELETED);
            dsDAO.update((EntityBean)dataset);
            this.addPageMessage(respage.getString("dataset_removed"));
            this.request.setAttribute("table", (Object)this.getDatasetTable());
            this.forwardPage(Page.VIEW_DATASETS);
        } else if (resword.getString("cancel").equalsIgnoreCase(action)) {
            this.request.setAttribute("table", (Object)this.getDatasetTable());
            this.forwardPage(Page.VIEW_DATASETS);
        } else {
            this.request.setAttribute("dataset", (Object)dataset);
            this.forwardPage(Page.REMOVE_DATASET);
        }
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private EntityBeanTable getDatasetTable() {
        FormProcessor fp = new FormProcessor(this.request);
        EntityBeanTable table = fp.getEntityBeanTable();
        DatasetDAO dsdao = new DatasetDAO(this.sm.getDataSource());
        ArrayList datasets = new ArrayList();
        datasets = dsdao.findAllByStudyId(this.currentStudy.getId());
        ArrayList datasetRows = DatasetRow.generateRowsFromBeans((ArrayList)datasets);
        String[] columns = new String[]{resword.getString("dataset_name"), resword.getString("description"), resword.getString("created_by"), resword.getString("created_date"), resword.getString("status"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(5);
        table.addLink(resword.getString("show_only_my_datasets"), "ViewDatasets?action=owner&ownerId=" + this.ub.getId());
        table.addLink(resword.getString("create_dataset"), "CreateDataset");
        table.setQuery("ViewDatasets", new HashMap());
        table.setRows(datasetRows);
        table.computeDisplay();
        return table;
    }
}

