/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.login;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.admin.EventStatusStatisticsTableFactory;
import org.akaza.openclinica.control.admin.SiteStatisticsTableFactory;
import org.akaza.openclinica.control.admin.StudyStatisticsTableFactory;
import org.akaza.openclinica.control.admin.StudySubjectStatusStatisticsTableFactory;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.submit.ListStudySubjectTableFactory;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyConfigService;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.table.sdv.SDVUtil;

public class ChangeStudyServlet
extends SecureController {
    Locale locale;
    private StudyEventDefinitionDAO studyEventDefinitionDAO;
    private SubjectDAO subjectDAO;
    private StudySubjectDAO studySubjectDAO;
    private StudyEventDAO studyEventDAO;
    private StudyGroupClassDAO studyGroupClassDAO;
    private SubjectGroupMapDAO subjectGroupMapDAO;
    private StudyDAO studyDAO;
    private EventCRFDAO eventCRFDAO;
    private EventDefinitionCRFDAO eventDefintionCRFDAO;
    private StudyGroupDAO studyGroupDAO;
    private DiscrepancyNoteDAO discrepancyNoteDAO;
    private StudyParameterValueDAO studyParameterValueDAO;

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
    }

    public void processRequest() throws Exception {
        String label;
        String action = this.request.getParameter("action");
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        ArrayList studies = udao.findStudyByUser(this.ub.getName(), (ArrayList)sdao.findAll());
        this.request.setAttribute("siteRoleMap", (Object)Role.siteRoleMap);
        this.request.setAttribute("studyRoleMap", (Object)Role.studyRoleMap);
        if (this.request.getAttribute("label") != null && (label = (String)this.request.getAttribute("label")).length() > 0) {
            this.request.setAttribute("label", (Object)label);
        }
        ArrayList<StudyUserRoleBean> validStudies = new ArrayList<StudyUserRoleBean>();
        for (int i = 0; i < studies.size(); ++i) {
            StudyUserRoleBean sr = (StudyUserRoleBean)studies.get(i);
            StudyBean study = (StudyBean)sdao.findByPK(sr.getStudyId());
            if (study != null && study.getStatus().equals((Term)Status.PENDING)) {
                sr.setStatus(study.getStatus());
            }
            validStudies.add(sr);
        }
        if (StringUtil.isBlank((String)action)) {
            this.request.setAttribute("studies", validStudies);
            this.forwardPage(Page.CHANGE_STUDY);
        } else if ("confirm".equalsIgnoreCase(action)) {
            logger.info("confirm");
            this.confirmChangeStudy(studies);
        } else if ("submit".equalsIgnoreCase(action)) {
            logger.info("submit");
            this.changeStudy();
        }
    }

    private void confirmChangeStudy(ArrayList studies) throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("studyId", 10);
        this.errors = v.validate();
        if (!this.errors.isEmpty()) {
            this.request.setAttribute("studies", (Object)studies);
            this.forwardPage(Page.CHANGE_STUDY);
        } else {
            int studyId = fp.getInt("studyId");
            logger.info("new study id:" + studyId);
            for (int i = 0; i < studies.size(); ++i) {
                StudyUserRoleBean studyWithRole = (StudyUserRoleBean)studies.get(i);
                if (studyWithRole.getStudyId() != studyId) continue;
                this.request.setAttribute("studyId", (Object)new Integer(studyId));
                this.session.setAttribute("studyWithRole", (Object)studyWithRole);
                this.request.setAttribute("currentStudy", (Object)this.currentStudy);
                this.forwardPage(Page.CHANGE_STUDY_CONFIRM);
                return;
            }
            this.addPageMessage(restext.getString("no_study_selected"));
            this.forwardPage(Page.CHANGE_STUDY);
        }
    }

    private void changeStudy() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        int studyId = fp.getInt("studyId");
        int prevStudyId = this.currentStudy.getId();
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean current = (StudyBean)sdao.findByPK(studyId);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        ArrayList studyParameters = spvdao.findParamConfigByStudy(current);
        current.setStudyParameters(studyParameters);
        int parentStudyId = this.currentStudy.getParentStudyId() > 0 ? this.currentStudy.getParentStudyId() : this.currentStudy.getId();
        StudyParameterValueBean parentSPV = spvdao.findByHandleAndStudy(parentStudyId, "subjectIdGeneration");
        current.getStudyParameterConfig().setSubjectIdGeneration(parentSPV.getValue());
        String idSetting = current.getStudyParameterConfig().getSubjectIdGeneration();
        if (idSetting.equals("auto editable") || idSetting.equals("auto non-editable")) {
            int nextLabel = this.getStudySubjectDAO().findTheGreatestLabel() + 1;
            this.request.setAttribute("label", (Object)new Integer(nextLabel).toString());
        }
        StudyConfigService scs = new StudyConfigService(this.sm.getDataSource());
        if (current.getParentStudyId() <= 0) {
            scs.setParametersForStudy(current);
        } else {
            if (current.getParentStudyId() > 0) {
                current.setParentStudyName(((StudyBean)sdao.findByPK(current.getParentStudyId())).getName());
            }
            scs.setParametersForSite(current);
        }
        if (current.getStatus().equals((Term)Status.DELETED) || current.getStatus().equals((Term)Status.AUTO_DELETED)) {
            this.session.removeAttribute("studyWithRole");
            this.addPageMessage(restext.getString("study_choosed_removed_restore_first"));
        } else {
            this.session.setAttribute("study", (Object)current);
            this.currentStudy = current;
            UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
            this.ub.setActiveStudyId(current.getId());
            this.ub.setUpdater(this.ub);
            this.ub.setUpdatedDate(new Date());
            udao.update((EntityBean)this.ub);
            if (current.getParentStudyId() > 0) {
                ArrayList roles = Role.toArrayList();
                for (Role role : roles) {
                    switch (role.getId()) {
                        case 2: {
                            role.setDescription("site_Study_Coordinator");
                            break;
                        }
                        case 3: {
                            role.setDescription("site_Study_Director");
                            break;
                        }
                        case 4: {
                            role.setDescription("site_investigator");
                            break;
                        }
                        case 5: {
                            role.setDescription("site_Data_Entry_Person");
                            break;
                        }
                        case 6: {
                            role.setDescription("site_monitor");
                            break;
                        }
                        case 7: {
                            role.setDescription("site_Data_Entry_Person2");
                            break;
                        }
                    }
                }
            } else {
                ArrayList roles = Role.toArrayList();
                for (Role role : roles) {
                    switch (role.getId()) {
                        case 2: {
                            role.setDescription("Study_Coordinator");
                            break;
                        }
                        case 3: {
                            role.setDescription("Study_Director");
                            break;
                        }
                        case 4: {
                            role.setDescription("investigator");
                            break;
                        }
                        case 5: {
                            role.setDescription("Data_Entry_Person");
                            break;
                        }
                        case 6: {
                            role.setDescription("monitor");
                            break;
                        }
                    }
                }
            }
            this.currentRole = (StudyUserRoleBean)this.session.getAttribute("studyWithRole");
            this.session.setAttribute("userRole", (Object)this.currentRole);
            this.session.removeAttribute("studyWithRole");
            this.addPageMessage(restext.getString("current_study_changed_succesfully"));
        }
        this.ub.incNumVisitsToMainMenu();
        if (prevStudyId != studyId) {
            this.session.removeAttribute("eventsForCreateDataset");
            this.session.setAttribute("tableFacadeRestore", (Object)"false");
        }
        this.request.setAttribute("studyJustChanged", (Object)"yes");
        Integer assignedDiscrepancies = this.getDiscrepancyNoteDAO().getViewNotesCountWithFilter(" AND dn.assigned_user_id =" + this.ub.getId() + " AND (dn.resolution_status_id=1 OR dn.resolution_status_id=2 OR dn.resolution_status_id=3)", this.currentStudy);
        this.request.setAttribute("assignedDiscrepancies", (Object)(assignedDiscrepancies == null ? 0 : assignedDiscrepancies));
        if (this.currentRole.isInvestigator() || this.currentRole.isResearchAssistant() || this.currentRole.isResearchAssistant2()) {
            this.setupListStudySubjectTable();
        }
        if (this.currentRole.isMonitor()) {
            this.setupSubjectSDVTable();
        } else if (this.currentRole.isCoordinator() || this.currentRole.isDirector()) {
            if (this.currentStudy.getStatus().isPending()) {
                this.response.sendRedirect(this.request.getContextPath() + Page.MANAGE_STUDY_MODULE.getFileName());
                return;
            }
            this.setupStudySiteStatisticsTable();
            this.setupSubjectEventStatusStatisticsTable();
            this.setupStudySubjectStatusStatisticsTable();
            if (this.currentStudy.getParentStudyId() == 0) {
                this.setupStudyStatisticsTable();
            }
        }
        this.forwardPage(Page.MENU);
    }

    private void setupSubjectSDVTable() {
        this.request.setAttribute("studyId", (Object)this.currentStudy.getId());
        String sdvMatrix = this.getSDVUtil().renderEventCRFTableWithLimit(this.request, this.currentStudy.getId(), "");
        this.request.setAttribute("sdvMatrix", (Object)sdvMatrix);
    }

    private void setupStudySubjectStatusStatisticsTable() {
        StudySubjectStatusStatisticsTableFactory factory = new StudySubjectStatusStatisticsTableFactory();
        factory.setStudySubjectDao(this.getStudySubjectDAO());
        factory.setCurrentStudy(this.currentStudy);
        factory.setStudyDao(this.getStudyDAO());
        String studySubjectStatusStatistics = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("studySubjectStatusStatistics", (Object)studySubjectStatusStatistics);
    }

    private void setupSubjectEventStatusStatisticsTable() {
        EventStatusStatisticsTableFactory factory = new EventStatusStatisticsTableFactory();
        factory.setStudySubjectDao(this.getStudySubjectDAO());
        factory.setCurrentStudy(this.currentStudy);
        factory.setStudyEventDao(this.getStudyEventDAO());
        factory.setStudyDao(this.getStudyDAO());
        String subjectEventStatusStatistics = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("subjectEventStatusStatistics", (Object)subjectEventStatusStatistics);
    }

    private void setupStudySiteStatisticsTable() {
        SiteStatisticsTableFactory factory = new SiteStatisticsTableFactory();
        factory.setStudySubjectDao(this.getStudySubjectDAO());
        factory.setCurrentStudy(this.currentStudy);
        factory.setStudyDao(this.getStudyDAO());
        String studySiteStatistics = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("studySiteStatistics", (Object)studySiteStatistics);
    }

    private void setupStudyStatisticsTable() {
        StudyStatisticsTableFactory factory = new StudyStatisticsTableFactory();
        factory.setStudySubjectDao(this.getStudySubjectDAO());
        factory.setCurrentStudy(this.currentStudy);
        factory.setStudyDao(this.getStudyDAO());
        String studyStatistics = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("studyStatistics", (Object)studyStatistics);
    }

    private void setupListStudySubjectTable() {
        ListStudySubjectTableFactory factory = new ListStudySubjectTableFactory(true);
        factory.setStudyEventDefinitionDao(this.getStudyEventDefinitionDao());
        factory.setSubjectDAO(this.getSubjectDAO());
        factory.setStudySubjectDAO(this.getStudySubjectDAO());
        factory.setStudyEventDAO(this.getStudyEventDAO());
        factory.setStudyBean(this.currentStudy);
        factory.setStudyGroupClassDAO(this.getStudyGroupClassDAO());
        factory.setSubjectGroupMapDAO(this.getSubjectGroupMapDAO());
        factory.setStudyDAO(this.getStudyDAO());
        factory.setCurrentRole(this.currentRole);
        factory.setCurrentUser(this.ub);
        factory.setEventCRFDAO(this.getEventCRFDAO());
        factory.setEventDefintionCRFDAO(this.getEventDefinitionCRFDAO());
        factory.setStudyGroupDAO(this.getStudyGroupDAO());
        factory.setStudyParameterValueDAO(this.getStudyParameterValueDAO());
        String findSubjectsHtml = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("findSubjectsHtml", (Object)findSubjectsHtml);
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDao() {
        this.studyEventDefinitionDAO = this.studyEventDefinitionDAO == null ? new StudyEventDefinitionDAO(this.sm.getDataSource()) : this.studyEventDefinitionDAO;
        return this.studyEventDefinitionDAO;
    }

    public SubjectDAO getSubjectDAO() {
        this.subjectDAO = this.subjectDAO == null ? new SubjectDAO(this.sm.getDataSource()) : this.subjectDAO;
        return this.subjectDAO;
    }

    public StudySubjectDAO getStudySubjectDAO() {
        this.studySubjectDAO = this.studySubjectDAO == null ? new StudySubjectDAO(this.sm.getDataSource()) : this.studySubjectDAO;
        return this.studySubjectDAO;
    }

    public StudyGroupClassDAO getStudyGroupClassDAO() {
        this.studyGroupClassDAO = this.studyGroupClassDAO == null ? new StudyGroupClassDAO(this.sm.getDataSource()) : this.studyGroupClassDAO;
        return this.studyGroupClassDAO;
    }

    public SubjectGroupMapDAO getSubjectGroupMapDAO() {
        this.subjectGroupMapDAO = this.subjectGroupMapDAO == null ? new SubjectGroupMapDAO(this.sm.getDataSource()) : this.subjectGroupMapDAO;
        return this.subjectGroupMapDAO;
    }

    public StudyEventDAO getStudyEventDAO() {
        this.studyEventDAO = this.studyEventDAO == null ? new StudyEventDAO(this.sm.getDataSource()) : this.studyEventDAO;
        return this.studyEventDAO;
    }

    public StudyDAO getStudyDAO() {
        this.studyDAO = this.studyDAO == null ? new StudyDAO(this.sm.getDataSource()) : this.studyDAO;
        return this.studyDAO;
    }

    public EventCRFDAO getEventCRFDAO() {
        this.eventCRFDAO = this.eventCRFDAO == null ? new EventCRFDAO(this.sm.getDataSource()) : this.eventCRFDAO;
        return this.eventCRFDAO;
    }

    public EventDefinitionCRFDAO getEventDefinitionCRFDAO() {
        this.eventDefintionCRFDAO = this.eventDefintionCRFDAO == null ? new EventDefinitionCRFDAO(this.sm.getDataSource()) : this.eventDefintionCRFDAO;
        return this.eventDefintionCRFDAO;
    }

    public StudyGroupDAO getStudyGroupDAO() {
        this.studyGroupDAO = this.studyGroupDAO == null ? new StudyGroupDAO(this.sm.getDataSource()) : this.studyGroupDAO;
        return this.studyGroupDAO;
    }

    public DiscrepancyNoteDAO getDiscrepancyNoteDAO() {
        this.discrepancyNoteDAO = this.discrepancyNoteDAO == null ? new DiscrepancyNoteDAO(this.sm.getDataSource()) : this.discrepancyNoteDAO;
        return this.discrepancyNoteDAO;
    }

    public SDVUtil getSDVUtil() {
        return (SDVUtil)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("sdvUtil");
    }

    public StudyParameterValueDAO getStudyParameterValueDAO() {
        this.studyParameterValueDAO = this.studyParameterValueDAO == null ? new StudyParameterValueDAO(this.sm.getDataSource()) : this.studyParameterValueDAO;
        return this.studyParameterValueDAO;
    }

    public void setStudyParameterValueDAO(StudyParameterValueDAO studyParameterValueDAO) {
        this.studyParameterValueDAO = studyParameterValueDAO;
    }
}

