/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.login;

import java.util.ArrayList;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.TermType;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RequestStudyServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        ArrayList studies = sdao.findAllByStatus(Status.AVAILABLE);
        ArrayList roles = Role.toArrayList();
        roles.remove(Role.ADMIN);
        this.request.setAttribute("roles", (Object)roles);
        this.request.setAttribute("studies", (Object)studies);
        if (StringUtil.isBlank((String)action)) {
            this.request.setAttribute("newRole", (Object)new StudyUserRoleBean());
            this.forwardPage(Page.REQUEST_STUDY);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.confirm();
        } else if ("submit".equalsIgnoreCase(action)) {
            this.submit();
        } else {
            logger.info("here...");
            this.forwardPage(Page.REQUEST_STUDY);
        }
    }

    private void confirm() throws Exception {
        Validator v = new Validator(this.request);
        v.addValidation("studyId", 10);
        v.addValidation("studyRoleId", 17, TermType.ROLE);
        HashMap errors = v.validate();
        FormProcessor fp = new FormProcessor(this.request);
        StudyUserRoleBean newRole = new StudyUserRoleBean();
        if (fp.getInt("studyRoleId") > 0) {
            newRole.setRole(Role.get((int)fp.getInt("studyRoleId")));
        }
        newRole.setStudyId(fp.getInt("studyId"));
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean studyRequested = (StudyBean)sdao.findByPK(newRole.getStudyId());
        newRole.setStudyName(studyRequested.getName());
        this.session.setAttribute("newRole", (Object)newRole);
        if (!errors.isEmpty()) {
            logger.info("after processing form,error is not empty");
            this.request.setAttribute("formMessages", (Object)errors);
            this.forwardPage(Page.REQUEST_STUDY);
        } else {
            logger.info("after processing form,no errors");
            this.forwardPage(Page.REQUEST_STUDY_CONFIRM);
        }
    }

    private void submit() throws Exception {
        StudyUserRoleBean newRole = (StudyUserRoleBean)this.session.getAttribute("newRole");
        logger.info("Sending email...");
        StringBuffer email = new StringBuffer(restext.getString("dear_openclinica_administrator") + ", <br>");
        email.append(this.ub.getFirstName() + restext.getString("request_to_acces_the_following_study") + ": <br>");
        email.append(resword.getString("user_full_name") + ": " + this.ub.getFirstName() + " " + this.ub.getLastName());
        email.append("<br>" + resword.getString("username2") + ": " + this.ub.getName());
        email.append("<br>" + resword.getString("email") + ": " + this.ub.getEmail());
        email.append("<br>" + resword.getString("study_requested") + ":" + newRole.getStudyName() + ", id:" + newRole.getStudyId());
        email.append("<br>" + resword.getString("user_role_requested") + ": " + newRole.getRole().getDescription());
        String emailBody = email.toString();
        logger.info("Sending email...begin" + emailBody);
        this.sendEmail(EmailEngine.getAdminEmail(), this.ub.getEmail().trim(), "request study access", emailBody, Boolean.valueOf(false));
        this.session.removeAttribute("newRole");
        this.forwardPage(Page.MENU);
    }
}

