/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.domain.SourceDataVerification;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.CRFRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;

public class AddCRFToDefinitionServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_permission_to_update_study_event_definition") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        Integer pageNumber;
        int i;
        String actionName = this.request.getParameter("actionName");
        String submit = this.request.getParameter("Submit");
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        ArrayList crfs = (ArrayList)cdao.findAllByStatus(Status.AVAILABLE);
        ArrayList edcs = (ArrayList)this.session.getAttribute("eventDefinitionCRFs");
        if (edcs == null) {
            edcs = new ArrayList();
        }
        HashMap<Integer, EventDefinitionCRFBean> crfIds = new HashMap<Integer, EventDefinitionCRFBean>();
        for (i = 0; i < edcs.size(); ++i) {
            EventDefinitionCRFBean edc = (EventDefinitionCRFBean)edcs.get(i);
            Integer crfId = new Integer(edc.getCrfId());
            crfIds.put(crfId, edc);
        }
        for (i = 0; i < crfs.size(); ++i) {
            CRFBean crf = (CRFBean)crfs.get(i);
            if (!crfIds.containsKey(new Integer(crf.getId()))) continue;
            crf.setSelected(true);
        }
        this.session.setAttribute("crfsWithVersion", (Object)crfs);
        if (submit != null) {
            this.addCRF();
        } else if (StringUtil.isBlank((String)actionName)) {
            FormProcessor fp = new FormProcessor(this.request);
            EntityBeanTable table = fp.getEntityBeanTable();
            ArrayList allRows = CRFRow.generateRowsFromBeans((ArrayList)crfs);
            String[] columns = new String[]{resword.getString("CRF_name"), resword.getString("date_created"), resword.getString("owner"), resword.getString("date_updated"), resword.getString("last_updated_by"), resword.getString("selected")};
            table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
            table.hideColumnLink(5);
            table.setQuery("AddCRFToDefinition", new HashMap());
            table.setRows(allRows);
            table.computeDisplay();
            this.request.setAttribute("table", (Object)table);
            this.forwardPage(Page.UPDATE_EVENT_DEFINITION2);
        } else if (actionName.equalsIgnoreCase("next") && (pageNumber = Integer.valueOf(this.request.getParameter("pageNum"))) != null) {
            if (pageNumber == 2) {
                String nextListPage = this.request.getParameter("next_list_page");
                if (nextListPage != null && nextListPage.equalsIgnoreCase("true")) {
                    this.confirmDefinition();
                }
            } else {
                this.confirmDefinition();
            }
        }
    }

    private void confirmDefinition() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        HashMap<Integer, String> tmpCRFIdMap = (HashMap<Integer, String>)this.session.getAttribute("tmpCRFIdMap");
        if (tmpCRFIdMap == null) {
            tmpCRFIdMap = new HashMap<Integer, String>();
        }
        ArrayList crfsWithVersion = (ArrayList)this.session.getAttribute("crfsWithVersion");
        for (int i = 0; i < crfsWithVersion.size(); ++i) {
            int id = fp.getInt("id" + i);
            String name = fp.getString("name" + i);
            String selected = fp.getString("selected" + i);
            if (!StringUtil.isBlank((String)selected) && "yes".equalsIgnoreCase(selected.trim())) {
                tmpCRFIdMap.put(id, name);
                continue;
            }
            if (!tmpCRFIdMap.containsKey(id)) continue;
            tmpCRFIdMap.remove(id);
        }
        this.session.setAttribute("tmpCRFIdMap", tmpCRFIdMap);
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList allRows = CRFRow.generateRowsFromBeans((ArrayList)crfsWithVersion);
        String[] columns = new String[]{resword.getString("CRF_name"), resword.getString("date_created"), resword.getString("owner"), resword.getString("date_updated"), resword.getString("last_updated_by"), resword.getString("selected")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(5);
        StudyEventDefinitionBean def1 = (StudyEventDefinitionBean)this.session.getAttribute("definition");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("actionName", "next");
        args.put("pageNum", "1");
        args.put("name", def1.getName());
        args.put("repeating", new Boolean(def1.isRepeating()).toString());
        args.put("category", def1.getCategory());
        args.put("description", def1.getDescription());
        args.put("type", def1.getType());
        table.setQuery("AddCRFToDefinition", args);
        table.setRows(allRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        this.forwardPage(Page.UPDATE_EVENT_DEFINITION2);
    }

    private void addCRF() throws Exception {
        String participateFormStatus;
        ArrayList versions;
        CRFBean cb;
        String name;
        int id;
        FormProcessor fp = new FormProcessor(this.request);
        CRFVersionDAO vdao = new CRFVersionDAO(this.sm.getDataSource());
        ArrayList<CRFBean> crfArray = new ArrayList<CRFBean>();
        HashMap tmpCRFIdMap = (HashMap)this.session.getAttribute("tmpCRFIdMap");
        if (tmpCRFIdMap == null) {
            tmpCRFIdMap = new HashMap();
        }
        ArrayList crfsWithVersion = (ArrayList)this.session.getAttribute("crfsWithVersion");
        for (int i = 0; i < crfsWithVersion.size(); ++i) {
            id = fp.getInt("id" + i);
            name = fp.getString("name" + i);
            String selected = fp.getString("selected" + i);
            if (!StringUtil.isBlank((String)selected) && "yes".equalsIgnoreCase(selected.trim())) {
                logger.info("one crf selected");
                cb = new CRFBean();
                cb.setId(id);
                cb.setName(name);
                versions = (ArrayList)vdao.findAllActiveByCRF(cb.getId());
                cb.setVersions(versions);
                crfArray.add(cb);
                continue;
            }
            if (!tmpCRFIdMap.containsKey(id)) continue;
            tmpCRFIdMap.remove(id);
        }
        Iterator tmpCRFIterator = tmpCRFIdMap.keySet().iterator();
        while (tmpCRFIterator.hasNext()) {
            id = (Integer)tmpCRFIterator.next();
            name = (String)tmpCRFIdMap.get(id);
            boolean isExists = false;
            for (CRFBean cb2 : crfArray) {
                if (id != cb2.getId()) continue;
                isExists = true;
            }
            if (isExists) continue;
            cb = new CRFBean();
            cb.setId(id);
            cb.setName(name);
            versions = (ArrayList)vdao.findAllActiveByCRF(cb.getId());
            cb.setVersions(versions);
            crfArray.add(cb);
        }
        this.session.removeAttribute("tmpCRFIdMap");
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        if (crfArray.size() == 0) {
            this.addPageMessage(respage.getString("no_new_CRF_added"));
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)this.session.getAttribute("definition");
            participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            sed.setCrfs(new ArrayList());
            this.session.setAttribute("definition", (Object)sed);
            this.forwardPage(Page.UPDATE_EVENT_DEFINITION1);
        } else {
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)this.session.getAttribute("definition");
            participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            if (participateFormStatus.equals("enabled")) {
                this.baseUrl();
            }
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            ArrayList edcs = (ArrayList)this.session.getAttribute("eventDefinitionCRFs");
            int ordinalForNewCRF = edcs.size();
            for (int i = 0; i < crfArray.size(); ++i) {
                CRFBean crf = (CRFBean)crfArray.get(i);
                EventDefinitionCRFBean edcBean = new EventDefinitionCRFBean();
                edcBean.setCrfId(crf.getId());
                edcBean.setCrfName(crf.getName());
                edcBean.setStudyId(this.ub.getActiveStudyId());
                edcBean.setStatus(Status.AVAILABLE);
                edcBean.setStudyEventDefinitionId(sed.getId());
                edcBean.setStudyId(this.ub.getActiveStudyId());
                edcBean.setSourceDataVerification(SourceDataVerification.NOTREQUIRED);
                edcBean.setOrdinal(++ordinalForNewCRF);
                edcBean.setVersions(crf.getVersions());
                CRFVersionBean defaultVersion1 = (CRFVersionBean)vdao.findByPK(edcBean.getDefaultVersionId());
                edcBean.setDefaultVersionName(defaultVersion1.getName());
                ++ordinalForNewCRF;
                edcs.add(edcBean);
            }
            this.session.setAttribute("eventDefinitionCRFs", (Object)edcs);
            ArrayList<String> sdvOptions = new ArrayList<String>();
            sdvOptions.add(SourceDataVerification.AllREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.PARTIALREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.NOTREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.NOTAPPLICABLE.toString());
            this.request.setAttribute("sdvOptions", sdvOptions);
            this.addPageMessage(respage.getString("has_have_been_added_need_confirmation"));
            this.forwardPage(Page.UPDATE_EVENT_DEFINITION1);
        }
    }
}

