/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.ChangeOrdinalServlet;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;

public class ChangeDefinitionCRFOrdinalServlet
extends ChangeOrdinalServlet {
    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int current = fp.getInt("current");
        int previous = fp.getInt("previous");
        int currOrdinal = fp.getInt("currentOrdinal");
        int prevOrdinal = fp.getInt("previousOrdinal");
        int definitionId = fp.getInt("id");
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        this.increase(current, previous, currOrdinal, prevOrdinal, definitionId, edcdao);
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        int siteId = fp.getInt("siteId");
        if (siteId > 0) {
            this.request.setAttribute("idToSort", (Object)new Integer(definitionId).toString());
            this.request.setAttribute("siteId", (Object)siteId);
            this.forwardPage(Page.VIEW_SITE_SERVLET);
        } else {
            this.request.setAttribute("id", (Object)new Integer(definitionId).toString());
            this.forwardPage(Page.VIEW_EVENT_DEFINITION_SERVLET);
        }
    }

    private void increase(int idCurrent, int idPrevious, int currOrdinal, int prevOrdinal, int defId, EventDefinitionCRFDAO dao) {
        EventDefinitionCRFBean current = (EventDefinitionCRFBean)dao.findByPK(idCurrent);
        EventDefinitionCRFBean previous = (EventDefinitionCRFBean)dao.findByPK(idPrevious);
        if (current.getOrdinal() == currOrdinal && previous.getOrdinal() == prevOrdinal) {
            if (idCurrent > 0) {
                int currentOrdinal = current.getOrdinal();
                current.setOrdinal(currentOrdinal - 1);
                current.setUpdater((UserAccountBean)this.session.getAttribute("userBean"));
                dao.update((EntityBean)current);
            }
            if (idPrevious > 0) {
                int previousOrdinal = previous.getOrdinal();
                previous.setOrdinal(previousOrdinal + 1);
                previous.setUpdater((UserAccountBean)this.session.getAttribute("userBean"));
                dao.update((EntityBean)previous);
            }
            ArrayList currOrdlist = dao.findAllByEventDefinitionIdAndOrdinal(defId, current.getOrdinal());
            ArrayList prevOrdlist = dao.findAllByEventDefinitionIdAndOrdinal(defId, previous.getOrdinal());
            if (currOrdlist.size() > 1 || prevOrdlist.size() > 1) {
                this.fixDuplicates(defId, dao);
            }
        }
    }

    private void fixDuplicates(int definitionId, EventDefinitionCRFDAO dao) {
        ArrayList list = dao.findAllByEventDefinitionId(definitionId);
        boolean prevOrdinal = false;
        boolean incrementNextOrdinal = false;
        for (int i = 0; i < list.size(); ++i) {
            EventDefinitionCRFBean edc = (EventDefinitionCRFBean)list.get(i);
            if (i == 0) {
                if (edc.getOrdinal() == 0) continue;
                edc.setOrdinal(i);
                dao.update((EntityBean)edc);
                continue;
            }
            if (incrementNextOrdinal) {
                edc.setOrdinal(i);
                dao.update((EntityBean)edc);
                continue;
            }
            if (edc.getOrdinal() == i) continue;
            edc.setOrdinal(i);
            dao.update((EntityBean)edc);
            incrementNextOrdinal = true;
        }
    }
}

