/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.InterventionBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;

public class CreateStudyServlet
extends SecureController {
    public static final String INPUT_START_DATE = "startDate";
    public static final String INPUT_END_DATE = "endDate";
    public static final String INPUT_VER_DATE = "protocolDateVerification";
    public static final String FAC_NAME = "FacName";
    public static final String FAC_CITY = "FacCity";
    public static final String FAC_STATE = "FacState";
    public static final String FAC_ZIP = "FacZIP";
    public static final String FAC_COUNTRY = "FacCountry";
    public static final String FAC_CONTACT_NAME = "FacContactName";
    public static final String FAC_CONTACT_DEGREE = "FacContactDegree";
    public static final String FAC_CONTACT_PHONE = "FacContactPhone";
    public static final String FAC_CONTACT_EMAIL = "FacContactEmail";
    static HashMap<String, String> facRecruitStatusMap = new LinkedHashMap();
    static HashMap<String, String> studyPhaseMap = new LinkedHashMap();
    static HashMap<String, String> interPurposeMap = new LinkedHashMap();
    static HashMap<String, String> allocationMap = new LinkedHashMap();
    static HashMap<String, String> maskingMap = new LinkedHashMap();
    static HashMap<String, String> controlMap = new LinkedHashMap();
    static HashMap<String, String> assignmentMap = new LinkedHashMap();
    static HashMap<String, String> endpointMap = new LinkedHashMap();
    static HashMap<String, String> interTypeMap = new LinkedHashMap();
    static HashMap<String, String> obserPurposeMap = new LinkedHashMap();
    static HashMap<String, String> selectionMap = new LinkedHashMap();
    static HashMap<String, String> timingMap = new LinkedHashMap();
    private Locale current_maps_locale;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.STUDY_LIST_SERVLET, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        this.panel.setExtractData(false);
        this.panel.setSubmitDataModule(false);
        this.panel.setCreateDataset(false);
        this.panel.setIconInfoShown(true);
        this.panel.setManageSubject(false);
        if (StringUtil.isBlank((String)action)) {
            this.session.setAttribute("newStudy", (Object)new StudyBean());
            UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
            Collection users = udao.findAllByRole("coordinator", "director");
            this.request.setAttribute("users", (Object)users);
            this.forwardPage(Page.CREATE_STUDY1);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.confirmWholeStudy();
        } else {
            if ("cancel".equalsIgnoreCase(action)) {
                this.addPageMessage(respage.getString("study_creation_cancelled"));
                this.forwardPage(Page.STUDY_LIST_SERVLET);
                return;
            }
            if ("submit".equalsIgnoreCase(action)) {
                this.submitStudy();
                this.session.removeAttribute("interventions");
                this.session.removeAttribute("isInterventionalFlag");
                this.session.removeAttribute("interventionArray");
                this.session.setAttribute("study", this.session.getAttribute("newStudy"));
                this.session.removeAttribute("newStudy");
                this.currentStudy = (StudyBean)this.session.getAttribute("study");
                UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
                StudyUserRoleBean sub = new StudyUserRoleBean();
                sub.setRole(Role.COORDINATOR);
                sub.setStudyId(this.currentStudy.getId());
                sub.setStatus(Status.AVAILABLE);
                sub.setOwner(this.ub);
                udao.createStudyUserRole(this.ub, sub);
                this.currentRole = sub;
                this.session.setAttribute("userRole", (Object)sub);
                this.addPageMessage(respage.getString("the_new_study_created_succesfully_current"));
                ArrayList pageMessages = (ArrayList)this.request.getAttribute("pageMessages");
                this.session.setAttribute("pageMessages", (Object)pageMessages);
                this.response.sendRedirect(this.request.getContextPath() + Page.MANAGE_STUDY_MODULE.getFileName());
            } else if ("next".equalsIgnoreCase(action)) {
                Integer pageNumber = Integer.valueOf(this.request.getParameter("pageNum"));
                if (pageNumber != null) {
                    if (pageNumber == 6) {
                        this.confirmStudy6();
                    } else if (pageNumber == 5) {
                        this.confirmStudy5();
                    } else if (pageNumber == 4) {
                        this.confirmStudy4();
                    } else if (pageNumber == 3) {
                        this.confirmStudy3();
                    } else if (pageNumber == 2) {
                        this.confirmStudy2();
                    } else {
                        logger.info("confirm study 1" + pageNumber);
                        this.confirmStudy1();
                    }
                } else {
                    if (this.session.getAttribute("newStudy") == null) {
                        this.session.setAttribute("newStudy", (Object)new StudyBean());
                    }
                    UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
                    Collection users = udao.findAllByRole("coordinator", "director");
                    this.request.setAttribute("users", (Object)users);
                    this.forwardPage(Page.CREATE_STUDY1);
                }
            }
        }
    }

    private void confirmStudy1() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("name", 1);
        v.addValidation("uniqueProId", 1);
        v.addValidation("description", 1);
        v.addValidation("prinInvestigator", 1);
        v.addValidation("sponsor", 1);
        v.addValidation("secondProId", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("collaborators", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 1000);
        v.addValidation("protocolDescription", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 1000);
        this.errors = v.validate();
        StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
        ArrayList allStudies = (ArrayList)studyDAO.findAll();
        for (StudyBean thisBean : allStudies) {
            if (fp.getString("name").trim().equals(thisBean.getName())) {
                MessageFormat mf = new MessageFormat("");
                mf.applyPattern(respage.getString("brief_title_existed"));
                Object[] arguments = new Object[]{fp.getString("name").trim()};
                Validator.addError((HashMap)this.errors, (String)"name", (String)mf.format(arguments));
            }
            if (!fp.getString("uniqueProId").trim().equals(thisBean.getIdentifier())) continue;
            Validator.addError((HashMap)this.errors, (String)"uniqueProId", (String)resexception.getString("unique_protocol_id_existed"));
        }
        if (fp.getString("name").trim().length() > 100) {
            Validator.addError((HashMap)this.errors, (String)"name", (String)resexception.getString("maximum_lenght_name_100"));
        }
        if (fp.getString("uniqueProId").trim().length() > 30) {
            Validator.addError((HashMap)this.errors, (String)"uniqueProId", (String)resexception.getString("maximum_lenght_unique_protocol_30"));
        }
        if (fp.getString("description").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"description", (String)resexception.getString("maximum_lenght_brief_summary_255"));
        }
        if (fp.getString("prinInvestigator").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"prinInvestigator", (String)resexception.getString("maximum_lenght_principal_investigator_255"));
        }
        if (fp.getString("sponsor").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"sponsor", (String)resexception.getString("maximum_lenght_sponsor_255"));
        }
        if (fp.getString("officialTitle").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"officialTitle", (String)resexception.getString("maximum_lenght_official_title_255"));
        }
        StudyBean studyBean = this.createStudyBean();
        if (this.errors.isEmpty()) {
            logger.info("no errors in the first section");
            this.request.setAttribute("studyPhaseMap", (Object)studyPhaseMap);
            this.request.setAttribute("statuses", (Object)Status.toActiveArrayList());
            logger.info("setting arrays to request, size of list: " + Status.toArrayList().size());
            if (this.request.getParameter("Save") != null && this.request.getParameter("Save").length() > 0) {
                StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
                studyBean.setOwner(this.ub);
                studyBean.setCreatedDate(new Date());
                studyBean.setStatus(Status.PENDING);
                studyBean = (StudyBean)sdao.create((EntityBean)studyBean);
                StudyBean newstudyBean = (StudyBean)sdao.findByName(studyBean.getName());
                UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
                String selectedUserIdStr = fp.getString("selectedUser");
                int selectedUserId = 0;
                if (selectedUserIdStr != null && selectedUserIdStr.length() > 0) {
                    selectedUserId = Integer.parseInt(fp.getString("selectedUser"));
                }
                if (selectedUserId > 0) {
                    UserAccountBean user = (UserAccountBean)udao.findByPK(selectedUserId);
                    StudyUserRoleBean sub = new StudyUserRoleBean();
                    sub.setRole(Role.COORDINATOR);
                    sub.setStudyId(newstudyBean.getId());
                    sub.setStatus(Status.AVAILABLE);
                    sub.setOwner(this.ub);
                    udao.createStudyUserRole(user, sub);
                    if (this.ub.getId() != selectedUserId) {
                        sub = new StudyUserRoleBean();
                        sub.setRole(Role.COORDINATOR);
                        sub.setStudyId(newstudyBean.getId());
                        sub.setStatus(Status.AVAILABLE);
                        sub.setOwner(this.ub);
                        udao.createStudyUserRole(this.ub, sub);
                    }
                } else {
                    StudyUserRoleBean sub = new StudyUserRoleBean();
                    sub.setRole(Role.COORDINATOR);
                    sub.setStudyId(newstudyBean.getId());
                    sub.setStatus(Status.AVAILABLE);
                    sub.setOwner(this.ub);
                    udao.createStudyUserRole(this.ub, sub);
                }
                this.addPageMessage(respage.getString("the_new_study_created_succesfully_current"));
                this.forwardPage(Page.STUDY_LIST_SERVLET);
            } else {
                this.session.setAttribute("newStudy", (Object)studyBean);
                this.forwardPage(Page.CREATE_STUDY2);
            }
        } else {
            this.session.setAttribute("newStudy", (Object)studyBean);
            logger.info("has validation errors in the first section");
            this.request.setAttribute("formMessages", (Object)this.errors);
            UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
            Collection users = udao.findAllByRole("coordinator", "director");
            this.request.setAttribute("users", (Object)users);
            this.forwardPage(Page.CREATE_STUDY1);
        }
    }

    private void confirmStudy2() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation(INPUT_START_DATE, 4);
        if (!StringUtil.isBlank((String)fp.getString(INPUT_END_DATE))) {
            v.addValidation(INPUT_END_DATE, 4);
        }
        v.addValidation("protocolType", 1);
        if (!StringUtil.isBlank((String)fp.getString(INPUT_VER_DATE))) {
            v.addValidation(INPUT_VER_DATE, 31);
        }
        this.errors = v.validate();
        boolean isInterventional = this.updateStudy2();
        this.session.setAttribute("isInterventionalFlag", (Object)new Boolean(isInterventional));
        if (this.errors.isEmpty()) {
            logger.info("no errors");
            this.setMaps(isInterventional);
            if (isInterventional) {
                this.forwardPage(Page.CREATE_STUDY3);
            } else {
                this.forwardPage(Page.CREATE_STUDY4);
            }
        } else {
            logger.info("has validation errors");
            try {
                this.local_df.parse(fp.getString(INPUT_START_DATE));
                fp.addPresetValue(INPUT_START_DATE, this.local_df.format(fp.getDate(INPUT_START_DATE)));
            }
            catch (ParseException pe) {
                fp.addPresetValue(INPUT_START_DATE, fp.getString(INPUT_START_DATE));
            }
            try {
                this.local_df.parse(fp.getString(INPUT_VER_DATE));
                fp.addPresetValue(INPUT_VER_DATE, this.local_df.format(fp.getDate(INPUT_VER_DATE)));
            }
            catch (ParseException pe) {
                fp.addPresetValue(INPUT_VER_DATE, fp.getString(INPUT_VER_DATE));
            }
            try {
                this.local_df.parse(fp.getString(INPUT_END_DATE));
                fp.addPresetValue(INPUT_END_DATE, this.local_df.format(fp.getDate(INPUT_END_DATE)));
            }
            catch (ParseException pe) {
                fp.addPresetValue(INPUT_END_DATE, fp.getString(INPUT_END_DATE));
            }
            this.setPresetValues(fp.getPresetValues());
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.request.setAttribute("studyPhaseMap", (Object)studyPhaseMap);
            this.request.setAttribute("statuses", (Object)Status.toActiveArrayList());
            this.forwardPage(Page.CREATE_STUDY2);
        }
    }

    private void confirmStudy3() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("purpose", 1);
        for (int i = 0; i < 10; ++i) {
            String type = fp.getString("interType" + i);
            String name = fp.getString("interName" + i);
            if (!StringUtil.isBlank((String)type) && StringUtil.isBlank((String)name)) {
                v.addValidation("interName", 1);
                this.request.setAttribute("interventionError", (Object)respage.getString("name_cannot_be_blank_if_type"));
                break;
            }
            if (StringUtil.isBlank((String)name) || !StringUtil.isBlank((String)type)) continue;
            v.addValidation("interType", 1);
            this.request.setAttribute("interventionError", (Object)respage.getString("name_cannot_be_blank_if_name"));
            break;
        }
        this.errors = v.validate();
        boolean isInterventional = true;
        if (this.session.getAttribute("isInterventionalFlag") != null) {
            isInterventional = (Boolean)this.session.getAttribute("isInterventionalFlag");
        }
        this.updateStudy3(isInterventional);
        if (this.errors.isEmpty()) {
            logger.info("no errors");
            if (this.session.getAttribute("interventionArray") == null) {
                this.request.setAttribute("interventions", new ArrayList());
            } else {
                this.request.setAttribute("interventions", this.session.getAttribute("interventionArray"));
            }
            this.forwardPage(Page.CREATE_STUDY5);
        } else {
            logger.info("has validation errors");
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.setMaps(isInterventional);
            if (isInterventional) {
                this.forwardPage(Page.CREATE_STUDY3);
            } else {
                this.forwardPage(Page.CREATE_STUDY4);
            }
        }
    }

    private void confirmStudy4() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("conditions", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 500);
        v.addValidation("keywords", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("eligibility", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 500);
        logger.info("expectedTotalEnrollment:" + fp.getInt("expectedTotalEnrollment"));
        this.errors = v.validate();
        if (fp.getInt("expectedTotalEnrollment") <= 0) {
            Validator.addError((HashMap)this.errors, (String)"expectedTotalEnrollment", (String)respage.getString("expected_total_enrollment_must_be_a_positive_number"));
        }
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.setConditions(fp.getString("conditions"));
        newStudy.setKeywords(fp.getString("keywords"));
        newStudy.setEligibility(fp.getString("eligibility"));
        newStudy.setGender(fp.getString("gender"));
        newStudy.setAgeMax(fp.getString("ageMax"));
        newStudy.setAgeMin(fp.getString("ageMin"));
        newStudy.setHealthyVolunteerAccepted(fp.getBoolean("healthyVolunteerAccepted"));
        newStudy.setExpectedTotalEnrollment(fp.getInt("expectedTotalEnrollment"));
        this.session.setAttribute("newStudy", (Object)newStudy);
        this.request.setAttribute("facRecruitStatusMap", (Object)facRecruitStatusMap);
        if (this.errors.isEmpty()) {
            newStudy.setFacilityName(SQLInitServlet.getField((String)FAC_NAME));
            newStudy.setFacilityCity(SQLInitServlet.getField((String)FAC_CITY));
            newStudy.setFacilityState(SQLInitServlet.getField((String)FAC_STATE));
            newStudy.setFacilityCountry(SQLInitServlet.getField((String)FAC_COUNTRY));
            newStudy.setFacilityContactDegree(SQLInitServlet.getField((String)FAC_CONTACT_DEGREE));
            newStudy.setFacilityContactEmail(SQLInitServlet.getField((String)FAC_CONTACT_EMAIL));
            newStudy.setFacilityContactName(SQLInitServlet.getField((String)FAC_CONTACT_NAME));
            newStudy.setFacilityContactPhone(SQLInitServlet.getField((String)FAC_CONTACT_PHONE));
            newStudy.setFacilityZip(SQLInitServlet.getField((String)FAC_ZIP));
            this.session.setAttribute("newStudy", (Object)newStudy);
            this.forwardPage(Page.CREATE_STUDY6);
        } else {
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.CREATE_STUDY5);
        }
    }

    private void confirmStudy5() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        Validator v = new Validator(this.request);
        if (!StringUtil.isBlank((String)fp.getString("facConEmail"))) {
            v.addValidation("facConEmail", 6);
        }
        v.addValidation("facName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facCity", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facState", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 20);
        v.addValidation("facZip", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
        v.addValidation("facCountry", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
        v.addValidation("facConName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConDegree", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConPhone", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConEmail", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        this.errors = v.validate();
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.setFacilityCity(fp.getString("facCity"));
        newStudy.setFacilityContactDegree(fp.getString("facConDrgree"));
        newStudy.setFacilityName(fp.getString("facName"));
        newStudy.setFacilityContactEmail(fp.getString("facConEmail"));
        newStudy.setFacilityContactPhone(fp.getString("facConPhone"));
        newStudy.setFacilityContactName(fp.getString("facConName"));
        newStudy.setFacilityCountry(fp.getString("facCountry"));
        newStudy.setFacilityContactDegree(fp.getString("facConDegree"));
        newStudy.setFacilityState(fp.getString("facState"));
        newStudy.setFacilityZip(fp.getString("facZip"));
        this.session.setAttribute("newStudy", (Object)newStudy);
        if (this.errors.isEmpty()) {
            this.forwardPage(Page.CREATE_STUDY7);
        } else {
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.request.setAttribute("facRecruitStatusMap", (Object)facRecruitStatusMap);
            this.forwardPage(Page.CREATE_STUDY6);
        }
    }

    private void confirmStudy6() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        Validator v = new Validator(this.request);
        v.addValidation("medlineIdentifier", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("url", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("urlDescription", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        this.errors = v.validate();
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.setMedlineIdentifier(fp.getString("medlineIdentifier"));
        newStudy.setResultsReference(fp.getBoolean("resultsReference"));
        newStudy.setUrl(fp.getString("url"));
        newStudy.setUrlDescription(fp.getString("urlDescription"));
        this.session.setAttribute("newStudy", (Object)newStudy);
        if (this.errors.isEmpty()) {
            if (this.session.getAttribute("interventionArray") == null) {
                this.request.setAttribute("interventions", new ArrayList());
            } else {
                this.request.setAttribute("interventions", this.session.getAttribute("interventionArray"));
            }
            this.forwardPage(Page.CREATE_STUDY8);
        } else {
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.CREATE_STUDY7);
        }
    }

    private void confirmWholeStudy() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        Validator v = new Validator(this.request);
        this.errors = v.validate();
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.getStudyParameterConfig().setCollectDob(fp.getString("collectDob"));
        newStudy.getStudyParameterConfig().setDiscrepancyManagement(fp.getString("discrepancyManagement"));
        newStudy.getStudyParameterConfig().setGenderRequired(fp.getString("genderRequired"));
        newStudy.getStudyParameterConfig().setInterviewerNameRequired(fp.getString("interviewerNameRequired"));
        newStudy.getStudyParameterConfig().setInterviewerNameDefault(fp.getString("interviewerNameDefault"));
        newStudy.getStudyParameterConfig().setInterviewDateEditable(fp.getString("interviewDateEditable"));
        newStudy.getStudyParameterConfig().setInterviewDateRequired(fp.getString("interviewDateRequired"));
        newStudy.getStudyParameterConfig().setInterviewerNameEditable(fp.getString("interviewerNameEditable"));
        newStudy.getStudyParameterConfig().setInterviewDateDefault(fp.getString("interviewDateDefault"));
        newStudy.getStudyParameterConfig().setSubjectIdGeneration(fp.getString("subjectIdGeneration"));
        newStudy.getStudyParameterConfig().setSubjectPersonIdRequired(fp.getString("subjectPersonIdRequired"));
        newStudy.getStudyParameterConfig().setSubjectIdPrefixSuffix(fp.getString("subjectIdPrefixSuffix"));
        newStudy.getStudyParameterConfig().setPersonIdShownOnCRF(fp.getString("personIdShownOnCRF"));
        newStudy.getStudyParameterConfig().setSecondaryLabelViewable(fp.getString("secondaryLabelViewable"));
        newStudy.getStudyParameterConfig().setAdminForcedReasonForChange(fp.getString("adminForcedReasonForChange"));
        this.session.setAttribute("newStudy", (Object)newStudy);
        if (this.errors.isEmpty()) {
            if (this.session.getAttribute("interventionArray") == null) {
                this.request.setAttribute("interventions", new ArrayList());
            } else {
                this.request.setAttribute("interventions", this.session.getAttribute("interventionArray"));
            }
            this.forwardPage(Page.STUDY_CREATE_CONFIRM);
        } else {
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.CREATE_STUDY8);
        }
    }

    private void submitStudy() {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        logger.info("study bean to be created:" + newStudy.getName() + newStudy.getProtocolDateVerification());
        newStudy.setOwner(this.ub);
        newStudy.setCreatedDate(new Date());
        StudyBean finalStudy = (StudyBean)sdao.create((EntityBean)newStudy);
        logger.info("new study created");
        StudyParameterValueBean spv = new StudyParameterValueBean();
        spv.setStudyId(finalStudy.getId());
        spv.setParameter("collectDob");
        spv.setValue(newStudy.getStudyParameterConfig().getCollectDob());
        spvdao.create((EntityBean)spv);
        spv.setParameter("discrepancyManagement");
        spv.setValue(newStudy.getStudyParameterConfig().getDiscrepancyManagement());
        spvdao.create((EntityBean)spv);
        spv.setParameter("genderRequired");
        spv.setValue(newStudy.getStudyParameterConfig().getGenderRequired());
        spvdao.create((EntityBean)spv);
        spv.setParameter("subjectPersonIdRequired");
        spv.setValue(newStudy.getStudyParameterConfig().getSubjectPersonIdRequired());
        spvdao.create((EntityBean)spv);
        spv.setParameter("interviewerNameRequired");
        spv.setValue(newStudy.getStudyParameterConfig().getInterviewerNameRequired());
        spvdao.create((EntityBean)spv);
        spv.setParameter("interviewerNameDefault");
        spv.setValue(newStudy.getStudyParameterConfig().getInterviewerNameDefault());
        spvdao.create((EntityBean)spv);
        spv.setParameter("interviewerNameEditable");
        spv.setValue(newStudy.getStudyParameterConfig().getInterviewerNameEditable());
        spvdao.create((EntityBean)spv);
        spv.setParameter("interviewDateRequired");
        spv.setValue(newStudy.getStudyParameterConfig().getInterviewDateRequired());
        spvdao.create((EntityBean)spv);
        spv.setParameter("interviewDateDefault");
        spv.setValue(newStudy.getStudyParameterConfig().getInterviewDateDefault());
        spvdao.create((EntityBean)spv);
        spv.setParameter("interviewDateEditable");
        spv.setValue(newStudy.getStudyParameterConfig().getInterviewDateEditable());
        spvdao.create((EntityBean)spv);
        spv.setParameter("subjectIdGeneration");
        spv.setValue(newStudy.getStudyParameterConfig().getSubjectIdGeneration());
        spvdao.create((EntityBean)spv);
        spv.setParameter("subjectIdPrefixSuffix");
        spv.setValue(newStudy.getStudyParameterConfig().getSubjectIdPrefixSuffix());
        spvdao.create((EntityBean)spv);
        spv.setParameter("personIdShownOnCRF");
        spv.setValue(newStudy.getStudyParameterConfig().getPersonIdShownOnCRF());
        spvdao.create((EntityBean)spv);
        spv.setParameter("secondaryLabelViewable");
        spv.setValue(newStudy.getStudyParameterConfig().getSecondaryLabelViewable());
        spvdao.create((EntityBean)spv);
        spv.setParameter("adminForcedReasonForChange");
        spv.setValue(newStudy.getStudyParameterConfig().getAdminForcedReasonForChange());
        spvdao.create((EntityBean)spv);
        logger.info("study parameters created done");
    }

    private StudyBean createStudyBean() {
        FormProcessor fp = new FormProcessor(this.request);
        StudyBean newStudy = new StudyBean();
        newStudy.setName(fp.getString("name"));
        newStudy.setOfficialTitle(fp.getString("officialTitle"));
        newStudy.setIdentifier(fp.getString("uniqueProId"));
        newStudy.setSecondaryIdentifier(fp.getString("secondProId"));
        newStudy.setPrincipalInvestigator(fp.getString("prinInvestigator"));
        newStudy.setProtocolType(fp.getString("protocolType"));
        newStudy.setSummary(fp.getString("description"));
        newStudy.setProtocolDescription(fp.getString("protocolDescription"));
        newStudy.setSponsor(fp.getString("sponsor"));
        newStudy.setCollaborators(fp.getString("collaborators"));
        return newStudy;
    }

    private boolean updateStudy2() {
        FormProcessor fp = new FormProcessor(this.request);
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.setProtocolType(fp.getString("protocolType"));
        newStudy.setStatus(Status.get((int)fp.getInt("statusId")));
        if (StringUtil.isBlank((String)fp.getString(INPUT_VER_DATE))) {
            newStudy.setProtocolDateVerification(null);
        } else {
            newStudy.setProtocolDateVerification(fp.getDate(INPUT_VER_DATE));
        }
        newStudy.setDatePlannedStart(fp.getDate(INPUT_START_DATE));
        if (StringUtil.isBlank((String)fp.getString(INPUT_END_DATE))) {
            newStudy.setDatePlannedEnd(null);
        } else {
            newStudy.setDatePlannedEnd(fp.getDate(INPUT_END_DATE));
        }
        newStudy.setPhase(fp.getString("phase"));
        if (fp.getInt("genetic") == 1) {
            newStudy.setGenetic(true);
        } else {
            newStudy.setGenetic(false);
        }
        this.session.setAttribute("newStudy", (Object)newStudy);
        String interventional = resadmin.getString("interventional");
        return interventional.equalsIgnoreCase(newStudy.getProtocolType());
    }

    private void updateStudy3(boolean isInterventional) {
        FormProcessor fp = new FormProcessor(this.request);
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.setPurpose(fp.getString("purpose"));
        if (isInterventional) {
            newStudy.setAllocation(fp.getString("allocation"));
            newStudy.setMasking(fp.getString("masking"));
            newStudy.setControl(fp.getString("control"));
            newStudy.setAssignment(fp.getString("assignment"));
            newStudy.setEndpoint(fp.getString("endpoint"));
            StringBuffer interventions = new StringBuffer();
            ArrayList<InterventionBean> interventionArray = new ArrayList<InterventionBean>();
            for (int i = 0; i < 10; ++i) {
                String type = fp.getString("interType" + i);
                String name = fp.getString("interName" + i);
                if (StringUtil.isBlank((String)type) || StringUtil.isBlank((String)name)) continue;
                InterventionBean ib = new InterventionBean(fp.getString("interType" + i), fp.getString("interName" + i));
                interventionArray.add(ib);
                interventions.append(ib.toString()).append(",");
            }
            newStudy.setInterventions(interventions.toString());
            this.session.setAttribute("interventionArray", interventionArray);
        } else {
            newStudy.setDuration(fp.getString("duration"));
            newStudy.setSelection(fp.getString("selection"));
            newStudy.setTiming(fp.getString("timing"));
        }
        this.session.setAttribute("newStudy", (Object)newStudy);
    }

    private void setMaps(boolean isInterventional) {
        if (isInterventional) {
            this.request.setAttribute("interPurposeMap", (Object)interPurposeMap);
            this.request.setAttribute("allocationMap", (Object)allocationMap);
            this.request.setAttribute("maskingMap", (Object)maskingMap);
            this.request.setAttribute("controlMap", (Object)controlMap);
            this.request.setAttribute("assignmentMap", (Object)assignmentMap);
            this.request.setAttribute("endpointMap", (Object)endpointMap);
            this.request.setAttribute("interTypeMap", (Object)interTypeMap);
            if (this.session.getAttribute("interventionArray") == null) {
                this.session.setAttribute("interventions", new ArrayList());
            } else {
                this.session.setAttribute("interventions", this.session.getAttribute("interventionArray"));
            }
        } else {
            this.request.setAttribute("obserPurposeMap", (Object)obserPurposeMap);
            this.request.setAttribute("selectionMap", (Object)selectionMap);
            this.request.setAttribute("timingMap", (Object)timingMap);
        }
    }

    private void updateMaps() {
        if (this.current_maps_locale != resadmin.getLocale()) {
            this.current_maps_locale = resadmin.getLocale();
            facRecruitStatusMap.put("not_yet_recruiting", resadmin.getString("not_yet_recruiting"));
            facRecruitStatusMap.put("recruiting", resadmin.getString("recruiting"));
            facRecruitStatusMap.put("no_longer_recruiting", resadmin.getString("no_longer_recruiting"));
            facRecruitStatusMap.put("completed", resadmin.getString("completed"));
            facRecruitStatusMap.put("suspended", resadmin.getString("suspended"));
            facRecruitStatusMap.put("terminated", resadmin.getString("terminated"));
            studyPhaseMap.put("n_a", resadmin.getString("n_a"));
            studyPhaseMap.put("phaseI", resadmin.getString("phaseI"));
            studyPhaseMap.put("phaseI_II", resadmin.getString("phaseI_II"));
            studyPhaseMap.put("phaseII", resadmin.getString("phaseII"));
            studyPhaseMap.put("phaseII_III", resadmin.getString("phaseII_III"));
            studyPhaseMap.put("phaseIII", resadmin.getString("phaseIII"));
            studyPhaseMap.put("phaseIII_IV", resadmin.getString("phaseIII_IV"));
            studyPhaseMap.put("phaseIV", resadmin.getString("phaseIV"));
            interPurposeMap.put("treatment", resadmin.getString("treatment"));
            interPurposeMap.put("prevention", resadmin.getString("prevention"));
            interPurposeMap.put("diagnosis", resadmin.getString("diagnosis"));
            interPurposeMap.put("educ_couns_train", resadmin.getString("educ_couns_train"));
            allocationMap.put("randomized", resadmin.getString("randomized"));
            allocationMap.put("non_randomized", resadmin.getString("non_randomized"));
            maskingMap.put("open", resadmin.getString("open"));
            maskingMap.put("single_blind", resadmin.getString("single_blind"));
            maskingMap.put("double_blind", resadmin.getString("double_blind"));
            controlMap.put("placebo", resadmin.getString("placebo"));
            controlMap.put("active", resadmin.getString("active"));
            controlMap.put("uncontrolled", resadmin.getString("uncontrolled"));
            controlMap.put("historical", resadmin.getString("historical"));
            controlMap.put("dose_comparison", resadmin.getString("dose_comparison"));
            assignmentMap.put("single_group", resadmin.getString("single_group"));
            assignmentMap.put("parallel", resadmin.getString("parallel"));
            assignmentMap.put("cross_over", resadmin.getString("cross_over"));
            assignmentMap.put("factorial", resadmin.getString("factorial"));
            assignmentMap.put("expanded_access", resadmin.getString("expanded_access"));
            endpointMap.put("safety", resadmin.getString("safety"));
            endpointMap.put("efficacy", resadmin.getString("efficacy"));
            endpointMap.put("safety_efficacy", resadmin.getString("safety_efficacy"));
            endpointMap.put("bio_equivalence", resadmin.getString("bio_equivalence"));
            endpointMap.put("bio_availability", resadmin.getString("bio_availability"));
            endpointMap.put("pharmacokinetics", resadmin.getString("pharmacokinetics"));
            endpointMap.put("pharmacodynamics", resadmin.getString("pharmacodynamics"));
            endpointMap.put("pharmacokinetics_pharmacodynamics", resadmin.getString("pharmacokinetics_pharmacodynamics"));
            interTypeMap.put("drug", resadmin.getString("drug"));
            interTypeMap.put("gene_transfer", resadmin.getString("gene_transfer"));
            interTypeMap.put("vaccine", resadmin.getString("vaccine"));
            interTypeMap.put("behavior", resadmin.getString("behavior"));
            interTypeMap.put("device", resadmin.getString("device"));
            interTypeMap.put("procedure", resadmin.getString("procedure"));
            interTypeMap.put("other", resadmin.getString("other"));
            obserPurposeMap.put("natural_history", resadmin.getString("natural_history"));
            obserPurposeMap.put("screening", resadmin.getString("screening"));
            obserPurposeMap.put("psychosocial", resadmin.getString("psychosocial"));
            selectionMap.put("convenience_sample", resadmin.getString("convenience_sample"));
            selectionMap.put("defined_population", resadmin.getString("defined_population"));
            selectionMap.put("random_sample", resadmin.getString("random_sample"));
            selectionMap.put("case_control", resadmin.getString("case_control"));
            timingMap.put("retrospective", resadmin.getString("retrospective"));
            timingMap.put("prospective", resadmin.getString("prospective"));
        }
    }

    protected String getAdminServlet() {
        return "admin";
    }

    static {
        facRecruitStatusMap.put("not_yet_recruiting", resadmin.getString("not_yet_recruiting"));
        facRecruitStatusMap.put("recruiting", resadmin.getString("recruiting"));
        facRecruitStatusMap.put("no_longer_recruiting", resadmin.getString("no_longer_recruiting"));
        facRecruitStatusMap.put("completed", resadmin.getString("completed"));
        facRecruitStatusMap.put("suspended", resadmin.getString("suspended"));
        facRecruitStatusMap.put("terminated", resadmin.getString("terminated"));
        studyPhaseMap.put("n_a", resadmin.getString("n_a"));
        studyPhaseMap.put("phaseI", resadmin.getString("phaseI"));
        studyPhaseMap.put("phaseI_II", resadmin.getString("phaseI_II"));
        studyPhaseMap.put("phaseII", resadmin.getString("phaseII"));
        studyPhaseMap.put("phaseII_III", resadmin.getString("phaseII_III"));
        studyPhaseMap.put("phaseIII", resadmin.getString("phaseIII"));
        studyPhaseMap.put("phaseIII_IV", resadmin.getString("phaseIII_IV"));
        studyPhaseMap.put("phaseIV", resadmin.getString("phaseIV"));
        interPurposeMap.put("treatment", resadmin.getString("treatment"));
        interPurposeMap.put("prevention", resadmin.getString("prevention"));
        interPurposeMap.put("diagnosis", resadmin.getString("diagnosis"));
        interPurposeMap.put("supportive_care", resadmin.getString("supportive_care"));
        interPurposeMap.put("screening", resadmin.getString("screening"));
        interPurposeMap.put("health_services_research", resadmin.getString("health_services_research"));
        interPurposeMap.put("basic_science", resadmin.getString("basic_science"));
        interPurposeMap.put("other", resadmin.getString("other"));
        allocationMap.put("randomized", resadmin.getString("randomized"));
        allocationMap.put("non_randomized", resadmin.getString("non_randomized"));
        allocationMap.put("n_a", resadmin.getString("n_a"));
        maskingMap.put("open", resadmin.getString("open"));
        maskingMap.put("single_blind", resadmin.getString("single_blind"));
        maskingMap.put("double_blind", resadmin.getString("double_blind"));
        controlMap.put("placebo", resadmin.getString("placebo"));
        controlMap.put("active", resadmin.getString("active"));
        controlMap.put("uncontrolled", resadmin.getString("uncontrolled"));
        controlMap.put("historical", resadmin.getString("historical"));
        controlMap.put("dose_comparison", resadmin.getString("dose_comparison"));
        assignmentMap.put("single_group", resadmin.getString("single_group"));
        assignmentMap.put("parallel", resadmin.getString("parallel"));
        assignmentMap.put("cross_over", resadmin.getString("cross_over"));
        assignmentMap.put("factorial", resadmin.getString("factorial"));
        assignmentMap.put("expanded_access", resadmin.getString("expanded_access"));
        endpointMap.put("safety", resadmin.getString("safety"));
        endpointMap.put("efficacy", resadmin.getString("efficacy"));
        endpointMap.put("safety_efficacy", resadmin.getString("safety_efficacy"));
        endpointMap.put("bio_equivalence", resadmin.getString("bio_equivalence"));
        endpointMap.put("bio_availability", resadmin.getString("bio_availability"));
        endpointMap.put("pharmacokinetics", resadmin.getString("pharmacokinetics"));
        endpointMap.put("pharmacodynamics", resadmin.getString("pharmacodynamics"));
        endpointMap.put("pharmacokinetics_pharmacodynamics", resadmin.getString("pharmacokinetics_pharmacodynamics"));
        interTypeMap.put("drug", resadmin.getString("drug"));
        interTypeMap.put("gene_transfer", resadmin.getString("gene_transfer"));
        interTypeMap.put("vaccine", resadmin.getString("vaccine"));
        interTypeMap.put("behavior", resadmin.getString("behavior"));
        interTypeMap.put("device", resadmin.getString("device"));
        interTypeMap.put("procedure", resadmin.getString("procedure"));
        interTypeMap.put("other", resadmin.getString("other"));
        obserPurposeMap.put("natural_history", resadmin.getString("natural_history"));
        obserPurposeMap.put("screening", resadmin.getString("screening"));
        obserPurposeMap.put("psychosocial", resadmin.getString("psychosocial"));
        selectionMap.put("convenience_sample", resadmin.getString("convenience_sample"));
        selectionMap.put("defined_population", resadmin.getString("defined_population"));
        selectionMap.put("random_sample", resadmin.getString("random_sample"));
        selectionMap.put("case_control", resadmin.getString("case_control"));
        timingMap.put("retrospective", resadmin.getString("retrospective"));
        timingMap.put("prospective", resadmin.getString("prospective"));
    }
}

