/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.bean.service.StudyParamsConfig;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.managestudy.CreateStudyServlet;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.domain.SourceDataVerification;
import org.akaza.openclinica.service.managestudy.EventDefinitionCrfTagService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;

public class CreateSubStudyServlet
extends SecureController {
    EventDefinitionCrfTagService eventDefinitionCrfTagService = null;
    public static final String INPUT_VER_DATE = "protocolDateVerification";
    public static final String INPUT_START_DATE = "startDate";
    public static final String INPUT_END_DATE = "endDate";

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.SITE_LIST_SERVLET, respage.getString("current_study_locked"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + "\n" + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.SITE_LIST_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String action = this.request.getParameter("action");
        this.session.setAttribute("sdvOptions", (Object)this.setSDVOptions());
        if (StringUtil.isBlank((String)action)) {
            if (this.currentStudy.getParentStudyId() > 0) {
                this.addPageMessage(respage.getString("you_cannot_create_site_itself_site"));
                this.forwardPage(Page.SITE_LIST_SERVLET);
            } else {
                StudyBean newStudy = new StudyBean();
                newStudy.setParentStudyId(this.currentStudy.getId());
                newStudy.setFacilityName(SQLInitServlet.getField((String)"FacName"));
                newStudy.setFacilityCity(SQLInitServlet.getField((String)"FacCity"));
                newStudy.setFacilityState(SQLInitServlet.getField((String)"FacState"));
                newStudy.setFacilityCountry(SQLInitServlet.getField((String)"FacCountry"));
                newStudy.setFacilityContactDegree(SQLInitServlet.getField((String)"FacContactDegree"));
                newStudy.setFacilityContactEmail(SQLInitServlet.getField((String)"FacContactEmail"));
                newStudy.setFacilityContactName(SQLInitServlet.getField((String)"FacContactName"));
                newStudy.setFacilityContactPhone(SQLInitServlet.getField((String)"FacContactPhone"));
                newStudy.setFacilityZip(SQLInitServlet.getField((String)"FacZIP"));
                ArrayList parentConfigs = this.currentStudy.getStudyParameters();
                ArrayList<StudyParamsConfig> configs = new ArrayList<StudyParamsConfig>();
                for (StudyParamsConfig scg : parentConfigs) {
                    if (scg == null || scg.getValue().getId() <= 0 || !scg.getParameter().isOverridable()) continue;
                    logger.info("parameter:" + scg.getParameter().getHandle());
                    logger.info("value:" + scg.getValue().getValue());
                    if (scg.getParameter().getHandle().equalsIgnoreCase("interviewerNameRequired")) {
                        scg.getValue().setValue(fp.getString("interviewerNameRequired"));
                    } else if (scg.getParameter().getHandle().equalsIgnoreCase("interviewerNameDefault")) {
                        scg.getValue().setValue(fp.getString("interviewerNameDefault"));
                    } else if (scg.getParameter().getHandle().equalsIgnoreCase("interviewDateRequired")) {
                        scg.getValue().setValue(fp.getString("interviewDateRequired"));
                    } else if (scg.getParameter().getHandle().equalsIgnoreCase("interviewDateDefault")) {
                        scg.getValue().setValue(fp.getString("interviewDateDefault"));
                    }
                    configs.add(scg);
                }
                newStudy.setStudyParameters(configs);
                newStudy.getStudyParameterConfig().setInterviewerNameEditable(this.currentStudy.getStudyParameterConfig().getInterviewerNameEditable());
                newStudy.getStudyParameterConfig().setInterviewerNameDefault(this.currentStudy.getStudyParameterConfig().getInterviewerNameDefault());
                newStudy.getStudyParameterConfig().setInterviewDateEditable(this.currentStudy.getStudyParameterConfig().getInterviewDateEditable());
                newStudy.getStudyParameterConfig().setInterviewDateDefault(this.currentStudy.getStudyParameterConfig().getInterviewDateDefault());
                try {
                    this.local_df.parse(fp.getString(INPUT_START_DATE));
                    fp.addPresetValue(INPUT_START_DATE, this.local_df.format(fp.getDate(INPUT_START_DATE)));
                }
                catch (ParseException pe) {
                    fp.addPresetValue(INPUT_START_DATE, fp.getString(INPUT_START_DATE));
                }
                try {
                    this.local_df.parse(fp.getString(INPUT_END_DATE));
                    fp.addPresetValue(INPUT_END_DATE, this.local_df.format(fp.getDate(INPUT_END_DATE)));
                }
                catch (ParseException pe) {
                    fp.addPresetValue(INPUT_END_DATE, fp.getString(INPUT_END_DATE));
                }
                try {
                    this.local_df.parse(fp.getString(INPUT_VER_DATE));
                    fp.addPresetValue(INPUT_VER_DATE, this.local_df.format(fp.getDate(INPUT_VER_DATE)));
                }
                catch (ParseException pe) {
                    fp.addPresetValue(INPUT_VER_DATE, fp.getString(INPUT_VER_DATE));
                }
                this.setPresetValues(fp.getPresetValues());
                this.session.setAttribute("newStudy", (Object)newStudy);
                this.session.setAttribute("definitions", (Object)this.initDefinitions(newStudy));
                this.request.setAttribute("facRecruitStatusMap", (Object)CreateStudyServlet.facRecruitStatusMap);
                this.request.setAttribute("statuses", (Object)Status.toActiveArrayList());
                this.forwardPage(Page.CREATE_SUB_STUDY);
            }
        } else if ("confirm".equalsIgnoreCase(action)) {
            StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
            this.session.setAttribute("definitions", (Object)this.initDefinitions(newStudy));
            this.confirmStudy();
        } else if ("back".equalsIgnoreCase(action)) {
            StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
            try {
                fp.addPresetValue(INPUT_START_DATE, this.local_df.format(newStudy.getDatePlannedEnd()));
            }
            catch (Exception pe) {
                fp.addPresetValue(INPUT_START_DATE, fp.getString(INPUT_START_DATE));
            }
            try {
                fp.addPresetValue(INPUT_END_DATE, this.local_df.format(newStudy.getDatePlannedStart()));
            }
            catch (Exception pe) {
                fp.addPresetValue(INPUT_END_DATE, fp.getString(INPUT_END_DATE));
            }
            try {
                fp.addPresetValue(INPUT_VER_DATE, this.local_df.format(newStudy.getProtocolDateVerification()));
            }
            catch (Exception pe) {
                fp.addPresetValue(INPUT_VER_DATE, fp.getString(INPUT_VER_DATE));
            }
            this.setPresetValues(fp.getPresetValues());
            this.request.setAttribute("facRecruitStatusMap", (Object)CreateStudyServlet.facRecruitStatusMap);
            this.request.setAttribute("statuses", (Object)Status.toActiveArrayList());
            this.forwardPage(Page.CREATE_SUB_STUDY);
        } else if ("submit".equalsIgnoreCase(action)) {
            this.submitStudy();
        }
    }

    private void confirmStudy() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("name", 1);
        v.addValidation("uniqueProId", 1);
        v.addValidation("prinInvestigator", 1);
        if (!StringUtil.isBlank((String)fp.getString(INPUT_START_DATE))) {
            v.addValidation(INPUT_START_DATE, 4);
        }
        if (!StringUtil.isBlank((String)fp.getString(INPUT_END_DATE))) {
            v.addValidation(INPUT_END_DATE, 4);
        }
        if (!StringUtil.isBlank((String)fp.getString("facConEmail"))) {
            v.addValidation("facConEmail", 6);
        }
        if (!StringUtil.isBlank((String)fp.getString(INPUT_VER_DATE))) {
            v.addValidation(INPUT_VER_DATE, 4);
        }
        v.addValidation("secondProId", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facCity", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facState", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 20);
        v.addValidation("facZip", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
        v.addValidation("facCountry", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
        v.addValidation("facConName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConDegree", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConPhone", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConEmail", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        StudyBean newSite = this.createStudyBean();
        StudyBean parentStudy = (StudyBean)new StudyDAO(this.sm.getDataSource()).findByPK(newSite.getParentStudyId());
        this.session.setAttribute("newStudy", (Object)newSite);
        this.session.setAttribute("definitions", (Object)this.createSiteEventDefinitions(parentStudy, v));
        if (this.errors.isEmpty()) {
            logger.info("no errors");
            this.forwardPage(Page.CONFIRM_CREATE_SUB_STUDY);
        }
    }

    private StudyBean createStudyBean() {
        FormProcessor fp = new FormProcessor(this.request);
        StudyBean study = (StudyBean)this.session.getAttribute("newStudy");
        study.setName(fp.getString("name"));
        study.setIdentifier(fp.getString("uniqueProId"));
        study.setSecondaryIdentifier(fp.getString("secondProId"));
        study.setSummary(fp.getString("description"));
        study.setPrincipalInvestigator(fp.getString("prinInvestigator"));
        study.setExpectedTotalEnrollment(fp.getInt("expectedTotalEnrollment"));
        Date startDate = null;
        Date endDate = null;
        Date protocolDate = null;
        try {
            this.local_df.setLenient(false);
            startDate = this.local_df.parse(fp.getString(INPUT_START_DATE));
        }
        catch (ParseException fe) {
            startDate = study.getDatePlannedStart();
            logger.info(fe.getMessage());
        }
        study.setDatePlannedStart(startDate);
        try {
            this.local_df.setLenient(false);
            endDate = this.local_df.parse(fp.getString(INPUT_END_DATE));
        }
        catch (ParseException fe) {
            endDate = study.getDatePlannedEnd();
        }
        study.setDatePlannedEnd(endDate);
        try {
            this.local_df.setLenient(false);
            protocolDate = this.local_df.parse(fp.getString(INPUT_VER_DATE));
        }
        catch (ParseException fe) {
            protocolDate = study.getProtocolDateVerification();
        }
        study.setProtocolDateVerification(protocolDate);
        study.setFacilityCity(fp.getString("facCity"));
        study.setFacilityContactDegree(fp.getString("facConDrgree"));
        study.setFacilityName(fp.getString("facName"));
        study.setFacilityContactEmail(fp.getString("facConEmail"));
        study.setFacilityContactPhone(fp.getString("facConPhone"));
        study.setFacilityContactName(fp.getString("facConName"));
        study.setFacilityContactDegree(fp.getString("facConDegree"));
        study.setFacilityCountry(fp.getString("facCountry"));
        study.setFacilityState(fp.getString("facState"));
        study.setFacilityZip(fp.getString("facZip"));
        study.setStatus(Status.get((int)fp.getInt("statusId")));
        ArrayList parameters = study.getStudyParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            StudyParamsConfig scg = (StudyParamsConfig)parameters.get(i);
            String value = fp.getString(scg.getParameter().getHandle());
            logger.info("get value:" + value);
            scg.getValue().setParameter(scg.getParameter().getHandle());
            scg.getValue().setValue(value);
        }
        study.getStudyParameterConfig().setInterviewerNameRequired(fp.getString("interviewerNameRequired"));
        study.getStudyParameterConfig().setInterviewerNameDefault(fp.getString("interviewerNameDefault"));
        study.getStudyParameterConfig().setInterviewDateRequired(fp.getString("interviewDateRequired"));
        study.getStudyParameterConfig().setInterviewDateDefault(fp.getString("interviewDateDefault"));
        return study;
    }

    private void submitStudy() throws IOException {
        FormProcessor fp = new FormProcessor(this.request);
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = (StudyBean)this.session.getAttribute("newStudy");
        ArrayList parameters = study.getStudyParameters();
        logger.info("study bean to be created:\n");
        logger.info(study.getName() + "\n" + study.getIdentifier() + "\n" + study.getParentStudyId() + "\n" + study.getSummary() + "\n" + study.getPrincipalInvestigator() + "\n" + study.getDatePlannedStart() + "\n" + study.getDatePlannedEnd() + "\n" + study.getFacilityName() + "\n" + study.getFacilityCity() + "\n" + study.getFacilityState() + "\n" + study.getFacilityZip() + "\n" + study.getFacilityCountry() + "\n" + study.getFacilityRecruitmentStatus() + "\n" + study.getFacilityContactName() + "\n" + study.getFacilityContactEmail() + "\n" + study.getFacilityContactPhone() + "\n" + study.getFacilityContactDegree());
        study.setOwner(this.ub);
        study.setCreatedDate(new Date());
        StudyBean parent = (StudyBean)sdao.findByPK(study.getParentStudyId());
        study.setType(parent.getType());
        study.setStatus(study.getStatus());
        study.setGenetic(parent.isGenetic());
        study = (StudyBean)sdao.create((EntityBean)study);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        for (int i = 0; i < parameters.size(); ++i) {
            StudyParamsConfig config = (StudyParamsConfig)parameters.get(i);
            StudyParameterValueBean spv = config.getValue();
            spv.setStudyId(study.getId());
            spv = (StudyParameterValueBean)spvdao.create((EntityBean)config.getValue());
        }
        StudyParameterValueBean spv = new StudyParameterValueBean();
        StudyParameterValueBean parentSPV = spvdao.findByHandleAndStudy(parent.getId(), "collectDob");
        spv.setStudyId(study.getId());
        spv.setParameter("collectDob");
        spv.setValue(parentSPV.getValue());
        spvdao.create((EntityBean)spv);
        parentSPV = spvdao.findByHandleAndStudy(parent.getId(), "genderRequired");
        spv.setParameter("genderRequired");
        spv.setValue(parentSPV.getValue());
        spvdao.create((EntityBean)spv);
        this.submitSiteEventDefinitions(study);
        this.session.removeAttribute("newStudy");
        this.addPageMessage(respage.getString("the_new_site_created_succesfully_current"));
        ArrayList pageMessages = (ArrayList)this.request.getAttribute("pageMessages");
        this.session.setAttribute("pageMessages", (Object)pageMessages);
        this.response.sendRedirect(this.request.getContextPath() + Page.MANAGE_STUDY_MODULE.getFileName());
    }

    private ArrayList<StudyEventDefinitionBean> createSiteEventDefinitions(StudyBean site, Validator v) throws MalformedURLException {
        StudyBean parentStudyBean;
        FormProcessor fp = new FormProcessor(this.request);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        ArrayList<EventDefinitionCRFBean> edcsInSession = new ArrayList<EventDefinitionCRFBean>();
        if (site.getParentStudyId() == 0) {
            parentStudyBean = site;
        } else {
            StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
            parentStudyBean = (StudyBean)studyDAO.findByPK(site.getParentStudyId());
        }
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        ArrayList eventDefCrfList = edcdao.findAllActiveSitesAndStudiesPerParentStudy(parentStudyBean.getId());
        ArrayList seds = new ArrayList();
        StudyBean parentStudy = (StudyBean)new StudyDAO(this.sm.getDataSource()).findByPK(site.getParentStudyId());
        seds = (ArrayList)this.session.getAttribute("definitions");
        if (seds == null || seds.size() <= 0) {
            StudyEventDefinitionDAO sedDao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            seds = sedDao.findAllByStudy(parentStudy);
        }
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        HashMap<String, Boolean> changes = new HashMap<String, Boolean>();
        for (StudyEventDefinitionBean sed : seds) {
            String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            if (participateFormStatus.equals("enabled")) {
                this.baseUrl();
            }
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            ArrayList edcs = sed.getCrfs();
            int start = 0;
            for (EventDefinitionCRFBean edcBean : edcs) {
                EventDefinitionCRFBean persistEventDefBean = (EventDefinitionCRFBean)edcdao.findByPK(edcBean.getId());
                int edcStatusId = edcBean.getStatus().getId();
                if (edcStatusId != 5 && edcStatusId != 7) {
                    ArrayList<Integer> idList;
                    String[] ids;
                    CRFVersionBean defaultVersion;
                    boolean isHide;
                    String order = start + "-" + edcBean.getId();
                    int defaultVersionId = fp.getInt("defaultVersionId" + order);
                    String requiredCRF = fp.getString("requiredCRF" + order);
                    String doubleEntry = fp.getString("doubleEntry" + order);
                    String electronicSignature = fp.getString("electronicSignature" + order);
                    String hideCRF = fp.getString("hideCRF" + order);
                    int sdvId = fp.getInt("sdvOption" + order);
                    String participantForm = fp.getString("participantForm" + order);
                    String allowAnonymousSubmission = fp.getString("allowAnonymousSubmission" + order);
                    String submissionUrl = fp.getString("submissionUrl" + order);
                    String offline = fp.getString("offline" + order);
                    ArrayList selectedVersionIdList = fp.getStringArray("versionSelection" + order);
                    int selectedVersionIdListSize = selectedVersionIdList.size();
                    String selectedVersionIds = "";
                    if (selectedVersionIdListSize > 0) {
                        for (String id : selectedVersionIdList) {
                            selectedVersionIds = selectedVersionIds + id + ",";
                        }
                        selectedVersionIds = selectedVersionIds.substring(0, selectedVersionIds.length() - 1);
                    }
                    boolean changed = false;
                    boolean isRequired = !StringUtil.isBlank((String)requiredCRF) && "yes".equalsIgnoreCase(requiredCRF.trim());
                    boolean isDouble = !StringUtil.isBlank((String)doubleEntry) && "yes".equalsIgnoreCase(doubleEntry.trim());
                    boolean hasPassword = !StringUtil.isBlank((String)electronicSignature) && "yes".equalsIgnoreCase(electronicSignature.trim());
                    boolean bl = isHide = !StringUtil.isBlank((String)hideCRF) && "yes".equalsIgnoreCase(hideCRF.trim());
                    if (edcBean.getParentId() > 0) {
                        int dbDefaultVersionId = edcBean.getDefaultVersionId();
                        if (defaultVersionId != dbDefaultVersionId) {
                            changed = true;
                            defaultVersion = (CRFVersionBean)cvdao.findByPK(defaultVersionId);
                            edcBean.setDefaultVersionId(defaultVersionId);
                            edcBean.setDefaultVersionName(defaultVersion.getName());
                        }
                        if (isRequired != edcBean.isRequiredCRF()) {
                            changed = true;
                            edcBean.setRequiredCRF(isRequired);
                        }
                        if (isDouble != edcBean.isDoubleEntry()) {
                            changed = true;
                            edcBean.setDoubleEntry(isDouble);
                        }
                        if (hasPassword != edcBean.isElectronicSignature()) {
                            changed = true;
                            edcBean.setElectronicSignature(hasPassword);
                        }
                        if (isHide != edcBean.isHideCrf()) {
                            changed = true;
                            edcBean.setHideCrf(isHide);
                        }
                        if (!submissionUrl.equals(edcBean.getSubmissionUrl()) || !submissionUrl.equals(persistEventDefBean.getSubmissionUrl())) {
                            changed = true;
                            edcBean.setSubmissionUrl(submissionUrl);
                        }
                        if (!StringUtil.isBlank((String)selectedVersionIds) && !selectedVersionIds.equals(edcBean.getSelectedVersionIds())) {
                            changed = true;
                            ids = selectedVersionIds.split(",");
                            idList = new ArrayList();
                            for (String id : ids) {
                                idList.add(Integer.valueOf(id));
                            }
                            edcBean.setSelectedVersionIdList(idList);
                            edcBean.setSelectedVersionIds(selectedVersionIds);
                        }
                        if (sdvId > 0 && sdvId != edcBean.getSourceDataVerification().getCode()) {
                            changed = true;
                            edcBean.setSourceDataVerification(SourceDataVerification.getByCode((Integer)sdvId));
                        }
                    } else {
                        int defaultId;
                        int n = defaultId = defaultVersionId > 0 ? defaultVersionId : edcBean.getDefaultVersionId();
                        if (defaultId != defaultVersionId) {
                            changed = true;
                            defaultVersion = (CRFVersionBean)cvdao.findByPK(defaultVersionId);
                            edcBean.setDefaultVersionId(defaultVersionId);
                            edcBean.setDefaultVersionName(defaultVersion.getName());
                        }
                        if (isRequired != edcBean.isRequiredCRF()) {
                            changed = true;
                            edcBean.setRequiredCRF(isRequired);
                            edcBean.setSubmissionUrl(submissionUrl);
                        }
                        if (isDouble != edcBean.isDoubleEntry()) {
                            changed = true;
                            edcBean.setDoubleEntry(isDouble);
                            edcBean.setSubmissionUrl(submissionUrl);
                        }
                        if (hasPassword != edcBean.isElectronicSignature()) {
                            changed = true;
                            edcBean.setElectronicSignature(hasPassword);
                            edcBean.setSubmissionUrl(submissionUrl);
                        }
                        if (isHide != edcBean.isHideCrf()) {
                            changed = true;
                            edcBean.setHideCrf(isHide);
                            edcBean.setSubmissionUrl(submissionUrl);
                        }
                        if (!submissionUrl.equals("")) {
                            changed = true;
                            edcBean.setSubmissionUrl(submissionUrl);
                        }
                        if (sdvId > 0 && sdvId != edcBean.getSourceDataVerification().getCode()) {
                            changed = true;
                            edcBean.setSourceDataVerification(SourceDataVerification.getByCode((Integer)sdvId));
                            edcBean.setSubmissionUrl(submissionUrl);
                        }
                        if (selectedVersionIdListSize > 0 && selectedVersionIdListSize != edcBean.getVersions().size()) {
                            changed = true;
                            ids = selectedVersionIds.split(",");
                            idList = new ArrayList<Integer>();
                            for (String id : ids) {
                                idList.add(Integer.valueOf(id));
                            }
                            edcBean.setSelectedVersionIdList(idList);
                            edcBean.setSelectedVersionIds(selectedVersionIds);
                            edcBean.setSubmissionUrl(submissionUrl);
                        }
                    }
                    changes.put(sed.getId() + "-" + edcBean.getId(), changed);
                    ++start;
                }
                edcsInSession.add(edcBean);
            }
            sed.setPopulated(false);
            eventDefCrfList = this.validateSubmissionUrl(edcsInSession, eventDefCrfList, v, sed);
            edcsInSession.clear();
        }
        this.errors = v.validate();
        StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
        ArrayList allStudies = (ArrayList)studyDAO.findAll();
        for (StudyBean thisBean : allStudies) {
            if (!fp.getString("uniqueProId").trim().equals(thisBean.getIdentifier())) continue;
            Validator.addError((HashMap)this.errors, (String)"uniqueProId", (String)resexception.getString("unique_protocol_id_existed"));
        }
        if (fp.getString("name").trim().length() > 100) {
            // empty if block
        }
        if (fp.getString("uniqueProId").trim().length() > 30) {
            Validator.addError((HashMap)this.errors, (String)"uniqueProId", (String)resexception.getString("maximum_lenght_unique_protocol_30"));
        }
        if (fp.getString("description").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"description", (String)resexception.getString("maximum_lenght_brief_summary_255"));
        }
        if (fp.getString("prinInvestigator").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"prinInvestigator", (String)resexception.getString("maximum_lenght_principal_investigator_255"));
        }
        if (fp.getInt("expectedTotalEnrollment") <= 0) {
            Validator.addError((HashMap)this.errors, (String)"expectedTotalEnrollment", (String)respage.getString("expected_total_enrollment_must_be_a_positive_number"));
        }
        if (!this.errors.isEmpty()) {
            StudyBean study = this.createStudyBean();
            this.session.setAttribute("newStudy", (Object)study);
            this.session.setAttribute("definitions", (Object)seds);
            this.request.setAttribute("formMessages", (Object)this.errors);
            logger.info("has validation errors");
            this.forwardPage(Page.CREATE_SUB_STUDY);
        }
        this.session.setAttribute("changed", changes);
        return seds;
    }

    private void submitSiteEventDefinitions(StudyBean site) throws MalformedURLException {
        FormProcessor fp = new FormProcessor(this.request);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        ArrayList seds = new ArrayList();
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        seds = (ArrayList)this.session.getAttribute("definitions");
        HashMap changes = (HashMap)this.session.getAttribute("changed");
        for (StudyEventDefinitionBean sed : seds) {
            String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            if (participateFormStatus.equals("enabled")) {
                this.baseUrl();
            }
            EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
            ArrayList edcs = sed.getCrfs();
            for (EventDefinitionCRFBean edcBean : edcs) {
                boolean changed;
                int edcStatusId = edcBean.getStatus().getId();
                if (edcStatusId == 5 || edcStatusId == 7 || !(changed = ((Boolean)changes.get(sed.getId() + "-" + edcBean.getId())).booleanValue())) continue;
                edcBean.setParentId(edcBean.getId());
                edcBean.setStudyId(site.getId());
                edcBean.setUpdater(this.ub);
                edcBean.setUpdatedDate(new Date());
                logger.debug("create for the site");
                edcdao.create((EntityBean)edcBean);
            }
        }
        this.session.removeAttribute("definitions");
        this.session.removeAttribute("changed");
        this.session.removeAttribute("sdvOptions");
    }

    private ArrayList<StudyEventDefinitionBean> initDefinitions(StudyBean site) throws MalformedURLException {
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        ArrayList seds = new ArrayList();
        StudyEventDefinitionDAO sedDao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        StudyBean parentStudy = (StudyBean)new StudyDAO(this.sm.getDataSource()).findByPK(site.getParentStudyId());
        seds = sedDao.findAllByStudy(parentStudy);
        int start = 0;
        for (StudyEventDefinitionBean sed : seds) {
            String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            if (participateFormStatus.equals("enabled")) {
                this.baseUrl();
            }
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            int defId = sed.getId();
            ArrayList edcs = (ArrayList)edcdao.findAllByDefinitionAndSiteIdAndParentStudyId(defId, site.getId(), parentStudy.getId());
            ArrayList<EventDefinitionCRFBean> defCrfs = new ArrayList<EventDefinitionCRFBean>();
            for (EventDefinitionCRFBean edcBean : edcs) {
                CRFBean cBean = (CRFBean)cdao.findByPK(edcBean.getCrfId());
                String crfPath = sed.getOid() + "." + cBean.getOid();
                edcBean.setOffline(this.getEventDefinitionCrfTagService().getEventDefnCrfOfflineStatus(2, crfPath, true));
                int edcStatusId = edcBean.getStatus().getId();
                CRFBean crf = (CRFBean)cdao.findByPK(edcBean.getCrfId());
                int crfStatusId = crf.getStatusId();
                if (edcStatusId == 5 || edcStatusId == 7 || crfStatusId == 5 || crfStatusId == 7) continue;
                ArrayList versions = (ArrayList)cvdao.findAllActiveByCRF(edcBean.getCrfId());
                edcBean.setVersions(versions);
                edcBean.setCrfName(crf.getName());
                CRFVersionBean defaultVersion = (CRFVersionBean)cvdao.findByPK(edcBean.getDefaultVersionId());
                edcBean.setDefaultVersionName(defaultVersion.getName());
                edcBean.setSubmissionUrl("");
                String sversionIds = edcBean.getSelectedVersionIds();
                ArrayList<Integer> idList = new ArrayList<Integer>();
                if (sversionIds.length() > 0) {
                    String[] ids;
                    for (String id : ids = sversionIds.split("\\,")) {
                        idList.add(Integer.valueOf(id));
                    }
                }
                edcBean.setSelectedVersionIdList(idList);
                defCrfs.add(edcBean);
                ++start;
            }
            logger.debug("definitionCrfs size=" + defCrfs.size() + " total size=" + edcs.size());
            sed.setCrfs(defCrfs);
            sed.setCrfNum(defCrfs.size());
        }
        return seds;
    }

    private ArrayList<String> setSDVOptions() {
        ArrayList<String> sdvOptions = new ArrayList<String>();
        sdvOptions.add(SourceDataVerification.AllREQUIRED.toString());
        sdvOptions.add(SourceDataVerification.PARTIALREQUIRED.toString());
        sdvOptions.add(SourceDataVerification.NOTREQUIRED.toString());
        sdvOptions.add(SourceDataVerification.NOTAPPLICABLE.toString());
        return sdvOptions;
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public ArrayList<EventDefinitionCRFBean> validateSubmissionUrl(ArrayList<EventDefinitionCRFBean> edcsInSession, ArrayList<EventDefinitionCRFBean> eventDefCrfList, Validator v, StudyEventDefinitionBean sed) {
        for (int i = 0; i < edcsInSession.size(); ++i) {
            String order = i + "-" + edcsInSession.get(i).getId();
            v.addValidation("submissionUrl" + order, 44);
            EventDefinitionCRFBean sessionBean = null;
            boolean isExist = false;
            for (EventDefinitionCRFBean eventDef : eventDefCrfList) {
                sessionBean = edcsInSession.get(i);
                System.out.println("iter:           " + eventDef.getId() + "--db:    " + eventDef.getSubmissionUrl());
                System.out.println("edcsInSession:  " + sessionBean.getId() + "--session:" + sessionBean.getSubmissionUrl());
                System.out.println();
                if (sessionBean.getSubmissionUrl().trim().equals("") || sessionBean.getSubmissionUrl().trim() == null) break;
                if (eventDef.getSubmissionUrl().trim().equalsIgnoreCase(sessionBean.getSubmissionUrl().trim()) && eventDef.getId() != sessionBean.getId()) {
                    v.addValidation("submissionUrl" + order, 45);
                    sed.setPopulated(true);
                    System.out.println("Duplicate ****************************");
                    isExist = true;
                    break;
                }
                if (!eventDef.getSubmissionUrl().trim().equalsIgnoreCase(sessionBean.getSubmissionUrl().trim()) || eventDef.getId() != sessionBean.getId()) continue;
                System.out.println("Not Duplicate  ***********");
                isExist = true;
                break;
            }
            if (isExist) continue;
            eventDefCrfList.add(sessionBean);
        }
        return eventDefCrfList;
    }

    public EventDefinitionCrfTagService getEventDefinitionCrfTagService() {
        this.eventDefinitionCrfTagService = this.eventDefinitionCrfTagService != null ? this.eventDefinitionCrfTagService : (EventDefinitionCrfTagService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("eventDefinitionCrfTagService");
        return this.eventDefinitionCrfTagService;
    }
}

