/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NullValue;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.domain.SourceDataVerification;
import org.akaza.openclinica.service.managestudy.EventDefinitionCrfTagService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.CRFRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.apache.commons.lang.StringUtils;

public class DefineStudyEventServlet
extends SecureController {
    EventDefinitionCrfTagService eventDefinitionCrfTagService = null;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_DEFINITION_SERVLET, respage.getString("current_study_locked"));
        if (this.currentStudy.getParentStudyId() > 0) {
            this.addPageMessage(respage.getString("SED_may_only_added_top_level") + respage.getString("please_contact_sysadmin_questions"));
            throw new InsufficientPermissionException(Page.STUDY_EVENT_DEFINITION_LIST, resexception.getString("not_top_study"), "1");
        }
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_persmission_add_SED_to_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.STUDY_EVENT_DEFINITION_LIST, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        block21: {
            StudyEventDefinitionBean sed;
            FormProcessor fpr = new FormProcessor(this.request);
            String actionName = this.request.getParameter("actionName");
            ArrayList<CRFBean> crfsWithVersion = (ArrayList<CRFBean>)this.session.getAttribute("crfsWithVersion");
            if (crfsWithVersion == null) {
                crfsWithVersion = new ArrayList<CRFBean>();
                CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
                CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
                ArrayList crfs = (ArrayList)cdao.findAllByStatus(Status.AVAILABLE);
                for (int i = 0; i < crfs.size(); ++i) {
                    CRFBean crf = (CRFBean)crfs.get(i);
                    ArrayList versions = cvdao.findAllByCRFId(crf.getId());
                    if (versions.isEmpty()) continue;
                    crfsWithVersion.add(crf);
                }
                this.session.setAttribute("crfsWithVersion", crfsWithVersion);
            }
            if (StringUtil.isBlank((String)actionName)) {
                StudyEventDefinitionBean sed2 = new StudyEventDefinitionBean();
                sed2.setStudyId(this.currentStudy.getId());
                this.session.setAttribute("definition", (Object)sed2);
                this.session.removeAttribute("tmpCRFIdMap");
                this.forwardPage(Page.DEFINE_STUDY_EVENT1);
            } else if ("confirm".equalsIgnoreCase(actionName)) {
                this.confirmWholeDefinition();
            } else if ("submit".equalsIgnoreCase(actionName)) {
                try {
                    Integer nextAction = Integer.valueOf(this.request.getParameter("nextAction"));
                    if (nextAction == null) break block21;
                    if (nextAction == 1) {
                        this.session.removeAttribute("definition");
                        this.addPageMessage(respage.getString("the_new_event_definition_creation_cancelled"));
                        this.forwardPage(Page.LIST_DEFINITION_SERVLET);
                        break block21;
                    }
                    if (nextAction == 2) {
                        this.submitDefinition();
                        ArrayList pageMessages = (ArrayList)this.request.getAttribute("pageMessages");
                        this.session.setAttribute("pageMessages", (Object)pageMessages);
                        this.response.sendRedirect(this.request.getContextPath() + Page.MANAGE_STUDY_MODULE.getFileName());
                        break block21;
                    }
                    logger.debug("actionName ==> 3");
                    this.submitDefinition();
                    sed = new StudyEventDefinitionBean();
                    sed.setStudyId(this.currentStudy.getId());
                    this.session.setAttribute("definition", (Object)sed);
                    this.forwardPage(Page.DEFINE_STUDY_EVENT1);
                }
                catch (NumberFormatException e) {
                    logger.error("nextAction value is not proper: ", (Throwable)e);
                    this.addPageMessage(respage.getString("the_new_event_definition_creation_cancelled"));
                    this.forwardPage(Page.LIST_DEFINITION_SERVLET);
                }
                catch (NullPointerException e) {
                    logger.error("Process in study event is not defined properly: ", (Throwable)e);
                    this.addPageMessage(respage.getString("the_new_event_definition_creation_cancelled"));
                    this.forwardPage(Page.LIST_DEFINITION_SERVLET);
                }
            } else if ("next".equalsIgnoreCase(actionName)) {
                Integer pageNumber = Integer.valueOf(this.request.getParameter("pageNum"));
                if (pageNumber != null) {
                    if (pageNumber == 2) {
                        String nextListPage = this.request.getParameter("next_list_page");
                        if (nextListPage != null && nextListPage.equalsIgnoreCase("true")) {
                            this.confirmDefinition1();
                        } else {
                            this.confirmDefinition2();
                        }
                    } else {
                        this.confirmDefinition1();
                    }
                } else {
                    if (this.session.getAttribute("definition") == null) {
                        sed = new StudyEventDefinitionBean();
                        sed.setStudyId(this.currentStudy.getId());
                        this.session.setAttribute("definition", (Object)sed);
                    }
                    this.forwardPage(Page.DEFINE_STUDY_EVENT1);
                }
            }
        }
    }

    private void confirmDefinition1() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("name", 1);
        v.addValidation("name", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
        v.addValidation("description", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
        v.addValidation("category", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
        this.errors = v.validate();
        this.session.setAttribute("definition", (Object)this.createStudyEventDefinition());
        if (this.errors.isEmpty()) {
            logger.debug("no errors in the first section");
            CRFVersionDAO vdao = new CRFVersionDAO(this.sm.getDataSource());
            ArrayList crfArray = new ArrayList();
            HashMap<Integer, String> tmpCRFIdMap = (HashMap<Integer, String>)this.session.getAttribute("tmpCRFIdMap");
            if (tmpCRFIdMap == null) {
                tmpCRFIdMap = new HashMap<Integer, String>();
            }
            ArrayList crfsWithVersion = (ArrayList)this.session.getAttribute("crfsWithVersion");
            for (int i = 0; i < crfsWithVersion.size(); ++i) {
                int id = fp.getInt("id" + i);
                String name = fp.getString("name" + i);
                String selected = fp.getString("selected" + i);
                if (!StringUtil.isBlank((String)selected) && "yes".equalsIgnoreCase(selected.trim())) {
                    tmpCRFIdMap.put(id, name);
                    continue;
                }
                if (!tmpCRFIdMap.containsKey(id)) continue;
                tmpCRFIdMap.remove(id);
            }
            this.session.setAttribute("tmpCRFIdMap", tmpCRFIdMap);
            EntityBeanTable table = fp.getEntityBeanTable();
            ArrayList allRows = CRFRow.generateRowsFromBeans((ArrayList)crfsWithVersion);
            String[] columns = new String[]{resword.getString("CRF_name"), resword.getString("date_created"), resword.getString("owner"), resword.getString("date_updated"), resword.getString("last_updated_by"), resword.getString("selected")};
            table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
            table.hideColumnLink(5);
            StudyEventDefinitionBean def1 = (StudyEventDefinitionBean)this.session.getAttribute("definition");
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("actionName", "next");
            args.put("pageNum", "1");
            args.put("name", URLEncoder.encode(def1.getName(), "UTF-8"));
            args.put("repeating", new Boolean(def1.isRepeating()).toString());
            args.put("category", def1.getCategory());
            args.put("description", URLEncoder.encode(def1.getDescription(), "UTF-8"));
            args.put("type", def1.getType());
            table.setQuery("DefineStudyEvent", args, true);
            table.setRows(allRows);
            table.computeDisplay();
            this.request.setAttribute("table", (Object)table);
            this.forwardPage(Page.DEFINE_STUDY_EVENT2);
        } else {
            logger.debug("has validation errors in the first section");
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.DEFINE_STUDY_EVENT1);
        }
    }

    private void confirmWholeDefinition() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        StudyEventDefinitionBean sed = (StudyEventDefinitionBean)this.session.getAttribute("definition");
        ArrayList<EventDefinitionCRFBean> eventDefinitionCRFs = new ArrayList<EventDefinitionCRFBean>();
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        for (int i = 0; i < sed.getCrfs().size(); ++i) {
            EventDefinitionCRFBean edcBean = new EventDefinitionCRFBean();
            int crfId = fp.getInt("crfId" + i);
            int defaultVersionId = fp.getInt("defaultVersionId" + i);
            edcBean.setCrfId(crfId);
            edcBean.setDefaultVersionId(defaultVersionId);
            CRFVersionBean defaultVersion = (CRFVersionBean)cvdao.findByPK(edcBean.getDefaultVersionId());
            edcBean.setDefaultVersionName(defaultVersion.getName());
            String crfName = fp.getString("crfName" + i);
            edcBean.setCrfName(crfName);
            String requiredCRF = fp.getString("requiredCRF" + i);
            String doubleEntry = fp.getString("doubleEntry" + i);
            String decisionCondition = fp.getString("decisionCondition" + i);
            String electronicSignature = fp.getString("electronicSignature" + i);
            String participantForm = fp.getString("participantForm" + i);
            String allowAnonymousSubmission = fp.getString("allowAnonymousSubmission" + i);
            String submissionUrl = fp.getString("submissionUrl" + i);
            String offline = fp.getString("offline" + i);
            String hiddenCrf = fp.getString("hiddenCrf" + i);
            if (!StringUtil.isBlank((String)hiddenCrf) && "yes".equalsIgnoreCase(hiddenCrf.trim())) {
                edcBean.setHideCrf(true);
            } else {
                edcBean.setHideCrf(false);
            }
            String sdvOption = fp.getString("sdvOption" + i);
            if (!StringUtils.isBlank((String)sdvOption)) {
                int id = Integer.valueOf(sdvOption);
                edcBean.setSourceDataVerification(SourceDataVerification.getByCode((Integer)id));
            }
            if (!StringUtils.isBlank((String)requiredCRF) && "yes".equalsIgnoreCase(requiredCRF.trim())) {
                edcBean.setRequiredCRF(true);
            } else {
                edcBean.setRequiredCRF(false);
            }
            if (!StringUtils.isBlank((String)participantForm) && "yes".equalsIgnoreCase(participantForm.trim())) {
                edcBean.setParticipantForm(true);
            } else {
                edcBean.setParticipantForm(false);
            }
            if (edcBean.isParticipantForm() && !StringUtils.isBlank((String)allowAnonymousSubmission) && "yes".equalsIgnoreCase(allowAnonymousSubmission.trim())) {
                edcBean.setAllowAnonymousSubmission(true);
            } else {
                edcBean.setAllowAnonymousSubmission(false);
            }
            if (!StringUtils.isBlank((String)offline) && "yes".equalsIgnoreCase(offline.trim())) {
                edcBean.setOffline(true);
            } else {
                edcBean.setOffline(false);
            }
            if (!StringUtils.isBlank((String)doubleEntry) && "yes".equalsIgnoreCase(doubleEntry.trim())) {
                edcBean.setDoubleEntry(true);
            } else {
                edcBean.setDoubleEntry(false);
            }
            if (!StringUtils.isBlank((String)decisionCondition) && "yes".equalsIgnoreCase(decisionCondition.trim())) {
                edcBean.setDecisionCondition(true);
            } else {
                edcBean.setDecisionCondition(false);
            }
            if (!StringUtils.isBlank((String)electronicSignature) && "yes".equalsIgnoreCase(electronicSignature.trim())) {
                edcBean.setElectronicSignature(true);
            } else {
                edcBean.setElectronicSignature(false);
            }
            if (edcBean.isParticipantForm() && edcBean.isAllowAnonymousSubmission()) {
                edcBean.setSubmissionUrl(submissionUrl.trim());
            }
            ArrayList versions = cvdao.findAllByCRFId(crfId);
            edcBean.setVersions(versions);
            String nullString = "";
            ArrayList nulls = NullValue.toArrayList();
            for (int a = 0; a < nulls.size(); ++a) {
                NullValue n = (NullValue)nulls.get(a);
                String myNull = fp.getString(n.getName().toLowerCase() + i);
                if (StringUtils.isBlank((String)myNull) || !"yes".equalsIgnoreCase(myNull.trim())) continue;
                nullString = nullString + n.getName().toUpperCase() + ",";
            }
            edcBean.setNullValues(nullString);
            edcBean.setStudyId(this.ub.getActiveStudyId());
            eventDefinitionCRFs.add(edcBean);
        }
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
        this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
        if (participateFormStatus.equals("enabled")) {
            this.baseUrl();
        }
        this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
        this.request.setAttribute("eventDefinitionCRFs", eventDefinitionCRFs);
        this.session.setAttribute("edCRFs", eventDefinitionCRFs);
        ArrayList edcsInSession = (ArrayList)this.session.getAttribute("edCRFs");
        int parentStudyId = sed.getStudyId();
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        ArrayList eventDefCrfList = edcdao.findAllActiveSitesAndStudiesPerParentStudy(parentStudyId);
        if (eventDefCrfList.size() != 0) {
            this.validateSubmissionUrl(edcsInSession, eventDefCrfList, v);
        }
        this.errors = v.validate();
        if (!this.errors.isEmpty()) {
            ArrayList<String> sdvOptions = new ArrayList<String>();
            sdvOptions.add(SourceDataVerification.AllREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.PARTIALREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.NOTREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.NOTAPPLICABLE.toString());
            this.request.setAttribute("sdvOptions", sdvOptions);
            logger.info("has errors");
            this.session.setAttribute("eventDefinitionCRFs", eventDefinitionCRFs);
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.DEFINE_STUDY_EVENT4);
        }
        this.forwardPage(Page.DEFINE_STUDY_EVENT_CONFIRM);
    }

    private StudyEventDefinitionBean createStudyEventDefinition() {
        FormProcessor fp = new FormProcessor(this.request);
        StudyEventDefinitionBean sed = (StudyEventDefinitionBean)this.session.getAttribute("definition");
        try {
            String name = URLDecoder.decode(this.request.getParameter("name"), "UTF-8");
            String description = URLDecoder.decode(this.request.getParameter("description"), "UTF-8");
            sed.setName(name);
            sed.setDescription(description);
        }
        catch (Exception e) {
            sed.setName(fp.getString("name"));
            sed.setDescription(fp.getString("description"));
        }
        String temp = fp.getString("repeating");
        if ("true".equalsIgnoreCase(temp) || "1".equals(temp)) {
            sed.setRepeating(true);
        } else if ("false".equalsIgnoreCase(temp) || "0".equals(temp)) {
            sed.setRepeating(false);
        }
        sed.setCategory(fp.getString("category"));
        sed.setType(fp.getString("type"));
        return sed;
    }

    private void confirmDefinition2() throws Exception {
        String participateFormStatus;
        ArrayList versions;
        CRFBean cb;
        String name;
        int id;
        FormProcessor fp = new FormProcessor(this.request);
        CRFVersionDAO vdao = new CRFVersionDAO(this.sm.getDataSource());
        ArrayList<CRFBean> crfArray = new ArrayList<CRFBean>();
        HashMap tmpCRFIdMap = (HashMap)this.session.getAttribute("tmpCRFIdMap");
        if (tmpCRFIdMap == null) {
            tmpCRFIdMap = new HashMap();
        }
        ArrayList crfsWithVersion = (ArrayList)this.session.getAttribute("crfsWithVersion");
        for (int i = 0; i < crfsWithVersion.size(); ++i) {
            id = fp.getInt("id" + i);
            name = fp.getString("name" + i);
            String selected = fp.getString("selected" + i);
            if (!StringUtils.isBlank((String)selected) && "yes".equalsIgnoreCase(selected.trim())) {
                logger.debug("one crf selected");
                cb = new CRFBean();
                cb.setId(id);
                cb.setName(name);
                versions = (ArrayList)vdao.findAllActiveByCRF(cb.getId());
                cb.setVersions(versions);
                crfArray.add(cb);
                continue;
            }
            if (!tmpCRFIdMap.containsKey(id)) continue;
            tmpCRFIdMap.remove(id);
        }
        Iterator tmpCRFIterator = tmpCRFIdMap.keySet().iterator();
        while (tmpCRFIterator.hasNext()) {
            id = (Integer)tmpCRFIterator.next();
            name = (String)tmpCRFIdMap.get(id);
            boolean isExists = false;
            for (CRFBean cb2 : crfArray) {
                if (id != cb2.getId()) continue;
                isExists = true;
            }
            if (isExists) continue;
            cb = new CRFBean();
            cb.setId(id);
            cb.setName(name);
            versions = (ArrayList)vdao.findAllActiveByCRF(cb.getId());
            cb.setVersions(versions);
            crfArray.add(cb);
        }
        this.session.removeAttribute("tmpCRFIdMap");
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        if (crfArray.size() == 0) {
            this.addPageMessage(respage.getString("no_CRF_selected_for_definition_add_later"));
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)this.session.getAttribute("definition");
            sed.setCrfs(new ArrayList());
            participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            this.session.setAttribute("definition", (Object)sed);
            this.request.setAttribute("eventDefinitionCRFs", new ArrayList());
            this.session.setAttribute("edCRFs", new ArrayList());
            this.forwardPage(Page.DEFINE_STUDY_EVENT_CONFIRM);
        } else {
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)this.session.getAttribute("definition");
            sed.setCrfs(crfArray);
            this.session.setAttribute("eventDefinitionCRFs", new ArrayList());
            this.session.setAttribute("definition", (Object)sed);
            participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            if (participateFormStatus.equals("enabled")) {
                this.baseUrl();
            }
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            ArrayList<String> sdvOptions = new ArrayList<String>();
            sdvOptions.add(SourceDataVerification.AllREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.PARTIALREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.NOTREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.NOTAPPLICABLE.toString());
            this.request.setAttribute("sdvOptions", sdvOptions);
            this.forwardPage(Page.DEFINE_STUDY_EVENT3);
        }
    }

    private void submitDefinition() throws NullPointerException {
        StudyEventDefinitionDAO edao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        StudyEventDefinitionBean sed = (StudyEventDefinitionBean)this.session.getAttribute("definition");
        if (sed.getName() == "" || sed.getName() == null) {
            throw new NullPointerException();
        }
        logger.debug("Definition bean to be created:" + sed.getName() + sed.getStudyId());
        ArrayList defs = edao.findAllByStudy(this.currentStudy);
        if (defs == null || defs.isEmpty()) {
            sed.setOrdinal(1);
        } else {
            int lastCount = defs.size() - 1;
            StudyEventDefinitionBean last = (StudyEventDefinitionBean)defs.get(lastCount);
            sed.setOrdinal(last.getOrdinal() + 1);
        }
        sed.setOwner(this.ub);
        sed.setCreatedDate(new Date());
        sed.setStatus(Status.AVAILABLE);
        StudyEventDefinitionBean sed1 = (StudyEventDefinitionBean)edao.create((EntityBean)sed);
        EventDefinitionCRFDAO cdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        ArrayList eventDefinitionCRFs = new ArrayList();
        if (this.session.getAttribute("edCRFs") != null) {
            eventDefinitionCRFs = (ArrayList)this.session.getAttribute("edCRFs");
        }
        for (int i = 0; i < eventDefinitionCRFs.size(); ++i) {
            EventDefinitionCRFBean edc = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
            edc.setOwner(this.ub);
            edc.setCreatedDate(new Date());
            edc.setStatus(Status.AVAILABLE);
            edc.setStudyEventDefinitionId(sed1.getId());
            edc.setOrdinal(i + 1);
            StudyEventDefinitionBean sedBean = (StudyEventDefinitionBean)seddao.findByPK(sed.getId());
            CRFBean cBean = (CRFBean)crfdao.findByPK(edc.getCrfId());
            String crfPath = sedBean.getOid() + "." + cBean.getOid();
            this.getEventDefinitionCrfTagService().saveEventDefnCrfOfflineTag(2, crfPath, edc, sedBean);
            cdao.create((EntityBean)edc);
        }
        this.session.removeAttribute("definition");
        this.session.removeAttribute("edCRFs");
        this.session.removeAttribute("crfsWithVersion");
        this.addPageMessage(respage.getString("the_new_event_definition_created_succesfully"));
    }

    public void validateSubmissionUrl(ArrayList<EventDefinitionCRFBean> edcsInSession, ArrayList<EventDefinitionCRFBean> eventDefCrfList, Validator v) {
        for (int i = 0; i < edcsInSession.size(); ++i) {
            v.addValidation("submissionUrl" + i, 44);
            EventDefinitionCRFBean sessionBean = null;
            boolean isExist = false;
            for (EventDefinitionCRFBean eventDef : eventDefCrfList) {
                sessionBean = edcsInSession.get(i);
                if (!sessionBean.isAllowAnonymousSubmission() || !sessionBean.isParticipantForm()) {
                    isExist = true;
                    break;
                }
                logger.debug("iter:           {}--db:    {}", (Object)eventDef.getId(), (Object)eventDef.getSubmissionUrl());
                logger.debug("edcsInSession:  {}--session: {}", (Object)sessionBean.getId(), (Object)sessionBean.getSubmissionUrl());
                if (sessionBean.getSubmissionUrl() == null || sessionBean.getSubmissionUrl().equals("")) break;
                if (eventDef.getSubmissionUrl().trim().equalsIgnoreCase(sessionBean.getSubmissionUrl().trim()) && eventDef.getId() != sessionBean.getId() || eventDef.getSubmissionUrl().trim().equalsIgnoreCase(sessionBean.getSubmissionUrl().trim()) && eventDef.getId() == sessionBean.getId() && sessionBean.getId() == 0) {
                    v.addValidation("submissionUrl" + i, 45);
                    logger.debug("Duplicate *************************");
                    isExist = true;
                    break;
                }
                if (!eventDef.getSubmissionUrl().trim().equalsIgnoreCase(sessionBean.getSubmissionUrl().trim()) || eventDef.getId() != sessionBean.getId() || sessionBean.getId() == 0) continue;
                logger.debug("Not Duplicate *********");
                isExist = true;
                break;
            }
            if (isExist) continue;
            eventDefCrfList.add(sessionBean);
        }
    }

    public EventDefinitionCrfTagService getEventDefinitionCrfTagService() {
        this.eventDefinitionCrfTagService = this.eventDefinitionCrfTagService != null ? this.eventDefinitionCrfTagService : (EventDefinitionCrfTagService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("eventDefinitionCrfTagService");
        return this.eventDefinitionCrfTagService;
    }
}

