/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.managestudy.CreateStudyServlet;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.service.StudyConfigService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class InitUpdateStudyServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
    }

    public void processRequest() throws Exception {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        String idString = this.request.getParameter("id");
        logger.info("study id:" + idString);
        if (StringUtil.isBlank((String)idString)) {
            this.addPageMessage(respage.getString("please_choose_a_study_to_edit"));
            this.forwardPage(Page.STUDY_LIST_SERVLET);
        } else {
            int studyId = Integer.valueOf(idString.trim());
            StudyBean study = (StudyBean)sdao.findByPK(studyId);
            StudyConfigService scs = new StudyConfigService(this.sm.getDataSource());
            study = scs.setParametersForStudy(study);
            logger.info("date created:" + study.getCreatedDate());
            logger.info("protocol Type:" + study.getProtocolType());
            this.session.setAttribute("newStudy", (Object)study);
            this.request.setAttribute("facRecruitStatusMap", (Object)CreateStudyServlet.facRecruitStatusMap);
            this.request.setAttribute("statuses", (Object)Status.toActiveArrayList());
            this.resetPanel();
            this.panel.setStudyInfoShown(false);
            this.panel.setOrderedData(true);
            this.panel.setExtractData(false);
            this.panel.setSubmitDataModule(false);
            this.panel.setCreateDataset(false);
            this.panel.setIconInfoShown(true);
            this.panel.setManageSubject(false);
            this.forwardPage(Page.UPDATE_STUDY1);
        }
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

