/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.StudyEventDefinitionRow;

public class ListEventDefinitionServlet
extends SecureController {
    Locale locale;

    public void mayProceed() throws InsufficientPermissionException {
        this.session.removeAttribute("tmpCRFIdMap");
        this.session.removeAttribute("crfsWithVersion");
        this.session.removeAttribute("eventDefinitionCRFs");
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MANAGE_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        StudyEventDefinitionDAO edao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        UserAccountDAO sdao = new UserAccountDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        CRFDAO crfDao = new CRFDAO(this.sm.getDataSource());
        CRFVersionDAO crfVersionDao = new CRFVersionDAO(this.sm.getDataSource());
        ArrayList seds = edao.findAllByStudy(this.currentStudy);
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
        for (int i = 0; i < seds.size(); ++i) {
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seds.get(i);
            Collection eventDefinitionCRFlist = edcdao.findAllParentsByDefinition(sed.getId());
            LinkedHashMap<String, String> crfWithDefaultVersion = new LinkedHashMap<String, String>();
            for (EventDefinitionCRFBean edcBean : eventDefinitionCRFlist) {
                CRFBean crfBean = (CRFBean)crfDao.findByPK(edcBean.getCrfId());
                CRFVersionBean crfVersionBean = (CRFVersionBean)crfVersionDao.findByPK(edcBean.getDefaultVersionId());
                logger.info("ED[" + sed.getName() + "]crf[" + crfBean.getName() + "]dv[" + crfVersionBean.getName() + "]");
                crfWithDefaultVersion.put(crfBean.getName(), crfVersionBean.getName());
            }
            sed.setCrfsWithDefaultVersion(crfWithDefaultVersion);
            logger.info("CRF size [" + sed.getCrfs().size() + "]");
            if (sed.getUpdater().getId() == 0) {
                sed.setUpdater(sed.getOwner());
                sed.setUpdatedDate(sed.getCreatedDate());
            }
            if (!this.isPopulated(sed, sedao)) continue;
            sed.setPopulated(true);
        }
        FormProcessor fp = new FormProcessor(this.request);
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList allStudyRows = StudyEventDefinitionRow.generateRowsFromBeans((ArrayList)seds);
        String[] columns = new String[]{resword.getString("order"), resword.getString("name"), resword.getString("OID"), resword.getString("repeating"), resword.getString("type"), resword.getString("category"), resword.getString("populated"), resword.getString("date_created"), resword.getString("date_updated"), resword.getString("CRFs"), resword.getString("default_version"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(2);
        table.hideColumnLink(3);
        table.hideColumnLink(4);
        table.hideColumnLink(6);
        table.hideColumnLink(7);
        table.hideColumnLink(8);
        table.hideColumnLink(9);
        table.hideColumnLink(10);
        table.hideColumnLink(11);
        table.hideColumnLink(12);
        table.setQuery("ListEventDefinition", new HashMap());
        table.setRows(allStudyRows);
        table.setPaginated(false);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        this.request.setAttribute("defSize", (Object)new Integer(seds.size()));
        if (this.request.getParameter("read") != null && this.request.getParameter("read").equals("true")) {
            this.request.setAttribute("readOnly", (Object)true);
        }
        this.forwardPage(Page.STUDY_EVENT_DEFINITION_LIST);
    }

    private boolean isPopulated(StudyEventDefinitionBean sed, StudyEventDAO sedao) {
        return sedao.countNotRemovedEvents(Integer.valueOf(sed.getId())) > 0;
    }

    private boolean isLockable(StudyEventDefinitionBean sed, StudyEventDAO sedao, EventCRFDAO ecdao, ItemDataDAO iddao) {
        ArrayList events = (ArrayList)sedao.findAllByDefinition(sed.getId());
        for (int j = 0; j < events.size(); ++j) {
            StudyEventBean event = (StudyEventBean)events.get(j);
            if (!event.getStatus().equals((Term)Status.AVAILABLE) && !event.getStatus().equals((Term)Status.DELETED)) {
                return false;
            }
            ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
            for (int k = 0; k < eventCRFs.size(); ++k) {
                EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(k);
                if (!eventCRF.getStatus().equals((Term)Status.UNAVAILABLE) && !eventCRF.getStatus().equals((Term)Status.DELETED)) {
                    return false;
                }
                ArrayList itemDatas = iddao.findAllByEventCRFId(eventCRF.getId());
                for (int a = 0; a < itemDatas.size(); ++a) {
                    ItemDataBean item = (ItemDataBean)itemDatas.get(a);
                    if (item.getStatus().equals((Term)Status.UNAVAILABLE) || item.getStatus().equals((Term)Status.DELETED)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

