/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.StudyRow;

public class ListSiteServlet
extends SecureController {
    Locale locale;

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MANAGE_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        if (this.currentStudy.getParentStudyId() > 0) {
            this.addPageMessage(respage.getString("no_sites_available_study_is_a_site"));
            this.forwardPage(Page.MENU_SERVLET);
        } else {
            StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
            ArrayList studies = (ArrayList)sdao.findAllByParent(this.currentStudy.getId());
            EntityBeanTable table = fp.getEntityBeanTable();
            ArrayList allStudyRows = StudyRow.generateRowsFromBeans((ArrayList)studies);
            String[] columns = new String[]{resword.getString("name"), resword.getString("unique_identifier"), resword.getString("OID"), resword.getString("principal_investigator"), resword.getString("facility_name"), resword.getString("date_created"), resword.getString("status"), resword.getString("actions")};
            table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
            table.hideColumnLink(2);
            table.hideColumnLink(6);
            table.setQuery("ListSite", new HashMap());
            table.setRows(allStudyRows);
            table.computeDisplay();
            this.request.setAttribute("table", (Object)table);
            if (this.request.getParameter("read") != null && this.request.getParameter("read").equals("true")) {
                this.request.setAttribute("readOnly", (Object)true);
            }
            this.session.setAttribute("fromListSite", (Object)"yes");
            this.forwardPage(Page.SITE_LIST);
        }
    }
}

