/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyGroupBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.submit.SubjectGroupMapBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RemoveSubjectGroupClassServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET, respage.getString("current_study_locked"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        FormProcessor fp = new FormProcessor(this.request);
        int classId = fp.getInt("id");
        if (classId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_subject_group_class_to_remove"));
            this.forwardPage(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET);
        } else {
            StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
            StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
            SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
            if (action.equalsIgnoreCase("confirm")) {
                StudyGroupClassBean sgcb = (StudyGroupClassBean)sgcdao.findByPK(classId);
                if (sgcb.getStatus().equals((Term)Status.DELETED)) {
                    this.addPageMessage(respage.getString("this_subject_group_class_has_been_deleted_already"));
                    this.forwardPage(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET);
                    return;
                }
                ArrayList groups = sgdao.findAllByGroupClass(sgcb);
                for (int i = 0; i < groups.size(); ++i) {
                    StudyGroupBean sg = (StudyGroupBean)groups.get(i);
                    ArrayList subjectMaps = sgmdao.findAllByStudyGroupClassAndGroup(sgcb.getId(), sg.getId());
                    sg.setSubjectMaps(subjectMaps);
                }
                this.session.setAttribute("group", (Object)sgcb);
                this.session.setAttribute("studyGroups", (Object)groups);
                this.forwardPage(Page.REMOVE_SUBJECT_GROUP_CLASS);
            } else if (action.equalsIgnoreCase("submit")) {
                StudyGroupClassBean group = (StudyGroupClassBean)this.session.getAttribute("group");
                group.setStatus(Status.DELETED);
                group.setUpdater(this.ub);
                sgcdao.update((EntityBean)group);
                ArrayList subjectMaps = sgmdao.findAllByStudyGroupClassId(group.getId());
                for (int i = 0; i < subjectMaps.size(); ++i) {
                    SubjectGroupMapBean sgmb = (SubjectGroupMapBean)subjectMaps.get(i);
                    if (sgmb.getStatus().equals((Term)Status.DELETED)) continue;
                    sgmb.setStatus(Status.AUTO_DELETED);
                    sgmb.setUpdater(this.ub);
                    sgmdao.update((EntityBean)sgmb);
                }
                this.addPageMessage(respage.getString("this_subject_group_class_was_removed_succesfully"));
                this.forwardPage(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET);
            } else {
                this.addPageMessage(respage.getString("no_action_specified"));
                this.forwardPage(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET);
            }
        }
    }
}

