/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.ViewSectionDataEntryServlet;
import org.akaza.openclinica.control.submit.CreateDiscrepancyNoteServlet;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.service.DiscrepancyNoteUtil;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InconsistentStateException;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ResolveDiscrepancyServlet
extends SecureController {
    private static final String INPUT_NOTE_ID = "noteId";
    private static final String CAN_ADMIN_EDIT = "canAdminEdit";
    private static final String EVENT_CRF_ID = "ecId";
    private static final String STUDY_SUB_ID = "studySubjectId";
    private static final String RESOLVING_NOTE = "resolving_note";
    private static final String RETURN_FROM_PROCESS_REQUEST = "returnFromProcess";
    public static final String ATTR_RESOLVE_DN = "resolveDiscrepancy";

    public Page getPageForForwarding(DiscrepancyNoteBean note, boolean isCompleted) {
        String entityType = note.getEntityType().toLowerCase();
        this.request.setAttribute("fromResolvingNotes", (Object)"yes");
        if ("subject".equalsIgnoreCase(entityType)) {
            if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
                return Page.UPDATE_SUBJECT_SERVLET;
            }
            return Page.VIEW_STUDY_SUBJECT_SERVLET;
        }
        if ("studysub".equalsIgnoreCase(entityType)) {
            if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
                return Page.UPDATE_STUDY_SUBJECT_SERVLET;
            }
            return Page.VIEW_STUDY_SUBJECT_SERVLET;
        }
        if ("studyevent".equalsIgnoreCase(entityType)) {
            if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
                return Page.UPDATE_STUDY_EVENT_SERVLET;
            }
            return Page.ENTER_DATA_FOR_STUDY_EVENT_SERVLET;
        }
        if ("itemdata".equalsIgnoreCase(entityType) || "eventcrf".equalsIgnoreCase(entityType)) {
            if (this.currentRole.getRole().equals((Term)Role.MONITOR)) {
                return Page.VIEW_SECTION_DATA_ENTRY_SERVLET;
            }
            if (!isCompleted) {
                return Page.INITIAL_DATA_ENTRY_SERVLET;
            }
            return Page.ADMIN_EDIT_SERVLET;
        }
        return null;
    }

    public boolean prepareRequestForResolution(HttpServletRequest request, DataSource ds, StudyBean currentStudy, DiscrepancyNoteBean note, boolean isCompleted) {
        String entityType = note.getEntityType().toLowerCase();
        int id = note.getEntityId();
        if ("subject".equalsIgnoreCase(entityType)) {
            StudySubjectDAO ssdao = new StudySubjectDAO(ds);
            StudySubjectBean ssb = ssdao.findBySubjectIdAndStudy(id, currentStudy);
            request.setAttribute("action", (Object)"show");
            request.setAttribute("id", (Object)String.valueOf(note.getEntityId()));
            request.setAttribute("studySubId", (Object)String.valueOf(ssb.getId()));
        } else if ("studysub".equalsIgnoreCase(entityType)) {
            request.setAttribute("action", (Object)"show");
            request.setAttribute("id", (Object)String.valueOf(note.getEntityId()));
        } else if ("eventcrf".equalsIgnoreCase(entityType)) {
            request.setAttribute("editInterview", (Object)"1");
            EventCRFDAO ecdao = new EventCRFDAO(ds);
            EventCRFBean ecb = (EventCRFBean)ecdao.findByPK(id);
            request.setAttribute("eventCRF", (Object)ecb);
            request.setAttribute(ViewSectionDataEntryServlet.EVENT_CRF_ID, (Object)(ecb.getId() + ""));
        } else if ("studyevent".equalsIgnoreCase(entityType)) {
            StudyEventDAO sedao = new StudyEventDAO(ds);
            StudyEventBean seb = (StudyEventBean)sedao.findByPK(id);
            request.setAttribute("eventId", (Object)String.valueOf(id));
            request.setAttribute("event_id", (Object)String.valueOf(id));
            request.setAttribute("ss_id", (Object)String.valueOf(seb.getStudySubjectId()));
        } else if ("itemdata".equalsIgnoreCase(entityType)) {
            ItemDataDAO iddao = new ItemDataDAO(ds);
            ItemDataBean idb = (ItemDataBean)iddao.findByPK(id);
            EventCRFDAO ecdao = new EventCRFDAO(ds);
            EventCRFBean ecb = (EventCRFBean)ecdao.findByPK(idb.getEventCRFId());
            StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
            StudySubjectBean ssb = (StudySubjectBean)ssdao.findByPK(ecb.getStudySubjectId());
            ItemFormMetadataDAO ifmdao = new ItemFormMetadataDAO(ds);
            ItemFormMetadataBean ifmb = ifmdao.findByItemIdAndCRFVersionId(idb.getItemId(), ecb.getCRFVersionId());
            if (this.currentRole.getRole().equals((Term)Role.MONITOR) || !isCompleted) {
                StudyEventDAO sedao = new StudyEventDAO(ds);
                StudyEventBean seb = (StudyEventBean)sedao.findByPK(id);
                request.setAttribute(EVENT_CRF_ID, (Object)String.valueOf(idb.getEventCRFId()));
                request.setAttribute(STUDY_SUB_ID, (Object)String.valueOf(seb.getStudySubjectId()));
                request.setAttribute("eventCRFId", (Object)String.valueOf(idb.getEventCRFId()));
                request.setAttribute("sectionId", (Object)String.valueOf(ifmb.getSectionId()));
            } else {
                request.setAttribute("eventCRFId", (Object)String.valueOf(idb.getEventCRFId()));
                request.setAttribute("sectionId", (Object)String.valueOf(ifmb.getSectionId()));
            }
            DataEntryStage dataEntryStage = ecb.getStage();
        }
        return true;
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int noteId = fp.getInt(INPUT_NOTE_ID);
        String module = (String)this.session.getAttribute("module");
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.sm.getDataSource());
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
        dndao.setFetchMapping(true);
        DiscrepancyNoteBean discrepancyNoteBean = (DiscrepancyNoteBean)dndao.findByPK(noteId);
        if (!discrepancyNoteBean.isActive()) {
            throw new InconsistentStateException(Page.MANAGE_STUDY_SERVLET, resexception.getString("you_are_trying_resolve_discrepancy_not_exist"));
        }
        ArrayList children = dndao.findAllByParent(discrepancyNoteBean);
        discrepancyNoteBean.setChildren(children);
        String entityType = discrepancyNoteBean.getEntityType().toLowerCase();
        discrepancyNoteBean.setResStatus(ResolutionStatus.get((int)discrepancyNoteBean.getResolutionStatusId()));
        discrepancyNoteBean.setDisType(DiscrepancyNoteType.get((int)discrepancyNoteBean.getDiscrepancyNoteTypeId()));
        if (this.currentRole.getRole().equals((Term)Role.MONITOR) && !"itemdata".equalsIgnoreCase(entityType) && !"eventcrf".equalsIgnoreCase(entityType)) {
            this.redirectMonitor(module, discrepancyNoteBean);
            return;
        }
        if (this.currentStudy.getStatus().isFrozen() && !"itemdata".equalsIgnoreCase(entityType) && !"eventcrf".equalsIgnoreCase(entityType)) {
            this.redirectMonitor(module, discrepancyNoteBean);
            return;
        }
        boolean toView = false;
        boolean isCompleted = false;
        if ("itemdata".equalsIgnoreCase(entityType)) {
            ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
            ItemDataBean idb = (ItemDataBean)iddao.findByPK(discrepancyNoteBean.getEntityId());
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            EventCRFBean ecb = (EventCRFBean)ecdao.findByPK(idb.getEventCRFId());
            StudySubjectBean studySubjectBean = (StudySubjectBean)studySubjectDAO.findByPK(ecb.getStudySubjectId());
            discrepancyNoteBean.setSubjectId(studySubjectBean.getId());
            discrepancyNoteBean.setItemId(idb.getItemId());
            if (ecb.getStatus().equals((Term)Status.UNAVAILABLE)) {
                isCompleted = true;
            }
            toView = true;
        }
        boolean goNext = this.prepareRequestForResolution(this.request, this.sm.getDataSource(), this.currentStudy, discrepancyNoteBean, isCompleted);
        Page p = this.getPageForForwarding(discrepancyNoteBean, isCompleted);
        if (p == null) {
            throw new InconsistentStateException(Page.VIEW_DISCREPANCY_NOTES_IN_STUDY_SERVLET, resexception.getString("the_discrepancy_note_triying_resolve_has_invalid_type"));
        }
        if (p.getFileName().contains("?")) {
            if (!p.getFileName().contains("fromViewNotes=1")) {
                p.setFileName(p.getFileName() + "&fromViewNotes=1");
            }
        } else {
            p.setFileName(p.getFileName() + "?fromViewNotes=1");
        }
        String createNoteURL = CreateDiscrepancyNoteServlet.getAddChildURL((DiscrepancyNoteBean)discrepancyNoteBean, (ResolutionStatus)ResolutionStatus.CLOSED, (boolean)true);
        this.setPopUpURL(createNoteURL);
        if (!goNext) {
            this.setPopUpURL("");
            this.addPageMessage(respage.getString("you_may_not_perform_admin_edit_on_CRF_not_completed_by_user"));
            p = Page.VIEW_DISCREPANCY_NOTES_IN_STUDY_SERVLET;
        }
        this.request.setAttribute(ATTR_RESOLVE_DN, (Object)true);
        this.forwardPage(p);
    }

    public static boolean noteIsClosed(DiscrepancyNoteBean note) {
        if (note.getResolutionStatusId() == ResolutionStatus.CLOSED.getId()) {
            return true;
        }
        ArrayList children = note.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            DiscrepancyNoteBean child = (DiscrepancyNoteBean)children.get(i);
            if (child.getResolutionStatusId() != ResolutionStatus.CLOSED.getId()) continue;
            return true;
        }
        return false;
    }

    public static boolean parentNoteIsClosed(DiscrepancyNoteBean parentNote) {
        return parentNote.getResolutionStatusId() == ResolutionStatus.CLOSED.getId();
    }

    protected void mayProceed() throws InsufficientPermissionException {
        String module = (String)this.session.getAttribute("module");
        if (module != null) {
            this.session.removeAttribute("module");
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR) || this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT) || this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT2) || this.currentRole.getRole().equals((Term)Role.MONITOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_permission_to_resolve_discrepancy") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director_or_study_coordinator"), "1");
    }

    private void redirectMonitor(String module, DiscrepancyNoteBean discrepancyNoteBean) {
        if (discrepancyNoteBean != null) {
            String createNoteURL = "";
            String entityType = discrepancyNoteBean.getEntityType().toLowerCase();
            int entityId = discrepancyNoteBean.getEntityId();
            RequestDispatcher dispatcher = null;
            DiscrepancyNoteUtil discNoteUtil = new DiscrepancyNoteUtil();
            if (!(entityType == null || "".equalsIgnoreCase(entityType) || "itemdata".equalsIgnoreCase(entityType) || "eventcrf".equalsIgnoreCase(entityType))) {
                if ("studySub".equalsIgnoreCase(entityType)) {
                    dispatcher = this.request.getRequestDispatcher("/ViewStudySubject?id=" + entityId + "&module=" + module);
                    discrepancyNoteBean.setSubjectId(entityId);
                } else if ("subject".equalsIgnoreCase(entityType)) {
                    int studySubId = discNoteUtil.getStudySubjectIdForDiscNote(discrepancyNoteBean, this.sm.getDataSource(), this.currentStudy.getId());
                    dispatcher = this.request.getRequestDispatcher("/ViewStudySubject?id=" + studySubId + "&module=" + module);
                    discrepancyNoteBean.setSubjectId(studySubId);
                } else if ("studyevent".equalsIgnoreCase(entityType)) {
                    dispatcher = this.request.getRequestDispatcher("/EnterDataForStudyEvent?eventId=" + entityId);
                }
                createNoteURL = CreateDiscrepancyNoteServlet.getAddChildURL((DiscrepancyNoteBean)discrepancyNoteBean, (ResolutionStatus)ResolutionStatus.CLOSED, (boolean)true);
                this.request.setAttribute("popUpURL", (Object)createNoteURL);
                try {
                    if (dispatcher != null) {
                        dispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
                    }
                }
                catch (ServletException e) {
                    logger.error("Dispatcher is not working properly: ", (Throwable)e);
                }
                catch (IOException e) {
                    logger.error("Error in dispatcher: ", (Throwable)e);
                }
            }
        }
    }
}

