/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Date;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayEventCRFBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RestoreEventCRFServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int eventCRFId = fp.getInt("id");
        int studySubId = fp.getInt("studySubId");
        this.checkStudyLocked("ViewStudySubject?id" + studySubId, respage.getString("current_study_locked"));
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        if (eventCRFId == 0) {
            this.addPageMessage(respage.getString("please_choose_an_event_CRF_to_restore"));
            this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
            this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
        } else {
            EventCRFBean eventCRF = (EventCRFBean)ecdao.findByPK(eventCRFId);
            StudySubjectBean studySub = (StudySubjectBean)subdao.findByPK(studySubId);
            Status s = studySub.getStatus();
            if ("removed".equalsIgnoreCase(s.getName()) || "auto-removed".equalsIgnoreCase(s.getName())) {
                this.addPageMessage(resword.getString("event_CRF") + resterm.getString("could_not_be") + resterm.getString("restored") + "." + respage.getString("study_subject_has_been_deleted"));
                this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
                this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            }
            this.request.setAttribute("studySub", (Object)studySub);
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
            int crfVersionId = eventCRF.getCRFVersionId();
            CRFBean cb = cdao.findByVersionId(crfVersionId);
            eventCRF.setCrf(cb);
            CRFVersionBean cvb = (CRFVersionBean)cvdao.findByPK(crfVersionId);
            eventCRF.setCrfVersion(cvb);
            int studyEventId = eventCRF.getStudyEventId();
            StudyEventBean event = (StudyEventBean)sedao.findByPK(studyEventId);
            int studyEventDefinitionId = sedao.getDefinitionIdFromStudyEventId(studyEventId);
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seddao.findByPK(studyEventDefinitionId);
            event.setStudyEventDefinition(sed);
            this.request.setAttribute("event", (Object)event);
            EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
            StudyBean study = (StudyBean)sdao.findByPK(studySub.getStudyId());
            EventDefinitionCRFBean edc = edcdao.findByStudyEventDefinitionIdAndCRFId(study, studyEventDefinitionId, cb.getId());
            DisplayEventCRFBean dec = new DisplayEventCRFBean();
            dec.setEventCRF(eventCRF);
            dec.setFlags(eventCRF, this.ub, this.currentRole, edc.isDoubleEntry());
            ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
            ArrayList itemData = iddao.findAllByEventCRFId(eventCRF.getId());
            this.request.setAttribute("items", (Object)itemData);
            String action = this.request.getParameter("action");
            if ("confirm".equalsIgnoreCase(action)) {
                if (!eventCRF.getStatus().equals((Term)Status.DELETED) && !eventCRF.getStatus().equals((Term)Status.AUTO_DELETED)) {
                    this.addPageMessage(respage.getString("this_event_CRF_avilable_for_study") + "  " + respage.getString("please_contact_sysadmin_for_more_information"));
                    this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
                    this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
                    return;
                }
                this.request.setAttribute("displayEventCRF", (Object)dec);
                this.forwardPage(Page.RESTORE_EVENT_CRF);
            } else {
                logger.info("submit to restore the event CRF from study");
                eventCRF.setStatus(Status.AVAILABLE);
                eventCRF.setUpdater(this.ub);
                eventCRF.setUpdatedDate(new Date());
                ecdao.update((EntityBean)eventCRF);
                for (int a = 0; a < itemData.size(); ++a) {
                    ItemDataBean item = (ItemDataBean)itemData.get(a);
                    if (!item.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                    item.setStatus(Status.AVAILABLE);
                    item.setUpdater(this.ub);
                    item.setUpdatedDate(new Date());
                    iddao.update((EntityBean)item);
                }
                String emailBody = respage.getString("the_event_CRF") + cb.getName() + " " + respage.getString("has_been_restored_to_the_event") + " " + event.getStudyEventDefinition().getName() + ".";
                this.addPageMessage(emailBody);
                this.sendEmail(emailBody);
                this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
                this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            }
        }
    }

    private void sendEmail(String emailBody) throws Exception {
        logger.info("Sending email...");
        this.sendEmail(this.ub.getEmail().trim(), respage.getString("restore_event_CRF_to_event"), emailBody, Boolean.valueOf(false));
        this.sendEmail(EmailEngine.getAdminEmail(), respage.getString("restore_event_CRF_to_event"), emailBody, Boolean.valueOf(false));
        logger.info("Sending email done..");
    }
}

