/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.service.managestudy.EventDefinitionCrfTagService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RestoreEventDefinitionServlet
extends SecureController {
    EventDefinitionCrfTagService eventDefinitionCrfTagService = null;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_DEFINITION_SERVLET, respage.getString("current_study_locked"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_DEFINITION_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String idString = this.request.getParameter("id");
        int defId = Integer.valueOf(idString.trim());
        StudyEventDefinitionDAO sdao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        StudyEventDefinitionBean sed = (StudyEventDefinitionBean)sdao.findByPK(defId);
        EventDefinitionCRFDAO edao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        ArrayList eventDefinitionCRFs = (ArrayList)edao.findAllByDefinition(defId);
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        for (int i = 0; i < eventDefinitionCRFs.size(); ++i) {
            EventDefinitionCRFBean edc = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
            ArrayList versions = (ArrayList)cvdao.findAllByCRF(edc.getCrfId());
            edc.setVersions(versions);
            CRFBean crf = (CRFBean)cdao.findByPK(edc.getCrfId());
            edc.setCrfName(crf.getName());
            CRFVersionBean defaultVersion = (CRFVersionBean)cvdao.findByPK(edc.getDefaultVersionId());
            edc.setDefaultVersionName(defaultVersion.getName());
            CRFBean cBean = (CRFBean)cdao.findByPK(edc.getCrfId());
            String crfPath = sed.getOid() + "." + cBean.getOid();
            edc.setOffline(this.getEventDefinitionCrfTagService().getEventDefnCrfOfflineStatus(2, crfPath, true));
        }
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        ArrayList events = (ArrayList)sedao.findAllByDefinition(sed.getId());
        String action = this.request.getParameter("action");
        if (StringUtil.isBlank((String)idString)) {
            this.addPageMessage(respage.getString("please_choose_a_SED_to_restore"));
            this.forwardPage(Page.LIST_DEFINITION_SERVLET);
        } else if ("confirm".equalsIgnoreCase(action)) {
            if (!sed.getStatus().equals((Term)Status.DELETED)) {
                this.addPageMessage(respage.getString("this_SED_cannot_be_restored") + " " + respage.getString("please_contact_sysadmin_for_more_information"));
                this.forwardPage(Page.LIST_DEFINITION_SERVLET);
                return;
            }
            String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            if (participateFormStatus.equals("enabled")) {
                this.baseUrl();
            }
            this.request.setAttribute("definitionToRestore", (Object)sed);
            this.request.setAttribute("eventDefinitionCRFs", (Object)eventDefinitionCRFs);
            this.request.setAttribute("events", (Object)events);
            this.forwardPage(Page.RESTORE_DEFINITION);
        } else {
            logger.info("submit to restore the definition");
            sed.setStatus(Status.AVAILABLE);
            sed.setUpdater(this.ub);
            sed.setUpdatedDate(new Date());
            sdao.update((EntityBean)sed);
            for (int j = 0; j < eventDefinitionCRFs.size(); ++j) {
                EventDefinitionCRFBean edc = (EventDefinitionCRFBean)eventDefinitionCRFs.get(j);
                if (!edc.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                edc.setStatus(Status.AVAILABLE);
                edc.setUpdater(this.ub);
                edc.setUpdatedDate(new Date());
                edao.update((EntityBean)edc);
            }
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            for (int j = 0; j < events.size(); ++j) {
                StudyEventBean event = (StudyEventBean)events.get(j);
                if (!event.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                event.setStatus(Status.AVAILABLE);
                event.setUpdater(this.ub);
                event.setUpdatedDate(new Date());
                sedao.update((EntityBean)event);
                ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
                ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
                for (int k = 0; k < eventCRFs.size(); ++k) {
                    EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(k);
                    if (!eventCRF.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                    eventCRF.setStatus(Status.AVAILABLE);
                    eventCRF.setUpdater(this.ub);
                    eventCRF.setUpdatedDate(new Date());
                    ecdao.update((EntityBean)eventCRF);
                    ArrayList itemDatas = iddao.findAllByEventCRFId(eventCRF.getId());
                    for (int a = 0; a < itemDatas.size(); ++a) {
                        ItemDataBean item = (ItemDataBean)itemDatas.get(a);
                        if (!item.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                        item.setStatus(Status.AVAILABLE);
                        item.setUpdater(this.ub);
                        item.setUpdatedDate(new Date());
                        iddao.update((EntityBean)item);
                    }
                }
            }
            String emailBody = respage.getString("the_SED") + " " + sed.getName() + "(" + respage.getString("and_all_associated_event_data_restored_to_study") + this.currentStudy.getName() + ".";
            this.addPageMessage(emailBody);
            this.forwardPage(Page.LIST_DEFINITION_SERVLET);
        }
    }

    private void sendEmail(String emailBody) throws Exception {
        logger.info("Sending email...");
        boolean emailSent = this.sendEmail(this.ub.getEmail().trim(), respage.getString("restore_SED"), emailBody, Boolean.valueOf(false));
        if (emailSent) {
            this.sendEmail(EmailEngine.getAdminEmail(), respage.getString("restore_SED"), emailBody, Boolean.valueOf(false));
        }
        logger.info("Sending email done..");
    }

    public EventDefinitionCrfTagService getEventDefinitionCrfTagService() {
        this.eventDefinitionCrfTagService = this.eventDefinitionCrfTagService != null ? this.eventDefinitionCrfTagService : (EventDefinitionCrfTagService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("eventDefinitionCrfTagService");
        return this.eventDefinitionCrfTagService;
    }
}

