/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.Locale;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.StudyAuditLogTableFactory;
import org.akaza.openclinica.dao.admin.AuditDAO;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class StudyAuditLogServlet
extends SecureController {
    Locale locale;

    public static String getLink(int userId) {
        return "AuditLogStudy";
    }

    protected void processRequest() throws Exception {
        int studyId = this.currentStudy.getId();
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        AuditDAO adao = new AuditDAO(this.sm.getDataSource());
        UserAccountDAO uadao = new UserAccountDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        StudyAuditLogTableFactory factory = new StudyAuditLogTableFactory();
        factory.setSubjectDao(sdao);
        factory.setStudySubjectDao(subdao);
        factory.setUserAccountDao(uadao);
        factory.setCurrentStudy(this.currentStudy);
        String auditLogsHtml = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("auditLogsHtml", (Object)auditLogsHtml);
        this.forwardPage(Page.AUDIT_LOGS_STUDY);
    }

    protected void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR) || r.equals((Term)Role.MONITOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
    }
}

