/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.control.managestudy.StudyAuditLogTableFactory;
import org.akaza.openclinica.dao.hibernate.AuditUserLoginDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyAuditLogFilter;
import org.akaza.openclinica.dao.managestudy.StudyAuditLogSort;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.i18n.util.I18nFormatUtil;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.jmesa.core.filter.DateFilterMatcher;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Filter;
import org.jmesa.limit.FilterSet;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.DateCellEditor;
import org.jmesa.view.editor.FilterEditor;

public class StudyAuditLogTableFactory
extends AbstractTableFactory {
    private AuditUserLoginDao auditUserLoginDao;
    private StudySubjectDAO studySubjectDao;
    private UserAccountDAO userAccountDao;
    private SubjectDAO subjectDao;
    private StudyBean currentStudy;
    private ResourceBundle resword;
    private ResourceBundle resformat;

    protected String getTableName() {
        return "studyAuditLogs";
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        tableFacade.setColumnProperties(new String[]{"studySubject.label", "studySubject.secondaryLabel", "studySubject.oid", "subject.dateOfBirth", "subject.uniqueIdentifier", "studySubject.owner", "studySubject.status", "actions"});
        Row row = tableFacade.getTable().getRow();
        this.configureColumn(row.getColumn("studySubject.label"), this.resword.getString("study_subject_ID"), null, null);
        this.configureColumn(row.getColumn("studySubject.secondaryLabel"), this.resword.getString("secondary_subject_ID"), null, null);
        this.configureColumn(row.getColumn("studySubject.oid"), this.resword.getString("study_subject_oid"), null, null);
        this.configureColumn(row.getColumn("subject.dateOfBirth"), this.resword.getString("date_of_birth"), (CellEditor)new DateCellEditor(this.getDateFormat()), null);
        this.configureColumn(row.getColumn("subject.uniqueIdentifier"), this.resword.getString("person_ID"), null, null);
        this.configureColumn(row.getColumn("studySubject.owner"), this.resword.getString("created_by"), (CellEditor)new OwnerCellEditor(this, null), null, true, false);
        this.configureColumn(row.getColumn("studySubject.status"), this.resword.getString("status"), (CellEditor)new StatusCellEditor(this, null), (FilterEditor)new StatusDroplistFilterEditor(this, null));
        String actionsHeader = this.resword.getString("actions") + "&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;";
        this.configureColumn(row.getColumn("actions"), actionsHeader, (CellEditor)new ActionsCellEditor(this, null), (FilterEditor)new DefaultActionsEditor(locale), true, false);
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        super.configureTableFacade(response, tableFacade);
        tableFacade.addFilterMatcher(new MatcherKey(Date.class, "subject.dateOfBirth"), (FilterMatcher)new DateFilterMatcher(this.getDateFormat()));
        tableFacade.addFilterMatcher(new MatcherKey(Status.class, "studySubject.status"), (FilterMatcher)new GenericFilterMatecher(this, null));
        tableFacade.addFilterMatcher(new MatcherKey(UserAccountBean.class, "studySubject.owner"), (FilterMatcher)new GenericFilterMatecher(this, null));
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)this.getLocale());
        this.resformat = ResourceBundleProvider.getFormatBundle((Locale)this.getLocale());
        Limit limit = tableFacade.getLimit();
        StudyAuditLogFilter auditLogStudyFilter = this.getAuditLogStudyFilter(limit);
        if (!limit.isComplete()) {
            int totalRows = this.getStudySubjectDao().getCountWithFilter(auditLogStudyFilter, this.getCurrentStudy());
            tableFacade.setTotalRows(totalRows);
        }
        StudyAuditLogSort auditLogStudySort = this.getAuditLogStudySort(limit);
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        ArrayList items = this.getStudySubjectDao().getWithFilterAndSort(this.getCurrentStudy(), auditLogStudyFilter, auditLogStudySort, rowStart, rowEnd);
        ArrayList theItems = new ArrayList();
        for (StudySubjectBean studySubjectBean : items) {
            SubjectBean subject = (SubjectBean)this.getSubjectDao().findByPK(studySubjectBean.getSubjectId());
            UserAccountBean owner = (UserAccountBean)this.getUserAccountDao().findByPK(studySubjectBean.getOwnerId());
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("studySubject", studySubjectBean);
            h.put("studySubject.label", studySubjectBean.getLabel());
            h.put("studySubject.secondaryLabel", studySubjectBean.getSecondaryLabel());
            h.put("studySubject.oid", studySubjectBean.getOid());
            h.put("studySubject.owner", owner);
            h.put("studySubject.status", studySubjectBean.getStatus());
            h.put("subject", subject);
            h.put("subject.dateOfBirth", this.resolveBirthDay(subject.getDateOfBirth(), subject.isDobCollected(), this.getLocale()));
            h.put("subject.uniqueIdentifier", subject.getUniqueIdentifier());
            theItems.add(h);
        }
        tableFacade.setItems(theItems);
    }

    protected StudyAuditLogFilter getAuditLogStudyFilter(Limit limit) {
        StudyAuditLogFilter auditLogStudyFilter = new StudyAuditLogFilter(this.getDateFormat());
        FilterSet filterSet = limit.getFilterSet();
        Collection filters = filterSet.getFilters();
        for (Filter filter : filters) {
            String property = filter.getProperty();
            String value = filter.getValue();
            if ("studySubject.status".equalsIgnoreCase(property)) {
                value = Status.getByName((String)value).getId() + "";
            }
            auditLogStudyFilter.addFilter(property, (Object)value);
        }
        return auditLogStudyFilter;
    }

    protected StudyAuditLogSort getAuditLogStudySort(Limit limit) {
        StudyAuditLogSort auditLogStudySort = new StudyAuditLogSort();
        SortSet sortSet = limit.getSortSet();
        Collection sorts = sortSet.getSorts();
        for (Sort sort : sorts) {
            String property = sort.getProperty();
            String order = sort.getOrder().toParam();
            auditLogStudySort.addSort(property, order);
        }
        return auditLogStudySort;
    }

    public AuditUserLoginDao getAuditUserLoginDao() {
        return this.auditUserLoginDao;
    }

    public void setAuditUserLoginDao(AuditUserLoginDao auditUserLoginDao) {
        this.auditUserLoginDao = auditUserLoginDao;
    }

    private String formatDate(Date date) {
        String format = this.resformat.getString("date_format_string");
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    private String getDateFormat() {
        return this.resformat.getString("date_format_string");
    }

    public StudySubjectDAO getStudySubjectDao() {
        return this.studySubjectDao;
    }

    public void setStudySubjectDao(StudySubjectDAO studySubjectDao) {
        this.studySubjectDao = studySubjectDao;
    }

    public SubjectDAO getSubjectDao() {
        return this.subjectDao;
    }

    public void setSubjectDao(SubjectDAO subjectDao) {
        this.subjectDao = subjectDao;
    }

    public StudyBean getCurrentStudy() {
        return this.currentStudy;
    }

    public void setCurrentStudy(StudyBean currentStudy) {
        this.currentStudy = currentStudy;
    }

    public UserAccountDAO getUserAccountDao() {
        return this.userAccountDao;
    }

    public void setUserAccountDao(UserAccountDAO userAccountDao) {
        this.userAccountDao = userAccountDao;
    }

    private String resolveBirthDay(Date birthDate, boolean isDobCollected, Locale locale) {
        if (birthDate == null) {
            return "";
        }
        if (isDobCollected) {
            return I18nFormatUtil.getDateFormat((Locale)locale).format(birthDate);
        }
        Calendar c = Calendar.getInstance(locale);
        c.setTime(birthDate);
        return c.get(1) + "";
    }
}

