/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class UnlockCRFVersionServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int crfVersionId = fp.getInt("id");
        String action = fp.getString("action");
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        if (crfVersionId == 0) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study"));
            this.forwardPage(Page.CRF_LIST_SERVLET);
            return;
        }
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFVersionBean version = (CRFVersionBean)cvdao.findByPK(crfVersionId);
        CRFBean crf = (CRFBean)cdao.findByPK(version.getCrfId());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        ArrayList eventCRFs = ecdao.findAllStudySubjectByCRFVersion(crfVersionId);
        if (StringUtil.isBlank((String)action)) {
            this.request.setAttribute("crfVersionToUnlock", (Object)version);
            this.request.setAttribute("crf", (Object)crf);
            this.request.setAttribute("eventSubjectsUsingVersion", (Object)eventCRFs);
            this.forwardPage(Page.CONFIRM_UNLOCKING_CRF_VERSION);
        } else if ("confirm".equalsIgnoreCase(action)) {
            version.setStatus(Status.AVAILABLE);
            version.setUpdater(this.ub);
            cvdao.update((EntityBean)version);
            this.addPageMessage(respage.getString("crf_version_unarchived_successfully"));
            this.forwardPage(Page.CRF_LIST_SERVLET);
        }
    }
}

