/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NullValue;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.domain.SourceDataVerification;
import org.akaza.openclinica.service.managestudy.EventDefinitionCrfTagService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateEventDefinitionServlet
extends SecureController {
    EventDefinitionCrfTagService eventDefinitionCrfTagService = null;
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_DEFINITION_SERVLET, respage.getString("current_study_locked"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_permission_to_update_study_event_definition") + "<br>" + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_DEFINITION_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        if (StringUtil.isBlank((String)action)) {
            this.forwardPage(Page.UPDATE_EVENT_DEFINITION1);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.confirmDefinition();
        } else if ("submit".equalsIgnoreCase(action)) {
            this.submitDefinition();
        } else {
            this.addPageMessage(respage.getString("updating_ED_is_cancelled"));
            this.forwardPage(Page.LIST_DEFINITION_SERVLET);
        }
    }

    private void confirmDefinition() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        StudyEventDefinitionBean sed = (StudyEventDefinitionBean)this.session.getAttribute("definition");
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
        if (participateFormStatus.equals("enabled")) {
            this.baseUrl();
        }
        this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
        v.addValidation("name", 1);
        v.addValidation("name", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
        v.addValidation("description", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
        v.addValidation("category", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
        ArrayList edcsInSession = (ArrayList)this.session.getAttribute("eventDefinitionCRFs");
        int parentStudyId = sed.getStudyId();
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        ArrayList eventDefCrfList = edcdao.findAllActiveSitesAndStudiesPerParentStudy(parentStudyId);
        sed.setName(fp.getString("name"));
        sed.setRepeating(fp.getBoolean("repeating"));
        sed.setCategory(fp.getString("category"));
        sed.setDescription(fp.getString("description"));
        sed.setType(fp.getString("type"));
        this.session.setAttribute("definition", (Object)sed);
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        ArrayList edcs = (ArrayList)this.session.getAttribute("eventDefinitionCRFs");
        for (int i = 0; i < edcs.size(); ++i) {
            EventDefinitionCRFBean edcBean = (EventDefinitionCRFBean)edcs.get(i);
            if (edcBean.getStatus().equals((Term)Status.DELETED) || edcBean.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
            int defaultVersionId = fp.getInt("defaultVersionId" + i);
            edcBean.setDefaultVersionId(defaultVersionId);
            CRFVersionBean defaultVersion = (CRFVersionBean)cvdao.findByPK(edcBean.getDefaultVersionId());
            edcBean.setDefaultVersionName(defaultVersion.getName());
            String requiredCRF = fp.getString("requiredCRF" + i);
            String doubleEntry = fp.getString("doubleEntry" + i);
            String decisionCondition = fp.getString("decisionCondition" + i);
            String electronicSignature = fp.getString("electronicSignature" + i);
            String hideCRF = fp.getString("hideCRF" + i);
            int sdvId = fp.getInt("sdvOption" + i);
            String participantForm = fp.getString("participantForm" + i);
            String allowAnonymousSubmission = fp.getString("allowAnonymousSubmission" + i);
            String submissionUrl = fp.getString("submissionUrl" + i);
            String offline = fp.getString("offline" + i);
            this.logger.debug("submission: {}", (Object)submissionUrl);
            if (!StringUtil.isBlank((String)hideCRF) && "yes".equalsIgnoreCase(hideCRF.trim())) {
                edcBean.setHideCrf(true);
            } else {
                edcBean.setHideCrf(false);
            }
            if (!StringUtil.isBlank((String)requiredCRF) && "yes".equalsIgnoreCase(requiredCRF.trim())) {
                edcBean.setRequiredCRF(true);
            } else {
                edcBean.setRequiredCRF(false);
            }
            if (!StringUtil.isBlank((String)doubleEntry) && "yes".equalsIgnoreCase(doubleEntry.trim())) {
                edcBean.setDoubleEntry(true);
            } else {
                edcBean.setDoubleEntry(false);
            }
            if (!StringUtil.isBlank((String)electronicSignature) && "yes".equalsIgnoreCase(electronicSignature.trim())) {
                edcBean.setElectronicSignature(true);
            } else {
                edcBean.setElectronicSignature(false);
            }
            if (!StringUtil.isBlank((String)decisionCondition) && "yes".equalsIgnoreCase(decisionCondition.trim())) {
                edcBean.setDecisionCondition(true);
            } else {
                edcBean.setDecisionCondition(false);
            }
            if (!StringUtil.isBlank((String)participantForm) && "yes".equalsIgnoreCase(participantForm.trim())) {
                edcBean.setParticipantForm(true);
            } else {
                edcBean.setParticipantForm(false);
            }
            if (!StringUtils.isBlank((String)allowAnonymousSubmission) && "yes".equalsIgnoreCase(allowAnonymousSubmission.trim())) {
                edcBean.setAllowAnonymousSubmission(true);
            } else {
                edcBean.setAllowAnonymousSubmission(false);
            }
            edcBean.setSubmissionUrl(submissionUrl.trim());
            if (!StringUtils.isBlank((String)offline) && "yes".equalsIgnoreCase(offline.trim())) {
                edcBean.setOffline(true);
            } else {
                edcBean.setOffline(false);
            }
            String nullString = "";
            ArrayList nulls = NullValue.toArrayList();
            for (int a = 0; a < nulls.size(); ++a) {
                NullValue n = (NullValue)nulls.get(a);
                String myNull = fp.getString(n.getName().toLowerCase() + i);
                if (StringUtil.isBlank((String)myNull) || !"yes".equalsIgnoreCase(myNull.trim())) continue;
                nullString = nullString + n.getName().toUpperCase() + ",";
            }
            if (sdvId > 0 && (edcBean.getSourceDataVerification() == null || sdvId != edcBean.getSourceDataVerification().getCode())) {
                edcBean.setSourceDataVerification(SourceDataVerification.getByCode((Integer)sdvId));
            }
            edcBean.setNullValues(nullString);
            this.logger.info("found null values: " + nullString);
        }
        this.validateSubmissionUrl(edcsInSession, eventDefCrfList, v);
        this.errors = v.validate();
        if (!this.errors.isEmpty()) {
            this.logger.info("has errors");
            this.session.setAttribute("eventDefinitionCRFs", (Object)edcs);
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.UPDATE_EVENT_DEFINITION1);
        }
        this.session.setAttribute("eventDefinitionCRFs", (Object)edcs);
        this.forwardPage(Page.UPDATE_EVENT_DEFINITION_CONFIRM);
    }

    private void submitDefinition() {
        ArrayList edcs = (ArrayList)this.session.getAttribute("eventDefinitionCRFs");
        StudyEventDefinitionBean sed = (StudyEventDefinitionBean)this.session.getAttribute("definition");
        StudyEventDefinitionDAO edao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        if (sed != null) {
            this.logger.info("Definition bean to be updated:" + sed.getName() + sed.getCategory());
        }
        sed.setUpdater(this.ub);
        sed.setUpdatedDate(new Date());
        sed.setStatus(Status.AVAILABLE);
        edao.update((EntityBean)sed);
        EventDefinitionCRFDAO cdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
        for (int i = 0; i < edcs.size(); ++i) {
            EventDefinitionCRFBean edc = (EventDefinitionCRFBean)edcs.get(i);
            if (edc.getId() > 0) {
                edc.setUpdater(this.ub);
                edc.setUpdatedDate(new Date());
                this.logger.info("Status:" + edc.getStatus().getName());
                this.logger.info("version:" + edc.getDefaultVersionId());
                this.logger.info("Electronic Signature [" + edc.isElectronicSignature() + "]");
                if (!sed.isRepeating()) {
                    edc.setAllowAnonymousSubmission(false);
                    edc.setSubmissionUrl("");
                }
                cdao.update((EntityBean)edc);
                String crfPath = sed.getOid() + "." + edc.getCrf().getOid();
                this.getEventDefinitionCrfTagService().saveEventDefnCrfOfflineTag(2, crfPath, edc, sed);
                ArrayList eventDefCrfBeans = cdao.findAllByCrfDefinitionInSiteOnly(edc.getStudyEventDefinitionId(), edc.getCrfId());
                for (EventDefinitionCRFBean eventDefCrfBean : eventDefCrfBeans) {
                    eventDefCrfBean.setParticipantForm(edc.isParticipantForm());
                    eventDefCrfBean.setAllowAnonymousSubmission(edc.isAllowAnonymousSubmission());
                    cdao.update((EntityBean)eventDefCrfBean);
                }
                if (edc.getStatus().equals((Term)Status.DELETED) || edc.getStatus().equals((Term)Status.AUTO_DELETED)) {
                    this.removeAllEventsItems(edc, sed);
                }
                if (edc.getOldStatus() == null || !edc.getOldStatus().equals((Term)Status.DELETED)) continue;
                this.restoreAllEventsItems(edc, sed);
                continue;
            }
            edc.setOwner(this.ub);
            edc.setCreatedDate(new Date());
            edc.setStatus(Status.AVAILABLE);
            if (!sed.isRepeating()) {
                edc.setAllowAnonymousSubmission(false);
                edc.setSubmissionUrl("");
            }
            cdao.create((EntityBean)edc);
            CRFBean cBean = (CRFBean)crfdao.findByPK(edc.getCrfId());
            String crfPath = sed.getOid() + "." + cBean.getOid();
            this.getEventDefinitionCrfTagService().saveEventDefnCrfOfflineTag(2, crfPath, edc, sed);
        }
        this.session.removeAttribute("definition");
        this.session.removeAttribute("eventDefinitionCRFs");
        this.session.removeAttribute("tmpCRFIdMap");
        this.session.removeAttribute("crfsWithVersion");
        this.session.removeAttribute("eventDefinitionCRFs");
        this.addPageMessage(respage.getString("the_ED_has_been_updated_succesfully"));
        this.forwardPage(Page.LIST_DEFINITION_SERVLET);
    }

    public void removeAllEventsItems(EventDefinitionCRFBean edc, StudyEventDefinitionBean sed) {
        StudyEventDAO seDao = new StudyEventDAO(this.sm.getDataSource());
        EventCRFDAO ecrfDao = new EventCRFDAO(this.sm.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
        ArrayList seList = seDao.findAllByStudyEventDefinitionAndCrfOids(sed.getOid(), edc.getCrf().getOid());
        for (int j = 0; j < seList.size(); ++j) {
            StudyEventBean seBean = (StudyEventBean)seList.get(j);
            ArrayList ecrfList = ecrfDao.findAllByStudyEventAndCrfOrCrfVersionOid(seBean, edc.getCrf().getOid());
            for (int k = 0; k < ecrfList.size(); ++k) {
                EventCRFBean ecrfBean = (EventCRFBean)ecrfList.get(k);
                ecrfBean.setOldStatus(ecrfBean.getStatus());
                ecrfBean.setStatus(Status.AUTO_DELETED);
                ecrfBean.setUpdater(this.ub);
                ecrfBean.setUpdatedDate(new Date());
                ecrfDao.update((EntityBean)ecrfBean);
                ArrayList itemData = iddao.findAllByEventCRFId(ecrfBean.getId());
                for (int a = 0; a < itemData.size(); ++a) {
                    ItemDataBean item = (ItemDataBean)itemData.get(a);
                    if (item.getStatus().equals((Term)Status.DELETED)) continue;
                    item.setOldStatus(item.getStatus());
                    item.setStatus(Status.AUTO_DELETED);
                    item.setUpdater(this.ub);
                    item.setUpdatedDate(new Date());
                    iddao.update((EntityBean)item);
                    DiscrepancyNoteDAO dnDao = new DiscrepancyNoteDAO(this.sm.getDataSource());
                    ArrayList dnNotesOfRemovedItem = dnDao.findExistingNotesForItemData(item.getId());
                    if (dnNotesOfRemovedItem.isEmpty()) continue;
                    DiscrepancyNoteBean itemParentNote = null;
                    for (Object obj : dnNotesOfRemovedItem) {
                        if (((DiscrepancyNoteBean)obj).getParentDnId() != 0) continue;
                        itemParentNote = (DiscrepancyNoteBean)obj;
                    }
                    DiscrepancyNoteBean dnb = new DiscrepancyNoteBean();
                    if (itemParentNote != null) {
                        dnb.setParentDnId(itemParentNote.getId());
                        dnb.setDiscrepancyNoteTypeId(itemParentNote.getDiscrepancyNoteTypeId());
                    }
                    dnb.setResolutionStatusId(ResolutionStatus.CLOSED.getId());
                    dnb.setStudyId(this.currentStudy.getId());
                    dnb.setAssignedUserId(this.ub.getId());
                    dnb.setOwner(this.ub);
                    dnb.setEntityType("itemData");
                    dnb.setEntityId(item.getId());
                    dnb.setColumn("value");
                    dnb.setCreatedDate(new Date());
                    dnb.setDescription("The item has been removed, this Discrepancy Note has been Closed.");
                    dnDao.create((EntityBean)dnb);
                    dnDao.createMapping(dnb);
                    itemParentNote.setResolutionStatusId(ResolutionStatus.CLOSED.getId());
                    dnDao.update((EntityBean)itemParentNote);
                }
            }
        }
    }

    public void restoreAllEventsItems(EventDefinitionCRFBean edc, StudyEventDefinitionBean sed) {
        StudyEventDAO seDao = new StudyEventDAO(this.sm.getDataSource());
        EventCRFDAO ecrfDao = new EventCRFDAO(this.sm.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
        ArrayList seList = seDao.findAllByStudyEventDefinitionAndCrfOids(sed.getOid(), edc.getCrf().getOid());
        for (int j = 0; j < seList.size(); ++j) {
            StudyEventBean seBean = (StudyEventBean)seList.get(j);
            ArrayList ecrfList = ecrfDao.findAllByStudyEventAndCrfOrCrfVersionOid(seBean, edc.getCrf().getOid());
            for (int k = 0; k < ecrfList.size(); ++k) {
                EventCRFBean ecrfBean = (EventCRFBean)ecrfList.get(k);
                ecrfBean.setStatus(ecrfBean.getOldStatus());
                ecrfBean.setUpdater(this.ub);
                ecrfBean.setUpdatedDate(new Date());
                ecrfDao.update((EntityBean)ecrfBean);
                ArrayList itemData = iddao.findAllByEventCRFId(ecrfBean.getId());
                for (int a = 0; a < itemData.size(); ++a) {
                    ItemDataBean item = (ItemDataBean)itemData.get(a);
                    if (!item.getStatus().equals((Term)Status.DELETED) && !item.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                    item.setStatus(item.getOldStatus());
                    item.setUpdater(this.ub);
                    item.setUpdatedDate(new Date());
                    iddao.update((EntityBean)item);
                }
            }
        }
    }

    public void validateSubmissionUrl(ArrayList<EventDefinitionCRFBean> edcsInSession, ArrayList<EventDefinitionCRFBean> eventDefCrfList, Validator v) {
        for (int i = 0; i < edcsInSession.size(); ++i) {
            v.addValidation("submissionUrl" + i, 44);
            EventDefinitionCRFBean sessionBean = null;
            boolean isExist = false;
            for (EventDefinitionCRFBean eventDef : eventDefCrfList) {
                sessionBean = edcsInSession.get(i);
                if (!sessionBean.isAllowAnonymousSubmission() || !sessionBean.isParticipantForm()) {
                    isExist = true;
                    break;
                }
                this.logger.debug("iter:           {} --db:   {}", (Object)eventDef.getId(), (Object)eventDef.getSubmissionUrl());
                this.logger.debug("edcsInSession:  {} --session: {}", (Object)sessionBean.getId(), (Object)sessionBean.getSubmissionUrl());
                if (sessionBean.getSubmissionUrl() == null || sessionBean.getSubmissionUrl().trim().equals("")) break;
                if (eventDef.getSubmissionUrl().trim().equalsIgnoreCase(sessionBean.getSubmissionUrl().trim()) && eventDef.getId() != sessionBean.getId() || eventDef.getSubmissionUrl().trim().equalsIgnoreCase(sessionBean.getSubmissionUrl().trim()) && eventDef.getId() == sessionBean.getId() && sessionBean.getId() == 0) {
                    v.addValidation("submissionUrl" + i, 45);
                    this.logger.debug("Duplicate *********************");
                    isExist = true;
                    break;
                }
                if (!eventDef.getSubmissionUrl().trim().equalsIgnoreCase(sessionBean.getSubmissionUrl().trim()) || eventDef.getId() != sessionBean.getId() || sessionBean.getId() == 0) continue;
                this.logger.debug("Not Duplicate ********");
                isExist = true;
                break;
            }
            if (isExist) continue;
            eventDefCrfList.add(sessionBean);
        }
    }

    public EventDefinitionCrfTagService getEventDefinitionCrfTagService() {
        this.eventDefinitionCrfTagService = this.eventDefinitionCrfTagService != null ? this.eventDefinitionCrfTagService : (EventDefinitionCrfTagService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("eventDefinitionCrfTagService");
        return this.eventDefinitionCrfTagService;
    }
}

