/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.InterventionBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.managestudy.CreateStudyServlet;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class UpdateStudyServlet
extends SecureController {
    public static final String INPUT_START_DATE = "startDate";
    public static final String INPUT_END_DATE = "endDate";
    public static final String INPUT_VER_DATE = "protocolDateVerification";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.STUDY_LIST_SERVLET, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        this.panel.setExtractData(false);
        this.panel.setSubmitDataModule(false);
        this.panel.setCreateDataset(false);
        this.panel.setIconInfoShown(true);
        this.panel.setManageSubject(false);
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = (StudyBean)this.session.getAttribute("newStudy");
        if (study == null) {
            this.addPageMessage(respage.getString("please_choose_a_study_to_edit"));
            this.forwardPage(Page.STUDY_LIST_SERVLET);
            return;
        }
        String interventional = resadmin.getString("interventional");
        boolean isInterventional = interventional.equalsIgnoreCase(study.getProtocolType());
        String action = this.request.getParameter("action");
        if (StringUtil.isBlank((String)action)) {
            this.request.setAttribute("statuses", (Object)Status.toActiveArrayList());
            this.forwardPage(Page.UPDATE_STUDY1);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.confirmWholeStudy();
        } else if ("submit".equalsIgnoreCase(action)) {
            this.submitStudy();
            this.addPageMessage(respage.getString("the_study_has_been_updated_succesfully"));
            this.forwardPage(Page.STUDY_LIST_SERVLET);
        } else if ("next".equalsIgnoreCase(action)) {
            Integer pageNumber = Integer.valueOf(this.request.getParameter("pageNum"));
            if (pageNumber != null) {
                if (pageNumber == 6) {
                    this.confirmStudy6();
                } else if (pageNumber == 5) {
                    this.confirmStudy5();
                } else if (pageNumber == 4) {
                    this.confirmStudy4();
                } else if (pageNumber == 3) {
                    this.confirmStudy3(isInterventional);
                } else if (pageNumber == 2) {
                    this.confirmStudy2();
                } else {
                    logger.info("confirm study 1" + pageNumber);
                    this.confirmStudy1();
                }
            } else {
                this.session.setAttribute("newStudy", (Object)study);
                this.forwardPage(Page.UPDATE_STUDY1);
            }
        }
    }

    private void confirmStudy1() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("name", 1);
        v.addValidation("uniqueProId", 1);
        v.addValidation("description", 1);
        v.addValidation("prinInvestigator", 1);
        v.addValidation("sponsor", 1);
        v.addValidation("secondProId", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("collaborators", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 1000);
        v.addValidation("protocolDescription", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 1000);
        this.errors = v.validate();
        if (fp.getString("name").trim().length() > 100) {
            Validator.addError((HashMap)this.errors, (String)"name", (String)resexception.getString("maximum_lenght_name_100"));
        }
        if (fp.getString("uniqueProId").trim().length() > 30) {
            Validator.addError((HashMap)this.errors, (String)"uniqueProId", (String)resexception.getString("maximum_lenght_unique_protocol_30"));
        }
        if (fp.getString("description").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"description", (String)resexception.getString("maximum_lenght_brief_summary_255"));
        }
        if (fp.getString("prinInvestigator").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"prinInvestigator", (String)resexception.getString("maximum_lenght_principal_investigator_255"));
        }
        if (fp.getString("sponsor").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"sponsor", (String)resexception.getString("maximum_lenght_sponsor_255"));
        }
        if (fp.getString("officialTitle").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"officialTitle", (String)resexception.getString("maximum_lenght_official_title_255"));
        }
        this.session.setAttribute("newStudy", (Object)this.createStudyBean());
        if (this.errors.isEmpty()) {
            logger.info("no errors in the first section");
            this.request.setAttribute("studyPhaseMap", (Object)CreateStudyServlet.studyPhaseMap);
            this.request.setAttribute("statuses", (Object)Status.toActiveArrayList());
            StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
            fp.addPresetValue(INPUT_START_DATE, this.local_df.format(newStudy.getDatePlannedStart()));
            if (newStudy.getDatePlannedEnd() != null) {
                fp.addPresetValue(INPUT_END_DATE, this.local_df.format(newStudy.getDatePlannedEnd()));
            }
            fp.addPresetValue(INPUT_VER_DATE, this.local_df.format(newStudy.getProtocolDateVerification()));
            this.setPresetValues(fp.getPresetValues());
            this.forwardPage(Page.UPDATE_STUDY2);
        } else {
            logger.info("has validation errors in the first section");
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.UPDATE_STUDY1);
        }
    }

    private void confirmStudy2() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation(INPUT_START_DATE, 4);
        if (!StringUtil.isBlank((String)fp.getString(INPUT_END_DATE))) {
            v.addValidation(INPUT_END_DATE, 4);
        }
        v.addValidation(INPUT_VER_DATE, 4);
        this.errors = v.validate();
        boolean isInterventional = this.updateStudy2();
        if (this.errors.isEmpty()) {
            logger.info("no errors");
            ArrayList interventionArray = new ArrayList();
            if (isInterventional) {
                interventionArray = this.parseInterventions((StudyBean)this.session.getAttribute("newStudy"));
                this.setMaps(isInterventional, interventionArray);
                this.forwardPage(Page.UPDATE_STUDY3);
            } else {
                this.setMaps(isInterventional, interventionArray);
                this.forwardPage(Page.UPDATE_STUDY4);
            }
        } else {
            logger.info("has validation errors");
            try {
                this.local_df.parse(fp.getString(INPUT_START_DATE));
                fp.addPresetValue(INPUT_START_DATE, this.local_df.format(fp.getDate(INPUT_START_DATE)));
            }
            catch (ParseException pe) {
                fp.addPresetValue(INPUT_START_DATE, fp.getString(INPUT_START_DATE));
            }
            try {
                this.local_df.parse(fp.getString(INPUT_VER_DATE));
                fp.addPresetValue(INPUT_VER_DATE, this.local_df.format(fp.getDate(INPUT_VER_DATE)));
            }
            catch (ParseException pe) {
                fp.addPresetValue(INPUT_VER_DATE, fp.getString(INPUT_VER_DATE));
            }
            try {
                this.local_df.parse(fp.getString(INPUT_END_DATE));
                fp.addPresetValue(INPUT_END_DATE, this.local_df.format(fp.getDate(INPUT_END_DATE)));
            }
            catch (ParseException pe) {
                fp.addPresetValue(INPUT_END_DATE, fp.getString(INPUT_END_DATE));
            }
            this.setPresetValues(fp.getPresetValues());
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.request.setAttribute("studyPhaseMap", (Object)CreateStudyServlet.studyPhaseMap);
            this.request.setAttribute("statuses", (Object)Status.toActiveArrayList());
            this.forwardPage(Page.UPDATE_STUDY2);
        }
    }

    private void confirmStudy3(boolean isInterventional) throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("purpose", 1);
        for (int i = 0; i < 10; ++i) {
            String type = fp.getString("interType" + i);
            String name = fp.getString("interName" + i);
            if (!StringUtil.isBlank((String)type) && StringUtil.isBlank((String)name)) {
                v.addValidation("interName", 1);
                this.request.setAttribute("interventionError", (Object)respage.getString("name_cannot_be_blank_if_type"));
                break;
            }
            if (StringUtil.isBlank((String)name) || !StringUtil.isBlank((String)type)) continue;
            v.addValidation("interType", 1);
            this.request.setAttribute("interventionError", (Object)respage.getString("name_cannot_be_blank_if_name"));
            break;
        }
        this.errors = v.validate();
        this.updateStudy3(isInterventional);
        if (this.errors.isEmpty()) {
            logger.info("no errors");
            this.request.setAttribute("interventions", this.session.getAttribute("interventions"));
            this.forwardPage(Page.UPDATE_STUDY5);
        } else {
            logger.info("has validation errors");
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.setMaps(isInterventional, (ArrayList)this.session.getAttribute("interventions"));
            if (isInterventional) {
                this.forwardPage(Page.UPDATE_STUDY3);
            } else {
                this.forwardPage(Page.UPDATE_STUDY4);
            }
        }
    }

    private void confirmStudy4() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        Validator v = new Validator(this.request);
        v.addValidation("conditions", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 500);
        v.addValidation("keywords", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("eligibility", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 500);
        this.errors = v.validate();
        if (fp.getInt("expectedTotalEnrollment") <= 0) {
            Validator.addError((HashMap)this.errors, (String)"expectedTotalEnrollment", (String)respage.getString("expected_total_enrollment_must_be_a_positive_number"));
        }
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.setConditions(fp.getString("conditions"));
        newStudy.setKeywords(fp.getString("keywords"));
        newStudy.setEligibility(fp.getString("eligibility"));
        newStudy.setGender(fp.getString("gender"));
        newStudy.setAgeMax(fp.getString("ageMax"));
        newStudy.setAgeMin(fp.getString("ageMin"));
        newStudy.setHealthyVolunteerAccepted(fp.getBoolean("healthyVolunteerAccepted"));
        newStudy.setExpectedTotalEnrollment(fp.getInt("expectedTotalEnrollment"));
        this.session.setAttribute("newStudy", (Object)newStudy);
        this.request.setAttribute("facRecruitStatusMap", (Object)CreateStudyServlet.facRecruitStatusMap);
        if (this.errors.isEmpty()) {
            this.forwardPage(Page.UPDATE_STUDY6);
        } else {
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.UPDATE_STUDY5);
        }
    }

    private void confirmStudy5() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        Validator v = new Validator(this.request);
        if (!StringUtil.isBlank((String)fp.getString("facConEmail"))) {
            v.addValidation("facConEmail", 6);
        }
        v.addValidation("facName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facCity", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facState", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 20);
        v.addValidation("facZip", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
        v.addValidation("facCountry", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
        v.addValidation("facConName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConDegree", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConPhone", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConEmail", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        this.errors = v.validate();
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.setFacilityCity(fp.getString("facCity"));
        newStudy.setFacilityContactDegree(fp.getString("facConDrgree"));
        newStudy.setFacilityName(fp.getString("facName"));
        newStudy.setFacilityContactEmail(fp.getString("facConEmail"));
        newStudy.setFacilityContactPhone(fp.getString("facConPhone"));
        newStudy.setFacilityContactName(fp.getString("facConName"));
        newStudy.setFacilityCountry(fp.getString("facCountry"));
        newStudy.setFacilityContactDegree(fp.getString("facConDegree"));
        newStudy.setFacilityState(fp.getString("facState"));
        newStudy.setFacilityZip(fp.getString("facZip"));
        this.session.setAttribute("newStudy", (Object)newStudy);
        if (this.errors.isEmpty()) {
            this.forwardPage(Page.UPDATE_STUDY7);
        } else {
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.request.setAttribute("facRecruitStatusMap", (Object)CreateStudyServlet.facRecruitStatusMap);
            this.forwardPage(Page.UPDATE_STUDY6);
        }
    }

    private void confirmStudy6() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        Validator v = new Validator(this.request);
        v.addValidation("medlineIdentifier", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("url", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("urlDescription", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        this.errors = v.validate();
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.setMedlineIdentifier(fp.getString("medlineIdentifier"));
        newStudy.setResultsReference(fp.getBoolean("resultsReference"));
        newStudy.setUrl(fp.getString("url"));
        newStudy.setUrlDescription(fp.getString("urlDescription"));
        this.session.setAttribute("newStudy", (Object)newStudy);
        if (this.errors.isEmpty()) {
            this.forwardPage(Page.UPDATE_STUDY8);
        } else {
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.UPDATE_STUDY7);
        }
    }

    private void confirmWholeStudy() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        Validator v = new Validator(this.request);
        this.errors = v.validate();
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.getStudyParameterConfig().setCollectDob(fp.getString("collectDob"));
        newStudy.getStudyParameterConfig().setDiscrepancyManagement(fp.getString("discrepancyManagement"));
        newStudy.getStudyParameterConfig().setGenderRequired(fp.getString("genderRequired"));
        newStudy.getStudyParameterConfig().setInterviewerNameRequired(fp.getString("interviewerNameRequired"));
        newStudy.getStudyParameterConfig().setInterviewerNameDefault(fp.getString("interviewerNameDefault"));
        newStudy.getStudyParameterConfig().setInterviewDateEditable(fp.getString("interviewDateEditable"));
        newStudy.getStudyParameterConfig().setInterviewDateRequired(fp.getString("interviewDateRequired"));
        newStudy.getStudyParameterConfig().setInterviewerNameEditable(fp.getString("interviewerNameEditable"));
        newStudy.getStudyParameterConfig().setInterviewDateDefault(fp.getString("interviewDateDefault"));
        newStudy.getStudyParameterConfig().setSubjectIdGeneration(fp.getString("subjectIdGeneration"));
        newStudy.getStudyParameterConfig().setSubjectPersonIdRequired(fp.getString("subjectPersonIdRequired"));
        newStudy.getStudyParameterConfig().setSubjectIdPrefixSuffix(fp.getString("subjectIdPrefixSuffix"));
        newStudy.getStudyParameterConfig().setPersonIdShownOnCRF(fp.getString("personIdShownOnCRF"));
        this.session.setAttribute("newStudy", (Object)newStudy);
        if (this.errors.isEmpty()) {
            this.forwardPage(Page.STUDY_UPDATE_CONFIRM);
        } else {
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.UPDATE_STUDY8);
        }
    }

    private void submitStudy() {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        StudyBean study1 = (StudyBean)this.session.getAttribute("newStudy");
        logger.info("study bean to be updated:" + study1.getName());
        study1.setUpdatedDate(new Date());
        study1.setUpdater((UserAccountBean)this.session.getAttribute("userBean"));
        logger.debug("study's parentId=" + study1.getParentStudyId());
        sdao.update((EntityBean)study1);
        StudyParameterValueBean spv = new StudyParameterValueBean();
        spv.setStudyId(study1.getId());
        spv.setParameter("collectDob");
        spv.setValue(new Integer(study1.getStudyParameterConfig().getCollectDob()).toString());
        this.updateParameter(spvdao, spv);
        spv.setParameter("discrepancyManagement");
        spv.setValue(study1.getStudyParameterConfig().getDiscrepancyManagement());
        this.updateParameter(spvdao, spv);
        spv.setParameter("genderRequired");
        spv.setValue(study1.getStudyParameterConfig().getGenderRequired());
        this.updateParameter(spvdao, spv);
        spv.setParameter("subjectPersonIdRequired");
        spv.setValue(study1.getStudyParameterConfig().getSubjectPersonIdRequired());
        this.updateParameter(spvdao, spv);
        spv.setParameter("interviewerNameRequired");
        spv.setValue(study1.getStudyParameterConfig().getInterviewerNameRequired());
        this.updateParameter(spvdao, spv);
        spv.setParameter("interviewerNameDefault");
        spv.setValue(study1.getStudyParameterConfig().getInterviewerNameDefault());
        this.updateParameter(spvdao, spv);
        spv.setParameter("interviewerNameEditable");
        spv.setValue(study1.getStudyParameterConfig().getInterviewerNameEditable());
        this.updateParameter(spvdao, spv);
        spv.setParameter("interviewDateRequired");
        spv.setValue(study1.getStudyParameterConfig().getInterviewDateRequired());
        this.updateParameter(spvdao, spv);
        spv.setParameter("interviewDateDefault");
        spv.setValue(study1.getStudyParameterConfig().getInterviewDateDefault());
        this.updateParameter(spvdao, spv);
        spv.setParameter("interviewDateEditable");
        spv.setValue(study1.getStudyParameterConfig().getInterviewDateEditable());
        this.updateParameter(spvdao, spv);
        spv.setParameter("subjectIdGeneration");
        spv.setValue(study1.getStudyParameterConfig().getSubjectIdGeneration());
        this.updateParameter(spvdao, spv);
        spv.setParameter("subjectIdPrefixSuffix");
        spv.setValue(study1.getStudyParameterConfig().getSubjectIdPrefixSuffix());
        this.updateParameter(spvdao, spv);
        spv.setParameter("personIdShownOnCRF");
        spv.setValue(study1.getStudyParameterConfig().getPersonIdShownOnCRF());
        this.updateParameter(spvdao, spv);
        StudyBean curStudy = (StudyBean)this.session.getAttribute("study");
        if (curStudy != null && study1.getId() == curStudy.getId()) {
            this.currentStudy = study1;
            this.session.setAttribute("study", (Object)study1);
        }
        ArrayList children = (ArrayList)sdao.findAllByParent(study1.getId());
        for (int i = 0; i < children.size(); ++i) {
            StudyBean child = (StudyBean)children.get(i);
            child.setType(study1.getType());
            child.setUpdatedDate(new Date());
            child.setUpdater(this.ub);
            sdao.update((EntityBean)child);
            StudyParameterValueBean childspv = new StudyParameterValueBean();
            childspv.setStudyId(child.getId());
            childspv.setParameter("collectDob");
            childspv.setValue(new Integer(study1.getStudyParameterConfig().getCollectDob()).toString());
            this.updateParameter(spvdao, childspv);
            childspv.setParameter("genderRequired");
            childspv.setValue(study1.getStudyParameterConfig().getGenderRequired());
            this.updateParameter(spvdao, childspv);
        }
        this.session.removeAttribute("newStudy");
        this.session.removeAttribute("interventions");
    }

    private StudyBean createStudyBean() {
        FormProcessor fp = new FormProcessor(this.request);
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.setName(fp.getString("name"));
        newStudy.setOfficialTitle(fp.getString("officialTitle"));
        newStudy.setIdentifier(fp.getString("uniqueProId"));
        newStudy.setSecondaryIdentifier(fp.getString("secondProId"));
        newStudy.setPrincipalInvestigator(fp.getString("prinInvestigator"));
        newStudy.setSummary(fp.getString("description"));
        newStudy.setProtocolDescription(fp.getString("protocolDescription"));
        newStudy.setSponsor(fp.getString("sponsor"));
        newStudy.setCollaborators(fp.getString("collaborators"));
        return newStudy;
    }

    private boolean updateStudy2() {
        FormProcessor fp = new FormProcessor(this.request);
        StudyBean newStudy = (StudyBean)this.session.getAttribute("newStudy");
        newStudy.setStatus(Status.get((int)fp.getInt("statusId")));
        newStudy.setProtocolDateVerification(fp.getDate(INPUT_VER_DATE));
        newStudy.setDatePlannedStart(fp.getDate(INPUT_START_DATE));
        if (StringUtil.isBlank((String)fp.getString(INPUT_END_DATE))) {
            newStudy.setDatePlannedEnd(null);
        } else {
            newStudy.setDatePlannedEnd(fp.getDate(INPUT_END_DATE));
        }
        newStudy.setPhase(fp.getString("phase"));
        if (fp.getInt("genetic") == 1) {
            newStudy.setGenetic(true);
        } else {
            newStudy.setGenetic(false);
        }
        this.session.setAttribute("newStudy", (Object)newStudy);
        String interventional = resadmin.getString("interventional");
        return interventional.equalsIgnoreCase(newStudy.getProtocolType());
    }

    private void updateStudy3(boolean isInterventional) {
        FormProcessor fp = new FormProcessor(this.request);
        StudyBean study = (StudyBean)this.session.getAttribute("newStudy");
        study.setPurpose(fp.getString("purpose"));
        ArrayList<InterventionBean> interventionArray = new ArrayList<InterventionBean>();
        if (isInterventional) {
            study.setAllocation(fp.getString("allocation"));
            study.setMasking(fp.getString("masking"));
            study.setControl(fp.getString("control"));
            study.setAssignment(fp.getString("assignment"));
            study.setEndpoint(fp.getString("endpoint"));
            StringBuffer interventions = new StringBuffer();
            for (int i = 0; i < 10; ++i) {
                String type = fp.getString("interType" + i);
                String name = fp.getString("interName" + i);
                if (StringUtil.isBlank((String)type) || StringUtil.isBlank((String)name)) continue;
                InterventionBean ib = new InterventionBean(fp.getString("interType" + i), fp.getString("interName" + i));
                interventionArray.add(ib);
                interventions.append(ib.toString()).append(",");
            }
            study.setInterventions(interventions.toString());
        } else {
            study.setDuration(fp.getString("duration"));
            study.setSelection(fp.getString("selection"));
            study.setTiming(fp.getString("timing"));
        }
        this.session.setAttribute("newStudy", (Object)study);
        this.session.setAttribute("interventions", interventionArray);
    }

    private ArrayList parseInterventions(StudyBean sb) {
        ArrayList<InterventionBean> inters = new ArrayList<InterventionBean>();
        String interventions = sb.getInterventions();
        try {
            if (!StringUtil.isBlank((String)interventions)) {
                StringTokenizer st = new StringTokenizer(interventions, ",");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    StringTokenizer st1 = new StringTokenizer(s, "/");
                    String type = st1.nextToken();
                    String name = st1.nextToken();
                    InterventionBean ib = new InterventionBean(type, name);
                    inters.add(ib);
                }
            }
        }
        catch (NoSuchElementException nse) {
            return new ArrayList();
        }
        return inters;
    }

    private void setMaps(boolean isInterventional, ArrayList interventionArray) {
        if (isInterventional) {
            this.request.setAttribute("interPurposeMap", (Object)CreateStudyServlet.interPurposeMap);
            this.request.setAttribute("allocationMap", (Object)CreateStudyServlet.allocationMap);
            this.request.setAttribute("maskingMap", (Object)CreateStudyServlet.maskingMap);
            this.request.setAttribute("controlMap", (Object)CreateStudyServlet.controlMap);
            this.request.setAttribute("assignmentMap", (Object)CreateStudyServlet.assignmentMap);
            this.request.setAttribute("endpointMap", (Object)CreateStudyServlet.endpointMap);
            this.request.setAttribute("interTypeMap", (Object)CreateStudyServlet.interTypeMap);
            this.session.setAttribute("interventions", (Object)interventionArray);
        } else {
            this.request.setAttribute("obserPurposeMap", (Object)CreateStudyServlet.obserPurposeMap);
            this.request.setAttribute("selectionMap", (Object)CreateStudyServlet.selectionMap);
            this.request.setAttribute("timingMap", (Object)CreateStudyServlet.timingMap);
        }
    }

    protected String getAdminServlet() {
        return "admin";
    }

    private void updateParameter(StudyParameterValueDAO spvdao, StudyParameterValueBean spv) {
        StudyParameterValueBean spv1 = spvdao.findByHandleAndStudy(spv.getStudyId(), spv.getParameter());
        if (spv1.getId() > 0) {
            spvdao.update((EntityBean)spv);
        } else {
            spvdao.create((EntityBean)spv);
        }
    }
}

