/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.InterventionBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.managestudy.CreateStudyServlet;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.service.StudyConfigService;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.apache.commons.lang.StringUtils;

public class UpdateStudyServletNew
extends SecureController {
    public static final String INPUT_START_DATE = "startDate";
    public static final String INPUT_END_DATE = "endDate";
    public static final String INPUT_VER_DATE = "protocolDateVerification";
    public static StudyBean study;
    private CoreResources core;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }

    public void processRequest() throws Exception {
        this.resetPanel();
        FormProcessor fp = new FormProcessor(this.request);
        Validator v = new Validator(this.request);
        int studyId = fp.getInt("id");
        studyId = studyId == 0 ? fp.getInt("studyId") : studyId;
        String action = fp.getString("action");
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        boolean isInterventional = false;
        study = (StudyBean)sdao.findByPK(studyId);
        if (study.getId() != this.currentStudy.getId()) {
            this.addPageMessage(respage.getString("not_current_study") + respage.getString("change_study_contact_sysadmin"));
            this.forwardPage(Page.MENU_SERVLET);
            return;
        }
        study.setId(studyId);
        StudyConfigService scs = new StudyConfigService(this.sm.getDataSource());
        study = scs.setParametersForStudy(study);
        this.request.setAttribute("studyToView", (Object)study);
        this.request.setAttribute("studyId", (Object)(studyId + ""));
        this.request.setAttribute("studyPhaseMap", (Object)CreateStudyServlet.studyPhaseMap);
        ArrayList statuses = Status.toStudyUpdateMembersList();
        statuses.add(Status.PENDING);
        this.request.setAttribute("statuses", (Object)statuses);
        String interventional = resadmin.getString("interventional");
        isInterventional = interventional.equalsIgnoreCase(study.getProtocolType());
        this.request.setAttribute("isInterventional", (Object)(isInterventional ? "1" : "0"));
        String protocolType = study.getProtocolTypeKey();
        if (study.getParentStudyId() > 0) {
            StudyBean parentStudy = (StudyBean)sdao.findByPK(study.getParentStudyId());
            this.request.setAttribute("parentStudy", (Object)parentStudy);
        }
        ArrayList interventionArray = new ArrayList();
        if (isInterventional) {
            interventionArray = this.parseInterventions(study);
            this.setMaps(isInterventional, interventionArray);
        } else {
            this.setMaps(isInterventional, interventionArray);
        }
        if (!action.equals("submit")) {
            if (study.getDatePlannedStart() != null) {
                fp.addPresetValue(INPUT_START_DATE, this.local_df.format(study.getDatePlannedStart()));
            }
            if (study.getDatePlannedEnd() != null) {
                fp.addPresetValue(INPUT_END_DATE, this.local_df.format(study.getDatePlannedEnd()));
            }
            if (study.getProtocolDateVerification() != null) {
                fp.addPresetValue(INPUT_VER_DATE, this.local_df.format(study.getProtocolDateVerification()));
            }
            this.setPresetValues(fp.getPresetValues());
        }
        if (study == null) {
            this.addPageMessage(respage.getString("please_choose_a_study_to_edit"));
            this.forwardPage(Page.STUDY_LIST_SERVLET);
            return;
        }
        if (action.equals("submit")) {
            this.validateStudy1(fp, v);
            this.validateStudy2(fp, new Validator(this.request));
            this.validateStudy3(isInterventional, new Validator(this.request), fp);
            this.validateStudy4(fp, new Validator(this.request));
            this.validateStudy5(fp, new Validator(this.request));
            this.validateStudy6(fp, new Validator(this.request));
            this.confirmWholeStudy(fp);
            this.request.setAttribute("studyToView", (Object)study);
            if (!this.errors.isEmpty()) {
                logger.error("found errors : " + this.errors.toString());
                this.request.setAttribute("formMessages", (Object)this.errors);
                this.forwardPage(Page.UPDATE_STUDY_NEW);
            } else {
                study.setProtocolType(protocolType);
                this.submitStudy(study);
                this.addPageMessage(respage.getString("the_study_has_been_updated_succesfully"));
                ArrayList pageMessages = (ArrayList)this.request.getAttribute("pageMessages");
                this.session.setAttribute("pageMessages", (Object)pageMessages);
                this.response.sendRedirect(this.request.getContextPath() + "/pages/studymodule");
            }
        } else {
            this.forwardPage(Page.UPDATE_STUDY_NEW);
        }
    }

    private void validateStudy1(FormProcessor fp, Validator v) {
        v.addValidation("name", 1);
        v.addValidation("uniqueProId", 1);
        v.addValidation("description", 1);
        v.addValidation("prinInvestigator", 1);
        v.addValidation("sponsor", 1);
        v.addValidation("secondProId", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("collaborators", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 1000);
        v.addValidation("protocolDescription", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 1000);
        this.errors = v.validate();
        if (fp.getString("name").trim().length() > 100) {
            Validator.addError((HashMap)this.errors, (String)"name", (String)resexception.getString("maximum_lenght_name_100"));
        }
        if (fp.getString("uniqueProId").trim().length() > 30) {
            Validator.addError((HashMap)this.errors, (String)"uniqueProId", (String)resexception.getString("maximum_lenght_unique_protocol_30"));
        }
        if (fp.getString("description").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"description", (String)resexception.getString("maximum_lenght_brief_summary_255"));
        }
        if (fp.getString("prinInvestigator").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"prinInvestigator", (String)resexception.getString("maximum_lenght_principal_investigator_255"));
        }
        if (fp.getString("sponsor").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"sponsor", (String)resexception.getString("maximum_lenght_sponsor_255"));
        }
        if (fp.getString("officialTitle").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"officialTitle", (String)resexception.getString("maximum_lenght_official_title_255"));
        }
        study = this.createStudyBean(fp);
    }

    private void validateStudy2(FormProcessor fp, Validator v) {
        HashMap vStudy2;
        v.addValidation(INPUT_START_DATE, 4);
        if (!StringUtils.isBlank((String)fp.getString(INPUT_END_DATE))) {
            v.addValidation(INPUT_END_DATE, 4);
        }
        if (!StringUtils.isBlank((String)fp.getString(INPUT_VER_DATE))) {
            v.addValidation(INPUT_VER_DATE, 4);
        }
        if ((vStudy2 = v.validate()) != null && vStudy2.size() > 0) {
            this.errors.putAll(vStudy2);
        }
        vStudy2 = null;
        logger.info("has validation errors");
        if (!StringUtils.isBlank((String)fp.getString(INPUT_START_DATE))) {
            fp.addPresetValue(INPUT_START_DATE, fp.getString(INPUT_START_DATE));
        }
        if (!StringUtils.isBlank((String)fp.getString(INPUT_VER_DATE))) {
            fp.addPresetValue(INPUT_VER_DATE, fp.getString(INPUT_VER_DATE));
        }
        if (!StringUtils.isBlank((String)fp.getString(INPUT_END_DATE))) {
            fp.addPresetValue(INPUT_END_DATE, fp.getString(INPUT_END_DATE));
        }
        this.updateStudy2(fp);
        this.setPresetValues(fp.getPresetValues());
    }

    private void validateStudy3(boolean isInterventional, Validator v, FormProcessor fp) {
        v.addValidation("purpose", 1);
        for (int i = 0; i < 10; ++i) {
            String type = fp.getString("interType" + i);
            String name = fp.getString("interName" + i);
            if (!StringUtil.isBlank((String)type) && StringUtil.isBlank((String)name)) {
                v.addValidation("interName", 1);
                this.request.setAttribute("interventionError", (Object)respage.getString("name_cannot_be_blank_if_type"));
                break;
            }
            if (StringUtil.isBlank((String)name) || !StringUtil.isBlank((String)type)) continue;
            v.addValidation("interType", 1);
            this.request.setAttribute("interventionError", (Object)respage.getString("name_cannot_be_blank_if_name"));
            break;
        }
        this.updateStudy3(isInterventional, fp);
    }

    private void validateStudy4(FormProcessor fp, Validator v) {
        v.addValidation("conditions", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 500);
        v.addValidation("keywords", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("eligibility", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 500);
        HashMap vStudy4 = v.validate();
        if (vStudy4 != null && vStudy4.size() > 0) {
            this.errors.putAll(vStudy4);
        }
        vStudy4 = null;
        if (fp.getInt("expectedTotalEnrollment") <= 0) {
            Validator.addError((HashMap)this.errors, (String)"expectedTotalEnrollment", (String)respage.getString("expected_total_enrollment_must_be_a_positive_number"));
        }
        study.setConditions(fp.getString("conditions"));
        study.setKeywords(fp.getString("keywords"));
        study.setEligibility(fp.getString("eligibility"));
        study.setGender(fp.getString("gender"));
        if (fp.getString("ageMax").length() > 3) {
            Validator.addError((HashMap)this.errors, (String)"ageMax", (String)respage.getString("condition_eligibility_3"));
        }
        study.setAgeMax(fp.getString("ageMax"));
        study.setAgeMin(fp.getString("ageMin"));
        study.setHealthyVolunteerAccepted(fp.getBoolean("healthyVolunteerAccepted"));
        study.setExpectedTotalEnrollment(fp.getInt("expectedTotalEnrollment"));
        this.request.setAttribute("facRecruitStatusMap", (Object)CreateStudyServlet.facRecruitStatusMap);
    }

    private void validateStudy5(FormProcessor fp, Validator v) {
        if (!StringUtil.isBlank((String)fp.getString("facConEmail"))) {
            v.addValidation("facConEmail", 6);
        }
        v.addValidation("facName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facCity", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facState", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 20);
        v.addValidation("facZip", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
        v.addValidation("facCountry", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
        v.addValidation("facConName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConDegree", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConPhone", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConEmail", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        HashMap vStudy5 = v.validate();
        if (vStudy5 != null && vStudy5.size() > 0) {
            this.errors.putAll(vStudy5);
        }
        vStudy5 = null;
        study.setFacilityCity(fp.getString("facCity"));
        study.setFacilityContactDegree(fp.getString("facConDrgree"));
        study.setFacilityName(fp.getString("facName"));
        study.setFacilityContactEmail(fp.getString("facConEmail"));
        study.setFacilityContactPhone(fp.getString("facConPhone"));
        study.setFacilityContactName(fp.getString("facConName"));
        study.setFacilityCountry(fp.getString("facCountry"));
        study.setFacilityContactDegree(fp.getString("facConDegree"));
        study.setFacilityState(fp.getString("facState"));
        study.setFacilityZip(fp.getString("facZip"));
        if (!this.errors.isEmpty()) {
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.request.setAttribute("facRecruitStatusMap", (Object)CreateStudyServlet.facRecruitStatusMap);
        }
    }

    private void validateStudy6(FormProcessor fp, Validator v) {
        v.addValidation("medlineIdentifier", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("url", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("urlDescription", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        HashMap vStudy6 = v.validate();
        if (vStudy6 != null && vStudy6.size() > 0) {
            this.errors.putAll(vStudy6);
        }
        vStudy6 = null;
        study.setMedlineIdentifier(fp.getString("medlineIdentifier"));
        study.setResultsReference(fp.getBoolean("resultsReference"));
        study.setUrl(fp.getString("url"));
        study.setUrlDescription(fp.getString("urlDescription"));
        if (!this.errors.isEmpty()) {
            this.request.setAttribute("formMessages", (Object)this.errors);
        }
    }

    private void confirmWholeStudy(FormProcessor fp) {
        if (study.getStatus().isLocked()) {
            study.getStudyParameterConfig().setDiscrepancyManagement("false");
        } else {
            study.getStudyParameterConfig().setDiscrepancyManagement(fp.getString("discrepancyManagement"));
        }
        study.getStudyParameterConfig().setCollectDob(fp.getString("collectDob"));
        study.getStudyParameterConfig().setGenderRequired(fp.getString("genderRequired"));
        study.getStudyParameterConfig().setInterviewerNameRequired(fp.getString("interviewerNameRequired"));
        study.getStudyParameterConfig().setInterviewerNameDefault(fp.getString("interviewerNameDefault"));
        study.getStudyParameterConfig().setInterviewDateEditable(fp.getString("interviewDateEditable"));
        study.getStudyParameterConfig().setInterviewDateRequired(fp.getString("interviewDateRequired"));
        study.getStudyParameterConfig().setInterviewerNameEditable(fp.getString("interviewerNameEditable"));
        study.getStudyParameterConfig().setInterviewDateDefault(fp.getString("interviewDateDefault"));
        study.getStudyParameterConfig().setSubjectIdGeneration(fp.getString("subjectIdGeneration"));
        study.getStudyParameterConfig().setSubjectPersonIdRequired(fp.getString("subjectPersonIdRequired"));
        study.getStudyParameterConfig().setSubjectIdPrefixSuffix(fp.getString("subjectIdPrefixSuffix"));
        study.getStudyParameterConfig().setPersonIdShownOnCRF(fp.getString("personIdShownOnCRF"));
        study.getStudyParameterConfig().setSecondaryLabelViewable(fp.getString("secondaryLabelViewable"));
        study.getStudyParameterConfig().setAdminForcedReasonForChange(fp.getString("adminForcedReasonForChange"));
        study.getStudyParameterConfig().setEventLocationRequired(fp.getString("eventLocationRequired"));
        if (!this.errors.isEmpty()) {
            this.request.setAttribute("formMessages", (Object)this.errors);
        }
    }

    private StudyBean createStudyBean(FormProcessor fp) {
        StudyBean newStudy = study;
        newStudy.setId(fp.getInt("studyId"));
        newStudy.setName(fp.getString("name"));
        newStudy.setOfficialTitle(fp.getString("officialTitle"));
        newStudy.setIdentifier(fp.getString("uniqueProId"));
        newStudy.setSecondaryIdentifier(fp.getString("secondProId"));
        newStudy.setPrincipalInvestigator(fp.getString("prinInvestigator"));
        newStudy.setSummary(fp.getString("description"));
        newStudy.setProtocolDescription(fp.getString("protocolDescription"));
        newStudy.setSponsor(fp.getString("sponsor"));
        newStudy.setCollaborators(fp.getString("collaborators"));
        return newStudy;
    }

    private boolean updateStudy2(FormProcessor fp) {
        study.setOldStatus(study.getStatus());
        study.setStatus(Status.get((int)fp.getInt("status")));
        if (StringUtil.isBlank((String)fp.getString(INPUT_VER_DATE))) {
            study.setProtocolDateVerification(null);
        } else {
            study.setProtocolDateVerification(fp.getDate(INPUT_VER_DATE));
        }
        study.setDatePlannedStart(fp.getDate(INPUT_START_DATE));
        if (StringUtil.isBlank((String)fp.getString(INPUT_END_DATE))) {
            study.setDatePlannedEnd(null);
        } else {
            study.setDatePlannedEnd(fp.getDate(INPUT_END_DATE));
        }
        study.setPhase(fp.getString("phase"));
        if (fp.getInt("genetic") == 1) {
            study.setGenetic(true);
        } else {
            study.setGenetic(false);
        }
        String interventional = resadmin.getString("interventional");
        return interventional.equalsIgnoreCase(study.getProtocolType());
    }

    private void updateStudy3(boolean isInterventional, FormProcessor fp) {
        study.setPurpose(fp.getString("purpose"));
        ArrayList<InterventionBean> interventionArray = new ArrayList<InterventionBean>();
        if (isInterventional) {
            study.setAllocation(fp.getString("allocation"));
            study.setMasking(fp.getString("masking"));
            study.setControl(fp.getString("control"));
            study.setAssignment(fp.getString("assignment"));
            study.setEndpoint(fp.getString("endpoint"));
            StringBuffer interventions = new StringBuffer();
            for (int i = 0; i < 10; ++i) {
                String type = fp.getString("interType" + i);
                String name = fp.getString("interName" + i);
                if (StringUtil.isBlank((String)type) || StringUtil.isBlank((String)name)) continue;
                InterventionBean ib = new InterventionBean(fp.getString("interType" + i), fp.getString("interName" + i));
                interventionArray.add(ib);
                interventions.append(ib.toString()).append(",");
            }
            study.setInterventions(interventions.toString());
        } else {
            study.setDuration(fp.getString("duration"));
            study.setSelection(fp.getString("selection"));
            study.setTiming(fp.getString("timing"));
        }
        this.request.setAttribute("interventions", interventionArray);
    }

    private ArrayList parseInterventions(StudyBean sb) {
        ArrayList<InterventionBean> inters = new ArrayList<InterventionBean>();
        String interventions = sb.getInterventions();
        try {
            if (!StringUtil.isBlank((String)interventions)) {
                StringTokenizer st = new StringTokenizer(interventions, ",");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    StringTokenizer st1 = new StringTokenizer(s, "/");
                    String type = st1.nextToken();
                    String name = st1.nextToken();
                    InterventionBean ib = new InterventionBean(type, name);
                    inters.add(ib);
                }
            }
        }
        catch (NoSuchElementException nse) {
            return new ArrayList();
        }
        return inters;
    }

    private void setMaps(boolean isInterventional, ArrayList interventionArray) {
        if (isInterventional) {
            this.request.setAttribute("interPurposeMap", (Object)CreateStudyServlet.interPurposeMap);
            this.request.setAttribute("allocationMap", (Object)CreateStudyServlet.allocationMap);
            this.request.setAttribute("maskingMap", (Object)CreateStudyServlet.maskingMap);
            this.request.setAttribute("controlMap", (Object)CreateStudyServlet.controlMap);
            this.request.setAttribute("assignmentMap", (Object)CreateStudyServlet.assignmentMap);
            this.request.setAttribute("endpointMap", (Object)CreateStudyServlet.endpointMap);
            this.request.setAttribute("interTypeMap", (Object)CreateStudyServlet.interTypeMap);
            this.session.setAttribute("interventions", (Object)interventionArray);
        } else {
            this.request.setAttribute("obserPurposeMap", (Object)CreateStudyServlet.obserPurposeMap);
            this.request.setAttribute("selectionMap", (Object)CreateStudyServlet.selectionMap);
            this.request.setAttribute("timingMap", (Object)CreateStudyServlet.timingMap);
        }
    }

    private void submitStudy(StudyBean newStudy) {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        StudyBean study1 = newStudy;
        logger.info("study bean to be updated:" + study1.getName());
        study1.setUpdatedDate(new Date());
        study1.setUpdater((UserAccountBean)this.session.getAttribute("userBean"));
        sdao.update((EntityBean)study1);
        ArrayList siteList = (ArrayList)sdao.findAllByParent(newStudy.getId());
        if (siteList.size() > 0) {
            sdao.updateSitesStatus(study1);
        }
        StudyParameterValueBean spv = new StudyParameterValueBean();
        spv.setStudyId(study1.getId());
        spv.setParameter("collectDob");
        spv.setValue(new Integer(study1.getStudyParameterConfig().getCollectDob()).toString());
        this.updateParameter(spvdao, spv);
        spv.setParameter("discrepancyManagement");
        spv.setValue(study1.getStudyParameterConfig().getDiscrepancyManagement());
        this.updateParameter(spvdao, spv);
        spv.setParameter("genderRequired");
        spv.setValue(study1.getStudyParameterConfig().getGenderRequired());
        this.updateParameter(spvdao, spv);
        spv.setParameter("subjectPersonIdRequired");
        spv.setValue(study1.getStudyParameterConfig().getSubjectPersonIdRequired());
        this.updateParameter(spvdao, spv);
        spv.setParameter("interviewerNameRequired");
        spv.setValue(study1.getStudyParameterConfig().getInterviewerNameRequired());
        this.updateParameter(spvdao, spv);
        spv.setParameter("interviewerNameDefault");
        spv.setValue(study1.getStudyParameterConfig().getInterviewerNameDefault());
        this.updateParameter(spvdao, spv);
        spv.setParameter("interviewerNameEditable");
        spv.setValue(study1.getStudyParameterConfig().getInterviewerNameEditable());
        this.updateParameter(spvdao, spv);
        ArrayList sites = new ArrayList();
        sites = (ArrayList)sdao.findAllByParent(newStudy.getId());
        if (sites != null && !sites.isEmpty()) {
            this.updateInterviewerForSites(newStudy, (List)sites, spvdao, "interviewerNameEditable");
        }
        spv.setParameter("interviewDateRequired");
        spv.setValue(study1.getStudyParameterConfig().getInterviewDateRequired());
        this.updateParameter(spvdao, spv);
        spv.setParameter("interviewDateDefault");
        spv.setValue(study1.getStudyParameterConfig().getInterviewDateDefault());
        this.updateParameter(spvdao, spv);
        spv.setParameter("interviewDateEditable");
        spv.setValue(study1.getStudyParameterConfig().getInterviewDateEditable());
        this.updateParameter(spvdao, spv);
        if (sites != null && !sites.isEmpty()) {
            this.updateInterviewerForSites(newStudy, (List)sites, spvdao, "interviewDateEditable");
        }
        spv.setParameter("subjectIdGeneration");
        spv.setValue(study1.getStudyParameterConfig().getSubjectIdGeneration());
        this.updateParameter(spvdao, spv);
        spv.setParameter("subjectIdPrefixSuffix");
        spv.setValue(study1.getStudyParameterConfig().getSubjectIdPrefixSuffix());
        this.updateParameter(spvdao, spv);
        spv.setParameter("personIdShownOnCRF");
        spv.setValue(study1.getStudyParameterConfig().getPersonIdShownOnCRF());
        this.updateParameter(spvdao, spv);
        spv.setParameter("secondaryLabelViewable");
        spv.setValue(study1.getStudyParameterConfig().getSecondaryLabelViewable());
        this.updateParameter(spvdao, spv);
        spv.setParameter("adminForcedReasonForChange");
        spv.setValue(study1.getStudyParameterConfig().getAdminForcedReasonForChange());
        this.updateParameter(spvdao, spv);
        spv.setParameter("eventLocationRequired");
        spv.setValue(study1.getStudyParameterConfig().getEventLocationRequired());
        this.updateParameter(spvdao, spv);
        StudyBean curStudy = (StudyBean)this.session.getAttribute("study");
        if (curStudy != null && study1.getId() == curStudy.getId()) {
            this.currentStudy = study1;
            this.session.setAttribute("study", (Object)study1);
        }
        ArrayList children = (ArrayList)sdao.findAllByParent(study1.getId());
        for (int i = 0; i < children.size(); ++i) {
            StudyBean child = (StudyBean)children.get(i);
            child.setType(study1.getType());
            child.setUpdatedDate(new Date());
            child.setUpdater(this.ub);
            sdao.update((EntityBean)child);
            StudyParameterValueBean childspv = new StudyParameterValueBean();
            childspv.setStudyId(child.getId());
            childspv.setParameter("collectDob");
            childspv.setValue(new Integer(study1.getStudyParameterConfig().getCollectDob()).toString());
            this.updateParameter(spvdao, childspv);
            childspv.setParameter("genderRequired");
            childspv.setValue(study1.getStudyParameterConfig().getGenderRequired());
            this.updateParameter(spvdao, childspv);
        }
    }

    protected String getAdminServlet() {
        return "admin";
    }

    private void updateParameter(StudyParameterValueDAO spvdao, StudyParameterValueBean spv) {
        StudyParameterValueBean spv1 = spvdao.findByHandleAndStudy(spv.getStudyId(), spv.getParameter());
        logger.debug("found parameter: " + spv.getParameter());
        if (spv1.getId() > 0) {
            spvdao.update((EntityBean)spv);
            logger.debug("updating");
        } else {
            spvdao.create((EntityBean)spv);
            logger.debug("creating");
        }
    }

    private void updateInterviewerForSites(StudyBean studyBean, List<StudyBean> sites, StudyParameterValueDAO studyParameterValueDAO, String parameterType) {
        StudyParameterValueBean studyParameterValueBean = new StudyParameterValueBean();
        if ("interviewerNameEditable".equalsIgnoreCase(parameterType)) {
            studyParameterValueBean.setParameter("interviewerNameEditable");
            studyParameterValueBean.setValue(studyBean.getStudyParameterConfig().getInterviewerNameEditable());
        } else {
            studyParameterValueBean.setParameter("interviewDateEditable");
            studyParameterValueBean.setValue(studyBean.getStudyParameterConfig().getInterviewDateEditable());
        }
        for (StudyBean siteBean : sites) {
            studyParameterValueBean.setStudyId(siteBean.getId());
            this.updateParameter(studyParameterValueDAO, studyParameterValueBean);
        }
    }
}

