/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.GroupClassType;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyGroupBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class UpdateSubjectGroupClassServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET, respage.getString("current_study_locked"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + "\n" + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        FormProcessor fp = new FormProcessor(this.request);
        int classId = fp.getInt("id");
        if (classId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_subject_group_class_to_edit"));
            this.forwardPage(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET);
        } else {
            StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
            StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
            if (!fp.isSubmitted()) {
                StudyGroupClassBean sgcb = (StudyGroupClassBean)sgcdao.findByPK(classId);
                ArrayList groups = sgdao.findAllByGroupClass(sgcb);
                this.request.setAttribute("groupTypes", (Object)GroupClassType.toArrayList());
                this.session.setAttribute("group", (Object)sgcb);
                this.session.setAttribute("studyGroups", (Object)groups);
                this.forwardPage(Page.UPDATE_SUBJECT_GROUP_CLASS);
            } else if (action.equalsIgnoreCase("confirm")) {
                this.confirmGroup();
            } else if (action.equalsIgnoreCase("submit")) {
                this.submitGroup();
            } else {
                this.addPageMessage(respage.getString("no_action_specified"));
                this.forwardPage(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET);
            }
        }
    }

    private void confirmGroup() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("name", 1);
        v.addValidation("subjectAssignment", 1);
        v.addValidation("name", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 30);
        v.addValidation("subjectAssignment", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 30);
        ArrayList<StudyGroupBean> studyGroups = new ArrayList<StudyGroupBean>();
        for (int i = 0; i < 10; ++i) {
            String name = fp.getString("studyGroup" + i);
            int studyGroupId = fp.getInt("studyGroupId" + i);
            String description = fp.getString("studyGroupDescription" + i);
            if (StringUtil.isBlank((String)name)) continue;
            StudyGroupBean g = new StudyGroupBean();
            g.setName(name);
            g.setDescription(description);
            g.setId(studyGroupId);
            studyGroups.add(g);
            if (name.length() > 255) {
                this.request.setAttribute("studyGroupError", (Object)resexception.getString("group_name_cannot_be_more_255"));
                break;
            }
            if (description.length() <= 1000) continue;
            this.request.setAttribute("studyGroupError", (Object)resexception.getString("group_description_cannot_be_more_100"));
            break;
        }
        this.errors = v.validate();
        if (fp.getInt("groupClassTypeId") == 0) {
            Validator.addError((HashMap)this.errors, (String)"groupClassTypeId", (String)"Group Class Type is required.");
        }
        StudyGroupClassBean group = (StudyGroupClassBean)this.session.getAttribute("group");
        group.setName(fp.getString("name"));
        group.setGroupClassTypeId(fp.getInt("groupClassTypeId"));
        group.setSubjectAssignment(fp.getString("subjectAssignment"));
        this.session.setAttribute("group", (Object)group);
        this.session.setAttribute("studyGroups", studyGroups);
        if (this.errors.isEmpty()) {
            logger.info("no errors in the first section");
            group.setGroupClassTypeName(GroupClassType.get((int)group.getGroupClassTypeId()).getName());
            this.forwardPage(Page.UPDATE_SUBJECT_GROUP_CLASS_CONFIRM);
        } else {
            logger.info("has validation errors in the first section");
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.request.setAttribute("groupTypes", (Object)GroupClassType.toArrayList());
            this.forwardPage(Page.UPDATE_SUBJECT_GROUP_CLASS);
        }
    }

    private void submitGroup() throws OpenClinicaException {
        StudyGroupClassBean group = (StudyGroupClassBean)this.session.getAttribute("group");
        ArrayList studyGroups = (ArrayList)this.session.getAttribute("studyGroups");
        ArrayList newStudyGroups = (ArrayList)this.session.getAttribute("newStudyGroups");
        StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
        group.setUpdater(this.ub);
        group.setUpdatedDate(new Date());
        group = (StudyGroupClassBean)sgcdao.update((EntityBean)group);
        if (!group.isActive()) {
            this.addPageMessage(respage.getString("the_subject_group_class_no_updated_database"));
        } else {
            StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
            for (int i = 0; i < studyGroups.size(); ++i) {
                StudyGroupBean sg = (StudyGroupBean)studyGroups.get(i);
                sg.setStudyGroupClassId(group.getId());
                if (sg.getId() == 0) {
                    sg.setOwner(this.ub);
                    sg.setStatus(Status.AVAILABLE);
                    sgdao.create((EntityBean)sg);
                    continue;
                }
                sg.setUpdater(this.ub);
                sg.setStatus(Status.AVAILABLE);
                sgdao.update((EntityBean)sg);
            }
            this.addPageMessage(respage.getString("the_subject_group_class_updated_succesfully"));
        }
        this.forwardPage(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET);
    }
}

