/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.List;
import java.util.Map;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.BeanFactory;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewCRFVersionPreview
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int crfId = fp.getInt("crfId");
        CRFVersionBean version = new CRFVersionBean();
        Map crfMap = (Map)this.session.getAttribute("preview_crf");
        Map crfIdnameInfo = null;
        if (crfMap != null) {
            crfIdnameInfo = (Map)crfMap.get("crf_info");
        } else {
            logger.info("The crfMap session attribute has expired or gone out of scope in: " + this.getClass().getName());
        }
        String crfName = "";
        String verNumber = "";
        if (crfIdnameInfo != null) {
            Map.Entry mapEnt2 = null;
            for (Map.Entry mapEnt2 : crfIdnameInfo.entrySet()) {
                if (((String)mapEnt2.getKey()).equalsIgnoreCase("crf_name")) {
                    crfName = (String)mapEnt2.getValue();
                }
                if (!((String)mapEnt2.getKey()).equalsIgnoreCase("version")) continue;
                verNumber = (String)mapEnt2.getValue();
            }
        }
        version.setName(verNumber);
        version.setCrfId(crfId);
        Map sectionsMap = null;
        if (crfMap != null) {
            sectionsMap = (Map)crfMap.get("sections");
        }
        Map itemsMap = null;
        if (crfMap != null) {
            itemsMap = (Map)crfMap.get("items");
        }
        Map groupsMap = null;
        if (crfMap != null) {
            groupsMap = (Map)crfMap.get("groups");
        }
        BeanFactory beanFactory = new BeanFactory();
        List sections = beanFactory.createSectionBeanList(sectionsMap, itemsMap, crfName, groupsMap);
        this.request.setAttribute("sections", (Object)sections);
        this.request.setAttribute("version", (Object)version);
        this.forwardPage(Page.VIEW_CRF_VERSION);
    }
}

