/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewNoteServlet
extends SecureController {
    public static final String NOTE_ID = "id";
    public static final String DIS_NOTE = "singleNote";

    protected void mayProceed() throws InsufficientPermissionException {
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_permission_to_view_discrepancies") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director_or_study_cordinator"), "1");
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        Locale locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        DateFormat dateFormatter = DateFormat.getDateInstance(2, locale);
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
        dndao.setFetchMapping(true);
        int noteId = fp.getInt(NOTE_ID, true);
        DiscrepancyNoteBean note = (DiscrepancyNoteBean)dndao.findByPK(noteId);
        String entityType = note.getEntityType();
        if (note.getEntityId() > 0 && !entityType.equals("") && !StringUtil.isBlank((String)entityType)) {
            StudySubjectBean ssub;
            if ("itemData".equalsIgnoreCase(entityType)) {
                ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
                ItemDataBean itemData = (ItemDataBean)iddao.findByPK(note.getEntityId());
                ItemDAO idao = new ItemDAO(this.sm.getDataSource());
                ItemBean item = (ItemBean)idao.findByPK(itemData.getItemId());
                note.setEntityValue(itemData.getValue());
                note.setEntityName(item.getName());
                note.setEntityId(itemData.getId());
                EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
                EventCRFBean ec = (EventCRFBean)ecdao.findByPK(itemData.getEventCRFId());
                StudyEventDAO sed = new StudyEventDAO(this.sm.getDataSource());
                StudyEventBean se = (StudyEventBean)sed.findByPK(ec.getStudyEventId());
                StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
                StudySubjectBean ssub2 = (StudySubjectBean)ssdao.findByPK(se.getStudySubjectId());
                note.setStudySub(ssub2);
                StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
                StudyEventDefinitionBean sedb = (StudyEventDefinitionBean)seddao.findByPK(se.getStudyEventDefinitionId());
                se.setName(sedb.getName());
                note.setEvent(se);
                CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
                CRFVersionBean cv = (CRFVersionBean)cvdao.findByPK(ec.getCRFVersionId());
                CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
                CRFBean crf = (CRFBean)cdao.findByPK(cv.getCrfId());
                note.setCrfName(crf.getName());
            } else if ("studySub".equalsIgnoreCase(entityType)) {
                StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
                StudySubjectBean ssub3 = (StudySubjectBean)ssdao.findByPK(note.getEntityId());
                note.setStudySub(ssub3);
                SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
                SubjectBean sub = (SubjectBean)sdao.findByPK(ssub3.getSubjectId());
                if (!StringUtil.isBlank((String)note.getColumn())) {
                    if ("enrollment_date".equalsIgnoreCase(note.getColumn())) {
                        if (ssub3.getEnrollmentDate() != null) {
                            note.setEntityValue(dateFormatter.format(ssub3.getEnrollmentDate()));
                        }
                        note.setEntityName(resword.getString("enrollment_date"));
                    } else if ("gender".equalsIgnoreCase(note.getColumn())) {
                        note.setEntityValue(sub.getGender() + "");
                        note.setEntityName(resword.getString("gender"));
                    } else if ("date_of_birth".equalsIgnoreCase(note.getColumn())) {
                        if (sub.getDateOfBirth() != null) {
                            note.setEntityValue(dateFormatter.format(sub.getDateOfBirth()));
                        }
                        note.setEntityName(resword.getString("date_of_birth"));
                    }
                }
            } else if ("subject".equalsIgnoreCase(entityType)) {
                SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
                SubjectBean sub = (SubjectBean)sdao.findByPK(note.getEntityId());
                ssub = new StudySubjectBean();
                ssub.setLabel(sub.getUniqueIdentifier());
                note.setStudySub(ssub);
                if (!StringUtil.isBlank((String)note.getColumn())) {
                    if ("gender".equalsIgnoreCase(note.getColumn())) {
                        note.setEntityValue(sub.getGender() + "");
                        note.setEntityName(resword.getString("gender"));
                    } else if ("date_of_birth".equalsIgnoreCase(note.getColumn())) {
                        if (sub.getDateOfBirth() != null) {
                            note.setEntityValue(dateFormatter.format(sub.getDateOfBirth()));
                        }
                        note.setEntityName(resword.getString("date_of_birth"));
                    } else if ("unique_identifier".equalsIgnoreCase(note.getColumn())) {
                        note.setEntityName(resword.getString("unique_identifier"));
                        note.setEntityValue(sub.getUniqueIdentifier());
                    }
                }
            } else if ("studyEvent".equalsIgnoreCase(entityType)) {
                StudyEventDAO sed = new StudyEventDAO(this.sm.getDataSource());
                StudyEventBean se = (StudyEventBean)sed.findByPK(note.getEntityId());
                StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
                StudySubjectBean ssub4 = (StudySubjectBean)ssdao.findByPK(se.getStudySubjectId());
                note.setStudySub(ssub4);
                StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
                StudyEventDefinitionBean sedb = (StudyEventDefinitionBean)seddao.findByPK(se.getStudyEventDefinitionId());
                se.setName(sedb.getName());
                note.setEvent(se);
                if (!StringUtil.isBlank((String)note.getColumn())) {
                    if ("location".equalsIgnoreCase(note.getColumn())) {
                        this.request.setAttribute("entityValue", (Object)se.getLocation());
                        this.request.setAttribute("entityName", (Object)resword.getString("location"));
                        note.setEntityName(resword.getString("location"));
                        note.setEntityValue(se.getLocation());
                    } else if ("date_start".equalsIgnoreCase(note.getColumn())) {
                        if (se.getDateStarted() != null) {
                            note.setEntityValue(dateFormatter.format(se.getDateStarted()));
                        }
                        note.setEntityName(resword.getString("start_date"));
                    } else if ("date_end".equalsIgnoreCase(note.getColumn())) {
                        if (se.getDateEnded() != null) {
                            note.setEntityValue(dateFormatter.format(se.getDateEnded()));
                        }
                        note.setEntityName(resword.getString("end_date"));
                    }
                }
            } else if ("eventCrf".equalsIgnoreCase(entityType)) {
                EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
                EventCRFBean ec = (EventCRFBean)ecdao.findByPK(note.getEntityId());
                ssub = (StudySubjectBean)new StudySubjectDAO(this.sm.getDataSource()).findByPK(ec.getStudySubjectId());
                note.setStudySub(ssub);
                StudyEventBean event = (StudyEventBean)new StudyEventDAO(this.sm.getDataSource()).findByPK(ec.getStudyEventId());
                note.setEvent(event);
                if (!StringUtil.isBlank((String)note.getColumn())) {
                    if ("date_interviewed".equals(note.getColumn())) {
                        if (ec.getDateInterviewed() != null) {
                            note.setEntityValue(dateFormatter.format(ec.getDateInterviewed()));
                        }
                        note.setEntityName(resword.getString("date_interviewed"));
                    } else if ("interviewer_name".equals(note.getColumn())) {
                        note.setEntityValue(ec.getInterviewerName());
                        note.setEntityName(resword.getString("interviewer_name"));
                    }
                }
            }
        }
        if (note.getStudyId() != this.currentStudy.getId()) {
            if (this.currentStudy.getParentStudyId() > 0) {
                if (this.currentStudy.getId() != note.getStudySub().getStudyId()) {
                    this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                    this.forwardPage(Page.MENU_SERVLET);
                    return;
                }
            } else {
                StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
                Collection sites = studydao.findOlnySiteIdsByStudy(this.currentStudy);
                if (!sites.contains(note.getStudySub().getStudyId())) {
                    this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                    this.forwardPage(Page.MENU_SERVLET);
                    return;
                }
            }
        }
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        ArrayList notes = dndao.findAllEntityByPK(note.getEntityType(), noteId);
        Date lastUpdatedDate = note.getCreatedDate();
        UserAccountBean lastUpdator = (UserAccountBean)udao.findByPK(note.getOwnerId());
        Collections.sort(notes);
        DiscrepancyNoteBean lastChild = (DiscrepancyNoteBean)notes.get(notes.size() - 1);
        lastUpdatedDate = lastChild.getCreatedDate();
        lastUpdator = (UserAccountBean)udao.findByPK(lastChild.getOwnerId());
        note.setLastUpdator(lastUpdator);
        note.setLastDateUpdated(lastUpdatedDate);
        note.setUpdatedDate(lastUpdatedDate);
        for (DiscrepancyNoteBean dnBean : notes) {
            if (dnBean.getParentDnId() <= 0) continue;
            note.getChildren().add(dnBean);
        }
        note.setNumChildren(note.getChildren().size());
        note.setDisType(DiscrepancyNoteType.get((int)note.getDiscrepancyNoteTypeId()));
        this.request.setAttribute(DIS_NOTE, (Object)note);
        this.forwardPage(Page.VIEW_SINGLE_NOTE);
    }
}

