/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.akaza.openclinica.bean.admin.AuditBean;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Utils;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.admin.AuditDAO;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewStudySubjectAuditLogServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        AuditDAO adao = new AuditDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        ArrayList studySubjectAudits = new ArrayList();
        ArrayList eventCRFAudits = new ArrayList();
        ArrayList studyEventAudits = new ArrayList();
        ArrayList allDeletedEventCRFs = new ArrayList();
        String attachedFilePath = Utils.getAttachedFilePath((StudyBean)this.currentStudy);
        int studySubId = fp.getInt("id", true);
        this.request.setAttribute("id", (Object)studySubId);
        if (studySubId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_subject_to_view"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS);
        } else {
            StudyEventBean studyEvent;
            int i;
            StudySubjectBean studySubject = (StudySubjectBean)subdao.findByPK(studySubId);
            StudyBean study = (StudyBean)studydao.findByPK(studySubject.getStudyId());
            if (studySubject.getStudyId() != this.currentStudy.getId()) {
                if (this.currentStudy.getParentStudyId() > 0) {
                    this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                    this.forwardPage(Page.MENU_SERVLET);
                    return;
                }
                Collection sites = studydao.findOlnySiteIdsByStudy(this.currentStudy);
                if (!sites.contains(study.getId())) {
                    this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                    this.forwardPage(Page.MENU_SERVLET);
                    return;
                }
            }
            this.request.setAttribute("studySub", (Object)studySubject);
            SubjectBean subject = (SubjectBean)sdao.findByPK(studySubject.getSubjectId());
            StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
            study.getStudyParameterConfig().setCollectDob(spvdao.findByHandleAndStudy(study.getId(), "collectDob").getValue());
            String collectdob = "used";
            if (study.getStudyParameterConfig().getCollectDob().equals("2")) {
                collectdob = "yearOnly";
            } else if (study.getStudyParameterConfig().getCollectDob().equals("3")) {
                collectdob = "notUsed";
            } else if (study.getStudyParameterConfig().getCollectDob().equals("1")) {
                collectdob = "used";
            }
            this.request.setAttribute("collectdob", (Object)collectdob);
            this.request.setAttribute("subject", (Object)subject);
            this.request.setAttribute("study", (Object)study);
            Collection studySubjectAuditEvents = adao.findStudySubjectAuditEvents(studySubject.getId());
            for (AuditBean auditBean : studySubjectAuditEvents) {
                if (auditBean.getAuditEventTypeId() != 3) continue;
                auditBean.setOldValue(Status.get((int)Integer.parseInt(auditBean.getOldValue())).getName());
                auditBean.setNewValue(Status.get((int)Integer.parseInt(auditBean.getNewValue())).getName());
            }
            studySubjectAudits.addAll(studySubjectAuditEvents);
            studySubjectAudits.addAll(adao.findSubjectAuditEvents(subject.getId()));
            studySubjectAudits.addAll(adao.findStudySubjectGroupAssignmentAuditEvents(studySubject.getId()));
            this.request.setAttribute("studySubjectAudits", studySubjectAudits);
            ArrayList events = sedao.findAllByStudySubject(studySubject);
            for (i = 0; i < events.size(); ++i) {
                studyEvent = (StudyEventBean)events.get(i);
                studyEvent.setStudyEventDefinition((StudyEventDefinitionBean)seddao.findByPK(studyEvent.getStudyEventDefinitionId()));
                studyEvent.setEventCRFs(ecdao.findAllByStudyEvent(studyEvent));
                List deletedEventCRFs = adao.findDeletedEventCRFsFromAuditEventByEventCRFStatus(studyEvent.getId());
                allDeletedEventCRFs.addAll(deletedEventCRFs);
                logger.info("deletedEventCRFs size[" + deletedEventCRFs.size() + "]");
            }
            for (i = 0; i < events.size(); ++i) {
                studyEvent = (StudyEventBean)events.get(i);
                studyEventAudits.addAll(adao.findStudyEventAuditEvents(studyEvent.getId()));
                ArrayList eventCRFs = studyEvent.getEventCRFs();
                for (int j = 0; j < eventCRFs.size(); ++j) {
                    EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(j);
                    eventCRF.setCrfVersion((CRFVersionBean)cvdao.findByPK(eventCRF.getCRFVersionId()));
                    eventCRF.setCrf(cdao.findByVersionId(eventCRF.getCRFVersionId()));
                    eventCRFAudits.addAll(adao.findEventCRFAuditEventsWithItemDataType(eventCRF.getId()));
                    logger.info("eventCRFAudits size [" + eventCRFAudits.size() + "] eventCRF id [" + eventCRF.getId() + "]");
                }
            }
            ItemDataDAO itemDataDao = new ItemDataDAO(this.sm.getDataSource());
            for (Object o : eventCRFAudits) {
                AuditBean ab = (AuditBean)o;
                if (!ab.getAuditTable().equalsIgnoreCase("item_data")) continue;
                ItemDataBean idBean = (ItemDataBean)itemDataDao.findByPK(ab.getEntityId());
                ab.setOrdinal(idBean.getOrdinal());
            }
            this.request.setAttribute("events", (Object)events);
            this.request.setAttribute("eventCRFAudits", eventCRFAudits);
            this.request.setAttribute("studyEventAudits", studyEventAudits);
            this.request.setAttribute("allDeletedEventCRFs", allDeletedEventCRFs);
            this.request.setAttribute("attachedFilePath", (Object)attachedFilePath);
            this.forwardPage(Page.VIEW_STUDY_SUBJECT_AUDIT);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

