/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.AuditEventBean;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.admin.StudyEventAuditBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.DisplayEventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.DisplayStudyEventBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayEventCRFBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.AuditEventDAO;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.AuditableEntityDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.service.crfdata.HideCRFManager;
import org.akaza.openclinica.service.managestudy.StudySubjectService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.DisplayStudyEventRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ViewStudySubjectServlet
extends SecureController {
    public static final String HAS_UNIQUE_ID_NOTE = "hasUniqueIDNote";
    public static final String HAS_DOB_NOTE = "hasDOBNote";
    public static final String HAS_GENDER_NOTE = "hasGenderNote";
    public static final String HAS_ENROLLMENT_NOTE = "hasEnrollmentNote";
    public static final String UNIQUE_ID_NOTE = "uniqueIDNote";
    public static final String DOB_NOTE = "dOBNote";
    public static final String GENDER_NOTE = "genderNote";
    public static final String ENROLLMENT_NOTE = "enrollmentNote";

    public void mayProceed() throws InsufficientPermissionException {
        this.getCrfLocker().unlockAllForUser(this.ub.getId());
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS, resexception.getString("not_study_director"), "1");
    }

    public static ArrayList<DisplayStudyEventBean> getDisplayStudyEventsForStudySubject(StudySubjectBean studySub, DataSource ds, UserAccountBean ub, StudyUserRoleBean currentRole) {
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(ds);
        StudyEventDAO sedao = new StudyEventDAO(ds);
        EventCRFDAO ecdao = new EventCRFDAO(ds);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(ds);
        StudySubjectDAO ssdao = new StudySubjectDAO(ds);
        StudyDAO sdao = new StudyDAO(ds);
        ArrayList events = sedao.findAllByStudySubject(studySub);
        ArrayList<DisplayStudyEventBean> displayEvents = new ArrayList<DisplayStudyEventBean>();
        for (int i = 0; i < events.size(); ++i) {
            StudyEventBean event = (StudyEventBean)events.get(i);
            StudySubjectBean studySubject = (StudySubjectBean)ssdao.findByPK(event.getStudySubjectId());
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seddao.findByPK(event.getStudyEventDefinitionId());
            event.setStudyEventDefinition(sed);
            StudyBean study = (StudyBean)sdao.findByPK(studySubject.getStudyId());
            ArrayList eventDefinitionCRFs = (ArrayList)edcdao.findAllActiveByEventDefinitionId(study, sed.getId());
            ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
            DisplayStudyEventBean de = new DisplayStudyEventBean();
            de.setStudyEvent(event);
            de.setDisplayEventCRFs(ViewStudySubjectServlet.getDisplayEventCRFs((DataSource)ds, (ArrayList)eventCRFs, (ArrayList)eventDefinitionCRFs, (UserAccountBean)ub, (StudyUserRoleBean)currentRole, (SubjectEventStatus)event.getSubjectEventStatus(), (StudyBean)study));
            ArrayList al = ViewStudySubjectServlet.getUncompletedCRFs((DataSource)ds, (ArrayList)eventDefinitionCRFs, (ArrayList)eventCRFs, (SubjectEventStatus)event.getSubjectEventStatus());
            ViewStudySubjectServlet.populateUncompletedCRFsWithCRFAndVersions((DataSource)ds, (ArrayList)al);
            de.setUncompletedCRFs(al);
            de.setMaximumSampleOrdinal(sedao.getMaxSampleOrdinal(sed, studySubject));
            displayEvents.add(de);
        }
        return displayEvents;
    }

    public void processRequest() throws Exception {
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int studySubId = fp.getInt("id", true);
        String from = fp.getString("from");
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        String crfVersionChangeMsg = fp.getString("isFromCRFVersionChange");
        if (crfVersionChangeMsg != null && !crfVersionChangeMsg.equals("")) {
            this.addPageMessage(crfVersionChangeMsg);
        }
        if (studySubId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_subject_to_view"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS);
        } else {
            if (!StringUtil.isBlank((String)from)) {
                this.request.setAttribute("from", (Object)from);
            } else {
                this.request.setAttribute("from", (Object)"");
            }
            StudySubjectBean studySub = (StudySubjectBean)subdao.findByPK(studySubId);
            this.request.setAttribute("studySub", (Object)studySub);
            int studyId = studySub.getStudyId();
            int subjectId = studySub.getSubjectId();
            StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
            StudyBean study = (StudyBean)studydao.findByPK(studyId);
            if (studySub.getStudyId() != this.currentStudy.getId()) {
                if (this.currentStudy.getParentStudyId() > 0) {
                    this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                    this.forwardPage(Page.MENU_SERVLET);
                    return;
                }
                Collection sites = studydao.findOlnySiteIdsByStudy(this.currentStudy);
                if (!sites.contains(study.getId())) {
                    this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                    this.forwardPage(Page.MENU_SERVLET);
                    return;
                }
            }
            boolean subjectStudyIsCurrentStudy = studyId == this.currentStudy.getId();
            boolean isParentStudy = study.getParentStudyId() < 1;
            DiscrepancyNoteDAO discrepancyNoteDAO = new DiscrepancyNoteDAO(this.sm.getDataSource());
            ArrayList allNotesforSubject = new ArrayList();
            if (subjectStudyIsCurrentStudy && isParentStudy) {
                allNotesforSubject = discrepancyNoteDAO.findAllSubjectByStudyAndId(study, subjectId);
                allNotesforSubject.addAll(discrepancyNoteDAO.findAllStudySubjectByStudyAndId(study, studySubId));
            } else if (!isParentStudy) {
                StudyBean stParent = (StudyBean)studydao.findByPK(study.getParentStudyId());
                allNotesforSubject = discrepancyNoteDAO.findAllSubjectByStudiesAndSubjectId(stParent, study, subjectId);
                allNotesforSubject.addAll(discrepancyNoteDAO.findAllStudySubjectByStudiesAndStudySubjectId(stParent, study, studySubId));
            } else {
                allNotesforSubject = discrepancyNoteDAO.findAllSubjectByStudiesAndSubjectId(this.currentStudy, study, subjectId);
                allNotesforSubject.addAll(discrepancyNoteDAO.findAllStudySubjectByStudiesAndStudySubjectId(this.currentStudy, study, studySubId));
            }
            if (!allNotesforSubject.isEmpty()) {
                this.setRequestAttributesForNotes((List)allNotesforSubject);
            }
            SubjectBean subject = (SubjectBean)sdao.findByPK(subjectId);
            if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("2")) {
                Date dob = subject.getDateOfBirth();
                if (dob != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(dob);
                    int year = cal.get(1);
                    this.request.setAttribute("yearOfBirth", (Object)new Integer(year));
                } else {
                    this.request.setAttribute("yearOfBirth", (Object)"");
                }
            }
            this.request.setAttribute("subject", (Object)subject);
            StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
            study.getStudyParameterConfig().setCollectDob(spvdao.findByHandleAndStudy(studyId, "collectDob").getValue());
            this.request.setAttribute("subjectStudy", (Object)study);
            if (study.getParentStudyId() > 0) {
                StudyBean parentStudy2 = (StudyBean)studydao.findByPK(study.getParentStudyId());
                this.request.setAttribute("parentStudy", (Object)parentStudy2);
            } else {
                this.request.setAttribute("parentStudy", (Object)new StudyBean());
            }
            ArrayList children = (ArrayList)sdao.findAllChildrenByPK(subjectId);
            this.request.setAttribute("children", (Object)children);
            StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            StudySubjectService studySubjectService = (StudySubjectService)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext()).getBean("studySubjectService");
            List displayEvents = studySubjectService.getDisplayStudyEventsForStudySubject(studySub, this.ub, this.currentRole);
            for (int i = 0; i < displayEvents.size(); ++i) {
                DisplayStudyEventBean decb = (DisplayStudyEventBean)displayEvents.get(i);
                if (this.currentRole.isDirector() || this.currentRole.isCoordinator() || !decb.getStudyEvent().getSubjectEventStatus().isLocked()) continue;
                decb.getStudyEvent().setEditable(false);
            }
            if (this.currentStudy.getParentStudyId() > 0) {
                HideCRFManager hideCRFManager = HideCRFManager.createHideCRFManager();
                for (DisplayStudyEventBean displayStudyEventBean : displayEvents) {
                    hideCRFManager.removeHiddenEventCRF(displayStudyEventBean);
                }
            }
            EntityBeanTable table = fp.getEntityBeanTable();
            table.setSortingIfNotExplicitlySet(1, false);
            ArrayList allEventRows = DisplayStudyEventRow.generateRowsFromBeans((List)displayEvents);
            String[] columns = new String[]{resword.getString("event") + " (" + resword.getString("occurrence_number") + ")", resword.getString("start_date1"), resword.getString("location"), resword.getString("status"), resword.getString("actions"), resword.getString("CRFs_atrib")};
            table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
            table.hideColumnLink(4);
            table.hideColumnLink(5);
            if (!"removed".equalsIgnoreCase(studySub.getStatus().getName()) && !"auto-removed".equalsIgnoreCase(studySub.getStatus().getName()) && this.currentStudy.getStatus().isAvailable() && !this.currentRole.getRole().equals((Term)Role.MONITOR)) {
                table.addLink(resword.getString("add_new_event"), "CreateNewStudyEvent?studySubjectId=" + studySub.getId());
            }
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("id", new Integer(studySubId).toString());
            table.setQuery("ViewStudySubject", args);
            table.setRows(allEventRows);
            table.computeDisplay();
            this.request.setAttribute("table", (Object)table);
            SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
            ArrayList groupMaps = (ArrayList)sgmdao.findAllByStudySubject(studySubId);
            this.request.setAttribute("groups", (Object)groupMaps);
            AuditEventDAO aedao = new AuditEventDAO(this.sm.getDataSource());
            ArrayList logs = aedao.findEventStatusLogByStudySubject(studySubId);
            UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
            ArrayList<StudyEventAuditBean> eventLogs = new ArrayList<StudyEventAuditBean>();
            for (int i = 0; i < logs.size(); ++i) {
                AuditEventBean avb = (AuditEventBean)logs.get(i);
                StudyEventAuditBean sea = new StudyEventAuditBean();
                sea.setAuditEvent(avb);
                StudyEventBean se = (StudyEventBean)sedao.findByPK(avb.getEntityId());
                StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seddao.findByPK(se.getStudyEventDefinitionId());
                sea.setDefinition(sed);
                String old = avb.getOldValue().trim();
                try {
                    String newValue;
                    if (!StringUtil.isBlank((String)old)) {
                        SubjectEventStatus oldStatus = SubjectEventStatus.get((int)new Integer(old));
                        sea.setOldSubjectEventStatus(oldStatus);
                    }
                    if (!StringUtil.isBlank((String)(newValue = avb.getNewValue().trim()))) {
                        SubjectEventStatus newStatus = SubjectEventStatus.get((int)new Integer(newValue));
                        sea.setNewSubjectEventStatus(newStatus);
                    }
                }
                catch (NumberFormatException e) {
                    logger.error("Subject event status is not able to be fetched: ", (Throwable)e);
                }
                UserAccountBean updater = (UserAccountBean)udao.findByPK(avb.getUserId());
                sea.setUpdater(updater);
                eventLogs.add(sea);
            }
            this.request.setAttribute("eventLogs", eventLogs);
            this.forwardPage(Page.VIEW_STUDY_SUBJECT);
        }
    }

    public static ArrayList getDisplayEventCRFs(DataSource ds, ArrayList eventCRFs, ArrayList eventDefinitionCRFs, UserAccountBean ub, StudyUserRoleBean currentRole, SubjectEventStatus status, StudyBean study) {
        ArrayList<DisplayEventCRFBean> answer = new ArrayList<DisplayEventCRFBean>();
        StudyEventDAO sedao = new StudyEventDAO(ds);
        CRFDAO cdao = new CRFDAO(ds);
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        ItemDataDAO iddao = new ItemDataDAO(ds);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(ds);
        for (int i = 0; i < eventCRFs.size(); ++i) {
            ArrayList idata;
            EventCRFBean ecb = (EventCRFBean)eventCRFs.get(i);
            int crfVersionId = ecb.getCRFVersionId();
            CRFBean cb = cdao.findByVersionId(crfVersionId);
            ecb.setCrf(cb);
            CRFVersionBean cvb = (CRFVersionBean)cvdao.findByPK(crfVersionId);
            ecb.setCrfVersion(cvb);
            int studyEventId = ecb.getStudyEventId();
            int studyEventDefinitionId = sedao.getDefinitionIdFromStudyEventId(studyEventId);
            EventDefinitionCRFBean edc = edcdao.findByStudyEventDefinitionIdAndCRFId(study, studyEventDefinitionId, cb.getId());
            if (status.equals((Term)SubjectEventStatus.LOCKED) || status.equals((Term)SubjectEventStatus.SKIPPED) || status.equals((Term)SubjectEventStatus.STOPPED)) {
                ecb.setStage(DataEntryStage.LOCKED);
            } else if (status.equals((Term)SubjectEventStatus.INVALID)) {
                ecb.setStage(DataEntryStage.LOCKED);
            } else if (!cb.getStatus().equals((Term)Status.AVAILABLE)) {
                ecb.setStage(DataEntryStage.LOCKED);
            } else if (!cvb.getStatus().equals((Term)Status.AVAILABLE)) {
                ecb.setStage(DataEntryStage.LOCKED);
            }
            if (edc == null) continue;
            DisplayEventCRFBean dec = new DisplayEventCRFBean();
            dec.setEventDefinitionCRF(edc);
            dec.setFlags(ecb, ub, currentRole, edc.isDoubleEntry());
            if (dec.isLocked()) {
                // empty if block
            }
            if ((idata = iddao.findAllByEventCRFId(ecb.getId())).isEmpty()) continue;
            answer.add(dec);
        }
        return answer;
    }

    public static ArrayList getUncompletedCRFs(DataSource ds, ArrayList eventDefinitionCRFs, ArrayList eventCRFs, SubjectEventStatus status) {
        int i;
        HashMap<Integer, Boolean> completed = new HashMap<Integer, Boolean>();
        HashMap<Integer, EventCRFBean> startedButIncompleted = new HashMap<Integer, EventCRFBean>();
        ArrayList<DisplayEventDefinitionCRFBean> answer = new ArrayList<DisplayEventDefinitionCRFBean>();
        for (i = 0; i < eventDefinitionCRFs.size(); ++i) {
            EventDefinitionCRFBean edcrf = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
            completed.put(new Integer(edcrf.getCrfId()), Boolean.FALSE);
            startedButIncompleted.put(new Integer(edcrf.getCrfId()), new EventCRFBean());
        }
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        ItemDataDAO iddao = new ItemDataDAO(ds);
        for (i = 0; i < eventCRFs.size(); ++i) {
            EventCRFBean ecrf = (EventCRFBean)eventCRFs.get(i);
            int crfId = cvdao.getCRFIdFromCRFVersionId(ecrf.getCRFVersionId());
            ArrayList idata = iddao.findAllByEventCRFId(ecrf.getId());
            if (!idata.isEmpty()) {
                completed.put(new Integer(crfId), Boolean.TRUE);
                continue;
            }
            startedButIncompleted.put(new Integer(crfId), ecrf);
        }
        for (i = 0; i < eventDefinitionCRFs.size(); ++i) {
            DisplayEventDefinitionCRFBean dedc = new DisplayEventDefinitionCRFBean();
            EventDefinitionCRFBean edcrf = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
            dedc.setEdc(edcrf);
            if (status.equals((Term)SubjectEventStatus.LOCKED)) {
                dedc.setStatus(Status.LOCKED);
            }
            Boolean b = (Boolean)completed.get(new Integer(edcrf.getCrfId()));
            EventCRFBean ev = (EventCRFBean)startedButIncompleted.get(new Integer(edcrf.getCrfId()));
            if (b != null && b.booleanValue()) continue;
            dedc.setEventCRF(ev);
            answer.add(dedc);
        }
        return answer;
    }

    public static void populateUncompletedCRFsWithCRFAndVersions(DataSource ds, ArrayList uncompletedEventDefinitionCRFs) {
        CRFDAO cdao = new CRFDAO(ds);
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        int size = uncompletedEventDefinitionCRFs.size();
        for (int i = 0; i < size; ++i) {
            DisplayEventDefinitionCRFBean dedcrf = (DisplayEventDefinitionCRFBean)uncompletedEventDefinitionCRFs.get(i);
            CRFBean cb = (CRFBean)cdao.findByPK(dedcrf.getEdc().getCrfId());
            dedcrf.getEdc().setCrf(cb);
            ArrayList theVersions = (ArrayList)cvdao.findAllActiveByCRF(dedcrf.getEdc().getCrfId());
            ArrayList versions = new ArrayList();
            HashMap<String, CRFVersionBean> crfVersionIds = new HashMap<String, CRFVersionBean>();
            for (int j = 0; j < theVersions.size(); ++j) {
                CRFVersionBean crfVersion = (CRFVersionBean)theVersions.get(j);
                crfVersionIds.put(String.valueOf(crfVersion.getId()), crfVersion);
            }
            if (!dedcrf.getEdc().getSelectedVersionIds().equals("")) {
                String[] kk;
                for (String string : kk = dedcrf.getEdc().getSelectedVersionIds().split(",")) {
                    if (crfVersionIds.get(string) == null) continue;
                    versions.add(crfVersionIds.get(string));
                }
            } else {
                versions = theVersions;
            }
            dedcrf.getEdc().setVersions(versions);
            uncompletedEventDefinitionCRFs.set(i, dedcrf);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public void mayAccess() throws InsufficientPermissionException {
        FormProcessor fp = new FormProcessor(this.request);
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        int studySubId = fp.getInt("id", true);
        if (studySubId > 0 && !this.entityIncluded(studySubId, this.ub.getName(), (AuditableEntityDAO)subdao, this.sm.getDataSource())) {
            this.addPageMessage(respage.getString("required_study_subject_not_belong"));
            throw new InsufficientPermissionException(Page.MENU, resexception.getString("entity_not_belong_studies"), "1");
        }
    }

    private void setRequestAttributesForNotes(List<DiscrepancyNoteBean> discBeans) {
        for (DiscrepancyNoteBean discrepancyNoteBean : discBeans) {
            if ("unique_identifier".equalsIgnoreCase(discrepancyNoteBean.getColumn())) {
                this.request.setAttribute("hasUniqueIDNote", (Object)"yes");
                this.request.setAttribute("uniqueIDNote", (Object)discrepancyNoteBean);
                continue;
            }
            if ("date_of_birth".equalsIgnoreCase(discrepancyNoteBean.getColumn())) {
                this.request.setAttribute("hasDOBNote", (Object)"yes");
                this.request.setAttribute("dOBNote", (Object)discrepancyNoteBean);
                continue;
            }
            if ("enrollment_date".equalsIgnoreCase(discrepancyNoteBean.getColumn())) {
                this.request.setAttribute("hasEnrollmentNote", (Object)"yes");
                this.request.setAttribute("enrollmentNote", (Object)discrepancyNoteBean);
                continue;
            }
            if (!"gender".equalsIgnoreCase(discrepancyNoteBean.getColumn())) continue;
            this.request.setAttribute("hasGenderNote", (Object)"yes");
            this.request.setAttribute("genderNote", (Object)discrepancyNoteBean);
        }
    }

    private void addDiscrepancyNotesFromChildStudies(List<DiscrepancyNoteBean> discBeans, int parentStudyId, int subjectId, int studySubId, StudyDAO studyDAO, DiscrepancyNoteDAO discrepancyNoteDAO) {
        if (discBeans == null || discBeans.isEmpty() || studyDAO == null || discrepancyNoteDAO == null) {
            return;
        }
        ArrayList childStudies = (ArrayList)studyDAO.findAllByParent(parentStudyId);
        for (StudyBean studyBean : childStudies) {
            discBeans.addAll(discrepancyNoteDAO.findAllSubjectByStudyAndId(studyBean, subjectId));
            discBeans.addAll(discrepancyNoteDAO.findAllStudySubjectByStudyAndId(studyBean, studySubId));
        }
    }
}

