/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.submit.DisplayEventCRFBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ResponseOptionBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.RuleValidator;
import org.akaza.openclinica.control.form.ScoreItemValidator;
import org.akaza.openclinica.control.submit.DataEntryServlet;
import org.akaza.openclinica.control.submit.DoubleDataProgress;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleDataEntryServlet
extends DataEntryServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoubleDataEntryServlet.class);
    Locale locale;
    public static final String COUNT_VALIDATE = "countValidate";
    public static final String DDE_ENTERED = "ddeEntered";
    public static final String DDE_PROGESS = "doubleDataProgress";

    private boolean userIsOwnerAndLessThanTwelveHoursHavePassed(HttpServletRequest request) {
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        boolean userIsOwner = ub.getId() == ecb.getOwnerId();
        boolean lessThanTwelveHoursHavePassed = !DisplayEventCRFBean.initialDataEntryCompletedMoreThanTwelveHoursAgo((EventCRFBean)ecb);
        return userIsOwner && lessThanTwelveHoursHavePassed;
    }

    protected void mayProceed(HttpServletRequest request, HttpServletResponse response) throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_locked"), request, response);
        this.checkStudyFrozen(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_frozen"), request, response);
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        HttpSession session = request.getSession();
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        this.getInputBeans(request);
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        FormProcessor fp = new FormProcessor(request);
        SectionBean sb = (SectionBean)request.getAttribute("section_bean");
        int tabNumber = 1;
        if (sb != null) {
            tabNumber = sb.getOrdinal();
        }
        if (tabNumber < 1) {
            String tab;
            if (fp == null) {
                fp = new FormProcessor(request);
            }
            tabNumber = (tab = fp.getString("tab")) == null || tab.length() < 1 ? 1 : fp.getInt("tab");
        }
        SectionDAO sectionDao = new SectionDAO(this.getDataSource());
        int crfVersionId = ecb.getCRFVersionId();
        int eventCRFId = ecb.getId();
        ArrayList sections = sectionDao.findAllByCRFVersionId(crfVersionId);
        int sectionSize = sections.size();
        HttpSession mySession = request.getSession();
        DoubleDataProgress doubleDataProgress = (DoubleDataProgress)mySession.getAttribute(DDE_PROGESS);
        if (doubleDataProgress == null || doubleDataProgress.getEventCRFId() != eventCRFId) {
            doubleDataProgress = new DoubleDataProgress(sectionSize, eventCRFId);
            mySession.setAttribute(DDE_PROGESS, (Object)doubleDataProgress);
        }
        boolean hasVisitedSection = doubleDataProgress.getSectionVisited(tabNumber, eventCRFId);
        int keyId = ecb.getId();
        Integer count = (Integer)session.getAttribute(COUNT_VALIDATE + keyId);
        if (count != null) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            session.setAttribute(COUNT_VALIDATE + keyId, (Object)count);
            LOGGER.info("^^^just set count to session: " + count);
        } else {
            count = 0;
            session.setAttribute(COUNT_VALIDATE + keyId, (Object)count);
            LOGGER.info("***count not found, set to session: " + count);
        }
        DataEntryStage stage = ecb.getStage();
        if (stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) && !hasVisitedSection) {
            request.setAttribute(DDE_ENTERED, (Object)true);
        }
        doubleDataProgress.setSectionVisited(eventCRFId, tabNumber, true);
        mySession.setAttribute(DDE_PROGESS, (Object)doubleDataProgress);
        Role r = currentRole.getRole();
        session.setAttribute("mayProcessUploading", (Object)"true");
    }

    protected boolean validateInputOnFirstRound() {
        return true;
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, HttpServletRequest request) {
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        HttpSession session = request.getSession();
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        boolean isSingleItem = false;
        if (StringUtil.isBlank((String)inputName)) {
            inputName = this.getInputName(dib);
            isSingleItem = true;
        }
        int keyId = ecb.getId();
        Integer validationCount = (Integer)session.getAttribute(COUNT_VALIDATE + keyId);
        ItemDataBean valueToCompareTmp = dib.getData();
        ItemDataBean valueToCompare = this.copyItemDataBean(valueToCompareTmp);
        if (!isSingleItem) {
            valueToCompare = dib.getDbData();
        }
        if (isSingleItem) {
            dib = this.loadFormValue(dib, request);
        }
        boolean showOriginalItem = this.getItemMetadataService().isShown(Integer.valueOf(dib.getItem().getId()), ecb, valueToCompare);
        boolean showItem = dib.getMetadata().isShowItem();
        if (!showItem && dib.getScdData().getScdItemMetadataBean().getScdItemFormMetadataId() > 0) {
            showItem = true;
        }
        boolean showDuplicateItem = this.getItemMetadataService().hasPassedDDE(dib.getMetadata(), ecb, valueToCompare);
        LOGGER.debug("*** show original item has value " + dib.getData().getValue() + " and show item has value " + valueToCompare.getValue());
        LOGGER.debug("--- show original: " + showOriginalItem + " show duplicate: " + showDuplicateItem + " and just show item: " + showItem);
        LOGGER.debug("VALIDATION COUNT " + validationCount);
        if (showOriginalItem && showDuplicateItem || showItem) {
            if (rt.equals((Term)ResponseType.TEXT) || rt.equals((Term)ResponseType.TEXTAREA)) {
                dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
                if (validationCount == null || validationCount == 0) {
                    v.addValidation(inputName, 25, valueToCompare, false);
                    v.setErrorMessage(respage.getString("value_you_specified") + " " + valueToCompare.getValue() + " " + respage.getString("from_initial_data_entry"));
                }
            } else if (rt.equals((Term)ResponseType.FILE)) {
                dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
                if (validationCount == null || validationCount == 0) {
                    ItemDataBean pathStrippedValueToCompare;
                    try {
                        pathStrippedValueToCompare = (ItemDataBean)BeanUtils.cloneBean((Object)valueToCompare);
                    }
                    catch (Throwable e) {
                        LOGGER.error("Error cloning the bean for pathStrippedValueToCompare: ", e);
                        return dib;
                    }
                    pathStrippedValueToCompare.setValue(FilenameUtils.getName((String)valueToCompare.getValue()));
                    v.addValidation(inputName, 25, pathStrippedValueToCompare, false);
                    v.setErrorMessage(respage.getString("value_you_specified") + " " + pathStrippedValueToCompare.getValue() + " " + respage.getString("from_initial_data_entry"));
                }
            } else if (rt.equals((Term)ResponseType.RADIO) || rt.equals((Term)ResponseType.SELECT)) {
                dib = this.validateDisplayItemBeanSingleCV(v, dib, inputName);
                if (validationCount == null || validationCount == 0) {
                    v.addValidation(inputName, 25, valueToCompare, false);
                    String errorValue = valueToCompare.getValue();
                    ArrayList options = dib.getMetadata().getResponseSet().getOptions();
                    for (int u = 0; u < options.size(); ++u) {
                        ResponseOptionBean rob = (ResponseOptionBean)options.get(u);
                        if (!rob.getValue().equals(errorValue)) continue;
                        errorValue = rob.getText();
                    }
                    v.setErrorMessage(respage.getString("value_you_specified") + " " + errorValue + " " + respage.getString("from_initial_data_entry"));
                }
            } else if (rt.equals((Term)ResponseType.CHECKBOX) || rt.equals((Term)ResponseType.SELECTMULTI)) {
                dib = this.validateDisplayItemBeanMultipleCV(v, dib, inputName);
                if (validationCount == null || validationCount == 0) {
                    v.addValidation(inputName, 25, valueToCompare, true);
                    String errorValue = valueToCompare.getValue();
                    String errorTexts = "";
                    ArrayList options = dib.getMetadata().getResponseSet().getOptions();
                    for (int u = 0; u < options.size(); ++u) {
                        ResponseOptionBean rob = (ResponseOptionBean)options.get(u);
                        if (!errorValue.contains(rob.getValue())) continue;
                        errorTexts = errorTexts + rob.getText();
                        if (u >= options.size() - 1) continue;
                        errorTexts = errorTexts + ", ";
                    }
                    v.setErrorMessage(respage.getString("value_you_specified") + " " + errorTexts + " " + respage.getString("from_initial_data_entry"));
                }
            }
        }
        return dib;
    }

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean digb, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, HttpServletRequest request, HttpServletResponse response) {
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        HttpSession session = request.getSession();
        LOGGER.info("===got this far");
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        int keyId = ecb.getId();
        Integer validationCount = (Integer)session.getAttribute(COUNT_VALIDATE + keyId);
        formGroups = this.loadFormValueForItemGroup(digb, digbs, formGroups, edcb.getId(), request);
        LOGGER.info("found formgroups size for " + digb.getGroupMetaBean().getName() + ": " + formGroups.size() + " compare to db groups size: " + digbs.size());
        String inputName = "";
        for (int i = 0; i < formGroups.size(); ++i) {
            DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)formGroups.get(i);
            List items = displayGroup.getItems();
            int order = displayGroup.getOrdinal();
            if (displayGroup.isAuto() && displayGroup.getFormInputOrdinal() > 0) {
                order = displayGroup.getFormInputOrdinal();
            }
            for (DisplayItemBean displayItem : items) {
                inputName = displayGroup.isAuto() ? this.getGroupItemInputName(displayGroup, order, displayItem) : this.getGroupItemManualInputName(displayGroup, order, displayItem);
                this.validateDisplayItemBean(v, displayItem, inputName, request);
            }
            if (validationCount != null && validationCount != 0 || i != 0 || formGroups.size() == digbs.size()) continue;
            v.addValidation(inputName + "group", 30);
            v.setErrorMessage("There are additional values here that were not present in the initial data entry. You have entered a different number of groups for the item groups containing " + inputName);
        }
        return formGroups;
    }

    protected DisplayItemBean validateCalcTypeDisplayItemBean(ScoreItemValidator sv, DisplayItemBean dib, String inputName, HttpServletRequest request) {
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        ItemDataDAO iddao = new ItemDataDAO(this.getDataSource());
        boolean isSingleItem = false;
        HttpSession session = request.getSession();
        if (StringUtil.isBlank((String)inputName)) {
            inputName = this.getInputName(dib);
            isSingleItem = true;
        }
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        int keyId = ecb.getId();
        Integer validationCount = (Integer)session.getAttribute(COUNT_VALIDATE + keyId);
        ItemDataBean valueToCompare = new ItemDataBean();
        if (isSingleItem) {
            int idId = dib.getData().getId();
            if (idId > 0) {
                valueToCompare = (ItemDataBean)iddao.findByPK(idId);
            }
        } else {
            valueToCompare = dib.getDbData();
        }
        if (rt.equals((Term)ResponseType.CALCULATION) || rt.equals((Term)ResponseType.GROUP_CALCULATION)) {
            boolean showOriginalItem = this.getItemMetadataService().isShown(Integer.valueOf(dib.getItem().getId()), ecb, valueToCompare);
            boolean showItem = dib.getMetadata().isShowItem();
            boolean showDuplicateItem = this.getItemMetadataService().hasPassedDDE(dib.getMetadata(), ecb, valueToCompare);
            if (showOriginalItem && showDuplicateItem || showItem) {
                dib = this.validateDisplayItemBeanText((DiscrepancyValidator)sv, dib, inputName, request);
            }
            if (showOriginalItem && showDuplicateItem || showItem) {
                sv.addValidation(inputName, 25, valueToCompare, false);
                sv.setErrorMessage(respage.getString("value_you_specified") + " " + valueToCompare.getValue() + " " + respage.getString("from_initial_data_entry"));
            }
        }
        return dib;
    }

    protected Status getBlankItemStatus() {
        return Status.PENDING;
    }

    protected Status getNonBlankItemStatus(HttpServletRequest request) {
        return Status.UNAVAILABLE;
    }

    protected String getEventCRFAnnotations(HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        return ecb.getValidatorAnnotations();
    }

    protected void setEventCRFAnnotations(String annotations, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        ecb.setValidatorAnnotations(annotations);
    }

    protected Page getJSPPage() {
        return Page.DOUBLE_DATA_ENTRY;
    }

    protected String getServletPage(HttpServletRequest request) {
        FormProcessor fp = new FormProcessor(request);
        String tabId = fp.getString("tab", true);
        String sectionId = fp.getString("sectionId", true);
        String eventCRFId = fp.getString("eventCRFId", true);
        if (StringUtil.isBlank((String)sectionId) || StringUtil.isBlank((String)tabId)) {
            return Page.DOUBLE_DATA_ENTRY_SERVLET.getFileName();
        }
        Page target = Page.DOUBLE_DATA_ENTRY_SERVLET;
        return target.getFileName() + "?eventCRFId=" + eventCRFId + "&sectionId=" + sectionId + "&tab=" + tabId;
    }

    protected boolean shouldLoadDBValues(DisplayItemBean dib) {
        if (dib.getData().getStatus() == null || dib.getData().getStatus().equals((Term)Status.UNAVAILABLE)) {
            return true;
        }
        return !dib.getData().getStatus().equals((Term)Status.PENDING);
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, RuleValidator rv, HashMap<String, ArrayList<String>> groupOrdinalPLusItemOid, Boolean fireRuleValidation, ArrayList<String> messages, HttpServletRequest request) {
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        boolean isSingleItem = false;
        if (StringUtil.isBlank((String)inputName)) {
            inputName = this.getInputName(dib);
            isSingleItem = true;
        }
        int keyId = ecb.getId();
        Integer validationCount = (Integer)request.getSession().getAttribute(COUNT_VALIDATE + keyId);
        ItemDataBean valueToCompare = dib.getData();
        if (!isSingleItem) {
            valueToCompare = dib.getDbData();
        }
        if (isSingleItem) {
            dib = this.loadFormValue(dib, request);
        }
        if (groupOrdinalPLusItemOid.containsKey(dib.getItem().getOid()) || fireRuleValidation.booleanValue()) {
            messages = messages == null ? groupOrdinalPLusItemOid.get(dib.getItem().getOid()) : messages;
            dib = this.validateDisplayItemBeanSingleCV(rv, dib, inputName, messages);
        }
        return dib;
    }

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean digb, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, RuleValidator rv, HashMap<String, ArrayList<String>> groupOrdinalPLusItemOid, HttpServletRequest request, HttpServletResponse response) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        int keyId = ecb.getId();
        Integer validationCount = (Integer)request.getSession().getAttribute(COUNT_VALIDATE + keyId);
        formGroups = this.loadFormValueForItemGroup(digb, digbs, formGroups, edcb.getId(), request);
        LOGGER.info("found formgroups size for " + digb.getGroupMetaBean().getName() + ": " + formGroups.size() + " compare to db groups size: " + digbs.size());
        String inputName = "";
        for (int i = 0; i < formGroups.size(); ++i) {
            DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)formGroups.get(i);
            List items = displayGroup.getItems();
            int order = displayGroup.getOrdinal();
            if (displayGroup.isAuto() && displayGroup.getFormInputOrdinal() > 0) {
                order = displayGroup.getFormInputOrdinal();
            }
            for (DisplayItemBean displayItem : items) {
                inputName = displayGroup.isAuto() ? this.getGroupItemInputName(displayGroup, order, displayItem) : this.getGroupItemManualInputName(displayGroup, order, displayItem);
                if (displayItem.getMetadata().isShowItem() || this.getItemMetadataService().isShown(Integer.valueOf(displayItem.getItem().getId()), ecb, displayItem.getData())) {
                    if (groupOrdinalPLusItemOid.containsKey(displayItem.getItem().getOid()) || groupOrdinalPLusItemOid.containsKey(String.valueOf(order + 1) + displayItem.getItem().getOid())) {
                        LOGGER.debug("IN : " + String.valueOf(order + 1) + displayItem.getItem().getOid());
                        this.validateDisplayItemBean(v, displayItem, inputName, rv, groupOrdinalPLusItemOid, Boolean.valueOf(true), groupOrdinalPLusItemOid.get(String.valueOf(order + 1) + displayItem.getItem().getOid()), request);
                        continue;
                    }
                    this.validateDisplayItemBean(v, displayItem, inputName, rv, groupOrdinalPLusItemOid, Boolean.valueOf(false), null, request);
                    continue;
                }
                LOGGER.debug("OUT : " + String.valueOf(order + 1) + displayItem.getItem().getOid());
            }
        }
        return formGroups;
    }

    protected boolean shouldRunRules() {
        return true;
    }

    protected boolean isAdministrativeEditing() {
        return false;
    }

    protected boolean isAdminForcedReasonForChange(HttpServletRequest request) {
        return false;
    }

    private ItemDataBean copyItemDataBean(ItemDataBean src) {
        ItemDataBean result = new ItemDataBean();
        result.setEventCRFId(src.getEventCRFId());
        result.setItemId(src.getItemId());
        result.setValue(src.getValue());
        result.setOrdinal(src.getOrdinal());
        result.setSelected(src.isSelected());
        result.setAuditLog(src.isAuditLog());
        result.setCreatedDate(src.getCreatedDate());
        result.setUpdatedDate(src.getUpdatedDate());
        result.setOwner(src.getOwner());
        result.setOwnerId(src.getOwnerId());
        result.setUpdater(src.getUpdater());
        result.setUpdaterId(src.getUpdaterId());
        result.setStatus(src.getStatus());
        return result;
    }
}

