/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.rule.FileUploadHelper;
import org.akaza.openclinica.bean.rule.XmlSchemaValidationHelper;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.crfdata.ODMContainer;
import org.akaza.openclinica.bean.submit.crfdata.SummaryStatsBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.submit.ImportCRFInfoContainer;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.crfdata.ImportCRFDataService;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;

public class ImportCRFDataServlet
extends SecureController {
    Locale locale;
    private ImportCRFDataService dataService;
    XmlSchemaValidationHelper schemaValidator = new XmlSchemaValidationHelper();
    FileUploadHelper uploadHelper = new FileUploadHelper();

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.MENU_SERVLET, respage.getString("current_study_locked"));
        this.checkStudyFrozen(Page.MENU_SERVLET, respage.getString("current_study_frozen"));
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR) || r.equals((Term)Role.INVESTIGATOR) || r.equals((Term)Role.RESEARCHASSISTANT) || r.equals((Term)Role.RESEARCHASSISTANT2)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }

    public void processRequest() throws Exception {
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        this.session.setAttribute("module", (Object)module);
        String action = this.request.getParameter("action");
        CRFVersionBean version = (CRFVersionBean)this.session.getAttribute("version");
        File xsdFile = new File(SpringServletAccess.getPropertiesDir((ServletContext)this.context) + "ODM1-3-0.xsd");
        File xsdFile2 = new File(SpringServletAccess.getPropertiesDir((ServletContext)this.context) + "ODM1-2-1.xsd");
        if (StringUtil.isBlank((String)action)) {
            logger.info("action is blank");
            this.request.setAttribute("version", (Object)version);
            this.forwardPage(Page.IMPORT_CRF_DATA);
        }
        if ("confirm".equalsIgnoreCase(action)) {
            String theDir;
            String dir = SQLInitServlet.getField((String)"filePath");
            if (!new File(dir).exists()) {
                logger.info("The filePath in datainfo.properties is invalid " + dir);
                this.addPageMessage(respage.getString("filepath_you_defined_not_seem_valid"));
                this.forwardPage(Page.IMPORT_CRF_DATA);
            }
            if (!new File(theDir = dir + "crf" + File.separator + "original" + File.separator).isDirectory()) {
                new File(theDir).mkdirs();
                logger.info("Made the directory " + theDir);
            }
            File f = null;
            try {
                f = this.uploadFile(theDir, version);
            }
            catch (Exception e) {
                logger.warn("*** Found exception during file upload***", (Throwable)e);
            }
            if (f == null) {
                this.forwardPage(Page.IMPORT_CRF_DATA);
            }
            Mapping myMap = new Mapping();
            String ODM_MAPPING_DIRPath = CoreResources.ODM_MAPPING_DIR;
            myMap.loadMapping(ODM_MAPPING_DIRPath + File.separator + "cd_odm_mapping.xml");
            Unmarshaller um1 = new Unmarshaller(myMap);
            boolean fail = false;
            ODMContainer odmContainer = new ODMContainer();
            this.session.removeAttribute("odmContainer");
            try {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                odmContainer = (ODMContainer)um1.unmarshal((Reader)isr);
                logger.debug("Found crf data container for study oid: " + odmContainer.getCrfDataPostImportContainer().getStudyOID());
                logger.debug("found length of subject list: " + odmContainer.getCrfDataPostImportContainer().getSubjectData().size());
                this.addPageMessage(respage.getString("passed_xml_validation"));
            }
            catch (Exception me1) {
                logger.info("found exception with xml transform", (Throwable)me1);
                logger.info("trying 1.2.1");
                try {
                    this.schemaValidator.validateAgainstSchema(f, xsdFile2);
                    InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                    odmContainer = (ODMContainer)um1.unmarshal((Reader)isr);
                }
                catch (Exception me2) {
                    MessageFormat mf = new MessageFormat("");
                    mf.applyPattern(respage.getString("your_xml_is_not_well_formed"));
                    Object[] arguments = new Object[]{me1.getMessage()};
                    this.addPageMessage(mf.format(arguments));
                    this.forwardPage(Page.IMPORT_CRF_DATA);
                }
            }
            List errors = this.getImportCRFDataService().validateStudyMetadata(odmContainer, this.ub.getActiveStudyId());
            if (errors != null) {
                logger.info(errors.toString());
                for (String error : errors) {
                    this.addPageMessage(error);
                }
                if (errors.size() > 0) {
                    this.forwardPage(Page.IMPORT_CRF_DATA);
                } else {
                    this.addPageMessage(respage.getString("passed_study_check"));
                    this.addPageMessage(respage.getString("passed_oid_metadata_check"));
                }
            }
            logger.debug("passed error check");
            Boolean eventCRFStatusesValid = this.getImportCRFDataService().eventCRFStatusesValid(odmContainer, this.ub);
            ImportCRFInfoContainer importCrfInfo = new ImportCRFInfoContainer(odmContainer, this.sm.getDataSource());
            List eventCRFBeans = this.getImportCRFDataService().fetchEventCRFBeans(odmContainer, this.ub);
            ArrayList displayItemBeanWrappers = new ArrayList();
            HashMap totalValidationErrors = new HashMap();
            HashMap hardValidationErrors = new HashMap();
            HashMap importedCRFStatuses = this.getImportCRFDataService().fetchEventCRFStatuses(odmContainer);
            if (eventCRFBeans == null) {
                fail = true;
                this.addPageMessage(respage.getString("no_event_status_matching"));
            } else {
                ArrayList<Integer> permittedEventCRFIds = new ArrayList<Integer>();
                logger.info("found a list of eventCRFBeans: " + eventCRFBeans.toString());
                logger.debug("found event crfs " + eventCRFBeans.size());
                if (!eventCRFBeans.isEmpty()) {
                    for (EventCRFBean eventCRFBean : eventCRFBeans) {
                        DataEntryStage dataEntryStage = eventCRFBean.getStage();
                        Status eventCRFStatus = eventCRFBean.getStatus();
                        logger.info("Event CRF Bean: id " + eventCRFBean.getId() + ", data entry stage " + dataEntryStage.getName() + ", status " + eventCRFStatus.getName());
                        if (!eventCRFStatus.equals((Term)Status.AVAILABLE) && !dataEntryStage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && !dataEntryStage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) && !dataEntryStage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE) && !dataEntryStage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY)) continue;
                        permittedEventCRFIds.add(new Integer(eventCRFBean.getId()));
                    }
                    if (eventCRFBeans.size() >= permittedEventCRFIds.size()) {
                        this.addPageMessage(respage.getString("passed_event_crf_status_check"));
                    } else {
                        fail = true;
                        this.addPageMessage(respage.getString("the_event_crf_not_correct_status"));
                    }
                    try {
                        List tempDisplayItemBeanWrappers = new ArrayList();
                        tempDisplayItemBeanWrappers = this.getImportCRFDataService().lookupValidationErrors(this.request, odmContainer, this.ub, totalValidationErrors, hardValidationErrors, permittedEventCRFIds);
                        logger.debug("generated display item bean wrappers " + tempDisplayItemBeanWrappers.size());
                        logger.debug("size of total validation errors: " + totalValidationErrors.size());
                        displayItemBeanWrappers.addAll(tempDisplayItemBeanWrappers);
                    }
                    catch (NullPointerException npe1) {
                        fail = true;
                        logger.debug("threw a NPE after calling lookup validation errors", (Throwable)npe1);
                        this.addPageMessage(respage.getString("an_error_was_thrown_while_validation_errors"));
                    }
                    catch (OpenClinicaException oce1) {
                        fail = true;
                        logger.debug("threw an OCE after calling lookup validation errors " + oce1.getOpenClinicaMessage());
                        this.addPageMessage(oce1.getOpenClinicaMessage());
                    }
                } else if (!eventCRFStatusesValid.booleanValue()) {
                    fail = true;
                    this.addPageMessage(respage.getString("the_event_crf_not_correct_status"));
                } else {
                    fail = true;
                    this.addPageMessage(respage.getString("no_event_crfs_matching_the_xml_metadata"));
                }
            }
            if (fail) {
                logger.debug("failed here - forwarding...");
                this.forwardPage(Page.IMPORT_CRF_DATA);
            } else {
                this.addPageMessage(respage.getString("passing_crf_edit_checks"));
                this.session.setAttribute("odmContainer", (Object)odmContainer);
                this.session.setAttribute("importedData", displayItemBeanWrappers);
                this.session.setAttribute("validationErrors", totalValidationErrors);
                this.session.setAttribute("hardValidationErrors", hardValidationErrors);
                this.session.setAttribute("importedCRFStatuses", (Object)importedCRFStatuses);
                this.session.setAttribute("importCrfInfo", (Object)importCrfInfo);
                logger.debug("+++ content of total validation errors: " + totalValidationErrors.toString());
                SummaryStatsBean ssBean = this.getImportCRFDataService().generateSummaryStatsBean(odmContainer, displayItemBeanWrappers, importCrfInfo);
                this.session.setAttribute("summaryStats", (Object)ssBean);
                this.session.setAttribute("subjectData", (Object)odmContainer.getCrfDataPostImportContainer().getSubjectData());
                this.forwardPage(Page.VERIFY_IMPORT_SERVLET);
            }
        }
    }

    private File getFirstFile() {
        File f = null;
        List files = this.uploadHelper.returnFiles(this.request, this.context);
        for (File file : files) {
            f = file;
            if (f == null || f.getName() == null) {
                logger.info("file is empty.");
                Validator.addError((HashMap)this.errors, (String)"xml_file", (String)"You have to provide an XML file!");
                continue;
            }
            if (f.getName().indexOf(".xml") >= 0 || f.getName().indexOf(".XML") >= 0) continue;
            logger.info("file name:" + f.getName());
            this.addPageMessage(respage.getString("file_you_uploaded_not_seem_xml_file"));
            f = null;
        }
        return f;
    }

    public File uploadFile(String theDir, CRFVersionBean version) throws Exception {
        return this.getFirstFile();
    }

    public ImportCRFDataService getImportCRFDataService() {
        this.dataService = this.dataService != null ? this.dataService : new ImportCRFDataService(this.sm.getDataSource(), this.locale);
        return this.dataService;
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

