/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.RuleValidator;
import org.akaza.openclinica.control.submit.DataEntryServlet;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/InitialDataEntry"})
public class InitialDataEntryServlet
extends DataEntryServlet {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    Locale locale;

    protected void mayProceed(HttpServletRequest request, HttpServletResponse response) throws InsufficientPermissionException {
        this.mayAccess(request);
        this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_locked"), request, response);
        this.checkStudyFrozen(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_frozen"), request, response);
        HttpSession session = request.getSession();
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        session.setAttribute("mayProcessUploading", (Object)"true");
        this.getInputBeans(request);
    }

    protected boolean validateInputOnFirstRound() {
        return true;
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, RuleValidator rv, HashMap<String, ArrayList<String>> groupOrdinalPLusItemOid, Boolean fireRuleValidation, ArrayList<String> messages, HttpServletRequest request) {
        ItemBean ib = dib.getItem();
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        if (StringUtil.isBlank((String)inputName)) {
            dib = this.loadFormValue(dib, request);
        }
        if (rt.equals((Term)ResponseType.TEXT) || rt.equals((Term)ResponseType.TEXTAREA) || rt.equals((Term)ResponseType.RADIO) || rt.equals((Term)ResponseType.SELECT)) {
            // empty if block
        }
        if (groupOrdinalPLusItemOid.containsKey(dib.getItem().getOid()) || fireRuleValidation.booleanValue()) {
            messages = messages == null ? groupOrdinalPLusItemOid.get(dib.getItem().getOid()) : messages;
            dib = this.validateDisplayItemBeanSingleCV(rv, dib, inputName, messages);
        }
        return dib;
    }

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean digb, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, RuleValidator rv, HashMap<String, ArrayList<String>> groupOrdinalPLusItemOid, HttpServletRequest request, HttpServletResponse response) {
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        formGroups = this.loadFormValueForItemGroup(digb, digbs, formGroups, edcb.getId(), request);
        String inputName = "";
        for (int i = 0; i < formGroups.size(); ++i) {
            DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)formGroups.get(i);
            List items = displayGroup.getItems();
            int order = displayGroup.getOrdinal();
            if (displayGroup.isAuto() && displayGroup.getFormInputOrdinal() > 0) {
                order = displayGroup.getFormInputOrdinal();
            }
            for (DisplayItemBean displayItem : items) {
                inputName = displayGroup.isAuto() ? this.getGroupItemInputName(displayGroup, order, displayItem) : this.getGroupItemManualInputName(displayGroup, order, displayItem);
                this.logger.debug("THe oid is " + displayItem.getItem().getOid() + " order : " + order + " inputName : " + inputName);
                if (groupOrdinalPLusItemOid.containsKey(displayItem.getItem().getOid()) || groupOrdinalPLusItemOid.containsKey(String.valueOf(displayGroup.getIndex() + 1) + displayItem.getItem().getOid())) {
                    this.logger.debug("IN : " + String.valueOf(displayGroup.getIndex() + 1) + displayItem.getItem().getOid());
                    this.validateDisplayItemBean(v, displayItem, inputName, rv, groupOrdinalPLusItemOid, Boolean.valueOf(true), groupOrdinalPLusItemOid.get(String.valueOf(displayGroup.getIndex() + 1) + displayItem.getItem().getOid()), request);
                    continue;
                }
                this.validateDisplayItemBean(v, displayItem, inputName, rv, groupOrdinalPLusItemOid, Boolean.valueOf(false), null, request);
            }
        }
        return formGroups;
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, HttpServletRequest request) {
        ItemBean ib = dib.getItem();
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        if (StringUtil.isBlank((String)inputName)) {
            dib = this.loadFormValue(dib, request);
        }
        if (rt.equals((Term)ResponseType.TEXT) || rt.equals((Term)ResponseType.TEXTAREA) || rt.equals((Term)ResponseType.FILE)) {
            dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
        } else if (rt.equals((Term)ResponseType.RADIO) || rt.equals((Term)ResponseType.SELECT)) {
            dib = this.validateDisplayItemBeanSingleCV(v, dib, inputName);
        } else if (rt.equals((Term)ResponseType.CHECKBOX) || rt.equals((Term)ResponseType.SELECTMULTI)) {
            dib = this.validateDisplayItemBeanMultipleCV(v, dib, inputName);
        }
        this.logger.debug("just ran validate display item bean on " + inputName);
        return dib;
    }

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean digb, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, HttpServletRequest request, HttpServletResponse response) {
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        formGroups = this.loadFormValueForItemGroup(digb, digbs, formGroups, edcb.getId(), request);
        String inputName = "";
        for (int i = 0; i < formGroups.size(); ++i) {
            DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)formGroups.get(i);
            List items = displayGroup.getItems();
            int order = displayGroup.getOrdinal();
            if (displayGroup.isAuto() && displayGroup.getFormInputOrdinal() > 0) {
                order = displayGroup.getFormInputOrdinal();
            }
            for (DisplayItemBean displayItem : items) {
                inputName = displayGroup.isAuto() ? this.getGroupItemInputName(displayGroup, order, displayItem) : this.getGroupItemManualInputName(displayGroup, order, displayItem);
                this.validateDisplayItemBean(v, displayItem, inputName, request);
            }
        }
        return formGroups;
    }

    protected Status getBlankItemStatus() {
        return Status.AVAILABLE;
    }

    protected Status getNonBlankItemStatus(HttpServletRequest request) {
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        return edcb.isDoubleEntry() ? Status.PENDING : Status.UNAVAILABLE;
    }

    protected String getEventCRFAnnotations(HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        return ecb.getAnnotations();
    }

    protected void setEventCRFAnnotations(String annotations, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        ecb.setAnnotations(annotations);
    }

    protected Page getJSPPage() {
        return Page.INITIAL_DATA_ENTRY_NW;
    }

    protected String getServletPage(HttpServletRequest request) {
        FormProcessor fp = new FormProcessor(request);
        String tabId = fp.getString("tab", true);
        String sectionId = fp.getString("sectionId", true);
        String eventCRFId = fp.getString("eventCRFId", true);
        if (StringUtil.isBlank((String)sectionId) || StringUtil.isBlank((String)tabId)) {
            return Page.INITIAL_DATA_ENTRY_SERVLET.getFileName();
        }
        Page target = Page.INITIAL_DATA_ENTRY_SERVLET;
        return target.getFileName() + "?eventCRFId=" + eventCRFId + "&sectionId=" + sectionId + "&tab=" + tabId;
    }

    protected boolean shouldLoadDBValues(DisplayItemBean dib) {
        return true;
    }

    protected boolean shouldRunRules() {
        return true;
    }

    protected boolean isAdministrativeEditing() {
        return false;
    }

    protected boolean isAdminForcedReasonForChange(HttpServletRequest request) {
        return false;
    }
}

