/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.domain.rule.RuleSetBean;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class RunRuleSetServlet
extends SecureController {
    private static String RULESET_ID = "ruleSetId";
    private static String RULE_ID = "ruleId";
    private static String RULESET = "ruleSet";
    private static String RULESET_RESULT = "ruleSetResult";
    private RuleSetServiceInterface ruleSetService;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String ruleSetId = this.request.getParameter(RULESET_ID);
        String ruleId = this.request.getParameter(RULE_ID);
        String dryRun = this.request.getParameter("dryRun");
        RuleSetBean ruleSetBean = this.getRuleSetBean(ruleSetId, ruleId);
        if (ruleSetBean != null) {
            ArrayList<RuleSetBean> ruleSets = new ArrayList<RuleSetBean>();
            ruleSets.add(ruleSetBean);
            if (dryRun != null && dryRun.equals("no")) {
                List resultOfRunningRules = this.getRuleSetService().runRulesInBulk(ruleSets, Boolean.valueOf(false), this.currentStudy, this.ub, false);
                this.addPageMessage(respage.getString("actions_successfully_taken"));
                this.forwardPage(Page.LIST_RULE_SETS_SERVLET);
            } else {
                List resultOfRunningRules = this.getRuleSetService().runRulesInBulk(ruleSets, Boolean.valueOf(true), this.currentStudy, this.ub, false);
                this.request.setAttribute(RULESET, (Object)ruleSetBean);
                this.request.setAttribute(RULESET_RESULT, (Object)resultOfRunningRules);
                if (resultOfRunningRules.size() > 0) {
                    this.addPageMessage(resword.getString("view_executed_rules_affected_subjects"));
                } else {
                    this.addPageMessage(resword.getString("view_executed_rules_no_affected_subjects"));
                }
                this.forwardPage(Page.VIEW_EXECUTED_RULES);
            }
        } else {
            this.addPageMessage("RuleSet not found");
            this.forwardPage(Page.LIST_RULE_SETS_SERVLET);
        }
    }

    private RuleSetBean getRuleSetBean(String ruleSetId, String ruleId) {
        RuleSetBean ruleSetBean = null;
        if (ruleId != null && ruleSetId != null && ruleId.length() > 0 && ruleSetId.length() > 0) {
            ruleSetBean = this.getRuleSetService().getRuleSetById(this.currentStudy, ruleSetId);
            ruleSetBean = this.ruleSetService.filterByRules(ruleSetBean, Integer.valueOf(ruleId));
        } else if (ruleSetId != null && ruleSetId.length() > 0) {
            ruleSetBean = this.getRuleSetService().getRuleSetById(this.currentStudy, ruleSetId);
        }
        return ruleSetBean;
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    private RuleSetServiceInterface getRuleSetService() {
        this.ruleSetService = this.ruleSetService != null ? this.ruleSetService : (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetService");
        this.ruleSetService.setContextPath(this.getContextPath());
        this.ruleSetService.setMailSender((JavaMailSenderImpl)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("mailSender"));
        this.ruleSetService.setRequestURLMinusServletPath(this.getRequestURLMinusServletPath());
        return this.ruleSetService;
    }
}

